/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.http;

import com.sun.cldc.io.DateParser;
import com.sun.midp.Configuration;
import com.sun.midp.io.ConnectionBaseAdapter;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Properties;
import com.sun.midp.io.j2me.http.StreamConnectionElement;
import com.sun.midp.io.j2me.http.StreamConnectionPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBaseAdapter
implements HttpConnection {
    protected String saved_url;
    protected String protocol = "http";
    protected int default_port = 80;
    protected HttpUrl url;
    protected String hostAndPort;
    protected int responseCode = -1;
    protected String responseMsg;
    protected Properties reqProperties;
    protected Properties headerFields;
    protected String method = "GET";
    protected int mode;
    protected int reconnects;
    private static final int MAX_NUMBER_OF_RECONNECTS = 2;
    private InputStream in;
    private OutputStream out;
    private StreamConnection streamConnection;
    private DataOutputStream streamOutput;
    private DataInputStream streamInput;
    private StringBuffer stringbuffer;
    private String http_proxy;
    protected static final String HTTP_VERSION_10 = "HTTP/1.0";
    protected static final String HTTP_VERSION_11 = "HTTP/1.1";
    protected static String HTTP_VERSION = "HTTP/1.1";
    private static StreamConnectionPool connectionPool;
    private StreamConnectionElement connectionElement = null;
    private String httpVer = null;
    private boolean ConnectionCloseFlag;
    private int chunksize;
    private int totalbytesread;
    private boolean chunkedIn;
    private boolean chunkedOut;
    private boolean eof;
    private byte[] readbuf;
    private int bytesleft;
    private int bytesread;
    private ByteArrayOutputStream byteArrayOutput;
    private int maxNumberOfPersistentConnections = 1;
    private final int HTTP_BUFFER_SIZE;
    private final int HTTP_OUTPUT_BUFFER_SIZE;
    private static final int INIT_STATE = 0;
    private static final int WRITE_STATE = 1;
    private static final int OPEN_STATE = 2;
    private static final int CHUNK_STATE = 3;
    private static final int READ_STATE = 4;
    private static final int CLOSE_STATE = 5;
    private static final int FLUSH_STATE = 6;
    private static final int CONNECT_STATE = 7;
    private int state = 0;
    private Properties proxyHeaders = new Properties();
    private byte handshakeError;
    private boolean useChunks = true;

    public Protocol() {
        String num;
        this.HTTP_BUFFER_SIZE = 256;
        this.HTTP_OUTPUT_BUFFER_SIZE = 2048;
        this.reqProperties = new Properties();
        this.headerFields = new Properties();
        this.stringbuffer = new StringBuffer(32);
        String flag = Configuration.getProperty("com.sun.midp.io.http.force_non_persistent");
        if (flag != null && flag.equals("true")) {
            this.ConnectionCloseFlag = true;
        }
        if ((num = Configuration.getProperty("com.sun.midp.io.http.max_persistent_connections")) != null) {
            try {
                this.maxNumberOfPersistentConnections = Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.maxNumberOfPersistentConnections <= 0) {
                this.maxNumberOfPersistentConnections = 1;
            }
        }
        this.readbuf = new byte[256];
        flag = Configuration.getProperty("com.sun.midp.io.http.use_chunks");
        this.useChunks = flag != null && flag.equals("true");
        if (!this.useChunks && this.ConnectionCloseFlag) {
            HTTP_VERSION = HTTP_VERSION_10;
        }
    }

    protected void connect(String name, int mode, boolean timeouts) throws IOException, IllegalArgumentException, ConnectionNotFoundException {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("illegal mode: " + mode);
        }
        this.saved_url = name;
        this.mode = mode;
        this.url = new HttpUrl(this.protocol, name);
        if (this.url.port == -1) {
            this.url.port = this.default_port;
        }
        if (this.url.host == null) {
            this.url.host = "";
        }
        this.hostAndPort = this.url.host + ":" + this.url.port;
    }

    public InputStream openInputStream() throws IOException {
        if (this.in != null) {
            throw new IOException("input stream already open");
        }
        if (this.mode != 1 && this.mode != 3) {
            throw new IOException("write-only connection");
        }
        this.sendRequest(4);
        this.bytesleft = 0;
        this.chunksize = 0;
        this.bytesread = 0;
        this.totalbytesread = 0;
        this.chunkedIn = false;
        this.eof = false;
        String te = this.getHeaderField("transfer-encoding");
        if (te != null && te.toLowerCase().equals("chunked")) {
            this.chunkedIn = true;
            this.chunksize = this.readChunkSize();
        } else {
            this.chunksize = (int)this.getLength();
        }
        if (this.chunksize == 0) {
            this.eof = true;
        }
        this.in = super.openInputStream();
        return this.in;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.mode != 2 && this.mode != 3) {
            throw new IOException("read-only connection");
        }
        this.byteArrayOutput = new ByteArrayOutputStream(2048);
        this.out = super.openOutputStream();
        return this.out;
    }

    protected int readBytes(byte[] b, int off, int len) throws IOException {
        int rc2;
        if (this.eof) {
            return -1;
        }
        if (this.chunkedIn) {
            int rc2;
            int total = 0;
            do {
                if ((rc2 = this.readBytesChunked(b, off, len)) == -1) {
                    if (total != 0) break;
                    total = -1;
                    break;
                }
                total += rc2;
                off += rc2;
            } while ((len -= rc2) > 0);
            return total;
        }
        if (this.chunksize > 0) {
            return this.readBytesChunked(b, off, len);
        }
        if (this.bytesleft == 0) {
            if (len >= 256) {
                rc2 = this.streamInput.read(b, off, len);
            } else {
                this.bytesleft = rc2 = this.streamInput.read(this.readbuf, 0, 256);
                this.bytesread = 0;
            }
            if (rc2 == -1) {
                this.eof = true;
                return -1;
            }
            this.totalbytesread += rc2;
            if (this.bytesleft == 0) {
                return rc2;
            }
        }
        rc2 = this.readFromBuffer(b, off, len);
        if (this.state != 7) {
            this.setState(4);
        }
        return rc2;
    }

    private int readFromBuffer(byte[] b, int off, int len) throws IOException {
        int rc = len > this.bytesleft ? this.bytesleft : len;
        System.arraycopy(this.readbuf, this.bytesread, b, off, rc);
        this.bytesleft -= rc;
        this.bytesread += rc;
        return rc;
    }

    protected int readBytesChunked(byte[] b, int off, int len) throws IOException {
        int rc;
        if (this.bytesleft == 0) {
            int bytesToRead;
            if (this.totalbytesread == this.chunksize) {
                if (!this.chunkedIn) {
                    this.eof = true;
                    return -1;
                }
                this.readCRLF();
                this.chunksize = this.readChunkSize();
                if (this.chunksize == 0) {
                    this.eof = true;
                    return -1;
                }
                this.totalbytesread = 0;
            }
            if (len >= (bytesToRead = this.chunksize - this.totalbytesread)) {
                rc = this.streamInput.read(b, off, bytesToRead);
            } else if (len >= 256) {
                rc = this.streamInput.read(b, off, len);
            } else {
                rc = 256 >= bytesToRead ? this.streamInput.read(this.readbuf, 0, bytesToRead) : this.streamInput.read(this.readbuf, 0, 256);
                this.bytesleft = rc;
                this.bytesread = 0;
            }
            if (rc == -1) {
                this.eof = true;
                throw new IOException("unexpected end of stream");
            }
            this.totalbytesread += rc;
            if (this.bytesleft == 0) {
                return rc;
            }
        }
        rc = this.readFromBuffer(b, off, len);
        return rc;
    }

    private int readChunkSize() throws IOException {
        int size = -1;
        try {
            String chunk = null;
            try {
                chunk = this.readLine(this.streamInput);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (chunk == null) {
                throw new IOException("No Chunk Size");
            }
            int i = 0;
            while (i < chunk.length()) {
                char ch = chunk.charAt(i);
                if (Character.digit(ch, 16) == -1) break;
                ++i;
            }
            size = Integer.parseInt(chunk.substring(0, i), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("invalid chunk size number format");
        }
        return size;
    }

    private void readCRLF() throws IOException {
        int ch = this.streamInput.read();
        if (ch != 13) {
            throw new IOException("missing CRLF");
        }
        ch = this.streamInput.read();
        if (ch != 10) {
            throw new IOException("missing CRLF");
        }
    }

    protected int writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.state < 2) {
            this.setState(1);
        }
        if (len > 2048 && this.useChunks) {
            this.chunkedOut = true;
            this.setRequestProperty("Transfer-Encoding", "chunked");
            if (this.byteArrayOutput.size() > 0) {
                this.flush();
            }
            this.byteArrayOutput.reset();
            this.sendRequest(3);
            this.sendRequestWritePayloadDirect(b, off, len);
            return len;
        }
        if (this.byteArrayOutput.size() + len > 2048 && this.useChunks) {
            this.chunkedOut = true;
            this.flush();
        }
        this.byteArrayOutput.write(b, off, len);
        return len;
    }

    public void flush() throws IOException {
        if (this.byteArrayOutput.size() > 0 && this.useChunks) {
            this.chunkedOut = true;
            this.setRequestProperty("Transfer-Encoding", "chunked");
            this.sendRequest(3);
        }
        if (this.streamOutput != null) {
            this.streamOutput.flush();
        }
    }

    public String getURL() {
        return this.protocol + ":" + this.saved_url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.url.host.length() == 0 ? null : this.url.host;
    }

    public String getFile() {
        return this.url.path;
    }

    public String getRef() {
        return this.url.fragment;
    }

    public String getQuery() {
        return this.url.query;
    }

    public int getPort() {
        return this.url.port;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public void setRequestMethod(String method) throws IOException {
        if (this.state == 7) {
            throw new IOException("connection already open");
        }
        if (!(method.equals("HEAD") || method.equals("GET") || method.equals("POST"))) {
            throw new IOException("unsupported method: " + method);
        }
        this.method = method;
    }

    public String getRequestProperty(String key) {
        if (key.startsWith("Proxy-")) {
            return this.proxyHeaders.getProperty(key);
        }
        return this.reqProperties.getProperty(key);
    }

    public void setRequestProperty(String key, String value) throws IOException {
        if (this.state == 7) {
            throw new IOException("connection already open");
        }
        if (value.indexOf("\r\n") != -1) {
            throw new IllegalArgumentException("illegal value found");
        }
        this.setRequestField(key, value);
    }

    protected void setRequestField(String key, String value) {
        if (key.startsWith("Proxy-")) {
            this.proxyHeaders.setProperty(key, value);
            return;
        }
        if (key.equals("Connection") && value.equals("close")) {
            this.ConnectionCloseFlag = true;
        }
        if (key.equals("Transfer-Encoding") && value.toLowerCase().equals("chunked")) {
            this.chunkedOut = true;
        }
        this.reqProperties.setProperty(key, value);
    }

    public int getResponseCode() throws IOException {
        this.sendRequest(4);
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.sendRequest(4);
        return this.responseMsg;
    }

    public long getLength() {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return -1L;
        }
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getType() {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return null;
        }
        return this.getHeaderField("content-type");
    }

    public String getEncoding() {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return null;
        }
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(String name) {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return null;
        }
        return this.headerFields.getProperty(this.toLowerCase(name));
    }

    public String getHeaderField(int index) {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return null;
        }
        if (index >= this.headerFields.size()) {
            return null;
        }
        return this.headerFields.getValueAt(index);
    }

    public String getHeaderFieldKey(int index) {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return null;
        }
        if (index >= this.headerFields.size()) {
            return null;
        }
        return this.headerFields.getKeyAt(index);
    }

    public int getHeaderFieldInt(String name, int def) {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return def;
        }
        try {
            return Integer.parseInt(this.getHeaderField(name));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return def;
    }

    public long getHeaderFieldDate(String name, long def) {
        try {
            this.sendRequest(4);
        }
        catch (IOException x) {
            return def;
        }
        try {
            return DateParser.parse(this.getHeaderField(name));
        }
        catch (NumberFormatException nfe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return def;
    }

    protected void sendRequest(int next_state) throws IOException {
        if (this.state == 7) {
            return;
        }
        if (this.state > 2) {
            if (next_state == 3) {
                this.sendRequestWritePayload(next_state);
            }
            if (this.state == 3 && (next_state == 5 || next_state == 4)) {
                if (this.byteArrayOutput.size() > 0) {
                    this.sendRequestWritePayload(this.state);
                }
                this.sendRequestEndSession(next_state);
            } else {
                this.setState(next_state);
            }
        } else {
            this.setState(2);
            this.streamConnection = this.connect();
            this.streamOutput = this.streamConnection.openDataOutputStream();
            this.streamInput = this.streamConnection.openDataInputStream();
            this.sendRequestGeneric(next_state);
            this.sendRequestWritePayload(next_state);
            if (next_state != 3) {
                this.sendRequestEndSession(next_state);
            } else {
                this.setState(next_state);
            }
        }
        if (this.http_proxy != null && this.responseCode >= 500) {
            throw new IOException("server error [" + this.responseCode + "]");
        }
    }

    protected void sendRequestGeneric(int next_state) throws IOException {
        if (this.reconnects > 2) {
            throw new IOException("ERROR: too many reconnections");
        }
        ++this.reconnects;
        if (this.getRequestProperty("Content-Length") == null) {
            this.setRequestProperty("Content-Length", "" + (this.out == null ? 0 : this.byteArrayOutput.size()));
        }
        if (this.state != 2) {
            return;
        }
        String filename = this.url.path;
        if (filename == null) {
            filename = "/";
        }
        String reqLine = this.http_proxy == null ? this.method + " " + filename + (this.url.query == null ? "" : "?" + this.url.query) + " " + HTTP_VERSION + "\r\n" : this.method + " " + this.protocol + "://" + this.hostAndPort + filename + (this.url.query == null ? "" : "?" + this.url.query) + " " + HTTP_VERSION + "\r\n";
        try {
            this.streamOutput.write(reqLine.getBytes());
        }
        catch (IOException ioe) {
            if (this.chunkedOut) {
                throw ioe;
            }
            this.reconnectServer();
            this.sendRequestGeneric(next_state);
            return;
        }
        this.setRequestProperty("Host", this.hostAndPort);
        int numberOfKeys = this.reqProperties.size();
        int i = 0;
        while (i < numberOfKeys) {
            block18: {
                String reqPropLine;
                block17: {
                    String key = this.reqProperties.getKeyAt(i);
                    reqPropLine = key + ": " + this.reqProperties.getValueAt(i) + "\r\n";
                    if (!key.equals("Content-Length")) break block17;
                    if (next_state == 3 || this.chunkedOut) break block18;
                    reqPropLine = this.byteArrayOutput == null ? "Content-Length: 0\r\n" : "Content-Length: " + this.byteArrayOutput.size() + "\r\n";
                }
                try {
                    this.streamOutput.write(reqPropLine.getBytes());
                }
                catch (IOException ioe) {
                    if (this.chunkedOut) {
                        throw ioe;
                    }
                    this.reconnectServer();
                    this.sendRequestGeneric(next_state);
                    return;
                }
            }
            ++i;
        }
        try {
            this.streamOutput.write("\r\n".getBytes());
        }
        catch (IOException ioe) {
            if (this.chunkedOut) {
                throw ioe;
            }
            this.reconnectServer();
            this.sendRequestGeneric(next_state);
            return;
        }
    }

    protected void sendRequestEndSession(int next_state) throws IOException {
        if (this.state == 3 || this.chunkedOut) {
            this.streamOutput.write("0\r\n\r\n".getBytes());
        }
        this.streamOutput.flush();
        this.readResponseMessage(this.streamInput);
        this.readHeaders(this.streamInput);
        if (this.responseCode == 100) {
            this.readResponseMessage(this.streamInput);
            this.readHeaders(this.streamInput);
        }
        this.setState(7);
    }

    protected void sendRequestWritePayloadDirect(byte[] b, int off, int len) throws IOException {
        String temp = Integer.toHexString(len);
        this.streamOutput.write(temp.getBytes());
        this.streamOutput.write("\r\n".getBytes());
        this.streamOutput.write(b, off, len);
        this.streamOutput.write("\r\n".getBytes());
    }

    protected void sendRequestWritePayload(int next_state) throws IOException {
        if (this.byteArrayOutput == null || this.byteArrayOutput.size() == 0) {
            return;
        }
        try {
            if (next_state == 3 || this.chunkedOut) {
                String temp = Integer.toHexString(this.byteArrayOutput.size());
                this.streamOutput.write(temp.getBytes());
                this.streamOutput.write("\r\n".getBytes());
            }
            this.streamOutput.write(this.byteArrayOutput.toByteArray());
            this.byteArrayOutput.reset();
            if (next_state == 3 || this.chunkedOut) {
                this.streamOutput.write("\r\n".getBytes());
            }
        }
        catch (IOException ioe) {
            if (this.chunkedOut) {
                throw ioe;
            }
            this.reconnectServer();
            this.sendRequestGeneric(next_state);
            return;
        }
    }

    protected void reconnectServer() throws IOException {
        boolean old_ConnectionCloseFlag = this.ConnectionCloseFlag;
        String old_httpVer = this.httpVer;
        this.ConnectionCloseFlag = true;
        this.httpVer = HTTP_VERSION_10;
        this.disconnect();
        this.streamConnection = this.connect();
        this.ConnectionCloseFlag = old_ConnectionCloseFlag;
        this.httpVer = old_httpVer;
    }

    protected StreamConnection connect() throws IOException {
        StreamConnectionElement conn;
        this.http_proxy = Configuration.getProperty("com.sun.midp.io.http.proxy");
        if (connectionPool == null) {
            connectionPool = new StreamConnectionPool(this.maxNumberOfPersistentConnections);
        }
        if (this.http_proxy == null) {
            conn = connectionPool.getConnection(this.saved_url, this.url.host, this.url.port, this.hostAndPort);
            this.streamOutput = conn.openDataOutputStream();
            this.streamInput = conn.openDataInputStream();
        } else {
            conn = connectionPool.getConnection(this.saved_url, this.url.host, this.url.port, this.http_proxy);
            this.streamOutput = conn.openDataOutputStream();
            this.streamInput = conn.openDataInputStream();
            try {
                this.doTunnelHandshake(this.streamOutput, this.streamInput);
            }
            catch (IOException ioe) {
                this.connectionElement = conn;
                boolean rc = connectionPool.remove(this.connectionElement);
                this.streamOutput.close();
                this.streamInput.close();
                String response = ioe.getMessage();
                if (response.indexOf(" 500 ") > -1) {
                    throw new ConnectionNotFoundException(ioe.getMessage());
                }
                throw ioe;
            }
        }
        this.connectionElement = conn;
        return conn;
    }

    protected void doTunnelHandshake(OutputStream os, InputStream is) throws IOException {
        String response;
        int c;
        String endOfLine;
        String emptyLine = endOfLine = "\r\n";
        String required = "CONNECT " + this.hostAndPort + " " + HTTP_VERSION + endOfLine;
        os.write(required.getBytes());
        int numberOfKeys = this.proxyHeaders.size();
        int i = 0;
        while (i < numberOfKeys) {
            String optional = this.proxyHeaders.getKeyAt(i) + ": " + this.proxyHeaders.getValueAt(i) + endOfLine;
            os.write(optional.getBytes());
            ++i;
        }
        os.write(emptyLine.getBytes());
        os.flush();
        StringBuffer temp = new StringBuffer();
        boolean newline = false;
        while ((c = is.read()) != -1) {
            if (c == 10) {
                if (newline) break;
                newline = true;
            } else if (c != 13) {
                newline = false;
            }
            temp.append((char)c);
        }
        if (temp.length() == 0) {
            temp.append("none");
        }
        if ((response = temp.toString()).indexOf(" 200 ") == -1) {
            throw new IOException("Error initializing HTTP tunnel connection: \n" + response);
        }
    }

    private void readResponseMessage(InputStream in) throws IOException {
        block9: {
            int httpEnd;
            String line = null;
            this.responseCode = -1;
            this.responseMsg = null;
            try {
                line = this.readLine(in);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (line != null && line.length() == 0) {
                try {
                    line = this.readLine(in);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.responseCode = -1;
            this.responseMsg = null;
            if (line != null && (httpEnd = line.indexOf(32)) >= 0) {
                int codeEnd;
                this.httpVer = line.substring(0, httpEnd);
                if (this.httpVer.startsWith("HTTP") && line.length() > httpEnd && (codeEnd = line.substring(httpEnd + 1).indexOf(32)) >= 0 && line.length() > (codeEnd += httpEnd + 1)) {
                    try {
                        this.responseCode = Integer.parseInt(line.substring(httpEnd + 1, codeEnd));
                    }
                    catch (NumberFormatException nfe) {
                        break block9;
                    }
                    this.responseMsg = line.substring(codeEnd + 1);
                    return;
                }
            }
        }
        throw new IOException("malformed response message");
    }

    private void readHeaders(InputStream in) throws IOException {
        while (true) {
            String line;
            try {
                line = this.readLine(in);
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage());
            }
            if (line == null || line.equals("")) {
                return;
            }
            int index = line.indexOf(58);
            if (index < 0) {
                throw new IOException("malformed header field");
            }
            String key = line.substring(0, index);
            if (key.length() == 0) {
                throw new IOException("malformed header field");
            }
            String value = line.length() <= index + 1 ? "" : line.substring(index + 1).trim();
            if (key.equals("Connection") && value.equals("close")) {
                this.ConnectionCloseFlag = true;
            }
            this.headerFields.addProperty(this.toLowerCase(key), value);
        }
    }

    private String readLine(InputStream in) throws IOException {
        this.stringbuffer.setLength(0);
        while (true) {
            int c;
            try {
                while (true) {
                    if ((c = in.read()) < 0) {
                        return null;
                    }
                    if (c == 13) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                return null;
            }
            if (c == 10) break;
            this.stringbuffer.append((char)c);
        }
        return this.stringbuffer.toString();
    }

    protected void disconnect() throws IOException {
        this.disconnect(this.streamConnection, this.streamInput, this.streamOutput);
    }

    protected void disconnect(StreamConnection connection, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (this.state == 3 || this.state == 1) {
            this.sendRequest(5);
        }
        if (this.streamConnection != null && this.httpVer != null) {
            boolean rc;
            this.streamOutput.flush();
            if (this.httpVer.equals(HTTP_VERSION_10) || this.ConnectionCloseFlag) {
                rc = connectionPool.remove(this.connectionElement);
                this.streamOutput.close();
                this.streamInput.close();
                this.streamConnection.close();
                this.streamConnection = null;
            } else if (this.bytesleft > 0 || !this.eof) {
                rc = connectionPool.remove(this.connectionElement);
                this.streamOutput.close();
                this.streamInput.close();
                this.streamConnection.close();
                this.streamConnection = null;
            }
        } else if (this.ConnectionCloseFlag) {
            if (connectionPool != null) {
                boolean rc = connectionPool.remove(this.connectionElement);
            }
            if (this.streamOutput != null) {
                this.streamOutput.close();
            }
            if (this.streamInput != null) {
                this.streamInput.close();
            }
            if (this.streamConnection != null) {
                this.streamConnection.close();
            }
            this.streamConnection = null;
            return;
        }
        if (this.streamConnection != null) {
            try {
                connectionPool.returnConnection(this.connectionElement);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        this.responseCode = -1;
        this.reconnects = 0;
        this.responseMsg = null;
    }

    private String toLowerCase(String string) {
        this.stringbuffer.setLength(0);
        int i = 0;
        while (i < string.length()) {
            this.stringbuffer.append(Character.toLowerCase(string.charAt(i)));
            ++i;
        }
        return this.stringbuffer.toString();
    }

    private void setState(int pstate) throws IOException {
        if (pstate < 0 || pstate > 7) {
            throw new RuntimeException("invalid state transition");
        }
        if (pstate < this.state && this.state != 4 && pstate != 2 && this.state != 6 && pstate != 2) {
            throw new RuntimeException("invalid state transition");
        }
        this.state = pstate;
    }
}

