dnl
dnl checking for gdk-pixbuf
dnl
AC_DEFUN([AC_CHECK_GDKPIXBUF], [
    AC_ARG_ENABLE([gdkpixbuf],
                  AC_HELP_STRING([--disable-gdkpixbuf],
                                 [do not activate gdk-pixbuf support]),
                  [enable_gdkpixbuf=$enableval], [enable_gdkpixbuf=yes])

    if test "x$enable_gdkpixbuf" = "xyes"; then
        PKG_CHECK_MODULES(GDK_PIXBUF, gdk-pixbuf-2.0,
                          have_gdkpixbuf=yes, have_gdkpixbuf=no)
        AC_SUBST(GDK_PIXBUF_CFLAGS)
        AC_SUBST(GDK_PIXBUF_LIBS)
        if test "x$have_gdkpixbuf" = "xyes"; then
            AC_DEFINE(HAVE_GDK_PIXBUF,1,[Define this if you have gdk-pixbuf installed])
        else
            AC_MSG_RESULT(*** All of the gdk-pixbuf dependent parts will be disabled ***)
        fi
    else
        have_gdkpixbuf=no
    fi
])
