package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOpenService invokes the yundun_bastionhost.DescribeOpenService API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describeopenservice.html
func (client *Client) DescribeOpenService(request *DescribeOpenServiceRequest) (response *DescribeOpenServiceResponse, err error) {
	response = CreateDescribeOpenServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOpenServiceWithChan invokes the yundun_bastionhost.DescribeOpenService API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describeopenservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOpenServiceWithChan(request *DescribeOpenServiceRequest) (<-chan *DescribeOpenServiceResponse, <-chan error) {
	responseChan := make(chan *DescribeOpenServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOpenService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOpenServiceWithCallback invokes the yundun_bastionhost.DescribeOpenService API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describeopenservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOpenServiceWithCallback(request *DescribeOpenServiceRequest, callback func(response *DescribeOpenServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOpenServiceResponse
		var err error
		defer close(result)
		response, err = client.DescribeOpenService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOpenServiceRequest is the request struct for api DescribeOpenService
type DescribeOpenServiceRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
	VendorCode string `position:"Query" name:"VendorCode"`
}

// DescribeOpenServiceResponse is the response struct for api DescribeOpenService
type DescribeOpenServiceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	OpenStatus bool   `json:"OpenStatus" xml:"OpenStatus"`
}

// CreateDescribeOpenServiceRequest creates a request to invoke DescribeOpenService API
func CreateDescribeOpenServiceRequest() (request *DescribeOpenServiceRequest) {
	request = &DescribeOpenServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "DescribeOpenService", "bastionhost", "openAPI")
	return
}

// CreateDescribeOpenServiceResponse creates a response to parse from DescribeOpenService response
func CreateDescribeOpenServiceResponse() (response *DescribeOpenServiceResponse) {
	response = &DescribeOpenServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
