package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AbstractEcommerceVideo invokes the videoenhan.AbstractEcommerceVideo API synchronously
func (client *Client) AbstractEcommerceVideo(request *AbstractEcommerceVideoRequest) (response *AbstractEcommerceVideoResponse, err error) {
	response = CreateAbstractEcommerceVideoResponse()
	err = client.DoAction(request, response)
	return
}

// AbstractEcommerceVideoWithChan invokes the videoenhan.AbstractEcommerceVideo API asynchronously
func (client *Client) AbstractEcommerceVideoWithChan(request *AbstractEcommerceVideoRequest) (<-chan *AbstractEcommerceVideoResponse, <-chan error) {
	responseChan := make(chan *AbstractEcommerceVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AbstractEcommerceVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AbstractEcommerceVideoWithCallback invokes the videoenhan.AbstractEcommerceVideo API asynchronously
func (client *Client) AbstractEcommerceVideoWithCallback(request *AbstractEcommerceVideoRequest, callback func(response *AbstractEcommerceVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AbstractEcommerceVideoResponse
		var err error
		defer close(result)
		response, err = client.AbstractEcommerceVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AbstractEcommerceVideoRequest is the request struct for api AbstractEcommerceVideo
type AbstractEcommerceVideoRequest struct {
	*requests.RpcRequest
	Duration requests.Float   `position:"Body" name:"Duration"`
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoUrl string           `position:"Body" name:"VideoUrl"`
	Width    requests.Integer `position:"Body" name:"Width"`
	Height   requests.Integer `position:"Body" name:"Height"`
}

// AbstractEcommerceVideoResponse is the response struct for api AbstractEcommerceVideo
type AbstractEcommerceVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAbstractEcommerceVideoRequest creates a request to invoke AbstractEcommerceVideo API
func CreateAbstractEcommerceVideoRequest() (request *AbstractEcommerceVideoRequest) {
	request = &AbstractEcommerceVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "AbstractEcommerceVideo", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAbstractEcommerceVideoResponse creates a response to parse from AbstractEcommerceVideo response
func CreateAbstractEcommerceVideoResponse() (response *AbstractEcommerceVideoResponse) {
	response = &AbstractEcommerceVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
