package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteQuotaAlarm invokes the quotas.DeleteQuotaAlarm API synchronously
func (client *Client) DeleteQuotaAlarm(request *DeleteQuotaAlarmRequest) (response *DeleteQuotaAlarmResponse, err error) {
	response = CreateDeleteQuotaAlarmResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteQuotaAlarmWithChan invokes the quotas.DeleteQuotaAlarm API asynchronously
func (client *Client) DeleteQuotaAlarmWithChan(request *DeleteQuotaAlarmRequest) (<-chan *DeleteQuotaAlarmResponse, <-chan error) {
	responseChan := make(chan *DeleteQuotaAlarmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteQuotaAlarm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteQuotaAlarmWithCallback invokes the quotas.DeleteQuotaAlarm API asynchronously
func (client *Client) DeleteQuotaAlarmWithCallback(request *DeleteQuotaAlarmRequest, callback func(response *DeleteQuotaAlarmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteQuotaAlarmResponse
		var err error
		defer close(result)
		response, err = client.DeleteQuotaAlarm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteQuotaAlarmRequest is the request struct for api DeleteQuotaAlarm
type DeleteQuotaAlarmRequest struct {
	*requests.RpcRequest
	AlarmId string `position:"Body" name:"AlarmId"`
}

// DeleteQuotaAlarmResponse is the response struct for api DeleteQuotaAlarm
type DeleteQuotaAlarmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteQuotaAlarmRequest creates a request to invoke DeleteQuotaAlarm API
func CreateDeleteQuotaAlarmRequest() (request *DeleteQuotaAlarmRequest) {
	request = &DeleteQuotaAlarmRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "DeleteQuotaAlarm", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteQuotaAlarmResponse creates a response to parse from DeleteQuotaAlarm response
func CreateDeleteQuotaAlarmResponse() (response *DeleteQuotaAlarmResponse) {
	response = &DeleteQuotaAlarmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
