package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProjectMember invokes the codeup.GetProjectMember API synchronously
func (client *Client) GetProjectMember(request *GetProjectMemberRequest) (response *GetProjectMemberResponse, err error) {
	response = CreateGetProjectMemberResponse()
	err = client.DoAction(request, response)
	return
}

// GetProjectMemberWithChan invokes the codeup.GetProjectMember API asynchronously
func (client *Client) GetProjectMemberWithChan(request *GetProjectMemberRequest) (<-chan *GetProjectMemberResponse, <-chan error) {
	responseChan := make(chan *GetProjectMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProjectMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProjectMemberWithCallback invokes the codeup.GetProjectMember API asynchronously
func (client *Client) GetProjectMemberWithCallback(request *GetProjectMemberRequest, callback func(response *GetProjectMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProjectMemberResponse
		var err error
		defer close(result)
		response, err = client.GetProjectMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProjectMemberRequest is the request struct for api GetProjectMember
type GetProjectMemberRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
	UserId         requests.Integer `position:"Path" name:"UserId"`
}

// GetProjectMemberResponse is the response struct for api GetProjectMember
type GetProjectMemberResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetProjectMemberRequest creates a request to invoke GetProjectMember API
func CreateGetProjectMemberRequest() (request *GetProjectMemberRequest) {
	request = &GetProjectMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetProjectMember", "/api/v3/projects/[ProjectId]/members/[UserId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetProjectMemberResponse creates a response to parse from GetProjectMember response
func CreateGetProjectMemberResponse() (response *GetProjectMemberResponse) {
	response = &GetProjectMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
