package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SavePortalConfig invokes the cloudwf.SavePortalConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveportalconfig.html
func (client *Client) SavePortalConfig(request *SavePortalConfigRequest) (response *SavePortalConfigResponse, err error) {
	response = CreateSavePortalConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SavePortalConfigWithChan invokes the cloudwf.SavePortalConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveportalconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SavePortalConfigWithChan(request *SavePortalConfigRequest) (<-chan *SavePortalConfigResponse, <-chan error) {
	responseChan := make(chan *SavePortalConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SavePortalConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SavePortalConfigWithCallback invokes the cloudwf.SavePortalConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveportalconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SavePortalConfigWithCallback(request *SavePortalConfigRequest, callback func(response *SavePortalConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SavePortalConfigResponse
		var err error
		defer close(result)
		response, err = client.SavePortalConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SavePortalConfigRequest is the request struct for api SavePortalConfig
type SavePortalConfigRequest struct {
	*requests.RpcRequest
	JsonData string `position:"Query" name:"JsonData"`
}

// SavePortalConfigResponse is the response struct for api SavePortalConfig
type SavePortalConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSavePortalConfigRequest creates a request to invoke SavePortalConfig API
func CreateSavePortalConfigRequest() (request *SavePortalConfigRequest) {
	request = &SavePortalConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SavePortalConfig", "cloudwf", "openAPI")
	return
}

// CreateSavePortalConfigResponse creates a response to parse from SavePortalConfig response
func CreateSavePortalConfigResponse() (response *SavePortalConfigResponse) {
	response = &SavePortalConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
