package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricConsortiumChannels invokes the baas.DescribeFabricConsortiumChannels API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumchannels.html
func (client *Client) DescribeFabricConsortiumChannels(request *DescribeFabricConsortiumChannelsRequest) (response *DescribeFabricConsortiumChannelsResponse, err error) {
	response = CreateDescribeFabricConsortiumChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricConsortiumChannelsWithChan invokes the baas.DescribeFabricConsortiumChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumChannelsWithChan(request *DescribeFabricConsortiumChannelsRequest) (<-chan *DescribeFabricConsortiumChannelsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricConsortiumChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricConsortiumChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricConsortiumChannelsWithCallback invokes the baas.DescribeFabricConsortiumChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumChannelsWithCallback(request *DescribeFabricConsortiumChannelsRequest, callback func(response *DescribeFabricConsortiumChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricConsortiumChannelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricConsortiumChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricConsortiumChannelsRequest is the request struct for api DescribeFabricConsortiumChannels
type DescribeFabricConsortiumChannelsRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeFabricConsortiumChannelsResponse is the response struct for api DescribeFabricConsortiumChannels
type DescribeFabricConsortiumChannelsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeFabricConsortiumChannelsRequest creates a request to invoke DescribeFabricConsortiumChannels API
func CreateDescribeFabricConsortiumChannelsRequest() (request *DescribeFabricConsortiumChannelsRequest) {
	request = &DescribeFabricConsortiumChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricConsortiumChannels", "baas", "openAPI")
	return
}

// CreateDescribeFabricConsortiumChannelsResponse creates a response to parse from DescribeFabricConsortiumChannels response
func CreateDescribeFabricConsortiumChannelsResponse() (response *DescribeFabricConsortiumChannelsResponse) {
	response = &DescribeFabricConsortiumChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
