/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class DeclarePrecedence
extends Declare {
    private TypePatternList patterns;

    public DeclarePrecedence(List patterns) {
        this(new TypePatternList(patterns));
    }

    private DeclarePrecedence(TypePatternList patterns) {
        this.patterns = patterns;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare precedence: ");
        buf.append(this.patterns);
        buf.append(";");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DeclarePrecedence)) {
            return false;
        }
        DeclarePrecedence o = (DeclarePrecedence)other;
        return o.patterns.equals(this.patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(4);
        this.patterns.write(s);
        this.writeLocation(s);
    }

    public static Declare read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        DeclarePrecedence ret = new DeclarePrecedence(TypePatternList.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolve(IScope scope) {
        this.patterns = this.patterns.resolveBindings(scope, Bindings.NONE, false, false);
        boolean seenStar = false;
        for (int i = 0; i < this.patterns.size(); ++i) {
            TypePattern pi = this.patterns.get(i);
            if (pi.isStar()) {
                if (seenStar) {
                    scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("circularityInPrecedenceStar"), pi.getSourceLocation(), null);
                }
                seenStar = true;
                continue;
            }
            ResolvedTypeX exactType = pi.getExactType().resolve(scope.getWorld());
            if (exactType == ResolvedTypeX.MISSING) continue;
            if (!exactType.isAspect() && !pi.isIncludeSubtypes()) {
                scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("nonAspectTypesInPrecedence", exactType.getName()), pi.getSourceLocation(), null);
            }
            for (int j = 0; j < this.patterns.size(); ++j) {
                TypePattern pj;
                if (j == i || (pj = this.patterns.get(j)).isStar() || !pj.matchesStatically(exactType)) continue;
                scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("circularityInPrecedenceTwo", exactType.getName()), pi.getSourceLocation(), pj.getSourceLocation());
            }
        }
    }

    public TypePatternList getPatterns() {
        return this.patterns;
    }

    private int matchingIndex(ResolvedTypeX a) {
        int knownMatch = -1;
        int starMatch = -1;
        int len = this.patterns.size();
        for (int i = 0; i < len; ++i) {
            TypePattern p = this.patterns.get(i);
            if (p.isStar()) {
                starMatch = i;
                continue;
            }
            if (!p.matchesStatically(a)) continue;
            if (knownMatch != -1) {
                a.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("multipleMatchesInPrecedence", a, this.patterns.get(knownMatch), p), this.patterns.get(knownMatch).getSourceLocation(), p.getSourceLocation());
                return -1;
            }
            knownMatch = i;
        }
        if (knownMatch == -1) {
            return starMatch;
        }
        return knownMatch;
    }

    public int compare(ResolvedTypeX aspect1, ResolvedTypeX aspect2) {
        int index1 = this.matchingIndex(aspect1);
        int index2 = this.matchingIndex(aspect2);
        if (index1 == -1 || index2 == -1) {
            return 0;
        }
        if (index1 == index2) {
            return 0;
        }
        if (index1 > index2) {
            return -1;
        }
        return 1;
    }

    public boolean isAdviceLike() {
        return false;
    }
}

