/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import java.util.ArrayList;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BatchImageBuilder
extends AbstractImageBuilder {
    protected BatchImageBuilder(JavaBuilder javaBuilder) {
        super(javaBuilder);
        this.nameEnvironment.isIncrementalBuild = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build() {
        if (JavaBuilder.DEBUG) {
            System.out.println("FULL build");
        }
        try {
            try {
                this.notifier.subTask(org.aspectj.org.eclipse.jdt.internal.core.util.Util.bind("build.cleaningOutput"));
                JavaBuilder.removeProblemsAndTasksFor(this.javaBuilder.currentProject);
                this.cleanOutputFolders(true);
                this.notifier.updateProgressDelta(0.1f);
                this.notifier.subTask(org.aspectj.org.eclipse.jdt.internal.core.util.Util.bind("build.analyzingSources"));
                ArrayList sourceFiles = new ArrayList(33);
                this.addAllSourceFiles(sourceFiles);
                this.notifier.updateProgressDelta(0.15f);
                if (sourceFiles.size() > 0) {
                    SourceFile[] allSourceFiles = new SourceFile[sourceFiles.size()];
                    sourceFiles.toArray(allSourceFiles);
                    this.notifier.setProgressPerCompilationUnit(0.75f / (float)allSourceFiles.length);
                    this.workQueue.addAll(allSourceFiles);
                    this.compile(allSourceFiles);
                }
                if (this.javaBuilder.javaProject.hasCycleMarker()) {
                    this.javaBuilder.mustPropagateStructuralChanges();
                }
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanUp();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.cleanUp();
    }

    protected void addAllSourceFiles(final ArrayList sourceFiles) throws CoreException {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            final ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
            final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
            final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
            final boolean isAlsoProject = sourceLocation.sourceFolder.equals(this.javaBuilder.currentProject);
            sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IResource resource = null;
                    switch (proxy.getType()) {
                        case 1: {
                            if ((exclusionPatterns != null || inclusionPatterns != null) && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource = proxy.requestResource(), inclusionPatterns, exclusionPatterns)) {
                                return false;
                            }
                            if (org.aspectj.org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(proxy.getName())) {
                                if (resource == null) {
                                    resource = proxy.requestResource();
                                }
                                sourceFiles.add(new SourceFile((IFile)resource, sourceLocation));
                            }
                            return false;
                        }
                        case 2: {
                            if (exclusionPatterns != null && inclusionPatterns == null && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource = proxy.requestResource(), inclusionPatterns, exclusionPatterns)) {
                                return false;
                            }
                            if (!isAlsoProject || !BatchImageBuilder.this.isExcludedFromProject(proxy.requestFullPath())) break;
                            return false;
                        }
                    }
                    return true;
                }
            }, 0);
            this.notifier.checkCancel();
            ++i;
        }
    }

    protected void cleanOutputFolders(boolean copyBack) throws CoreException {
        block13: {
            block12: {
                boolean deleteAll = "clean".equals(this.javaBuilder.javaProject.getOption("org.aspectj.org.eclipse.jdt.core.builder.cleanOutputFolder", true));
                if (!deleteAll) break block12;
                ArrayList<IContainer> visited = new ArrayList<IContainer>(this.sourceLocations.length);
                int i = 0;
                int l = this.sourceLocations.length;
                while (i < l) {
                    this.notifier.subTask(org.aspectj.org.eclipse.jdt.internal.core.util.Util.bind("build.cleaningOutput"));
                    ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
                    if (sourceLocation.hasIndependentOutputFolder) {
                        IContainer outputFolder = sourceLocation.binaryFolder;
                        if (!visited.contains(outputFolder)) {
                            visited.add(outputFolder);
                            IResource[] members = outputFolder.members();
                            int j = 0;
                            int m = members.length;
                            while (j < m) {
                                IResource member = members[j];
                                if (!member.isDerived()) {
                                    member.accept(new IResourceVisitor(){

                                        public boolean visit(IResource resource) throws CoreException {
                                            resource.setDerived(true);
                                            return resource.getType() != 1;
                                        }
                                    });
                                }
                                member.delete(1, null);
                                ++j;
                            }
                        }
                        this.notifier.checkCancel();
                        if (copyBack) {
                            this.copyExtraResourcesBack(sourceLocation, true);
                        }
                    } else {
                        boolean isOutputFolder = sourceLocation.sourceFolder.equals(sourceLocation.binaryFolder);
                        final char[][] exclusionPatterns = isOutputFolder ? sourceLocation.exclusionPatterns : null;
                        final char[][] inclusionPatterns = isOutputFolder ? sourceLocation.inclusionPatterns : null;
                        sourceLocation.binaryFolder.accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy proxy) throws CoreException {
                                IResource resource = null;
                                if (proxy.getType() == 1) {
                                    if ((exclusionPatterns != null || inclusionPatterns != null) && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource = proxy.requestResource(), inclusionPatterns, exclusionPatterns)) {
                                        return false;
                                    }
                                    if (Util.isClassFileName(proxy.getName())) {
                                        if (resource == null) {
                                            resource = proxy.requestResource();
                                        }
                                        resource.delete(1, null);
                                    }
                                    return false;
                                }
                                if (exclusionPatterns != null && inclusionPatterns == null && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource = proxy.requestResource(), inclusionPatterns, exclusionPatterns)) {
                                    return false;
                                }
                                BatchImageBuilder.this.notifier.checkCancel();
                                return true;
                            }
                        }, 0);
                        if (!isOutputFolder && copyBack) {
                            this.notifier.checkCancel();
                            this.copyPackages(sourceLocation);
                        }
                    }
                    this.notifier.checkCancel();
                    ++i;
                }
                break block13;
            }
            if (!copyBack) break block13;
            int i = 0;
            int l = this.sourceLocations.length;
            while (i < l) {
                ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
                if (sourceLocation.hasIndependentOutputFolder) {
                    this.copyExtraResourcesBack(sourceLocation, false);
                } else if (!sourceLocation.sourceFolder.equals(sourceLocation.binaryFolder)) {
                    this.copyPackages(sourceLocation);
                }
                this.notifier.checkCancel();
                ++i;
            }
        }
    }

    protected void copyExtraResourcesBack(ClasspathMultiDirectory sourceLocation, final boolean deletedAll) throws CoreException {
        this.notifier.subTask(org.aspectj.org.eclipse.jdt.internal.core.util.Util.bind("build.copyingResources"));
        final int segmentCount = sourceLocation.sourceFolder.getFullPath().segmentCount();
        final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
        final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
        final IContainer outputFolder = sourceLocation.binaryFolder;
        final boolean isAlsoProject = sourceLocation.sourceFolder.equals(this.javaBuilder.currentProject);
        sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource resource = null;
                switch (proxy.getType()) {
                    case 1: {
                        if (org.aspectj.org.eclipse.jdt.internal.core.util.Util.isJavaLikeFileName(proxy.getName()) || Util.isClassFileName(proxy.getName())) {
                            return false;
                        }
                        resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        if ((exclusionPatterns != null || inclusionPatterns != null) && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, inclusionPatterns, exclusionPatterns)) {
                            return false;
                        }
                        IPath partialPath = resource.getFullPath().removeFirstSegments(segmentCount);
                        IFile copiedResource = outputFolder.getFile(partialPath);
                        if (copiedResource.exists()) {
                            if (deletedAll) {
                                IResource originalResource = BatchImageBuilder.this.findOriginalResource(partialPath);
                                String id = originalResource.getFullPath().removeFirstSegments(1).toString();
                                BatchImageBuilder.this.createProblemFor(resource, null, org.aspectj.org.eclipse.jdt.internal.core.util.Util.bind("build.duplicateResource", id), BatchImageBuilder.this.javaBuilder.javaProject.getOption("org.aspectj.org.eclipse.jdt.core.builder.duplicateResourceTask", true));
                                return false;
                            }
                            copiedResource.delete(1, null);
                        }
                        resource.copy(copiedResource.getFullPath(), 1, null);
                        copiedResource.setDerived(true);
                        org.aspectj.org.eclipse.jdt.internal.core.util.Util.setReadOnly(copiedResource, false);
                        return false;
                    }
                    case 2: {
                        resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        IPath folderPath = resource.getFullPath();
                        if (isAlsoProject && BatchImageBuilder.this.isExcludedFromProject(folderPath)) {
                            return false;
                        }
                        if (exclusionPatterns != null && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, inclusionPatterns, exclusionPatterns)) {
                            return inclusionPatterns != null;
                        }
                        BatchImageBuilder.this.createFolder(folderPath.removeFirstSegments(segmentCount), outputFolder);
                    }
                }
                return true;
            }
        }, 0);
    }

    protected void copyPackages(ClasspathMultiDirectory sourceLocation) throws CoreException {
        final int segmentCount = sourceLocation.sourceFolder.getFullPath().segmentCount();
        final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
        final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
        final IContainer outputFolder = sourceLocation.binaryFolder;
        final boolean isAlsoProject = sourceLocation.sourceFolder.equals(this.javaBuilder.currentProject);
        sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                switch (proxy.getType()) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        IResource resource = proxy.requestResource();
                        if (BatchImageBuilder.this.javaBuilder.filterExtraResource(resource)) {
                            return false;
                        }
                        IPath folderPath = resource.getFullPath();
                        if (isAlsoProject && BatchImageBuilder.this.isExcludedFromProject(folderPath)) {
                            return false;
                        }
                        if (exclusionPatterns != null && org.aspectj.org.eclipse.jdt.internal.core.util.Util.isExcluded(resource, inclusionPatterns, exclusionPatterns)) {
                            return inclusionPatterns != null;
                        }
                        BatchImageBuilder.this.createFolder(folderPath.removeFirstSegments(segmentCount), outputFolder);
                    }
                }
                return true;
            }
        }, 0);
    }

    protected IResource findOriginalResource(IPath partialPath) {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            IFile originalResource;
            ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
            if (sourceLocation.hasIndependentOutputFolder && (originalResource = sourceLocation.sourceFolder.getFile(partialPath)).exists()) {
                return originalResource;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "batch image builder for:\n\tnew state: " + this.newState;
    }
}

