/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IPrivilegedHandler;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UpdatedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ObjectVector;

public abstract class Scope
implements BaseTypes,
CompilerModifiers,
ProblemReasons,
TagBits,
TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public int kind;
    public Scope parent;

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    public static ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] originalTypes) {
        ReferenceBinding[] substitutedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            ReferenceBinding originalType = originalTypes[i];
            ReferenceBinding substitutedParameter = (ReferenceBinding)substitution.substitute(originalType);
            if (substitutedParameter != originalType) {
                if (substitutedTypes == originalTypes) {
                    substitutedTypes = new ReferenceBinding[length];
                    System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                }
                substitutedTypes[i] = substitutedParameter;
            } else if (substitutedTypes != originalTypes) {
                substitutedTypes[i] = originalType;
            }
            ++i;
        }
        return substitutedTypes;
    }

    public static TypeBinding[] substitute(Substitution substitution, TypeBinding[] originalTypes) {
        TypeBinding[] substitutedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            TypeBinding originalType = originalTypes[i];
            TypeBinding substitutedParameter = substitution.substitute(originalType);
            if (substitutedParameter != originalType) {
                if (substitutedTypes == originalTypes) {
                    substitutedTypes = new TypeBinding[length];
                    System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                }
                substitutedTypes[i] = substitutedParameter;
            } else if (substitutedTypes != originalTypes) {
                substitutedTypes[i] = originalType;
            }
            ++i;
        }
        return substitutedTypes;
    }

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public int boxing(int id) {
        switch (id) {
            case 10: {
                return 29;
            }
            case 3: {
                return 26;
            }
            case 4: {
                return 27;
            }
            case 2: {
                return 28;
            }
            case 7: {
                return 30;
            }
            case 9: {
                return 31;
            }
            case 8: {
                return 32;
            }
            case 5: {
                return 33;
            }
            case 6: {
                return 34;
            }
        }
        return id;
    }

    public TypeBinding boxing(TypeBinding type) {
        switch (type.id) {
            case 10: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_INTEGER);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_INTEGER, 1);
            }
            case 3: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_BYTE);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_BYTE, 1);
            }
            case 4: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_SHORT);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_SHORT, 1);
            }
            case 2: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_CHARACTER);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_CHARACTER, 1);
            }
            case 7: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_LONG);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_LONG, 1);
            }
            case 9: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_FLOAT);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_FLOAT, 1);
            }
            case 8: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_DOUBLE);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_DOUBLE, 1);
            }
            case 5: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_BOOLEAN);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_BOOLEAN, 1);
            }
            case 6: {
                ReferenceBinding boxedType = this.environment().getType(TypeConstants.JAVA_LANG_VOID);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(TypeConstants.JAVA_LANG_VOID, 1);
            }
        }
        return type;
    }

    public final ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public int compareUncheckedException(ReferenceBinding type) {
        int comparison = Scope.compareTypes(type, this.getJavaLangRuntimeException());
        if (comparison != 0) {
            return comparison;
        }
        return Scope.compareTypes(type, this.getJavaLangError());
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite) {
        TypeBinding[] genericTypeArguments = invocationSite.genericTypeArguments();
        TypeBinding[] parameters = method.parameters;
        TypeVariableBinding[] typeVariables = method.typeVariables;
        if (parameters == arguments && (method.returnType.tagBits & 0x20000000L) == 0L && genericTypeArguments == null && typeVariables == TypeConstants.NoTypeVariables) {
            return method;
        }
        int argLength = arguments.length;
        int paramLength = parameters.length;
        boolean isVarArgs = method.isVarargs();
        if (!(argLength == paramLength || isVarArgs && argLength >= paramLength - 1)) {
            return null;
        }
        if (typeVariables != TypeConstants.NoTypeVariables) {
            if ((method = ParameterizedGenericMethodBinding.computeCompatibleMethod(method, arguments, this, invocationSite)) == null) {
                return null;
            }
            if (!method.isValidBinding()) {
                return method;
            }
            parameters = method.parameters;
        } else if (genericTypeArguments != null) {
            if (method instanceof ParameterizedGenericMethodBinding) {
                if (!((ParameterizedGenericMethodBinding)method).wasInferred) {
                    return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 13);
                }
            } else {
                return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 11);
            }
        }
        if (this.parameterCompatibilityLevel(method, arguments) > -1) {
            return method;
        }
        if (genericTypeArguments != null) {
            return new ProblemMethodBinding(method, method.selector, arguments, 12);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean connectTypeVariables(TypeParameter[] typeParameters) {
        noProblems = true;
        if (typeParameters == null || this.environment().options.sourceLevel < 0x310000L) {
            return true;
        }
        i = 0;
        paramLength = typeParameters.length;
        while (i < paramLength) {
            block15: {
                block16: {
                    typeParameter = typeParameters[i];
                    typeVariable = typeParameter.binding;
                    if (typeVariable == null) {
                        return false;
                    }
                    typeVariable.superclass = this.getJavaLangObject();
                    typeVariable.superInterfaces = TypeConstants.NoSuperInterfaces;
                    typeVariable.firstBound = null;
                    typeRef = typeParameter.type;
                    if (typeRef == null) break block15;
                    v0 = superType = this.kind == 2 ? (ReferenceBinding)typeRef.resolveType((BlockScope)this, false) : (ReferenceBinding)typeRef.resolveType((ClassScope)this);
                    if (superType != null) break block16;
                    typeVariable.tagBits |= 32768L;
                    noProblems = false;
                    break block15;
                }
                if (!superType.isTypeVariable()) ** GOTO lbl-1000
                varSuperType = (TypeVariableBinding)superType;
                if (varSuperType.rank >= typeVariable.rank && varSuperType.declaringElement == typeVariable.declaringElement) {
                    this.problemReporter().forwardTypeVariableReference(typeParameter, varSuperType);
                    typeVariable.tagBits |= 32768L;
                    noProblems = false;
                } else lbl-1000:
                // 2 sources

                {
                    if (superType.isFinal()) {
                        this.problemReporter().finalVariableBound(typeVariable, typeRef);
                    }
                    typeRef.resolvedType = superType;
                    if (superType.isClass()) {
                        typeVariable.superclass = superType;
                    } else {
                        typeVariable.superInterfaces = new ReferenceBinding[]{superType};
                        typeVariable.modifiers |= 512;
                    }
                    typeVariable.firstBound = superType;
                    boundRefs = typeParameter.bounds;
                    if (boundRefs != null) {
                        j = 0;
                        k = boundRefs.length;
                        while (j < k) {
                            typeRef = boundRefs[j];
                            v1 = superType = this.kind == 2 ? (ReferenceBinding)typeRef.resolveType((BlockScope)this, false) : (ReferenceBinding)typeRef.resolveType((ClassScope)this);
                            if (superType == null) {
                                typeVariable.tagBits |= 32768L;
                                noProblems = false;
                                break;
                            }
                            typeRef.resolvedType = superType;
                            if (superType.isClass()) {
                                this.problemReporter().boundsMustBeAnInterface(typeRef, superType);
                                typeVariable.tagBits |= 32768L;
                                noProblems = false;
                                break;
                            }
                            if (superType.isParameterizedType()) {
                                match = typeVariable.superclass.findSuperTypeErasingTo((ReferenceBinding)superType.erasure());
                                isCollision = match != null && match != superType;
                                index = typeVariable.superInterfaces.length;
                                while (!isCollision && --index >= 0) {
                                    temp = typeVariable.superInterfaces[index];
                                    v2 = isCollision = superType != temp && superType.erasure() == temp.erasure();
                                }
                                if (isCollision) {
                                    this.problemReporter().boundHasConflictingArguments(typeRef, superType);
                                    typeVariable.tagBits |= 32768L;
                                    noProblems = false;
                                    break;
                                }
                            }
                            size = typeVariable.superInterfaces.length;
                            typeVariable.superInterfaces = new ReferenceBinding[size + 1];
                            System.arraycopy(typeVariable.superInterfaces, 0, typeVariable.superInterfaces, 0, size);
                            typeVariable.superInterfaces[size] = superType;
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        return noProblems;
    }

    public TypeBinding convertToRawType(TypeBinding type) {
        int dimension = type.dimensions();
        TypeBinding originalType = type.leafComponentType();
        if (originalType instanceof ReferenceBinding) {
            ReferenceBinding originalEnclosing;
            ReferenceBinding convertedType = (ReferenceBinding)originalType;
            ReferenceBinding convertedEnclosing = originalEnclosing = originalType.enclosingType();
            if (originalEnclosing != null && convertedType.isStatic() && originalEnclosing.isGenericType()) {
                convertedEnclosing = (ReferenceBinding)this.convertToRawType(originalEnclosing);
            }
            if (originalType.isGenericType()) {
                convertedType = this.environment().createRawType(convertedType, convertedEnclosing);
            } else if (originalEnclosing != convertedEnclosing) {
                convertedType = this.createParameterizedType(convertedType, null, convertedEnclosing);
            }
            if (originalType != convertedType) {
                return dimension > 0 ? this.createArrayType(convertedType, dimension) : convertedType;
            }
        }
        return type;
    }

    public ArrayBinding createArrayType(TypeBinding type, int dimension) {
        if (type.isValidBinding()) {
            return this.environment().createArrayType(type, dimension);
        }
        return new ArrayBinding(type, dimension, this.environment());
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding genericType, TypeBinding[] arguments, ReferenceBinding enclosingType) {
        block3: {
            if (genericType.isValidBinding()) {
                int i = 0;
                int max = arguments == null ? 0 : arguments.length;
                while (i < max) {
                    if (arguments[i].isValidBinding()) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return this.environment().createParameterizedType(genericType, arguments, enclosingType);
            }
        }
        return new ParameterizedTypeBinding(genericType, arguments, enclosingType, this.environment());
    }

    public TypeVariableBinding[] createTypeVariables(TypeParameter[] typeParameters, Binding declaringElement) {
        PackageBinding unitPackage = this.compilationUnitScope().fPackage;
        if (typeParameters == null || this.environment().options.sourceLevel < 0x310000L) {
            return TypeConstants.NoTypeVariables;
        }
        TypeVariableBinding[] typeVariableBindings = TypeConstants.NoTypeVariables;
        int length = typeParameters.length;
        typeVariableBindings = new TypeVariableBinding[length];
        HashtableOfObject knownTypeParameterNames = new HashtableOfObject(length);
        int count = 0;
        int i = 0;
        while (i < length) {
            TypeParameter typeParameter = typeParameters[i];
            TypeVariableBinding parameterBinding = new TypeVariableBinding(typeParameter.name, declaringElement, i);
            parameterBinding.fPackage = unitPackage;
            typeParameter.binding = parameterBinding;
            if (knownTypeParameterNames.containsKey(typeParameter.name)) {
                TypeVariableBinding previousBinding = (TypeVariableBinding)knownTypeParameterNames.get(typeParameter.name);
                if (previousBinding != null) {
                    int j = 0;
                    while (j < i) {
                        TypeParameter previousParameter = typeParameters[j];
                        if (previousParameter.binding == previousBinding) {
                            this.problemReporter().duplicateTypeParameterInType(previousParameter);
                            previousParameter.binding = null;
                            break;
                        }
                        ++j;
                    }
                }
                knownTypeParameterNames.put(typeParameter.name, null);
                this.problemReporter().duplicateTypeParameterInType(typeParameter);
                typeParameter.binding = null;
            } else {
                knownTypeParameterNames.put(typeParameter.name, parameterBinding);
                if (parameterBinding != null) {
                    typeVariableBindings[count++] = parameterBinding;
                }
            }
            ++i;
        }
        if (count != length) {
            TypeVariableBinding[] typeVariableBindingArray = typeVariableBindings;
            typeVariableBindings = new TypeVariableBinding[count];
            System.arraycopy(typeVariableBindingArray, 0, typeVariableBindings, 0, count);
        }
        return typeVariableBindings;
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public SourceTypeBinding invocationType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).invocationType();
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    public MethodBinding findDefaultAbstractMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding classHierarchyStart, MethodBinding matchingMethod, ObjectVector found) {
        boolean isCompliant14;
        int startFoundSize = found.size;
        ReferenceBinding currentType = classHierarchyStart;
        while (currentType != null) {
            matchingMethod = this.findMethodInSuperInterfaces(currentType, selector, found, matchingMethod);
            currentType = currentType.superclass();
        }
        CompilationUnitScope unitScope = this.compilationUnitScope();
        int foundSize = found.size;
        if (foundSize == startFoundSize) {
            if (matchingMethod != null) {
                unitScope.recordTypeReferences(matchingMethod.thrownExceptions);
            }
            return matchingMethod;
        }
        MethodBinding[] candidates = new MethodBinding[foundSize - startFoundSize];
        int candidatesCount = 0;
        MethodBinding problemMethod = null;
        int i = startFoundSize;
        while (i < foundSize) {
            MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
            MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
            if (compatibleMethod != null) {
                if (compatibleMethod.isValidBinding()) {
                    candidates[candidatesCount++] = compatibleMethod;
                } else if (problemMethod == null) {
                    problemMethod = compatibleMethod;
                }
            }
            ++i;
        }
        if (candidatesCount == 1) {
            unitScope.recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (candidatesCount == 0) {
            if (problemMethod != null) {
                return problemMethod;
            }
            int argLength = argumentTypes.length;
            int i2 = 0;
            while (i2 < foundSize) {
                block16: {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i2);
                    TypeBinding[] params = methodBinding.parameters;
                    int paramLength = params.length;
                    int a = 0;
                    block3: while (a < argLength) {
                        TypeBinding arg = argumentTypes[a];
                        int p = 0;
                        while (p < paramLength) {
                            if (params[p] != arg) {
                                ++p;
                                continue;
                            }
                            ++a;
                            continue block3;
                        }
                        break block16;
                    }
                    return methodBinding;
                }
                ++i2;
            }
            return (MethodBinding)found.elementAt(0);
        }
        boolean bl = isCompliant14 = unitScope.environment.options.complianceLevel >= 0x300000L;
        if (isCompliant14) {
            return this.mostSpecificMethodBinding(candidates, candidatesCount, argumentTypes, invocationSite);
        }
        return this.mostSpecificInterfaceMethodBinding(candidates, candidatesCount, invocationSite);
    }

    public ReferenceBinding findDirectMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x4000L) != 0L) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null ? memberType.canBeSeenBy(this.getCurrentPackage()) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(typeName, memberType, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        MethodBinding exactMethod = receiverType.getExactMethod(selector, argumentTypes, unitScope);
        if (exactMethod != null) {
            unitScope.recordTypeReferences(exactMethod.thrownExceptions);
            if (receiverType.isInterface() || exactMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                if (receiverType.id != 1 && argumentTypes == TypeConstants.NoParameters && CharOperation.equals(selector, TypeConstants.GETCLASS) && exactMethod.returnType.isParameterizedType()) {
                    return ParameterizedMethodBinding.instantiateGetClass(receiverType, exactMethod, this);
                }
                if (exactMethod.typeVariables != TypeConstants.NoTypeVariables || invocationSite.genericTypeArguments() != null) {
                    exactMethod = this.computeCompatibleMethod(exactMethod, argumentTypes, invocationSite);
                }
                return exactMethod;
            }
        }
        return null;
    }

    public static final IPrivilegedHandler findPrivilegedHandler(ReferenceBinding type) {
        if (type == null) {
            return null;
        }
        if (type instanceof SourceTypeBinding && ((SourceTypeBinding)type).privilegedHandler != null) {
            return ((SourceTypeBinding)type).privilegedHandler;
        }
        return Scope.findPrivilegedHandler(type.enclosingType());
    }

    /*
     * Enabled aggressive block sorting
     */
    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        if (receiverType.isBaseType()) {
            return null;
        }
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReference(receiverType);
        if (receiverType.isArrayType()) {
            TypeBinding leafType = receiverType.leafComponentType();
            if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)leafType, fieldName, 8);
            }
            if (!CharOperation.equals(fieldName, TypeConstants.LENGTH)) return null;
            return ArrayBinding.ArrayLength;
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemFieldBinding(currentType, fieldName, 8);
        }
        FieldBinding field = currentType.getField(fieldName, true, invocationSite, this);
        if (field != null) {
            FieldBinding ret = field.getVisibleBinding(currentType, invocationSite, this);
            if (ret != null) {
                return ret;
            }
            if (invocationSite == null) {
                if (!field.canBeSeenBy(this.getCurrentPackage())) return new ProblemFieldBinding(field, field.declaringClass, fieldName, 2);
                return field;
            }
            if (!field.canBeSeenBy(currentType, invocationSite, this)) return new ProblemFieldBinding(field, field.declaringClass, fieldName, 2);
            return field;
        }
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        FieldBinding visibleField = null;
        boolean keepLooking = true;
        boolean notVisible = false;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordTypeReference(currentType);
            field = currentType.getField(fieldName, needResolve, invocationSite, this);
            if (field == null) continue;
            keepLooking = false;
            if ((field = field.getVisibleBinding(receiverType, invocationSite, this)) != null) {
                if (!field.canBeSeenBy(receiverType, invocationSite, this)) continue;
                if (visibleField != null) return new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
                visibleField = field;
                continue;
            }
            notVisible = true;
        }
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ProblemFieldBinding ambiguous = null;
            int i = 0;
            block1: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding anInterface = interfaces[j];
                    if ((anInterface.tagBits & 0x800L) == 0L) {
                        anInterface.tagBits |= 0x800L;
                        unitScope.recordTypeReference(anInterface);
                        field = anInterface.getField(fieldName, true, invocationSite, this);
                        if (field != null) {
                            if ((field = field.getVisibleBinding(receiverType, invocationSite, this)) != null) {
                                if (visibleField == null) {
                                    visibleField = field;
                                } else {
                                    ambiguous = new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
                                    break block1;
                                }
                            }
                        } else {
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    ++j;
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleField != null) {
            return visibleField;
        }
        if (!notVisible) return null;
        return new ProblemFieldBinding(currentType, fieldName, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x4000L) != 0L) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.invocationType();
        PackageBinding currentPackage = this.getCurrentPackage();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null) {
                if (!memberType.canBeSeenBy(currentPackage)) return new ProblemReferenceBinding(typeName, memberType, 2);
                return memberType;
            }
            if (!memberType.canBeSeenBy(enclosingType, enclosingSourceType)) return new ProblemReferenceBinding(typeName, memberType, 2);
            return memberType;
        }
        ReferenceBinding currentType = enclosingType;
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        ReferenceBinding visibleMemberType = null;
        boolean keepLooking = true;
        ReferenceBinding notVisible = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordReference(currentType, typeName);
            memberType = currentType.getMemberType(typeName);
            if (memberType == null) continue;
            unitScope.recordTypeReference(memberType);
            keepLooking = false;
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                if (visibleMemberType != null) return new ProblemReferenceBinding(typeName, 3);
                visibleMemberType = memberType;
                continue;
            }
            notVisible = memberType;
        }
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ProblemReferenceBinding ambiguous = null;
            int i = 0;
            block1: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    block22: {
                        ReferenceBinding anInterface = interfaces[j];
                        if ((anInterface.tagBits & 0x800L) == 0L) {
                            anInterface.tagBits |= 0x800L;
                            unitScope.recordReference(anInterface, typeName);
                            memberType = anInterface.getMemberType(typeName);
                            if (memberType != null) {
                                unitScope.recordTypeReference(memberType);
                                if (visibleMemberType == null) {
                                    visibleMemberType = memberType;
                                    break block22;
                                } else {
                                    ambiguous = new ProblemReferenceBinding(typeName, 3);
                                    break block1;
                                }
                            }
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    ++j;
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleMemberType != null) {
            return visibleMemberType;
        }
        if (notVisible == null) return null;
        return new ProblemReferenceBinding(typeName, notVisible, 2);
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        int i;
        ReferenceBinding currentType = receiverType;
        MethodBinding matchingMethod = null;
        ObjectVector found = new ObjectVector();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        if (currentType.isInterface()) {
            unitScope.recordTypeReference(currentType);
            Object[] currentMethods = currentType.getMethods(selector);
            int currentLength = currentMethods.length;
            if (currentLength == 1) {
                matchingMethod = currentMethods[0];
            } else if (currentLength > 1) {
                found.addAll(currentMethods);
            }
            matchingMethod = this.findMethodInSuperInterfaces(currentType, selector, found, matchingMethod);
            currentType = this.getJavaLangObject();
        }
        boolean isCompliant14 = unitScope.environment.options.complianceLevel >= 0x300000L;
        ReferenceBinding classHierarchyStart = currentType;
        while (currentType != null) {
            unitScope.recordTypeReference(currentType);
            Object[] currentMethods = currentType.getMethods(selector);
            int currentLength = currentMethods.length;
            if (isCompliant14 && matchingMethod != null || found.size > 0) {
                int i2 = 0;
                while (i2 < currentLength) {
                    MethodBinding currentMethod = currentMethods[i2];
                    if (matchingMethod != null) {
                        if (currentMethod.areParametersEqual(matchingMethod)) {
                            --currentLength;
                            currentMethods[i2] = null;
                        }
                    } else {
                        int j = 0;
                        int max = found.size;
                        while (j < max) {
                            if (((MethodBinding)found.elementAt(j)).areParametersEqual(currentMethod)) {
                                --currentLength;
                                currentMethods[i2] = null;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
            if (currentLength == 1 && matchingMethod == null && found.size == 0) {
                matchingMethod = currentMethods[0];
            } else if (currentLength > 0) {
                int maxMethod;
                if (matchingMethod != null) {
                    found.add(matchingMethod);
                    matchingMethod = null;
                }
                if ((maxMethod = currentMethods.length) == currentLength) {
                    found.addAll(currentMethods);
                } else {
                    int i3 = 0;
                    int max = currentMethods.length;
                    while (i3 < max) {
                        Object currentMethod = currentMethods[i3];
                        if (currentMethod != null) {
                            found.add(currentMethod);
                        }
                        ++i3;
                    }
                }
            }
            currentType = currentType.superclass();
        }
        int foundSize = found.size;
        MethodBinding[] candidates = null;
        int candidatesCount = 0;
        boolean checkedMatchingMethod = false;
        MethodBinding problemMethod = null;
        if (foundSize > 0) {
            i = 0;
            while (i < foundSize) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        switch (candidatesCount) {
                            case 0: {
                                matchingMethod = compatibleMethod;
                                checkedMatchingMethod = true;
                                break;
                            }
                            case 1: {
                                candidates = new MethodBinding[foundSize];
                                candidates[0] = matchingMethod;
                                matchingMethod = null;
                            }
                            default: {
                                candidates[candidatesCount] = compatibleMethod;
                            }
                        }
                        ++candidatesCount;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
        }
        if (candidatesCount > 0) {
            problemMethod = null;
        }
        if (matchingMethod != null) {
            MethodBinding compatibleMethod;
            if (!checkedMatchingMethod && (compatibleMethod = this.computeCompatibleMethod(matchingMethod, argumentTypes, invocationSite)) != null) {
                if (compatibleMethod.isValidBinding()) {
                    matchingMethod = compatibleMethod;
                    checkedMatchingMethod = true;
                } else {
                    problemMethod = compatibleMethod;
                }
            }
            if (checkedMatchingMethod && !matchingMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, null, found);
                if (interfaceMethod != null) {
                    return interfaceMethod;
                }
                unitScope.recordTypeReferences(matchingMethod.thrownExceptions);
                return matchingMethod;
            }
            if ((matchingMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found)) != null) {
                return matchingMethod;
            }
            return problemMethod;
        }
        if (candidatesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            if (problemMethod != null) {
                return problemMethod;
            }
            int argLength = argumentTypes.length;
            foundSize = found.size;
            int i4 = 0;
            while (i4 < foundSize) {
                block59: {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i4);
                    TypeBinding[] params = methodBinding.parameters;
                    int paramLength = params.length;
                    int a = 0;
                    block10: while (a < argLength) {
                        TypeBinding arg = argumentTypes[a];
                        int p = 0;
                        while (p < paramLength) {
                            if (params[p] != arg) {
                                ++p;
                                continue;
                            }
                            ++a;
                            continue block10;
                        }
                        break block59;
                    }
                    return methodBinding;
                }
                ++i4;
            }
            if (found.size == 0) {
                return null;
            }
            return (MethodBinding)found.elementAt(0);
        }
        if (unitScope.environment.options.sourceLevel >= 0x310000L) {
            i = 0;
            while (i < candidatesCount) {
                MethodBinding current = candidates[i];
                if (current instanceof ParameterizedGenericMethodBinding) {
                    current = ((ParameterizedGenericMethodBinding)current).originalMethod;
                }
                if (current instanceof ParameterizedMethodBinding) {
                    int j = i + 1;
                    while (j < candidatesCount) {
                        if (current.declaringClass == candidates[j].declaringClass && current.areParametersEqual(candidates[j])) {
                            return new ProblemMethodBinding(candidates[i].selector, candidates[i].parameters, 3);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        int visiblesCount = 0;
        int i5 = 0;
        while (i5 < candidatesCount) {
            MethodBinding methodBinding = candidates[i5];
            if ((methodBinding = methodBinding.getVisibleBinding(receiverType, invocationSite, this)) != null && methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visiblesCount != i5) {
                    candidates[i5] = null;
                    candidates[visiblesCount] = methodBinding;
                }
                ++visiblesCount;
            }
            ++i5;
        }
        if (visiblesCount == 1) {
            unitScope.recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (visiblesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            return new ProblemMethodBinding(candidates[0], candidates[0].selector, candidates[0].parameters, 2);
        }
        if (isCompliant14) {
            return this.mostSpecificMethodBinding(candidates, visiblesCount, argumentTypes, invocationSite);
        }
        return candidates[0].declaringClass.isClass() ? this.mostSpecificClassMethodBinding(candidates, visiblesCount, invocationSite) : this.mostSpecificInterfaceMethodBinding(candidates, visiblesCount, invocationSite);
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding leafType = receiverType.leafComponentType();
        if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, TypeConstants.NoParameters, (ReferenceBinding)leafType, 8);
        }
        ReferenceBinding object = this.getJavaLangObject();
        MethodBinding methodBinding = object.getExactMethod(selector, argumentTypes);
        if (methodBinding != null) {
            if (argumentTypes == TypeConstants.NoParameters) {
                switch (selector[0]) {
                    case 'c': {
                        if (!CharOperation.equals(selector, TypeConstants.CLONE)) break;
                        return new UpdatedMethodBinding(this.environment().options.targetJDK >= 0x300000L ? receiverType : object, methodBinding.modifiers & 0xFFFFFFFB | 1, TypeConstants.CLONE, methodBinding.returnType, argumentTypes, null, object);
                    }
                    case 'g': {
                        if (!CharOperation.equals(selector, TypeConstants.GETCLASS) || !methodBinding.returnType.isParameterizedType()) break;
                        return ParameterizedMethodBinding.instantiateGetClass(receiverType, methodBinding, this);
                    }
                }
            }
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(object, selector, argumentTypes, invocationSite)) == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        if (methodBinding.isValidBinding()) {
            MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
            if (compatibleMethod == null) {
                return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
            }
            if (!compatibleMethod.isValidBinding()) {
                return compatibleMethod;
            }
            methodBinding = compatibleMethod;
            if (!methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
            }
        }
        return methodBinding;
    }

    public MethodBinding findMethodInSuperInterfaces(ReferenceBinding currentType, char[] selector, ObjectVector found, MethodBinding matchingMethod) {
        ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = -1;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800L) == 0L) {
                        currentType.tagBits |= 0x800L;
                        this.compilationUnitScope().recordTypeReference(currentType);
                        Object[] currentMethods = currentType.getMethods(selector);
                        int currentLength = currentMethods.length;
                        if (currentLength == 1 && matchingMethod == null && found.size == 0) {
                            matchingMethod = currentMethods[0];
                        } else if (currentLength > 0) {
                            if (matchingMethod != null) {
                                found.add(matchingMethod);
                                matchingMethod = null;
                            }
                            found.addAll(currentMethods);
                        }
                        itsInterfaces = currentType.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    ++j;
                }
                ++i;
            }
        }
        return matchingMethod;
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        ReferenceBinding typeBinding = declarationPackage.getType(typeName);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && !typeBinding.canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(typeName, typeBinding, 2);
        }
        return typeBinding;
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    public static TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return BaseTypes.IntBinding;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return BaseTypes.VoidBinding;
                }
                case 'b': {
                    if (length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n') {
                        return BaseTypes.BooleanBinding;
                    }
                    if (length != 4 || name[1] != 'y' || name[2] != 't' || name[3] != 'e') break;
                    return BaseTypes.ByteBinding;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return BaseTypes.CharBinding;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return BaseTypes.DoubleBinding;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return BaseTypes.FloatBinding;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return BaseTypes.LongBinding;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return BaseTypes.ShortBinding;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        try {
            Binding binding = null;
            Binding problemField = null;
            if ((mask & 3) != 0) {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                Binding foundField = null;
                ProblemFieldBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                int foundDepth = 0;
                SourceTypeBinding foundActualReceiverType = null;
                block8: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                        }
                        case 1: {
                            LocalVariableBinding variableBinding = scope.findVariable(name);
                            if (variableBinding == null) break;
                            if (foundField != null && foundField.isValidBinding()) {
                                return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                            }
                            if (depth <= 0) return variableBinding;
                            invocationSite.setDepth(depth);
                            return variableBinding;
                        }
                        case 3: {
                            ClassScope classScope = (ClassScope)scope;
                            SourceTypeBinding enclosingType = classScope.referenceContext.binding;
                            FieldBinding fieldBinding = classScope.findField(enclosingType, name, invocationSite, needResolve);
                            if (fieldBinding != null) {
                                if (fieldBinding.problemId() == 3) {
                                    if (foundField == null) return fieldBinding;
                                    if (foundField.problemId() != 2) return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                    return fieldBinding;
                                }
                                ProblemFieldBinding insideProblem = null;
                                if (fieldBinding.isValidBinding()) {
                                    if (!fieldBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 6);
                                        } else if (insideStaticContext) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 7);
                                        }
                                    }
                                    if (enclosingType == fieldBinding.declaringClass || this.environment().options.complianceLevel >= 0x300000L) {
                                        if (foundField == null) {
                                            FieldBinding fieldBinding2;
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(enclosingType);
                                            }
                                            if (insideProblem == null) {
                                                fieldBinding2 = fieldBinding;
                                                return fieldBinding2;
                                            }
                                            fieldBinding2 = insideProblem;
                                            return fieldBinding2;
                                        }
                                        if (foundField.isValidBinding() && ((FieldBinding)foundField).declaringClass != fieldBinding.declaringClass) {
                                            return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                        }
                                    }
                                }
                                if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                    foundDepth = depth;
                                    foundActualReceiverType = enclosingType;
                                    foundInsideProblem = insideProblem;
                                    foundField = fieldBinding;
                                }
                            }
                            depth += classScope.addDepth();
                            insideStaticContext |= this.invocationType().isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block8;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundInsideProblem != null) {
                    return foundInsideProblem;
                }
                if (foundField != null) {
                    if (foundField.isValidBinding()) {
                        if (foundDepth <= 0) return foundField;
                        invocationSite.setDepth(foundDepth);
                        invocationSite.setActualReceiverType(foundActualReceiverType);
                        return foundField;
                    }
                    problemField = foundField;
                }
                if (this.environment().options.complianceLevel >= 0x310000L) {
                    CompilationUnitScope unitScope = (CompilationUnitScope)scope;
                    ImportBinding[] imports = unitScope.imports;
                    if (imports != null) {
                        int i = 0;
                        int length = imports.length;
                        while (i < length) {
                            ImportBinding importBinding = imports[i];
                            if (importBinding.isStatic() && !importBinding.onDemand && CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) && unitScope.resolveSingleImport(importBinding) != null && importBinding.resolvedImport instanceof FieldBinding) {
                                ImportReference importReference = importBinding.reference;
                                if (importReference == null) return importBinding.resolvedImport;
                                importReference.used = true;
                                return importBinding.resolvedImport;
                            }
                            ++i;
                        }
                        boolean foundInImport = false;
                        int i2 = 0;
                        int length2 = imports.length;
                        while (i2 < length2) {
                            FieldBinding temp;
                            Binding resolvedImport;
                            ImportBinding importBinding = imports[i2];
                            if (importBinding.isStatic() && importBinding.onDemand && (resolvedImport = importBinding.resolvedImport) instanceof ReferenceBinding && (temp = this.findField((ReferenceBinding)resolvedImport, name, invocationSite, needResolve)) != null) {
                                if (!temp.isValidBinding()) {
                                    problemField = temp;
                                } else if (temp.isStatic()) {
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    if (foundInImport) {
                                        return new ProblemReferenceBinding(name, 3);
                                    }
                                    foundField = temp;
                                    foundInImport = true;
                                }
                            }
                            ++i2;
                        }
                        if (foundField != null) {
                            return foundField;
                        }
                    }
                }
            }
            if ((mask & 4) != 0) {
                binding = Scope.getBaseType(name);
                if (binding != null) {
                    return binding;
                }
                binding = this.getTypeOrPackage(name, (mask & 0x10) == 0 ? 4 : 20);
                if (binding.isValidBinding()) return binding;
                if (mask == 4) {
                    return binding;
                }
            } else if ((mask & 0x10) != 0) {
                this.compilationUnitScope().recordSimpleReference(name);
                binding = this.environment().getTopLevelPackage(name);
                if (binding != null) {
                    return binding;
                }
            }
            if (problemField == null) return new ProblemBinding(name, (ReferenceBinding)this.enclosingSourceType(), 1);
            return problemField;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public MethodBinding getConstructor(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        try {
            CompilationUnitScope unitScope = this.compilationUnitScope();
            unitScope.recordTypeReference(receiverType);
            unitScope.recordTypeReferences(argumentTypes);
            MethodBinding methodBinding = receiverType.getExactConstructor(argumentTypes);
            if (methodBinding != null) {
                methodBinding = methodBinding.getVisibleBinding(invocationSite, this);
            }
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                }
                return methodBinding;
            }
            MethodBinding[] methods = receiverType.getMethods(TypeConstants.INIT);
            if (methods == TypeConstants.NoMethods) {
                return new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
            }
            MethodBinding[] compatible = new MethodBinding[methods.length];
            int compatibleIndex = 0;
            MethodBinding problemMethod = null;
            int i = 0;
            int length = methods.length;
            while (i < length) {
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methods[i], argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        compatible[compatibleIndex++] = compatibleMethod;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
            if (compatibleIndex == 0) {
                if (problemMethod == null) {
                    return new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
                }
                return problemMethod;
            }
            MethodBinding[] visible = new MethodBinding[compatibleIndex];
            int visibleIndex = 0;
            int i2 = 0;
            while (i2 < compatibleIndex) {
                MethodBinding method = compatible[i2];
                if ((method = method.getVisibleBinding(invocationSite, this)) != null && method.canBeSeenBy(invocationSite, this)) {
                    visible[visibleIndex++] = method;
                }
                ++i2;
            }
            if (visibleIndex == 1) {
                return visible[0];
            }
            if (visibleIndex == 0) {
                return new ProblemMethodBinding(compatible[0], TypeConstants.INIT, compatible[0].parameters, 2);
            }
            return this.mostSpecificMethodBinding(visible, visibleIndex, argumentTypes, invocationSite);
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null) break;
                    return context.modifiers;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (type == null) break;
                return type.modifiers;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                return context.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        try {
            FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
            if (field != null) {
                return field;
            }
            return new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MethodBinding getImplicitMethod(char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        block46: {
            Binding foundMethod;
            block47: {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                foundMethod = null;
                MethodBinding foundFuzzyProblem = null;
                ProblemMethodBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                block5: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                            break;
                        }
                        case 3: {
                            MethodBinding methodBinding;
                            ClassScope classScope = (ClassScope)scope;
                            SourceTypeBinding receiverType = classScope.referenceContext.binding;
                            boolean isExactMatch = true;
                            MethodBinding methodBinding2 = methodBinding = foundMethod == null ? classScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite) : classScope.findExactMethod(receiverType, ((MethodBinding)foundMethod).selector, ((MethodBinding)foundMethod).parameters, invocationSite);
                            if (methodBinding == null) {
                                isExactMatch = false;
                                methodBinding = classScope.findMethod(receiverType, selector, argumentTypes, invocationSite);
                            }
                            if (methodBinding != null) {
                                if (methodBinding.problemId() == 3) {
                                    if (foundMethod != null && foundMethod.problemId() != 2) {
                                        return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 5);
                                    }
                                    return methodBinding;
                                }
                                MethodBinding fuzzyProblem = null;
                                ProblemMethodBinding insideProblem = null;
                                if (methodBinding.isValidBinding()) {
                                    if (!isExactMatch) {
                                        MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                                        if (compatibleMethod == null) {
                                            if (foundMethod == null || foundMethod.problemId() == 2) {
                                                return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
                                            }
                                            fuzzyProblem = new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 5);
                                        } else if (!compatibleMethod.isValidBinding()) {
                                            fuzzyProblem = compatibleMethod;
                                        } else {
                                            methodBinding = compatibleMethod;
                                            if (!methodBinding.canBeSeenBy(receiverType, invocationSite, classScope)) {
                                                MethodBinding visMethodBinding = methodBinding.getVisibleBinding(invocationSite, this);
                                                if (visMethodBinding == null) {
                                                    fuzzyProblem = new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
                                                } else {
                                                    methodBinding = visMethodBinding;
                                                }
                                            }
                                        }
                                    }
                                    if (fuzzyProblem == null && !methodBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 6);
                                        } else if (insideStaticContext) {
                                            insideProblem = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 7);
                                        }
                                    }
                                    if (receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != TypeConstants.NoMethods || (fuzzyProblem == null || fuzzyProblem.problemId() != 2) && this.environment().options.complianceLevel >= 0x300000L) {
                                        if (foundMethod == null) {
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(receiverType);
                                            }
                                            if (fuzzyProblem != null) {
                                                return fuzzyProblem;
                                            }
                                            if (insideProblem != null) {
                                                return insideProblem;
                                            }
                                            return methodBinding;
                                        }
                                        if (((MethodBinding)foundMethod).declaringClass != methodBinding.declaringClass) {
                                            return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 5);
                                        }
                                    }
                                }
                                if (foundMethod == null || foundMethod.problemId() == 2 && methodBinding.problemId() != 2) {
                                    if (depth > 0) {
                                        invocationSite.setDepth(depth);
                                        invocationSite.setActualReceiverType(receiverType);
                                    }
                                    foundFuzzyProblem = fuzzyProblem;
                                    foundInsideProblem = insideProblem;
                                    if (fuzzyProblem == null) {
                                        foundMethod = methodBinding;
                                    }
                                }
                            }
                            ++depth;
                            insideStaticContext |= receiverType.isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block5;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundFuzzyProblem != null) {
                    return foundFuzzyProblem;
                }
                if (foundInsideProblem != null) {
                    return foundInsideProblem;
                }
                if (foundMethod != null) {
                    return foundMethod;
                }
                if (!insideStaticContext || this.environment().options.complianceLevel < 0x310000L) break block46;
                CompilationUnitScope unitScope = (CompilationUnitScope)scope;
                ImportBinding[] imports = unitScope.imports;
                if (imports == null) break block47;
                boolean foundInImport = false;
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    block48: {
                        MethodBinding temp;
                        block50: {
                            ImportBinding importBinding;
                            block49: {
                                Binding resolvedImport;
                                importBinding = imports[i];
                                if (!importBinding.isStatic() || !importBinding.onDemand || !((resolvedImport = importBinding.resolvedImport) instanceof ReferenceBinding) || (temp = this.findMethod((ReferenceBinding)resolvedImport, selector, argumentTypes, invocationSite)) == null) break block48;
                                if (temp.isValidBinding()) break block49;
                                if (foundMethod == null) {
                                    foundMethod = temp;
                                }
                                break block48;
                            }
                            if (!temp.isStatic()) break block48;
                            MethodBinding compatibleMethod = this.computeCompatibleMethod(temp, argumentTypes, invocationSite);
                            if (compatibleMethod == null) break block50;
                            if (compatibleMethod.isValidBinding()) {
                                if (compatibleMethod.canBeSeenBy(unitScope.fPackage)) {
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    if (foundInImport) {
                                        return new ProblemMethodBinding(compatibleMethod, selector, compatibleMethod.parameters, 3);
                                    }
                                    foundMethod = compatibleMethod;
                                    foundInImport = true;
                                    break block48;
                                } else if (foundMethod == null) {
                                    foundMethod = new ProblemMethodBinding(compatibleMethod, selector, compatibleMethod.parameters, 2);
                                }
                            }
                            break block48;
                        }
                        if (foundMethod == null) {
                            foundMethod = new ProblemMethodBinding(temp, selector, argumentTypes, 1);
                        }
                    }
                    ++i;
                }
            }
            if (foundMethod != null) {
                return foundMethod;
            }
        }
        return new ProblemMethodBinding(selector, argumentTypes, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_IO_SERIALIZABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_IO_SERIALIZABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_IO_SERIALIZABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangAnnotationAnnotation() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ASSERTIONERROR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangClass() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_CLASS);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_CLASS);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_CLASS, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangCloneable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_CLONEABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_CLONEABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_CLONEABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangEnum() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ENUM);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ENUM);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ENUM, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangError() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ERROR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ERROR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ERROR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangIterable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ITERABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ITERABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ITERABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangObject() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_OBJECT);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_OBJECT);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangRuntimeException() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangString() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_STRING);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_STRING);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_STRING, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangThrowable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_THROWABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_THROWABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_THROWABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaUtilIterator() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_UTIL_ITERATOR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_UTIL_ITERATOR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_UTIL_ITERATOR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = this.findMemberType(typeName, enclosingType);
        if (memberType != null) {
            return memberType;
        }
        return new ProblemReferenceBinding(typeName, 1);
    }

    public MethodBinding getMethod(TypeBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        try {
            if (receiverType.isBaseType()) {
                return new ProblemMethodBinding(selector, argumentTypes, 1);
            }
            this.compilationUnitScope().recordTypeReference(receiverType);
            if (receiverType.isArrayType()) {
                return this.findMethodForArray((ArrayBinding)receiverType, selector, argumentTypes, invocationSite);
            }
            ReferenceBinding currentType = (ReferenceBinding)receiverType;
            if (!currentType.canBeSeenBy(this)) {
                return new ProblemMethodBinding(selector, argumentTypes, 8);
            }
            MethodBinding methodBinding = this.findExactMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding != null) {
                return methodBinding;
            }
            methodBinding = this.findMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding == null) {
                return new ProblemMethodBinding(selector, argumentTypes, 1);
            }
            if (methodBinding.isValidBinding()) {
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                if (compatibleMethod == null) {
                    return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
                }
                if (!compatibleMethod.isValidBinding()) {
                    return compatibleMethod;
                }
                methodBinding = compatibleMethod;
                if (!methodBinding.canBeSeenBy(currentType, invocationSite, this)) {
                    MethodBinding visMethodBinding = methodBinding.getVisibleBinding(invocationSite, this);
                    if (visMethodBinding == null) {
                        return new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
                    }
                    methodBinding = visMethodBinding;
                }
            }
            return methodBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public final Binding getPackage(char[][] compoundName) {
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        Binding binding = this.getTypeOrPackage(compoundName[0], 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int currentIndex = 1;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (currentIndex < compoundName.length) {
            if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(compoundName, 1);
    }

    public final TypeBinding getType(char[] name) {
        TypeBinding binding = Scope.getBaseType(name);
        if (binding != null) {
            return binding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(name, 4);
    }

    public final TypeBinding getType(char[] name, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(name);
        }
        Binding binding = packageBinding.getTypeOrPackage(name);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), binding.problemId());
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding;
        if (!typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), typeBinding, 2);
        }
        return typeBinding;
    }

    /*
     * Unable to fully structure code
     */
    public final TypeBinding getType(char[][] compoundName, int typeNameLength) {
        if (typeNameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(compoundName);
        binding = this.getTypeOrPackage(compoundName[0], typeNameLength == 1 ? 4 : 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < typeNameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        unitScope.recordTypeReference(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl34
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            if (typeBinding instanceof ProblemReferenceBinding) {
                problemBinding = (ProblemReferenceBinding)typeBinding;
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), problemBinding.original, typeBinding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding.problemId());
lbl34:
            // 2 sources

            ** while (currentIndex < typeNameLength)
        }
lbl35:
        // 1 sources

        return typeBinding;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] name, int mask) {
        PackageBinding packageBinding;
        Scope scope = this;
        Binding foundType = null;
        boolean insideStaticContext = false;
        if ((mask & 4) == 0) {
            Scope next = scope;
            while ((next = scope.parent) != null) {
                scope = next;
            }
        } else {
            block7: while (true) {
                switch (scope.kind) {
                    case 2: {
                        TypeVariableBinding typeVariable;
                        MethodScope methodScope = (MethodScope)scope;
                        AbstractMethodDeclaration methodDecl = methodScope.referenceMethod();
                        if (methodDecl != null && methodDecl.binding != null && (typeVariable = methodDecl.binding.getTypeVariable(name)) != null) {
                            return typeVariable;
                        }
                        insideStaticContext |= methodScope.isStatic;
                    }
                    case 1: {
                        ReferenceBinding localType = ((BlockScope)scope).findLocalType(name);
                        if (localType == null) break;
                        if (foundType != null && foundType != localType) {
                            return new ProblemReferenceBinding(name, 5);
                        }
                        return localType;
                    }
                    case 3: {
                        TypeVariableBinding typeVariable;
                        SourceTypeBinding sourceType = ((ClassScope)scope).referenceContext.binding;
                        if (sourceType.isHierarchyBeingConnected()) {
                            typeVariable = sourceType.getTypeVariable(name);
                            if (typeVariable != null) {
                                return typeVariable;
                            }
                            if (!CharOperation.equals(name, sourceType.sourceName)) break;
                            return sourceType;
                        }
                        typeVariable = sourceType.getTypeVariable(name);
                        if (typeVariable != null) {
                            if (insideStaticContext) {
                                return new ProblemReferenceBinding(name, 7);
                            }
                            return typeVariable;
                        }
                        insideStaticContext |= (sourceType.modifiers & 8) != 0;
                        ReferenceBinding memberType = this.findMemberType(name, sourceType);
                        if (memberType != null) {
                            if (memberType.problemId() == 3) {
                                if (foundType != null && foundType.problemId() != 2) {
                                    return new ProblemReferenceBinding(name, 5);
                                }
                                return memberType;
                            }
                            if (memberType.isValidBinding() && (sourceType == memberType.enclosingType() || this.environment().options.complianceLevel >= 0x300000L)) {
                                if (foundType == null) {
                                    return memberType;
                                }
                                if (foundType.isValidBinding() && foundType != memberType) {
                                    return new ProblemReferenceBinding(name, 5);
                                }
                            }
                            if (foundType == null || foundType.problemId() == 2 && memberType.problemId() != 2) {
                                foundType = memberType;
                            }
                        }
                        if (!CharOperation.equals(sourceType.sourceName, name)) break;
                        if (foundType != null && foundType != sourceType && foundType.problemId() != 2) {
                            return new ProblemReferenceBinding(name, 5);
                        }
                        return sourceType;
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope = scope.parent;
            }
            if (foundType != null && foundType.problemId() != 2) {
                return foundType;
            }
        }
        CompilationUnitScope unitScope = (CompilationUnitScope)scope;
        PackageBinding currentPackage = unitScope.fPackage;
        if ((mask & 4) != 0) {
            ImportBinding[] imports = unitScope.imports;
            if (imports != null) {
                HashtableOfObject typeImports = unitScope.resolvedSingeTypeImports;
                if (typeImports != null) {
                    ImportBinding typeImport = (ImportBinding)typeImports.get(name);
                    if (typeImport != null) {
                        ImportReference importReference = typeImport.reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        return typeImport.resolvedImport;
                    }
                } else {
                    int i = 0;
                    int length = imports.length;
                    while (i < length) {
                        ImportBinding typeImport = imports[i];
                        if (!typeImport.onDemand && CharOperation.equals(typeImport.compoundName[typeImport.compoundName.length - 1], name) && unitScope.resolveSingleImport(typeImport) != null) {
                            ImportReference importReference = typeImport.reference;
                            if (importReference != null) {
                                importReference.used = true;
                            }
                            return typeImport.resolvedImport;
                        }
                        ++i;
                    }
                }
            }
            unitScope.recordReference(currentPackage.compoundName, name);
            Binding binding = currentPackage.getTypeOrPackage(name);
            if (binding instanceof ReferenceBinding) {
                return binding;
            }
            if (imports != null) {
                boolean foundInImport = false;
                ReferenceBinding type = null;
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    ImportBinding someImport = imports[i];
                    if (someImport.onDemand) {
                        ReferenceBinding temp;
                        Binding resolvedImport = someImport.resolvedImport;
                        ReferenceBinding referenceBinding = resolvedImport instanceof PackageBinding ? this.findType(name, (PackageBinding)resolvedImport, currentPackage) : (temp = someImport.isStatic() ? this.findMemberType(name, (ReferenceBinding)resolvedImport) : this.findDirectMemberType(name, (ReferenceBinding)resolvedImport));
                        if (temp != null) {
                            if (temp.isValidBinding()) {
                                ImportReference importReference = someImport.reference;
                                if (importReference != null) {
                                    importReference.used = true;
                                }
                                if (foundInImport) {
                                    return new ProblemReferenceBinding(name, 3);
                                }
                                type = temp;
                                foundInImport = true;
                            } else if (foundType == null) {
                                foundType = temp;
                            }
                        }
                    }
                    ++i;
                }
                if (type != null) {
                    return type;
                }
            }
        }
        unitScope.recordSimpleReference(name);
        if ((mask & 0x10) != 0 && (packageBinding = unitScope.environment.getTopLevelPackage(name)) != null) {
            return packageBinding;
        }
        if (foundType != null) {
            return foundType;
        }
        return new ProblemReferenceBinding(name, 1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final Binding getTypeOrPackage(char[][] compoundName) {
        nameLength = compoundName.length;
        if (nameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        binding = this.getTypeOrPackage(compoundName[0], 20);
        if (!binding.isValidBinding()) {
            return binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < nameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return binding;
            }
            checkVisibility = true;
        }
        qualifiedType = null;
        typeBinding = (ReferenceBinding)binding;
        if (typeBinding.isGenericType()) {
            qualifiedType = this.environment().createRawType(typeBinding, (ReferenceBinding)qualifiedType);
        } else {
            v0 /* !! */  = qualifiedType = qualifiedType != null && (qualifiedType.isRawType() != false || qualifiedType.isParameterizedType() != false) ? this.createParameterizedType(typeBinding, null, (ReferenceBinding)qualifiedType) : typeBinding;
        }
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl36
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isGenericType()) {
                qualifiedType = this.environment().createRawType(typeBinding, (ReferenceBinding)qualifiedType);
            } else {
                v1 /* !! */  = qualifiedType = qualifiedType != null && (qualifiedType.isRawType() != false || qualifiedType.isParameterizedType() != false) ? this.createParameterizedType(typeBinding, null, (ReferenceBinding)qualifiedType) : typeBinding;
            }
            if (qualifiedType.isValidBinding()) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), qualifiedType.problemId());
lbl36:
            // 2 sources

            ** while (currentIndex < nameLength)
        }
lbl37:
        // 1 sources

        return qualifiedType;
    }

    public TypeBinding[] greaterLowerBound(TypeBinding[] types) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        TypeBinding[] result = types;
        int removed = 0;
        int i = 0;
        while (i < length) {
            TypeBinding iType = result[i];
            int j = 0;
            while (j < length) {
                TypeBinding jType;
                if (i != j && (jType = result[j]) != null && iType.isCompatibleWith(jType)) {
                    if (result == types) {
                        TypeBinding[] typeBindingArray = result;
                        result = new TypeBinding[length];
                        System.arraycopy(typeBindingArray, 0, result, 0, length);
                    }
                    result[j] = null;
                    ++removed;
                }
                ++j;
            }
            ++i;
        }
        if (removed == 0) {
            return result;
        }
        TypeBinding[] trimmedResult = new TypeBinding[length - removed];
        int i2 = 0;
        int index = 0;
        while (i2 < length) {
            TypeBinding iType = result[i2];
            if (iType != null) {
                trimmedResult[index++] = iType;
            }
            ++i2;
        }
        return trimmedResult;
    }

    public boolean isBoxingCompatibleWith(TypeBinding left, TypeBinding right) {
        return left.isBaseType() != right.isBaseType() && this.environment().isBoxingCompatibleWith(left, right);
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding method) {
        Scope scope = this;
        do {
            ReferenceContext refContext;
            if (!(scope instanceof MethodScope) || !((refContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)refContext).binding != method) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding type) {
        Scope scope;
        ReferenceBinding enclosingType = type;
        while ((type = enclosingType.enclosingType()) != null) {
            enclosingType = type;
        }
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        SourceTypeBinding[] topLevelTypes = ((CompilationUnitScope)unitScope).topLevelTypes;
        int i = topLevelTypes.length;
        while (--i >= 0) {
            if (topLevelTypes[i] != enclosingType) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding type) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).referenceContext.binding != type) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null || !context.isViewedAsDeprecated()) break;
                    return true;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if (type == null || !type.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null || !context.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    private TypeBinding leastContainingInvocation(TypeBinding mec, List invocations) {
        int length = invocations.size();
        if (length == 0) {
            return mec;
        }
        if (length == 1) {
            return (TypeBinding)invocations.get(0);
        }
        int argLength = mec.typeVariables().length;
        if (argLength == 0) {
            return mec;
        }
        TypeBinding[] bestArguments = new TypeBinding[argLength];
        int i = 0;
        while (i < length) {
            TypeBinding invocation = (TypeBinding)invocations.get(i);
            TypeVariableBinding[] invocationVariables = invocation.typeVariables();
            if (invocation.isGenericType()) {
                int j = 0;
                while (j < argLength) {
                    TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[j], invocationVariables[j], (ReferenceBinding)mec, j);
                    if (bestArgument == null) {
                        return null;
                    }
                    bestArguments[j] = bestArgument;
                    ++j;
                }
            } else if (invocation.isParameterizedType()) {
                ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)invocation;
                int j = 0;
                while (j < argLength) {
                    TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[j], parameterizedType.arguments[j], (ReferenceBinding)mec, j);
                    if (bestArgument == null) {
                        return null;
                    }
                    bestArguments[j] = bestArgument;
                    ++j;
                }
            } else if (invocation.isRawType()) {
                return invocation;
            }
            ++i;
        }
        return this.createParameterizedType((ReferenceBinding)mec.erasure(), bestArguments, null);
    }

    private TypeBinding leastContainingTypeArgument(TypeBinding u, TypeBinding v, ReferenceBinding genericType, int rank) {
        if (u == null) {
            return v;
        }
        if (u == v) {
            return u;
        }
        if (v.isWildcard()) {
            WildcardBinding wildV = (WildcardBinding)v;
            if (u.isWildcard()) {
                WildcardBinding wildU = (WildcardBinding)u;
                switch (wildU.kind) {
                    case 1: {
                        switch (wildV.kind) {
                            case 1: {
                                TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, wildV.bound});
                                if (lub == null) {
                                    return null;
                                }
                                return this.environment().createWildcard(genericType, rank, lub, 1);
                            }
                            case 2: {
                                if (wildU.bound == wildV.bound) {
                                    return wildU.bound;
                                }
                                return this.environment().createWildcard(genericType, rank, null, 0);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (wildU.kind == 2) {
                            TypeBinding[] glb = this.greaterLowerBound(new TypeBinding[]{wildU.bound, wildV.bound});
                            if (glb == null) {
                                return null;
                            }
                            return this.environment().createWildcard(genericType, rank, glb[0], 2);
                        } else {
                            break;
                        }
                    }
                }
            } else {
                switch (wildV.kind) {
                    case 1: {
                        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, wildV.bound});
                        if (lub == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, lub, 1);
                    }
                    case 2: {
                        TypeBinding[] glb = this.greaterLowerBound(new TypeBinding[]{u, wildV.bound});
                        if (glb == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, glb[0], 2);
                    }
                }
            }
        } else if (u.isWildcard()) {
            WildcardBinding wildU = (WildcardBinding)u;
            switch (wildU.kind) {
                case 1: {
                    TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, v});
                    if (lub == null) {
                        return null;
                    }
                    return this.environment().createWildcard(genericType, rank, lub, 1);
                }
                case 2: {
                    TypeBinding[] glb = this.greaterLowerBound(new TypeBinding[]{wildU.bound, v});
                    if (glb == null) {
                        return null;
                    }
                    return this.environment().createWildcard(genericType, rank, glb[0], 2);
                }
            }
        }
        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, v});
        if (lub == null) {
            return null;
        }
        return this.environment().createWildcard(genericType, rank, lub, 1);
    }

    public TypeBinding lowerUpperBound(TypeBinding[] types) {
        if (types.length == 1) {
            TypeBinding type = types[0];
            return type == null ? BaseTypes.VoidBinding : type;
        }
        ArrayList invocations = new ArrayList(1);
        TypeBinding mec = this.minimalErasedCandidate(types, invocations);
        return this.leastContainingInvocation(mec, invocations);
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    private TypeBinding minimalErasedCandidate(TypeBinding[] types, List invocations) {
        TypeBinding[] superTypes;
        int superLength;
        HashMap allInvocations = new HashMap(2);
        int length = types.length;
        int indexOfFirst = -1;
        int actualLength = 0;
        int i = 0;
        while (i < length) {
            TypeBinding type = types[i];
            if (type != null) {
                if (type.isBaseType()) {
                    return null;
                }
                if (indexOfFirst < 0) {
                    indexOfFirst = i;
                }
                ++actualLength;
            }
            ++i;
        }
        switch (actualLength) {
            case 0: {
                return BaseTypes.VoidBinding;
            }
            case 1: {
                return types[indexOfFirst];
            }
        }
        TypeBinding firstType = types[indexOfFirst];
        if (firstType.isBaseType()) {
            return null;
        }
        if (firstType.isArrayType()) {
            superLength = 4;
            if (firstType.erasure() != firstType) {
                ArrayList<TypeBinding> someInvocations = new ArrayList<TypeBinding>(1);
                someInvocations.add(firstType);
                allInvocations.put(firstType.erasure(), someInvocations);
            }
            superTypes = new TypeBinding[]{firstType.erasure(), this.getJavaIoSerializable(), this.getJavaLangCloneable(), this.getJavaLangObject()};
        } else {
            ArrayList<TypeBinding> typesToVisit = new ArrayList<TypeBinding>(5);
            if (firstType.erasure() != firstType) {
                ArrayList<TypeBinding> someInvocations = new ArrayList<TypeBinding>(1);
                someInvocations.add(firstType);
                allInvocations.put(firstType.erasure(), someInvocations);
            }
            typesToVisit.add(firstType.erasure());
            ReferenceBinding currentType = (ReferenceBinding)firstType;
            int i2 = 0;
            int max = 1;
            while (i2 < max) {
                TypeBinding itsSuperclassErasure;
                currentType = (ReferenceBinding)typesToVisit.get(i2);
                ReferenceBinding itsSuperclass = currentType.superclass();
                if (itsSuperclass != null && !typesToVisit.contains(itsSuperclassErasure = itsSuperclass.erasure())) {
                    if (itsSuperclassErasure != itsSuperclass) {
                        ArrayList<ReferenceBinding> someInvocations = new ArrayList<ReferenceBinding>(1);
                        someInvocations.add(itsSuperclass);
                        allInvocations.put(itsSuperclassErasure, someInvocations);
                    }
                    typesToVisit.add(itsSuperclassErasure);
                    ++max;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                int j = 0;
                int count = itsInterfaces.length;
                while (j < count) {
                    ReferenceBinding itsInterface = itsInterfaces[j];
                    TypeBinding itsInterfaceErasure = itsInterface.erasure();
                    if (!typesToVisit.contains(itsInterfaceErasure)) {
                        if (itsInterfaceErasure != itsInterface) {
                            ArrayList<ReferenceBinding> someInvocations = new ArrayList<ReferenceBinding>(1);
                            someInvocations.add(itsInterface);
                            allInvocations.put(itsInterfaceErasure, someInvocations);
                        }
                        typesToVisit.add(itsInterfaceErasure);
                        ++max;
                    }
                    ++j;
                }
                ++i2;
            }
            superLength = typesToVisit.size();
            superTypes = new TypeBinding[superLength];
            typesToVisit.toArray(superTypes);
        }
        int remaining = superLength;
        int i3 = indexOfFirst + 1;
        while (i3 < length) {
            TypeBinding otherType = types[i3];
            if (otherType != null) {
                if (otherType.isArrayType()) {
                    int j = 0;
                    while (j < superLength) {
                        TypeBinding superType = superTypes[j];
                        if (superType != null && superType != otherType) {
                            switch (superType.id) {
                                case 1: 
                                case 36: 
                                case 37: {
                                    break;
                                }
                                default: {
                                    superTypes[j] = null;
                                    if (--remaining != 0) break;
                                    return null;
                                }
                            }
                        }
                        ++j;
                    }
                } else {
                    ReferenceBinding otherRefType = (ReferenceBinding)otherType;
                    int j = 0;
                    while (j < superLength) {
                        TypeBinding superType = superTypes[j];
                        if (superType != null) {
                            if (otherRefType.erasure().isCompatibleWith(superType)) {
                                ReferenceBinding match = otherRefType.findSuperTypeErasingTo((ReferenceBinding)superType);
                                if (match == null || match.erasure() == match) break;
                                ArrayList<ReferenceBinding> someInvocations = (ArrayList<ReferenceBinding>)allInvocations.get(superType);
                                if (someInvocations == null) {
                                    someInvocations = new ArrayList<ReferenceBinding>(1);
                                }
                                someInvocations.add(match);
                                allInvocations.put(superType, someInvocations);
                                break;
                            }
                            superTypes[j] = null;
                            if (--remaining == 0) {
                                return null;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < superLength) {
            TypeBinding superType = superTypes[i3];
            if (superType != null) {
                List matchingInvocations = (List)allInvocations.get(superType);
                if (matchingInvocations != null) {
                    invocations.addAll(matchingInvocations);
                }
                return superType;
            }
            ++i3;
        }
        return null;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding problemMethod = null;
        MethodBinding previous = null;
        int i = 0;
        while (i < visibleSize) {
            block5: {
                MethodBinding method = visible[i];
                if (previous != null && method.declaringClass != previous.declaringClass) break;
                if (!method.isStatic()) {
                    previous = method;
                }
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block5;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        if (problemMethod == null) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        return problemMethod;
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding problemMethod = null;
        int i = 0;
        while (i < visibleSize) {
            block4: {
                MethodBinding method = visible[i];
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        if (problemMethod == null) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        return problemMethod;
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] visible, int visibleSize, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        int[] compatibilityLevels = new int[visibleSize];
        int i = 0;
        while (i < visibleSize) {
            compatibilityLevels[i] = this.parameterCompatibilityLevel(visible[i], argumentTypes);
            ++i;
        }
        int level = 0;
        while (level <= 2) {
            int i2 = 0;
            while (i2 < visibleSize) {
                block6: {
                    if (compatibilityLevels[i2] == level) {
                        MethodBinding method = visible[i2];
                        int j = 0;
                        while (j < visibleSize) {
                            TypeBinding elementsType;
                            int paramLength;
                            if (i2 == j || compatibilityLevels[j] != level || visible[j].tiebreakMethod().areParametersCompatibleWith(method.tiebreakMethod().parameters) || method.isVarargs() && visible[j].isVarargs() && (paramLength = method.parameters.length) == visible[j].parameters.length && paramLength == argumentTypes.length + 1 && method.parameters[paramLength - 1].isCompatibleWith(elementsType = ((ArrayBinding)visible[j].parameters[paramLength - 1]).elementsType())) {
                                ++j;
                                continue;
                            }
                            break block6;
                        }
                        this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                        return method;
                    }
                }
                ++i2;
            }
            ++level;
        }
        return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    protected int parameterCompatibilityLevel(MethodBinding method, TypeBinding[] arguments) {
        TypeBinding arg;
        int argLength;
        TypeBinding[] parameters = method.parameters;
        int paramLength = parameters.length;
        int lastIndex = argLength = arguments.length;
        int level = 0;
        if (method.isVarargs()) {
            TypeBinding param;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                param = parameters[lastIndex];
                TypeBinding arg2 = arguments[lastIndex];
                if (param != arg2 && !arg2.isCompatibleWith(param)) {
                    if (this.isBoxingCompatibleWith(arg2, param)) {
                        level = 1;
                    } else {
                        if (!arg2.isCompatibleWith(param = ((ArrayBinding)param).elementsType()) && !this.isBoxingCompatibleWith(arg2, param)) {
                            return -1;
                        }
                        level = 2;
                    }
                }
            } else {
                if (paramLength < argLength) {
                    param = ((ArrayBinding)parameters[lastIndex]).elementsType();
                    int i = lastIndex;
                    while (i < argLength) {
                        arg = arguments[i];
                        if (param != arg && !arg.isCompatibleWith(param) && !this.isBoxingCompatibleWith(arg, param)) {
                            return -1;
                        }
                        ++i;
                    }
                } else if (lastIndex != argLength) {
                    return -1;
                }
                level = 2;
            }
        }
        int i = 0;
        while (i < lastIndex) {
            arg = arguments[i];
            TypeBinding param = parameters[i];
            if (arg != param && !arg.isCompatibleWith(param)) {
                if (!this.isBoxingCompatibleWith(arg, param)) {
                    return -1;
                }
                level = 1;
            }
            ++i;
        }
        return level;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    int startIndex() {
        return 0;
    }

    public CaseStatement switchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).switchCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public int unboxing(int id) {
        switch (id) {
            case 29: {
                return 10;
            }
            case 26: {
                return 3;
            }
            case 27: {
                return 4;
            }
            case 28: {
                return 2;
            }
            case 30: {
                return 7;
            }
            case 31: {
                return 9;
            }
            case 32: {
                return 8;
            }
            case 33: {
                return 5;
            }
            case 34: {
                return 6;
            }
        }
        return id;
    }

    public TypeBinding unboxing(TypeBinding type) {
        switch (type.id) {
            case 29: {
                return BaseTypes.IntBinding;
            }
            case 26: {
                return BaseTypes.ByteBinding;
            }
            case 27: {
                return BaseTypes.ShortBinding;
            }
            case 28: {
                return BaseTypes.CharBinding;
            }
            case 30: {
                return BaseTypes.LongBinding;
            }
            case 31: {
                return BaseTypes.FloatBinding;
            }
            case 32: {
                return BaseTypes.DoubleBinding;
            }
            case 33: {
                return BaseTypes.BooleanBinding;
            }
            case 34: {
                return BaseTypes.VoidBinding;
            }
        }
        return type;
    }
}

