/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateTranslatorTest {
    @Test
    public void testNonNull() throws IOException {
        HashMap<String, String> oneTwoMap = new HashMap<String, String>();
        oneTwoMap.put("one", "two");
        HashMap<String, String> threeFourMap = new HashMap<String, String>();
        threeFourMap.put("three", "four");
        LookupTranslator translator1 = new LookupTranslator(oneTwoMap);
        LookupTranslator translator2 = new LookupTranslator(threeFourMap);
        AggregateTranslator subject = new AggregateTranslator(new CharSequenceTranslator[]{translator1, translator2});
        StringWriter out1 = new StringWriter();
        int result1 = subject.translate((CharSequence)new StringBuffer("one"), 0, (Writer)out1);
        Assertions.assertEquals((int)3, (int)result1, (String)"Incorrect code point consumption");
        Assertions.assertEquals((Object)"two", (Object)out1.toString());
        StringWriter out2 = new StringWriter();
        int result2 = subject.translate((CharSequence)new StringBuffer("three"), 0, (Writer)out2);
        Assertions.assertEquals((int)5, (int)result2, (String)"Incorrect code point consumption");
        Assertions.assertEquals((Object)"four", (Object)out2.toString(), (String)"Incorrect value");
    }

    @Test
    public void testNullConstructor() {
        String testString = "foo";
        AggregateTranslator subject = new AggregateTranslator((CharSequenceTranslator[])null);
        Assertions.assertEquals((Object)"foo", (Object)subject.translate((CharSequence)"foo"));
    }

    @Test
    public void testNullVarargConstructor() {
        String testString = "foo";
        AggregateTranslator subject = new AggregateTranslator(new CharSequenceTranslator[]{null});
        Assertions.assertEquals((Object)"foo", (Object)subject.translate((CharSequence)"foo"));
    }
}

