/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.ContextMenuIf;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.PluginManager;
import devplugin.Program;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateListener;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.programkeyevent.ProgramKeyAndContextMenuListener;
import util.programkeyevent.ProgramKeyEventHandler;
import util.programmouseevent.AutoScrollerAndClickKeyHandler;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.ProgramListCellRenderer;
import util.ui.ProgramPanel;
import util.ui.UiUtilities;

public class ProgramList
extends JList<Program>
implements ChangeListener,
ListDataListener,
PluginStateListener,
ProgramKeyAndContextMenuListener,
AutoScrollerAndClickKeyHandler.ProgramAutoScrollListener {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramList.class);
    private static final int STATE_CHANGE_GAP = 500;
    public static final String DATE_SEPARATOR = "DATE_SEPARATOR";
    private Vector<Program> mPrograms = new Vector();
    private ContextMenuIf mCaller;
    private ProgramKeyEventHandler mKeyEventHandler;
    private JPopupMenu mPopupMenu;
    private AutoScrollerAndClickKeyHandler mAutoScroller;
    private boolean mHandleClicks = false;
    private long mLastStateChange = 0L;
    private ProgramListCellRenderer mListCellRenderer;

    public ProgramList(Vector<Program> programArr) {
        this(programArr, new PluginPictureSettings(0));
    }

    public ProgramList(Program[] programArr) {
        this(programArr, new PluginPictureSettings(0));
    }

    public ProgramList(ListModel<Program> programs) {
        this(programs, new PluginPictureSettings(0));
    }

    public ProgramList(Vector<Program> programVector, ProgramPanelSettings settings) {
        super(programVector);
        this.initialize(settings);
    }

    private void initialize(ProgramPanelSettings settings) {
        this.mListCellRenderer = new ProgramListCellRenderer(settings);
        this.setCellRenderer(this.mListCellRenderer);
        this.setToolTipText("");
        UiUtilities.addKeyRotation(this);
        this.mAutoScroller = new AutoScrollerAndClickKeyHandler(this, this);
    }

    public ProgramList(Program[] programArr, ProgramPanelSettings settings) {
        super(programArr);
        this.initialize(settings);
    }

    public ProgramList(ListModel<Program> programs, ProgramPanelSettings settings) {
        super(programs);
        programs.addListDataListener(this);
        this.initialize(settings);
    }

    public ProgramList(Vector<Program> programVector, PluginPictureSettings settings) {
        this(programVector, new ProgramPanelSettings(settings, false));
    }

    public ProgramList(Program[] programArr, PluginPictureSettings settings) {
        this(programArr, new ProgramPanelSettings(settings, false));
    }

    public ProgramList(ListModel<Program> programs, PluginPictureSettings settings) {
        this(programs, new ProgramPanelSettings(settings, false));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeFromPrograms();
        this.addToPrograms();
        PluginProxyManager.getInstance().addPluginStateListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeFromPrograms();
        PluginProxyManager.getInstance().removePluginStateListener(this);
    }

    private void removeFromPrograms() {
        this.removeFromPrograms(0, this.mPrograms.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromPrograms(int indexFirst, int indexLast) {
        Vector<Program> vector = this.mPrograms;
        synchronized (vector) {
            while (indexFirst >= this.mPrograms.size()) {
                indexFirst = this.mPrograms.size() - 1;
            }
            while (indexLast >= this.mPrograms.size()) {
                indexLast = this.mPrograms.size() - 1;
            }
            if (indexFirst >= 0) {
                for (int i = indexLast; i >= indexFirst; --i) {
                    this.mPrograms.remove(i).removeChangeListener(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPrograms() {
        ListModel<Program> list;
        ListModel<Program> listModel = list = this.getModel();
        synchronized (listModel) {
            this.addToPrograms(0, list.getSize() - 1, list);
        }
    }

    private void addToPrograms(int indexFirst, int indexLast, ListModel<Program> list) {
        if (list.getSize() > indexLast) {
            for (int i = indexFirst; i <= indexLast; ++i) {
                Program element = list.getElementAt(i);
                if (!(element instanceof Program)) continue;
                Program prg = element;
                prg.addChangeListener(this);
                this.mPrograms.add(prg);
            }
        }
    }

    @Deprecated(since="3.3.1")
    public void addMouseListeners(ContextMenuIf caller) {
        this.addMouseAndKeyListeners(caller);
    }

    public void addMouseAndKeyListeners(ContextMenuIf caller) {
        if (!this.mHandleClicks) {
            this.mAutoScroller.setOwner(caller);
            this.mCaller = caller;
            this.mHandleClicks = true;
        }
        if (this.mKeyEventHandler == null) {
            this.mCaller = caller;
            this.mKeyEventHandler = new ProgramKeyEventHandler(this, caller);
            this.addKeyListener(this.mKeyEventHandler);
        }
    }

    private void showPopup(Point p, ContextMenuIf caller) {
        if (this.mPopupMenu != null && this.mPopupMenu.isVisible()) {
            this.mPopupMenu.setVisible(false);
        } else {
            PluginManager mng = Plugin.getPluginManager();
            int inx = this.locationToIndex(p);
            this.setSelectedIndex(inx);
            if (this.getModel().getElementAt(inx) instanceof Program) {
                Program prog = (Program)this.getModel().getElementAt(inx);
                this.mPopupMenu = mng.createPluginContextMenu(prog, caller);
                UiUtilities.registerForClosing(this.mPopupMenu);
                this.mPopupMenu.show(this, p.x - 15, p.y - 15);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (System.currentTimeMillis() - 500L > this.mLastStateChange) {
            this.mLastStateChange = System.currentTimeMillis();
            this.repaint();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.removeFromPrograms();
        this.addToPrograms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalAdded(ListDataEvent e) {
        ListModel<Program> list;
        ListModel<Program> listModel = list = this.getModel();
        synchronized (listModel) {
            this.addToPrograms(e.getIndex0(), e.getIndex1(), list);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.removeFromPrograms(e.getIndex0(), e.getIndex1());
    }

    public Program[] getSelectedPrograms() {
        List o = this.getSelectedValuesList();
        if (o == null || o.size() == 0) {
            return null;
        }
        Program[] p = new Program[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            p[i] = (Program)o.get(i);
        }
        return p;
    }

    @Override
    public void pluginActivated(PluginProxy plugin) {
        if (plugin.getProgramTableIcons(Plugin.getPluginManager().getExampleProgram()) != null) {
            this.updatePrograms();
        }
    }

    @Override
    public void pluginDeactivated(PluginProxy plugin) {
        this.updatePrograms();
    }

    private void updatePrograms() {
        this.repaint();
    }

    @Override
    public void pluginLoaded(PluginProxy plugin) {
    }

    @Override
    public void pluginUnloaded(PluginProxy plugin) {
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Rectangle bounds;
        Point point = event.getPoint();
        int index = this.locationToIndex(point);
        if (index >= 0 && (bounds = this.getCellBounds(index, index)) != null) {
            Container container;
            int x = point.x - bounds.x;
            int y = point.y - bounds.y;
            Component component = this.getCellRenderer().getListCellRendererComponent(this, (Program)this.getModel().getElementAt(index), index, false, false);
            if (component != null && component instanceof Container && (component = (container = (Container)component).getComponent(1)) != null && component instanceof ProgramPanel) {
                ProgramPanel panel = (ProgramPanel)component;
                return panel.getToolTipText(x -= panel.getX(), y -= panel.getY());
            }
        }
        return null;
    }

    public void setShowDateSeparators(boolean show) {
        this.mListCellRenderer.setShowDateSeparators(show);
        this.invalidate();
        this.repaint();
    }

    @Deprecated(since="4.2.3")
    public void addDateSeparators() throws TvBrowserException {
        this.setShowDateSeparators(true);
    }

    @Override
    public void setModel(ListModel<Program> model) {
        super.setModel(model);
        this.mPrograms.clear();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!(model.getElementAt(i) instanceof Program)) continue;
            this.mPrograms.add(model.getElementAt(i));
            model.getElementAt(i).addChangeListener(this);
        }
    }

    public void scrollToNextDateIfAvailable(Date date) {
        for (int i = 0; i < super.getModel().getSize(); ++i) {
            Object test = super.getModel().getElementAt(i);
            if (!(test instanceof Program) || date.compareTo(((Program)test).getDate()) != 0) continue;
            Point p = this.indexToLocation(i);
            if (this.getVisibleRect() != null) {
                super.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.getVisibleRect().height));
                this.repaint();
            }
            return;
        }
    }

    public void scrollToTimeFromCurrentViewIfAvailable(int time) {
        int index = this.locationToIndex(this.getVisibleRect().getLocation());
        if (index < this.getModel().getSize() - 1) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < super.getModel().getSize() - 1) {
                boolean down;
                Date current = ((Program)o).getDate();
                int i = index + 1;
                boolean bl = down = time <= ((Program)o).getStartTime();
                if (down) {
                    i = index - 1;
                }
                Point scrollPoint = null;
                if (down && ((Program)o).getStartTime() == time) {
                    scrollPoint = i > 0 ? this.indexToLocation(i) : this.indexToLocation(i + 1);
                }
                while (down ? i >= 0 : i < super.getModel().getSize()) {
                    Object test = super.getModel().getElementAt(i);
                    if (test instanceof Program) {
                        Program prog = (Program)test;
                        int startTime = prog.getStartTime();
                        if (prog.getDate().compareTo(current) == 0) {
                            if (down ? startTime < time : startTime >= time) {
                                if (scrollPoint != null) break;
                                if (i > 0 || startTime > time) {
                                    scrollPoint = this.indexToLocation(i - 1);
                                    break;
                                }
                                scrollPoint = this.indexToLocation(i);
                                break;
                            }
                            if (down && startTime == time) {
                                if (i > 0) {
                                    scrollPoint = this.indexToLocation(i - 1);
                                    break;
                                }
                                scrollPoint = this.indexToLocation(i);
                            }
                        } else if (scrollPoint == null) {
                            if (down && i < this.getModel().getSize() - 1) {
                                scrollPoint = this.indexToLocation(i + 1);
                                break;
                            }
                            if (!down && i > 0) {
                                scrollPoint = this.indexToLocation(i - 1);
                                break;
                            }
                            scrollPoint = this.indexToLocation(i);
                            break;
                        }
                    } else if (test instanceof String && scrollPoint == null) {
                        if (down || i == 0) {
                            scrollPoint = this.indexToLocation(i);
                            break;
                        }
                        scrollPoint = this.indexToLocation(i - 1);
                        break;
                    }
                    if (down) {
                        --i;
                        continue;
                    }
                    ++i;
                }
                if (scrollPoint == null) {
                    if (down) {
                        if (this.getModel().getSize() > 0) {
                            scrollPoint = this.indexToLocation(0);
                        }
                    } else if (this.getModel().getSize() > 0) {
                        scrollPoint = this.indexToLocation(this.getModel().getSize() - 1);
                    }
                }
                if (scrollPoint != null && this.getVisibleRect() != null) {
                    super.scrollRectToVisible(new Rectangle(scrollPoint.x, scrollPoint.y, 1, this.getVisibleRect().height));
                    this.repaint();
                }
            }
        }
    }

    public void scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable(int time) {
        int index = this.locationToIndex(this.getVisibleRect().getLocation());
        if (index < this.getModel().getSize() - 1) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < super.getModel().getSize() - 1 && ((Program)o).getStartTime() != time) {
                Date current = ((Program)o).getDate();
                if (((Program)o).getStartTime() > time) {
                    time += 1440;
                }
                for (int i = index + 1; i < super.getModel().getSize(); ++i) {
                    Object test = super.getModel().getElementAt(i);
                    if (!(test instanceof Program)) continue;
                    Program prog = (Program)test;
                    int startTime = prog.getStartTime();
                    if (prog.getDate().compareTo(current) > 0) {
                        startTime += 1440;
                    }
                    if (prog.getDate().compareTo(current) < 0 || startTime < time) continue;
                    Point p = this.indexToLocation(i);
                    if (i > 0 || startTime > time) {
                        p = this.indexToLocation(i - 1);
                    }
                    if (this.getVisibleRect() != null) {
                        super.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.getVisibleRect().height));
                        this.repaint();
                    }
                    return;
                }
            }
        }
    }

    public void scrollToNextDayIfAvailable() {
        int index = this.locationToIndex(this.getVisibleRect().getLocation());
        if (index < this.getModel().getSize() - 1) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < super.getModel().getSize() - 1) {
                Date current = ((Program)o).getDate();
                for (int i = index + 1; i < super.getModel().getSize(); ++i) {
                    Object test = super.getModel().getElementAt(i);
                    if (!(test instanceof Program) || current.compareTo(((Program)test).getDate()) >= 0) continue;
                    Point p = this.indexToLocation(i);
                    if (this.getVisibleRect() != null) {
                        super.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.getVisibleRect().height));
                    }
                    return;
                }
            }
        }
    }

    public void scrollToPreviousDayIfAvailable() {
        int index = this.locationToIndex(this.getVisibleRect().getLocation()) - 1;
        if (index > 0) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index - 1);
                --index;
            }
            if (index > 0) {
                Date current = ((Program)o).getDate();
                for (int i = index - 1; i >= 0; --i) {
                    Object test = super.getModel().getElementAt(i);
                    if (!(test instanceof Program) || current.compareTo(((Program)test).getDate()) <= 0) continue;
                    super.ensureIndexIsVisible(i + 1);
                    return;
                }
            }
        }
        if (this.getModel().getSize() > 0) {
            super.ensureIndexIsVisible(0);
        }
    }

    @Deprecated(since="4.2.3")
    public int getNewIndexForOldIndex(int index) {
        return index;
    }

    public static String getPreviousActionTooltip() {
        return LOCALIZER.msg("prevTooltip", "Scrolls to previous day from current view position (if there is previous day in the list)");
    }

    public static String getNextActionTooltip() {
        return LOCALIZER.msg("nextTooltip", "Scrolls to next day from current view position (if there is next day in the list)");
    }

    @Override
    public Program getProgramForMouseEvent(MouseEvent e) {
        int inx = this.locationToIndex(e.getPoint());
        if (inx >= 0) {
            Object element = this.getModel().getElementAt(inx);
            if (element instanceof Program) {
                return (Program)element;
            }
            if (SwingUtilities.isLeftMouseButton(e) && element instanceof String && this.getSelectedIndices().length == 1) {
                this.setSelectedIndex(inx);
            }
        }
        return null;
    }

    @Override
    public void mouseEventActionFinished() {
    }

    @Override
    public void showContextMenu(MouseEvent e) {
        this.showPopup(e.getPoint(), this.mCaller);
    }

    @Override
    public Program getProgramForKeyEvent(KeyEvent e) {
        Object program = this.getSelectedValue();
        if (program instanceof Program) {
            return (Program)program;
        }
        return null;
    }

    @Override
    public void keyEventActionFinished() {
    }

    @Override
    public void showContextMenu(Program program) {
        Point p = this.indexToLocation(this.getSelectedIndex());
        Rectangle r = this.getCellBounds(this.getSelectedIndex(), this.getSelectedIndex());
        p.x += (int)((float)r.width * 0.2f);
        p.y += (int)((float)(r.height * 2) / 3.0f);
        this.showPopup(p, this.mCaller);
    }

    @Override
    public void setSelectedIndex(int row) {
        if (this.getModel().getSize() > 0) {
            int index = this.getSelectedIndex();
            index = index - 1 == row ? -1 : 1;
            if (row == 0 && this.getSelectedIndex() == this.getModel().getSize() - 1) {
                index = 1;
            }
            if (row < 0) {
                row = this.getModel().getSize() - 1;
            } else if (row > this.getModel().getSize() - 1) {
                row = 0;
            }
            if (!(this.getModel().getElementAt(row) instanceof Program)) {
                this.setSelectedIndex(row + index);
            } else {
                super.setSelectedIndex(row);
                this.ensureIndexIsVisible(row);
            }
        }
    }

    @Override
    public Program getProgramAt(int x, int y) {
        int index = this.locationToIndex(new Point(x, y));
        if (index >= 0 && index < this.mPrograms.size()) {
            return this.mPrograms.get(index);
        }
        return null;
    }

    @Override
    public boolean isSelectedItemAt(int x, int y) {
        return this.getSelectedIndex() == this.locationToIndex(new Point(x, y));
    }

    @Override
    public void selectItemAt(int x, int y) {
        this.setSelectedIndex(this.locationToIndex(new Point(x, y)));
    }

    @Override
    public void deSelectItem() {
        this.setSelectedIndex(-1);
    }

    @Override
    public void handleMousePressed(MouseEvent evt) {
    }

    @Override
    public void handleMouseReleased(MouseEvent evt) {
    }

    @Override
    public void handleMouseExited(MouseEvent evt) {
    }

    @Override
    public void handleMouseDragged(MouseEvent evt) {
    }

    @Override
    public void handleMouseMoved(MouseEvent evt) {
    }

    @Override
    public boolean isAutoScrollingEnabled() {
        return true;
    }

    @Override
    public boolean isClickAndContextMenuHandlingEnabled() {
        return this.mHandleClicks;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (Settings.ProgramPanel.SMOOTHER_SCROLLING.getBoolean()) {
            int increment = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            int valueDefault = 10;
            if (increment >= visibleRect.height) {
                valueDefault = Math.max(valueDefault, 10 + increment - visibleRect.height);
            }
            return Math.min(increment, valueDefault);
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }
}

