/*
 * Decompiled with CFR 0.152.
 */
package util.tvdataservice;

import devplugin.AbstractTvDataService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import util.io.IOUtilities;
import util.misc.ChangeTrackingProperties;
import util.misc.SoftReferenceCache;
import util.ui.LazyImageIcon;

public class IconLoader {
    private static final Logger mLog = Logger.getLogger(IconLoader.class.getName());
    private File mIconDir;
    private File mIconIndexFile;
    private String mChannelGroup;
    private ChangeTrackingProperties mProperties;
    private AbstractTvDataService mDataService;
    private static final SoftReferenceCache<String, File> ICON_CACHE = new SoftReferenceCache();
    private static final ArrayList<String> BLOCKED_SERVERS = new ArrayList(0);

    public IconLoader(AbstractTvDataService service, String channelGroup, File dir) throws IOException {
        this.mDataService = service;
        this.mChannelGroup = channelGroup;
        this.mIconDir = new File(dir + "/icons_" + this.mChannelGroup);
        if (!this.mIconDir.exists()) {
            this.mIconDir.mkdirs();
        }
        this.mIconIndexFile = new File(this.mIconDir, "index.txt");
        this.mProperties = new ChangeTrackingProperties();
        if (this.mIconIndexFile.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.mIconIndexFile), 4096);
            this.mProperties.load(in);
            in.close();
        } else {
            mLog.warning("no icons known for channel group " + channelGroup);
        }
    }

    public Icon getIcon(String channelId, String url) throws IOException {
        String key = "icons_" + this.mChannelGroup + "_" + channelId;
        String prevUrl = (String)this.mProperties.get(key);
        Icon icon = null;
        File iconFile = new File(this.mIconDir, this.escapedName(channelId));
        if (url.equals(prevUrl)) {
            icon = this.getIconFromFile(iconFile);
            return icon;
        }
        mLog.warning("iconUrl is not in cache for channelId " + channelId + ". prevUrl=" + prevUrl + ". currentUrl=" + url);
        if (ICON_CACHE.containsKey(url)) {
            try {
                File iconCacheFile = ICON_CACHE.get(url);
                if (iconCacheFile != null && !iconCacheFile.equals(iconFile)) {
                    IOUtilities.copy(ICON_CACHE.get(url), iconFile);
                    icon = this.getIconFromFile(iconFile);
                }
            }
            catch (Exception e) {
                mLog.log(Level.SEVERE, "Problem while copying File from Cache", e);
            }
        }
        if (icon == null && this.mDataService.hasRightToDownloadIcons() && !BLOCKED_SERVERS.contains(url)) {
            try {
                IOUtilities.download(new URL(url), iconFile);
                icon = this.getIconFromFile(iconFile);
                ICON_CACHE.put(url, iconFile);
            }
            catch (IOException e) {
                BLOCKED_SERVERS.add(url);
                mLog.warning("channel " + channelId + ": could not download icon from " + url);
            }
            catch (Exception e) {
                mLog.severe("Could not extract icon file");
            }
        }
        if (icon != null) {
            this.mProperties.setProperty(key, url);
        }
        return icon;
    }

    private String escapedName(String channelId) {
        return StringUtils.replace((String)channelId, (String)".", (String)"_");
    }

    private String unescape(String fileName) {
        return StringUtils.replace((String)fileName, (String)"_", (String)".");
    }

    private Icon getIconFromFile(File iconFile) {
        if (!iconFile.exists()) {
            String namePart = iconFile.getName();
            String unescapedPath = iconFile.getAbsolutePath().replace(namePart, this.unescape(namePart));
            File unescapedFile = new File(unescapedPath);
            if (unescapedFile.exists()) {
                unescapedFile.renameTo(iconFile);
            }
        }
        try {
            return new LazyImageIcon(iconFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() throws IOException {
        FileOutputStream out = new FileOutputStream(this.mIconIndexFile);
        out.getChannel().lock();
        this.mProperties.store(out, null);
        out.close();
    }
}

