/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.settings.PropertyManager;

public abstract class Property {
    private PropertyManager mManager;
    private String mKey;
    private Vector<ChangeListener> mChangeList;

    public Property(PropertyManager manager, String key) {
        this.mManager = manager;
        this.mKey = key;
        this.mChangeList = null;
        this.mManager.addProperty(this);
    }

    protected void setProperty(String value) {
        this.mManager.setProperty(this.mKey, value);
        this.fireChangeEvent();
    }

    protected String getProperty() {
        return this.mManager.getProperty(this.mKey);
    }

    public String getKey() {
        return this.mKey;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.mChangeList == null) {
            this.mChangeList = new Vector(1);
        }
        this.mChangeList.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.mChangeList == null) {
            return;
        }
        this.mChangeList.remove(l);
    }

    public void fireChangeEvent() {
        if (this.mChangeList == null) {
            return;
        }
        for (int i = 0; i < this.mChangeList.size(); ++i) {
            ChangeListener l = this.mChangeList.get(i);
            l.stateChanged(new ChangeEvent(this));
        }
    }

    protected abstract void clearCache();
}

