/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.awt.Color;
import org.apache.commons.lang3.StringUtils;
import util.settings.Property;
import util.settings.PropertyManager;
import util.ui.UiUtilities;

public final class ColorProperty
extends Property {
    private Color mDefaultColor;
    private boolean mIsCacheFilled;
    private Color mCachedValue;

    public ColorProperty(PropertyManager manager, String key, Color defaultvalue) {
        super(manager, key);
        this.mDefaultColor = defaultvalue;
    }

    public Color getDefaultColor() {
        return this.mDefaultColor;
    }

    public Color getColor() {
        if (!this.mIsCacheFilled) {
            String asString = this.getProperty();
            if (asString == null) {
                this.mCachedValue = this.mDefaultColor;
            } else {
                try {
                    if (asString.length() == 9 && asString.startsWith("#")) {
                        Color c;
                        int red = Integer.parseInt(asString.substring(1, 3), 16);
                        int green = Integer.parseInt(asString.substring(3, 5), 16);
                        int blue = Integer.parseInt(asString.substring(5, 7), 16);
                        int alpha = Integer.parseInt(asString.substring(7, 9), 16);
                        this.mCachedValue = c = new Color(red, green, blue, alpha);
                    } else {
                        this.mCachedValue = this.mDefaultColor;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.mCachedValue = this.mDefaultColor;
                }
            }
            this.mIsCacheFilled = true;
        }
        return this.mCachedValue;
    }

    public void setColor(Color color) {
        if (color == this.mDefaultColor) {
            this.setProperty(null);
        } else {
            this.mCachedValue = color;
            String value = UiUtilities.getHTMLColorCode(color) + StringUtils.leftPad((String)Integer.toString(color.getAlpha(), 16), (int)2, (char)'0');
            this.setProperty(value);
        }
    }

    @Override
    protected void clearCache() {
        this.mIsCacheFilled = false;
    }
}

