/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.splashscreen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import tvbrowser.TVBrowser;
import tvbrowser.ui.splashscreen.Splash;
import util.i18n.Localizer;
import util.misc.OperatingSystem;
import util.ui.UiUtilities;

public class SplashScreen
implements Splash {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SplashScreen.class);
    private static final Font MESSAGE_FONT = new Font("Dialog", 1, 15);
    private static final Font VERSION_FONT = new Font("Dialog", 1, 12);
    private static final Font DOMAIN_FONT = new Font("Dialog", 0, 10);
    private static final String DOMAIN = "tvbrowser.org";
    private static final String VERSION = TVBrowser.VERSION.toString();
    private static final String INFO = mLocalizer.msg("info", "The free program guide");
    private String mMessage;
    private int mMsgX;
    private int mMsgY;
    private int mVersionX;
    private int mVersionY;
    private int mDomainX;
    private int mDomainY;
    protected String mImgFileName;
    private java.awt.SplashScreen mSplashScreen = OperatingSystem.isMacOs() ? null : java.awt.SplashScreen.getSplashScreen();
    private Image mImage;
    private JWindow mSplashWindow;

    public SplashScreen() {
        this.mMessage = mLocalizer.ellipsisMsg("loading", "Loading");
        if (this.mSplashScreen == null) {
            try {
                File splash = new File("imgs/splash.png");
                if (splash.isFile()) {
                    this.mImage = ImageIO.read(splash);
                }
            }
            catch (IOException splash) {
                // empty catch block
            }
            if (this.mImage != null) {
                Frame parent = UiUtilities.getParentFrameOnMouseScreen();
                this.mSplashWindow = new JWindow(parent.getGraphicsConfiguration()){

                    @Override
                    public void paint(Graphics g) {
                        ((Graphics2D)g).setBackground(new Color(0, 0, 0, 0));
                        g.clearRect(0, 0, this.getWidth(), this.getHeight());
                        if (SplashScreen.this.mImage != null) {
                            g.drawImage(SplashScreen.this.mImage, 0, 0, null);
                        }
                        SplashScreen.this.paintOnce((Graphics2D)g);
                    }
                };
                this.mSplashWindow.setSize(this.mImage.getWidth(null), this.mImage.getHeight(null));
                this.mSplashWindow.setBackground(new Color(0, 0, 0, 0));
                this.mSplashWindow.setLocationRelativeTo(parent);
                parent.dispose();
            }
        }
    }

    public void paintOnce(Graphics2D grp) {
        Graphics2D graphics = grp;
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        grp.setFont(MESSAGE_FONT);
        grp.setColor(Color.white);
        grp.drawString(this.mMessage, this.mMsgX, this.mMsgY + 32);
        grp.drawString(INFO, this.mMsgX, this.mMsgY);
        grp.setFont(VERSION_FONT);
        grp.setColor(Color.darkGray);
        grp.drawString(VERSION, this.mVersionX, this.mVersionY);
        grp.setFont(DOMAIN_FONT);
        grp.setColor(Color.darkGray);
        grp.drawString(DOMAIN, this.mDomainX, this.mDomainY);
        grp.dispose();
    }

    @Override
    public void setMessage(final String msg) {
        new Thread(){

            @Override
            public void run() {
                SplashScreen.this.mMessage = msg;
                if (SplashScreen.this.mSplashScreen != null && SplashScreen.this.mSplashScreen.isVisible()) {
                    Graphics2D g2d2 = SplashScreen.this.mSplashScreen.createGraphics();
                    g2d2.setColor(Color.white);
                    g2d2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    Graphics2D g2d = SplashScreen.this.mSplashScreen.createGraphics();
                    g2d.setComposite(AlphaComposite.Clear);
                    g2d.fillRect(0, 0, SplashScreen.this.getWidth(), SplashScreen.this.getHeight());
                    g2d.dispose();
                    SplashScreen.this.paintOnce(g2d2);
                    g2d2.dispose();
                    if (SplashScreen.this.mSplashScreen.isVisible()) {
                        SplashScreen.this.mSplashScreen.update();
                    }
                } else if (SplashScreen.this.mSplashWindow != null) {
                    SplashScreen.this.mSplashWindow.repaint();
                }
            }
        }.start();
    }

    private int getWidth() {
        if (this.mSplashScreen != null && this.mSplashScreen.isVisible()) {
            return this.mSplashScreen.getSize().width;
        }
        if (this.mSplashWindow != null) {
            return this.mSplashWindow.getWidth();
        }
        return 0;
    }

    private int getHeight() {
        if (this.mSplashScreen != null && this.mSplashScreen.isVisible()) {
            return this.mSplashScreen.getSize().height;
        }
        if (this.mSplashWindow != null) {
            return this.mSplashWindow.getHeight();
        }
        return 0;
    }

    @Override
    public void hideSplash() {
        if (this.mSplashScreen != null && this.mSplashScreen.isVisible()) {
            this.mSplashScreen.close();
        } else if (this.mSplashWindow != null) {
            this.mSplashWindow.dispose();
        }
    }

    @Override
    public void showSplash() {
        Thread thread = new Thread("Splash screen creation"){

            @Override
            public void run() {
                SplashScreen.this.mMsgY = 93;
                SplashScreen.this.mDomainX = SplashScreen.this.getWidth() - UiUtilities.getStringWidth(DOMAIN_FONT, SplashScreen.DOMAIN) - 15;
                SplashScreen.this.mDomainY = SplashScreen.this.getHeight() - 15;
                SplashScreen.this.mMsgX = 15;
                SplashScreen.this.mVersionX = 15;
                SplashScreen.this.mVersionY = SplashScreen.this.getHeight() - 15;
                if (SplashScreen.this.mSplashWindow != null) {
                    SplashScreen.this.mSplashWindow.setAlwaysOnTop(true);
                    SplashScreen.this.mSplashWindow.setVisible(true);
                    SwingUtilities.invokeLater(() -> SplashScreen.this.mSplashWindow.toFront());
                }
            }
        };
        thread.setPriority(10);
        try {
            SwingUtilities.invokeAndWait(thread);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

