/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ContextMenuAction;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.programinfo.ProgramInfoDialog;
import tvbrowser.extras.programinfo.ProgramInfoSettings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ProgramTable;
import util.i18n.Localizer;
import util.program.ProgramUtilities;
import util.settings.PluginPictureSettings;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;

public class ProgramInfo {
    static Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramInfo.class);
    private static final String DATAFILE_PREFIX = "programinfo.ProgramInfo";
    private Dimension mLeftSplit = null;
    private ProgramInfoSettings mSettings;
    private static ProgramInfo mInstance;
    private Object[] mOrder;
    private static boolean mIsShowing;
    private Thread mInitThread;
    private ArrayList<InfoProgram> mHistory = new ArrayList();
    private int mHistoryIndex = 0;
    private Program[] mNextPrograms;
    private Program[] mPreviousPrograms;

    private ProgramInfo() {
        mInstance = this;
        LookAndFeelAddons.setTrackingLookAndFeelChanges((boolean)true);
    }

    public void handleTvBrowserStartFinished() {
        this.mInitThread = new Thread("Program Info init thread"){

            @Override
            public void run() {
                try {
                    UIThreadRunner.invokeAndWait(() -> {
                        ProgramInfo.this.mPreviousPrograms = new Program[0];
                        ProgramInfo.this.mNextPrograms = new Program[0];
                        ProgramInfoDialog.getInstance(Plugin.getPluginManager().getExampleProgram(), ProgramInfo.this.mLeftSplit, true);
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        this.mInitThread.setPriority(5);
        this.mInitThread.start();
    }

    protected ActionMenu getContextMenuActions(Program program) {
        ContextMenuAction action = new ContextMenuAction();
        action.setText(LOCALIZER.msg("contextMenuText", "Program information"));
        action.setSmallIcon(IconLoader.getInstance().getIconFromTheme("actions", "edit-find", 16));
        action.setActionListener(event -> {
            try {
                UIThreadRunner.invokeAndWait(() -> {
                    this.setLook();
                    this.showProgramInformation(program, true);
                });
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e2) {
                e2.printStackTrace();
            }
        });
        return new ActionMenu(action);
    }

    public static synchronized ProgramInfo getInstance() {
        if (mInstance == null) {
            new ProgramInfo();
        }
        return mInstance;
    }

    public ProgramInfoSettings getSettings() {
        return this.mSettings;
    }

    void loadSettings(Properties prop) {
        this.mSettings = new ProgramInfoSettings(prop);
        int splitWidht = this.mSettings.getWidth();
        int splitHeigt = this.mSettings.getHeight();
        if (splitWidht > 0 && splitHeigt > 0) {
            this.mLeftSplit = new Dimension(splitWidht, splitHeigt);
        }
    }

    Properties storeSettings() {
        if (this.mLeftSplit != null) {
            this.mSettings.setWidth(this.mLeftSplit.width);
            this.mSettings.setHeight(this.mLeftSplit.height);
        }
        return this.mSettings.getProperties();
    }

    public int parseNumber(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showProgramInformation(Program program, boolean showSettings) {
        if (program.equals(Plugin.getPluginManager().getExampleProgram()) && showSettings) {
            return;
        }
        InfoProgram p = new InfoProgram(program);
        if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(program)) {
            this.mHistory.add(p);
            this.mHistoryIndex = this.mHistory.size() - 1;
        }
        Object object = this.mInitThread;
        synchronized (object) {
            if (this.mInitThread != null && this.mInitThread.isAlive()) {
                try {
                    this.mInitThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((mIsShowing || ProgramInfoDialog.isShowing()) && showSettings && !ProgramInfoDialog.closeDialog()) {
            return;
        }
        mIsShowing = true;
        object = this;
        synchronized (object) {
            Window window = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            ProgramTable programTable = MainFrame.getInstance().getProgramTableScrollPane().getProgramTable();
            window.setCursor(Cursor.getPredefinedCursor(3));
            programTable.setCursor(Cursor.getPredefinedCursor(3));
            this.findPreviousAndNextProgram(p);
            Program test = p.getProgram();
            ProgramInfoDialog.getInstance(test != null ? test : program, this.mLeftSplit, showSettings).show();
            window.setCursor(Cursor.getPredefinedCursor(0));
            programTable.setCursor(Cursor.getPredefinedCursor(0));
            mIsShowing = false;
        }
    }

    private void findPreviousAndNextProgram(InfoProgram prog) {
        if (!prog.getProgram().equals(Plugin.getPluginManager().getExampleProgram())) {
            int i;
            Iterator<Program> dayProgram = ProgramUtilities.getJointProgramIteratorFor(prog.mDate, prog.mChannel);
            ArrayList<Program> previousPrograms = new ArrayList<Program>();
            ArrayList<Program> nextPrograms = new ArrayList<Program>();
            boolean currentFound = false;
            while (dayProgram.hasNext()) {
                InfoProgram current = new InfoProgram(dayProgram.next());
                if (prog.equals(current)) {
                    currentFound = true;
                    continue;
                }
                if (currentFound) {
                    nextPrograms.add(current.getProgram());
                    continue;
                }
                previousPrograms.add(current.getProgram());
            }
            if (previousPrograms.size() < 5 && (dayProgram = ProgramUtilities.getJointProgramIteratorFor(prog.mDate.addDays(-1), prog.mChannel)) != null) {
                int i2 = 0;
                while (dayProgram.hasNext()) {
                    previousPrograms.add(i2++, dayProgram.next());
                }
            }
            if (nextPrograms.size() < 5 && (dayProgram = ProgramUtilities.getJointProgramIteratorFor(prog.mDate.addDays(1), prog.mChannel)) != null) {
                while (dayProgram.hasNext()) {
                    Program next = dayProgram.next();
                    nextPrograms.add(next);
                    if (nextPrograms.size() < 5) continue;
                    break;
                }
            }
            int pSize = previousPrograms.size() >= 5 ? 5 : previousPrograms.size();
            int nSize = nextPrograms.size() >= 5 ? 5 : nextPrograms.size();
            this.mPreviousPrograms = new Program[pSize];
            this.mNextPrograms = new Program[nSize];
            for (i = 0; i < pSize; ++i) {
                this.mPreviousPrograms[i] = (Program)previousPrograms.get(previousPrograms.size() - i - 1);
            }
            for (i = 0; i < nSize; ++i) {
                this.mNextPrograms[i] = (Program)nextPrograms.get(i);
            }
        }
    }

    protected void setSettings(Dimension d) {
        if (this.mSettings.getShowFunctions()) {
            this.mLeftSplit = d;
        }
    }

    protected Object[] getOrder() {
        if (this.mOrder == null) {
            this.mOrder = this.mSettings.getFieldOrder();
        }
        return this.mOrder;
    }

    protected void setOrder() {
        this.mOrder = this.mSettings.getFieldOrder();
    }

    protected void setLook() {
        try {
            if (mIsShowing) {
                return;
            }
            String lf = this.mSettings.getLook();
            if (lf.length() > 0) {
                LookAndFeelAddons.setAddon((String)lf);
            } else {
                LookAndFeelAddons.setAddon((String)LookAndFeelAddons.getBestMatchAddonClassName());
            }
            ProgramInfoDialog.resetFunctionGroup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return ProgramInfo.getName();
    }

    static String getName() {
        return LOCALIZER.msg("pluginName", "Program details");
    }

    protected PluginPictureSettings getPictureSettings() {
        return new PluginPictureSettings(this.mSettings.getPictureSettings());
    }

    public static boolean isShowing() {
        return ProgramInfoDialog.isShowing() || mIsShowing;
    }

    public void showProgramInformation(Program program) {
        this.showProgramInformation(program, true);
    }

    public static String getProgramInfoPluginId() {
        return DATAFILE_PREFIX;
    }

    void historyBack() {
        this.history(-1);
    }

    private void history(int delta) {
        this.mHistoryIndex += delta;
        if (this.mHistoryIndex < 0) {
            this.mHistoryIndex = 0;
        }
        if (this.mHistoryIndex >= this.mHistory.size()) {
            this.mHistoryIndex = this.mHistory.size() - 1;
        }
        if (this.mHistoryIndex >= 0) {
            InfoProgram p = this.mHistory.get(this.mHistoryIndex);
            this.findPreviousAndNextProgram(p);
            ProgramInfoDialog.getInstance(p.getProgram(), this.mLeftSplit, true);
        }
    }

    void historyForward() {
        this.history(1);
    }

    Program[] getNextPrograms() {
        return this.mNextPrograms;
    }

    void nextProgram() {
        if (this.mNextPrograms != null && this.mNextPrograms.length > 0) {
            if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(this.mNextPrograms[0])) {
                this.mHistory.add(new InfoProgram(this.mNextPrograms[0]));
                this.mHistoryIndex = this.mHistory.size() - 1;
            }
            Program next = this.mNextPrograms[0];
            this.findPreviousAndNextProgram(new InfoProgram(next));
            ProgramInfoDialog.getInstance(next, this.mLeftSplit, true);
        }
    }

    void showProgram(Program p) {
        InfoProgram prog = new InfoProgram(p);
        if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(p)) {
            this.mHistory.add(prog);
            this.mHistoryIndex = this.mHistory.size() - 1;
        }
        this.findPreviousAndNextProgram(prog);
        ProgramInfoDialog.getInstance(p, this.mLeftSplit, true);
    }

    Program[] getPreviousPrograms() {
        return this.mPreviousPrograms;
    }

    void previousProgram() {
        if (this.mPreviousPrograms != null && this.mPreviousPrograms.length > 0) {
            InfoProgram previous = new InfoProgram(this.mPreviousPrograms[0]);
            if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(this.mPreviousPrograms[0])) {
                this.mHistory.add(previous);
                this.mHistoryIndex = this.mHistory.size() - 1;
            }
            this.findPreviousAndNextProgram(previous);
            ProgramInfoDialog.getInstance(previous.getProgram(), this.mLeftSplit, true);
        }
    }

    boolean canNavigateBack() {
        return this.mHistoryIndex > 0;
    }

    boolean canNavigateForward() {
        return this.mHistoryIndex < this.mHistory.size() - 1;
    }

    String navigationBackwardText() {
        if (!this.canNavigateBack()) {
            return null;
        }
        return this.mHistory.get(this.mHistoryIndex - 1).getTitle();
    }

    String navigationForwardText() {
        if (!this.canNavigateForward()) {
            return null;
        }
        return this.mHistory.get(this.mHistoryIndex + 1).getTitle();
    }

    public static void resetLocalizer() {
        LOCALIZER = Localizer.getLocalizerFor(ProgramInfo.class);
    }

    public boolean dialogWasClosedRecently() {
        return ProgramInfoDialog.wasClosedRecently();
    }

    static {
        mIsShowing = false;
    }

    private static final class InfoProgram {
        private String mId;
        private Date mDate;
        private Channel mChannel;
        private String mTitle;
        private Program mProgram;
        private int mIndex;

        public InfoProgram(Program p) {
            this.mId = p.getUniqueID();
            this.mDate = p.getDate();
            this.mChannel = p.getChannel();
            this.mTitle = p.getTitle();
            this.mProgram = p;
            Program[] progs = PluginManagerImpl.getInstance().getPrograms(this.mId);
            if (progs != null) {
                for (int i = 0; i < progs.length; ++i) {
                    if (progs[i] != p) continue;
                    this.mIndex = i;
                    break;
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Program) {
                return ((Program)obj).getUniqueID().contentEquals(this.mId);
            }
            if (obj instanceof InfoProgram) {
                return ((InfoProgram)obj).mId.contentEquals(this.mId) && ((InfoProgram)obj).mIndex == this.mIndex;
            }
            return super.equals(obj);
        }

        public Program getProgram() {
            Program[] progs;
            if ((this.mProgram == null || this.mProgram.getProgramState() != 0) && (progs = PluginManagerImpl.getInstance().getPrograms(this.mId)) != null) {
                this.mProgram = this.mIndex < progs.length ? progs[this.mIndex] : progs[0];
            }
            return this.mProgram;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String toString() {
            return this.mIndex + " " + this.mProgram;
        }
    }
}

