/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.search.booleansearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import tvbrowser.core.search.booleansearch.IMatcher;
import tvbrowser.core.search.booleansearch.StringMatcher;

abstract class OperandMatcher
implements IMatcher {
    protected ArrayList<IMatcher> subMatcher = new ArrayList();

    protected OperandMatcher(IMatcher left, IMatcher right) {
        this.subMatcher.add(left);
        this.subMatcher.add(right);
    }

    protected OperandMatcher(OperandMatcher leftOp, OperandMatcher rightOp) {
        this.subMatcher.addAll(leftOp.subMatcher);
        this.subMatcher.addAll(rightOp.subMatcher);
        this.subMatcher.remove(leftOp);
        this.subMatcher.remove(rightOp);
    }

    @Override
    public IMatcher optimize() {
        ArrayList<IMatcher> nonDuplicates = new ArrayList<IMatcher>(new HashSet<IMatcher>(this.subMatcher));
        this.subMatcher = new ArrayList(nonDuplicates.size());
        for (IMatcher matcher : nonDuplicates) {
            this.subMatcher.add(matcher.optimize());
        }
        Collections.sort(this.subMatcher, new Comparator<IMatcher>(){

            @Override
            public int compare(IMatcher leftMatcher, IMatcher rightMatcher) {
                boolean leftIsString = leftMatcher instanceof StringMatcher;
                boolean rightIsString = rightMatcher instanceof StringMatcher;
                if (leftIsString && rightIsString) {
                    StringMatcher m1 = (StringMatcher)leftMatcher;
                    StringMatcher m2 = (StringMatcher)rightMatcher;
                    return -Integer.valueOf(m1.size()).compareTo(m2.size());
                }
                if (leftIsString) {
                    return -1;
                }
                if (rightIsString) {
                    return 1;
                }
                return 0;
            }
        });
        return this;
    }

    public String toString() {
        StringBuilder temp = new StringBuilder(100);
        temp.append('(').append(this.subMatcher.get(0));
        for (int i = 1; i < this.subMatcher.size(); ++i) {
            temp.append(' ').append(this.getOperandString()).append(' ').append(this.subMatcher.get(i).toString());
        }
        temp.append(')');
        return temp.toString();
    }

    protected abstract String getOperandString();
}

