/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Channel;
import devplugin.Program;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;
import tvbrowser.core.filters.FilterComponent;

public class SingleChannelFilterComponent
implements FilterComponent {
    private Channel mChannel;
    private String mLoadName;

    public SingleChannelFilterComponent(String name, String description) {
    }

    public SingleChannelFilterComponent(Channel ch) {
        this.mChannel = ch;
        this.mLoadName = ch != null ? "_" + this.mChannel.getName().replaceAll("\\s+|\\p{Punct}", "_") : "[INVALID]";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        return this.mChannel != null ? program.getChannel().equals(this.mChannel) : false;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.mChannel = Channel.readData(in, true);
            if (version == 0) {
                this.mLoadName = this.mChannel != null ? "_" + this.mChannel.getName().replaceAll("\\s+|\\p{Punct}", "_") : "[INVALID]";
            } else {
                this.mLoadName = in.readUTF();
                if (this.mLoadName.trim().length() == 0) {
                    this.mLoadName = "[INVALID]";
                }
            }
        } else {
            this.mLoadName = "[INVALID]";
        }
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.mChannel != null);
        if (this.mChannel != null) {
            this.mChannel.writeData(out);
        }
        out.writeUTF(this.mLoadName);
    }

    @Override
    public JPanel getSettingsPanel() {
        return null;
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public String getName() {
        if (this.mChannel != null) {
            return "_" + this.mChannel.getName().replaceAll("\\s+|\\p{Punct}", "_");
        }
        return "[INVALID]";
    }

    @Override
    public String getTypeDescription() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setDescription(String desc) {
    }

    public String getLoadName() {
        return this.mLoadName;
    }

    public boolean isNameToUpdate() {
        return !this.mLoadName.equals(this.getName());
    }

    public void updateName() {
        this.mLoadName = this.getName();
    }

    public boolean isValidChannel() {
        return this.mChannel != null;
    }

    public boolean containsChannel(Channel ch) {
        return this.mChannel != null && this.mChannel.equals(ch);
    }

    public boolean isBrokenPartially() {
        return this.isBrokenCompletely();
    }

    public boolean isBrokenCompletely() {
        return !this.isValidChannel();
    }
}

