/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.contextmenu;

import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Program;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ConfigMenuItem;
import tvbrowser.core.contextmenu.DoNothingContextMenuItem;
import tvbrowser.core.contextmenu.LeaveFullScreenMenuItem;
import tvbrowser.core.contextmenu.SelectProgramContextMenuItem;
import tvbrowser.core.contextmenu.SeparatorMenuItem;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.searchplugin.SearchPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.settings.ContextMenuMouseActionSetting;
import util.ui.TVBrowserIcons;
import util.ui.menu.MenuUtil;

public class ContextMenuManager {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ContextMenuManager.class);
    public static final int NO_MOUSE_MODIFIER_EX = 0;
    private static ContextMenuManager mInstance;
    private Hashtable<Integer, ContextMenuAction> mContextMenuLeftSingleClickTable;
    private Hashtable<Integer, ContextMenuAction> mContextMenuLeftDoubleClickTable;
    private Hashtable<Integer, ContextMenuAction> mContextMenuMiddleSingleClickTable;
    private Hashtable<Integer, ContextMenuAction> mContextMenuMiddleDoubleClickTable;

    private ContextMenuManager() {
        mInstance = this;
        this.mContextMenuLeftSingleClickTable = new Hashtable();
        this.mContextMenuLeftDoubleClickTable = new Hashtable();
        this.mContextMenuMiddleSingleClickTable = new Hashtable();
        this.mContextMenuMiddleDoubleClickTable = new Hashtable();
        this.init();
    }

    private void setContextMenuValues(Hashtable<Integer, ContextMenuAction> hashtable, ContextMenuMouseActionSetting[] clickArray) {
        for (ContextMenuMouseActionSetting setting : clickArray) {
            ContextMenuIf menuIf = setting.getContextMenuIf();
            if (menuIf == null) continue;
            hashtable.put(setting.getModifiersEx(), new ContextMenuAction(menuIf, setting.getContextMenuActionId()));
        }
    }

    public void init() {
        this.mContextMenuLeftSingleClickTable.clear();
        this.mContextMenuLeftDoubleClickTable.clear();
        this.mContextMenuMiddleSingleClickTable.clear();
        this.mContextMenuMiddleDoubleClickTable.clear();
        this.setContextMenuValues(this.mContextMenuLeftSingleClickTable, Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.setContextMenuValues(this.mContextMenuLeftDoubleClickTable, Settings.Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.setContextMenuValues(this.mContextMenuMiddleSingleClickTable, Settings.Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
        this.setContextMenuValues(this.mContextMenuMiddleDoubleClickTable, Settings.Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray());
    }

    public static synchronized ContextMenuManager getInstance() {
        if (mInstance == null) {
            new ContextMenuManager();
        }
        return mInstance;
    }

    public ContextMenuAction getContextMenuForSingleClick(MouseEvent e) {
        int cleanModifierEx = e.getModifiersEx() & 0xFFFFE3FF;
        if (SwingUtilities.isLeftMouseButton(e)) {
            return this.mContextMenuLeftSingleClickTable.get(cleanModifierEx);
        }
        if (SwingUtilities.isMiddleMouseButton(e)) {
            ContextMenuAction c = this.mContextMenuMiddleSingleClickTable.get(cleanModifierEx);
            if (c == null) {
                c = this.mContextMenuMiddleSingleClickTable.get(cleanModifierEx & 0xFFFFFDFF);
            }
            return c;
        }
        return null;
    }

    public ContextMenuAction getContextMenuArrayForModifierEx(int modifierEx, boolean leftMouseButton, boolean singleClick) {
        if (leftMouseButton) {
            if (singleClick) {
                return this.mContextMenuLeftSingleClickTable.get(modifierEx);
            }
            return this.mContextMenuLeftDoubleClickTable.get(modifierEx);
        }
        if (singleClick) {
            return this.mContextMenuMiddleSingleClickTable.get(modifierEx);
        }
        return this.mContextMenuMiddleDoubleClickTable.get(modifierEx);
    }

    public ContextMenuAction getContextMenuForDoubleClick(MouseEvent e) {
        int cleanModifierEx = e.getModifiersEx() & 0xFFFFE3FF;
        if (SwingUtilities.isLeftMouseButton(e)) {
            return this.mContextMenuLeftDoubleClickTable.get(cleanModifierEx);
        }
        if (SwingUtilities.isMiddleMouseButton(e)) {
            ContextMenuAction c = this.mContextMenuMiddleDoubleClickTable.get(cleanModifierEx);
            if (c == null) {
                c = this.mContextMenuMiddleDoubleClickTable.get(cleanModifierEx & 0xFFFFFDFF);
            }
            return c;
        }
        return null;
    }

    public static ContextMenuIf getContextMenuIfForId(String id) {
        if (id == null) {
            return null;
        }
        PluginProxy plugin = PluginProxyManager.getInstance().getActivatedPluginForId(id);
        if (plugin != null) {
            return plugin;
        }
        TvDataServiceProxy dataService = TvDataServiceProxyManager.getInstance().findDataServiceById(id);
        if (dataService != null) {
            return dataService;
        }
        if (id != null) {
            InternalPluginProxyIf internalPlugin = InternalPluginProxyList.getInstance().getProxyForId(id);
            if (internalPlugin != null && internalPlugin instanceof ContextMenuIf) {
                return (ContextMenuIf)((Object)internalPlugin);
            }
            if (id.compareTo("######CONFIG######") == 0) {
                return ConfigMenuItem.getInstance();
            }
            if (id.compareTo("######LEAVEFULLSCREEN######") == 0) {
                return LeaveFullScreenMenuItem.getInstance();
            }
            if (id.compareTo("######DONOTHING######") == 0) {
                return DoNothingContextMenuItem.getInstance();
            }
            if (id.compareTo("######SELECTPROGRAM######") == 0) {
                return SelectProgramContextMenuItem.getInstance();
            }
        }
        return null;
    }

    public ContextMenuIf[] getAvailableContextMenuIfs(boolean includingDisabledItems, boolean cleanSeparator) {
        int i;
        InternalPluginProxyIf[] internalPluginProxies = InternalPluginProxyList.getInstance().getAvailableProxys();
        PluginProxy[] pluginArr = PluginProxyManager.getInstance().getActivatedPlugins();
        TvDataServiceProxy[] dataServiceArr = TvDataServiceProxyManager.getInstance().getDataServices();
        String[] order = Settings.ContextMenu.MENU_ORDER.getStringArray();
        List<ContextMenuIf> disabledList = ContextMenuManager.getDisabledContextMenuIfs();
        ArrayList<Object> ifList = new ArrayList<Object>();
        boolean lastWasSeparator = false;
        if (order == null) {
            for (InternalPluginProxyIf internalPluginProxyIf : internalPluginProxies) {
                if (!(internalPluginProxyIf instanceof ContextMenuIf)) continue;
                ifList.add((ContextMenuIf)((Object)internalPluginProxyIf));
            }
            ifList.add(new SeparatorMenuItem());
            for (PluginProxy pluginProxy : pluginArr) {
                ifList.add(pluginProxy);
            }
            ifList.add(new SeparatorMenuItem());
            for (TvDataServiceProxy tvDataServiceProxy : dataServiceArr) {
                ifList.add(tvDataServiceProxy);
            }
        } else {
            for (String string : order) {
                if (string.compareTo("######SEPARATOR######") == 0) {
                    if (cleanSeparator && (!cleanSeparator || ifList.size() <= 0 || lastWasSeparator)) continue;
                    ifList.add(new SeparatorMenuItem());
                    lastWasSeparator = true;
                    continue;
                }
                if (string.compareTo("######CONFIG######") == 0) {
                    if (!includingDisabledItems && disabledList.contains(ConfigMenuItem.getInstance())) continue;
                    ifList.add(ConfigMenuItem.getInstance());
                    lastWasSeparator = false;
                    continue;
                }
                if (string.compareTo("######LEAVEFULLSCREEN######") == 0) {
                    if (!includingDisabledItems && disabledList.contains(LeaveFullScreenMenuItem.getInstance())) continue;
                    ifList.add(LeaveFullScreenMenuItem.getInstance());
                    lastWasSeparator = false;
                    continue;
                }
                ContextMenuIf item = ContextMenuManager.getContextMenuIfForId(string);
                if (item == null || !includingDisabledItems && disabledList.contains(item)) continue;
                lastWasSeparator = false;
                ifList.add(item);
            }
        }
        for (InternalPluginProxyIf internalPluginProxyIf : internalPluginProxies) {
            if (!(internalPluginProxyIf instanceof ContextMenuIf) || ifList.contains(internalPluginProxyIf) || !includingDisabledItems && (internalPluginProxyIf == null || disabledList.contains(internalPluginProxyIf))) continue;
            ifList.add((ContextMenuIf)((Object)internalPluginProxyIf));
        }
        for (i = 0; i < pluginArr.length; ++i) {
            if (ifList.contains(pluginArr[i]) || !includingDisabledItems && (pluginArr[i] == null || disabledList.contains(pluginArr[i]))) continue;
            ifList.add(pluginArr[i]);
        }
        for (i = 0; i < dataServiceArr.length; ++i) {
            if (ifList.contains(dataServiceArr[i]) || !includingDisabledItems && (dataServiceArr[i] == null || disabledList.contains(dataServiceArr[i]))) continue;
            ifList.add(dataServiceArr[i]);
        }
        if (!(ifList.contains(LeaveFullScreenMenuItem.getInstance()) || !includingDisabledItems && disabledList.contains(LeaveFullScreenMenuItem.getInstance()))) {
            ifList.add(LeaveFullScreenMenuItem.getInstance());
        }
        if (!(ifList.contains(ConfigMenuItem.getInstance()) || !includingDisabledItems && disabledList.contains(ConfigMenuItem.getInstance()))) {
            if (!lastWasSeparator) {
                ifList.add(new SeparatorMenuItem());
            }
            ifList.add(ConfigMenuItem.getInstance());
        }
        if (cleanSeparator) {
            while (ifList.get(ifList.size() - 1) instanceof SeparatorMenuItem) {
                ifList.remove(ifList.size() - 1);
            }
        }
        ContextMenuIf[] menuIf = new ContextMenuIf[ifList.size()];
        ifList.toArray(menuIf);
        return menuIf;
    }

    public JMenu createContextMenuItems(ContextMenuIf callerIf, Program program) {
        return this.createContextMenuItems(callerIf, program, null);
    }

    public JMenu createContextMenuItems(ContextMenuIf callerIf, Program program, ActionMenu callerMenu) {
        try {
            ContextMenuIf[] menuIfArr = ContextMenuManager.getInstance().getAvailableContextMenuIfs(false, true);
            HashMap<ContextMenuIf, HashSet<Integer>> disabledSubMenus = ContextMenuManager.getDisabledSubMenuMap();
            JMenu rootMenu = new JMenu();
            for (ContextMenuIf menuIf : menuIfArr) {
                ActionMenu[] subItems;
                ActionMenu actionMenu;
                JMenuItem item;
                HashSet<Integer> disabledItems = disabledSubMenus.get(menuIf);
                boolean equalsPlugin = false;
                if (callerIf != null && callerIf.getId().equals(menuIf.getId())) {
                    equalsPlugin = true;
                }
                if (menuIf instanceof SeparatorMenuItem) {
                    if (rootMenu.getMenuComponentCount() <= 0) continue;
                    rootMenu.addSeparator();
                    continue;
                }
                if (menuIf instanceof ConfigMenuItem) {
                    item = new JMenuItem(menuIf.toString());
                    item.setIcon(TVBrowserIcons.preferences(16));
                    item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
                    item.addActionListener(e -> MainFrame.getInstance().showSettingsDialog("#contextmenu"));
                    rootMenu.add(item);
                    continue;
                }
                if (menuIf instanceof LeaveFullScreenMenuItem) {
                    if (!MainFrame.getInstance().isFullScreenMode()) continue;
                    item = new JMenuItem(menuIf.toString());
                    item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
                    item.setIcon(TVBrowserIcons.fullScreen(16));
                    item.addActionListener(e -> {
                        if (MainFrame.getInstance().isFullScreenMode()) {
                            MainFrame.getInstance().switchFullscreenMode();
                        }
                    });
                    rootMenu.add(item);
                    continue;
                }
                ActionMenu actionMenu2 = actionMenu = !equalsPlugin ? menuIf.getContextMenuActions(program) : callerMenu;
                if (actionMenu == null) continue;
                if (actionMenu.showOnlySubMenus()) {
                    subItems = actionMenu.getSubItems();
                    if (subItems == null || subItems.length <= 0) continue;
                    Icon ic = (Icon)actionMenu.getAction().getValue("SmallIcon");
                    rootMenu.addSeparator();
                    for (ActionMenu item2 : subItems) {
                        if (item2 == null || item2.getActionId() != -1 && disabledItems != null && disabledItems.contains(item2.getActionId())) continue;
                        if (item2.getAction().getValue("SmallIcon") == null && ic != null) {
                            item2.getAction().putValue("SmallIcon", ic);
                        }
                        if (item2.getAction() instanceof ContextMenuSeparatorAction) {
                            rootMenu.addSeparator();
                            continue;
                        }
                        JMenuItem menuItem = MenuUtil.createMenuItem(item2, disabledItems);
                        if (menuItem == null) continue;
                        rootMenu.add(menuItem);
                    }
                    rootMenu.addSeparator();
                    continue;
                }
                subItems = actionMenu.getSubItems();
                if (subItems != null && subItems.length > 0) {
                    ArrayList<ActionMenu> result = new ArrayList<ActionMenu>();
                    for (ActionMenu item2 : subItems) {
                        if (item2 == null || item2.getActionId() != -1 && disabledItems != null && disabledItems.contains(item2.getActionId())) continue;
                        result.add(item2);
                    }
                    actionMenu = !result.isEmpty() ? new ActionMenu(actionMenu.getActionId(), actionMenu.getTitle(), (Icon)actionMenu.getAction().getValue("SmallIcon"), result.toArray(new ActionMenu[result.size()])) : null;
                }
                if (actionMenu == null) continue;
                JMenuItem menuItem = MenuUtil.createMenuItem(actionMenu, disabledItems);
                rootMenu.add(menuItem);
            }
            while (rootMenu.getMenuComponent(rootMenu.getMenuComponentCount() - 1) instanceof JPopupMenu.Separator) {
                rootMenu.remove(rootMenu.getMenuComponentCount() - 1);
            }
            for (int i = rootMenu.getMenuComponentCount() - 2; i > 0; --i) {
                if (!(rootMenu.getMenuComponent(i) instanceof JPopupMenu.Separator) || !(rootMenu.getMenuComponent(i + 1) instanceof JPopupMenu.Separator)) continue;
                rootMenu.remove(i + 1);
            }
            return rootMenu;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public JMenuItem getPluginContextMenu(Program program, String id) {
        ActionMenu menu = null;
        InternalPluginProxyIf pluginProxy = InternalPluginProxyList.getInstance().getProxyForId(id);
        if (pluginProxy != null) {
            if (pluginProxy instanceof ContextMenuIf) {
                menu = ((ContextMenuIf)((Object)pluginProxy)).getContextMenuActions(program);
            }
        } else {
            PluginProxy proxy = PluginProxyManager.getInstance().getActivatedPluginForId(id);
            if (proxy != null) {
                menu = proxy.getContextMenuActions(program);
            } else {
                TvDataServiceProxy dataProxy = TvDataServiceProxyManager.getInstance().findDataServiceById(id);
                if (dataProxy != null) {
                    menu = dataProxy.getContextMenuActions(program);
                }
            }
        }
        if (menu != null) {
            return MenuUtil.createMenuItem(menu);
        }
        return null;
    }

    public static List<ContextMenuIf> getDisabledContextMenuIfs() {
        String[] disabled = Settings.ContextMenu.DISABLED_ITEMS.getStringArray();
        ArrayList<ContextMenuIf> list = new ArrayList<ContextMenuIf>();
        if (disabled == null) {
            return list;
        }
        for (String element : disabled) {
            ContextMenuIf item = ContextMenuManager.getContextMenuIfForId(element);
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    public static HashMap<ContextMenuIf, HashSet<Integer>> getDisabledSubMenuMap() {
        HashMap<ContextMenuIf, HashSet<Integer>> disabledSubMenusMap = new HashMap<ContextMenuIf, HashSet<Integer>>();
        String[] disabledSubMenus = Settings.ContextMenu.DISABLED_SUB_ITEMS.getStringArray();
        if (disabledSubMenus != null) {
            for (String menuInfo : disabledSubMenus) {
                String[] ids;
                ContextMenuIf menuIf;
                String[] parts = menuInfo.split("##_#_##");
                if (parts.length != 2 || (menuIf = ContextMenuManager.getContextMenuIfForId(parts[0])) == null || (ids = parts[1].split(";;_#_;;")).length <= 0) continue;
                HashSet<Integer> setIds = new HashSet<Integer>();
                for (String id : ids) {
                    try {
                        setIds.add(Integer.parseInt(id));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (setIds.isEmpty()) continue;
                disabledSubMenusMap.put(menuIf, setIds);
            }
        }
        return disabledSubMenusMap;
    }

    public JPopupMenu createRemovedProgramContextMenu(Program program) {
        JPopupMenu menu = new JPopupMenu();
        ActionMenu repetitionSearch = SearchPluginProxy.getInstance().getContextMenuActions(program);
        if (repetitionSearch != null) {
            menu.add(MenuUtil.createMenuItem(repetitionSearch));
        }
        JMenuItem item = new JMenuItem(mLocalizer.msg("scrollToPlaceOfProgram", "Scroll to last place of program in program table"));
        item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
        item.addActionListener(e -> {
            MainFrame.getInstance().goTo(program.getDate());
            MainFrame.getInstance().showChannel(program.getChannel());
            MainFrame.getInstance().scrollToTime(program.getStartTime(), false);
            MainFrame.getInstance().showProgramTableTabIfAvailable();
        });
        menu.add(item);
        return menu;
    }

    public static ActionMenu loadActionMenu(ActionMenu actionMenu, int actionMenuId) {
        ActionMenu menu = null;
        if (actionMenu != null) {
            ActionMenu[] subItems = actionMenu.getSubItems();
            ActionMenu actionMenu2 = menu = actionMenu.getActionId() == actionMenuId ? actionMenu : null;
            if (subItems != null && menu == null) {
                for (ActionMenu item : subItems) {
                    if (menu != null) break;
                    if (item.hasSubItems()) {
                        menu = ContextMenuManager.loadActionMenu(item, actionMenuId);
                        continue;
                    }
                    if (item.getActionId() != actionMenuId) continue;
                    menu = item;
                    break;
                }
            }
        }
        return menu;
    }

    public static final class ContextMenuAction {
        private ContextMenuIf mContextMenuIf;
        private int mContextMenuActionId;

        public ContextMenuAction(ContextMenuIf contextMenuIf, int contextMenuActionId) {
            this.mContextMenuIf = contextMenuIf;
            this.mContextMenuActionId = contextMenuActionId;
        }

        public ContextMenuIf getContextMenuIf() {
            return this.mContextMenuIf;
        }

        public int getContextMenuActionId() {
            return this.mContextMenuActionId;
        }
    }
}

