/*
 * Decompiled with CFR 0.152.
 */
package compat;

import compat.VersionCompat;
import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ImportanceValue;
import devplugin.Program;
import devplugin.Version;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.searchplugin.SearchPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ProgramTable;
import util.program.ProgramUtilities;
import util.settings.StringArrayProperty;
import util.ui.Localizer;
import util.ui.menu.MenuUtil;

public final class ProgramCompat {
    private static Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramCompat.class);
    private static final Logger mLog = Logger.getLogger(ProgramCompat.class.getName());

    public static byte getProgramImportance(Program program) {
        byte result = -1;
        if (TVBrowser.VERSION.compareTo(new Version(3, 10, true)) >= 0) {
            try {
                Method m = ProgramUtilities.class.getDeclaredMethod("getProgramImportance", Program.class);
                result = (Byte)m.invoke(null, program);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == -1) {
            result = ProgramCompat.getProgramImportanceCompat(program);
        }
        return result;
    }

    private static byte getProgramImportanceCompat(Program program) {
        if (program.getProgramState() == 0 && Settings.propProgramPanelAllowTransparency.getBoolean()) {
            PluginProxy[] plugins;
            int count = 0;
            int addValue = 0;
            PluginProxy[] pluginProxyArray = plugins = PluginProxyManager.getInstance().getActivatedPlugins();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                PluginProxy plugin = pluginProxyArray[n2];
                ImportanceValue value = plugin.getImportanceValueForProgram(program);
                if (value.getWeight() > 0 && value.getTotalImportance() >= 0) {
                    count += value.getWeight();
                    addValue += value.getTotalImportance();
                }
                ++n2;
            }
            if (count > 0) {
                return (byte)Math.max(addValue / count, 0);
            }
        }
        return 10;
    }

    public static Program[] getPrograms(devplugin.Date date, String progID) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 33, true)) >= 0) {
            try {
                Method m = PluginManagerImpl.class.getDeclaredMethod("getPrograms", devplugin.Date.class, String.class);
                return (Program[])m.invoke((Object)PluginManagerImpl.getInstance(), date, progID);
            }
            catch (Exception exception) {}
        } else {
            return ProgramCompat.getProgramsCompat(date, progID);
        }
        return null;
    }

    private static Program[] getProgramsCompat(devplugin.Date date, String progID) {
        Channel ch = ProgramCompat.getChannelFromProgId(progID);
        if (ProgramCompat.checkChannelAccess(ch)) {
            Iterator dayProg = PluginManagerImpl.getInstance().getChannelDayProgram(date, ch);
            if (dayProg != null) {
                ArrayList<Program> listProgs = new ArrayList<Program>();
                while (dayProg.hasNext()) {
                    Program test = (Program)dayProg.next();
                    if (!progID.equals(test.getID())) continue;
                    listProgs.add(test);
                }
                if (!listProgs.isEmpty()) {
                    return listProgs.toArray(new Program[listProgs.size()]);
                }
                mLog.warning("could not find program with id '" + progID + "' (date: " + date + ")");
            } else {
                mLog.warning("day program not found: " + progID + "; " + date);
            }
        }
        return null;
    }

    public static Program[] getPrograms(String uniqueID) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 33, true)) >= 0) {
            try {
                Method m = PluginManagerImpl.class.getDeclaredMethod("getPrograms", String.class);
                return (Program[])m.invoke((Object)PluginManagerImpl.getInstance(), uniqueID);
            }
            catch (Exception exception) {}
        } else {
            return ProgramCompat.getProgramsCompat(uniqueID);
        }
        return null;
    }

    private static Program[] getProgramsCompat(String uniqueID) {
        Object[] values = ProgramCompat.getDateAndProgIDforUniqueID(uniqueID);
        return ProgramCompat.getPrograms((devplugin.Date)values[0], (String)values[1]);
    }

    private static boolean checkChannelAccess(Channel ch) {
        if (ch != null) {
            boolean isAccessControl = false;
            try {
                Method m = Channel.class.getDeclaredMethod("isAccessControl", new Class[0]);
                isAccessControl = (Boolean)m.invoke((Object)ch, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isAccessControl) {
                StringArrayProperty prop = null;
                try {
                    Field f = Settings.class.getDeclaredField("propAccessControl");
                    prop = (StringArrayProperty)f.get(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (prop != null && prop.getStringArray().length > 0) {
                    StackTraceElement[] stackTace = Thread.currentThread().getStackTrace();
                    String[] values = prop.getStringArray();
                    int i = 0;
                    while (i < Math.min(5, stackTace.length)) {
                        String[] stringArray = values;
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String testValue = stringArray[n2];
                            String className = stackTace[i].getClassName();
                            if (className.substring(0, className.indexOf(".")).equals(testValue)) {
                                return false;
                            }
                            ++n2;
                        }
                        ++i;
                    }
                }
            }
        }
        return true;
    }

    private static Channel getChannelFromProgId(String progId) {
        Channel channel;
        int strLen = progId.length();
        int count = 0;
        int lastSeparator = 0;
        int i = 0;
        while (i < strLen) {
            if (progId.charAt(i) == '_') {
                ++count;
                lastSeparator = i;
            }
            ++i;
        }
        if (count == 4 && (channel = ChannelList.getChannel((String)progId.substring(0, lastSeparator))) != null) {
            return channel;
        }
        String[] s = progId.split("_");
        if (s.length < 4) {
            return ChannelList.getChannel(null, null, null, (String)s[0]);
        }
        if (s.length == 4) {
            return ChannelList.getChannel((String)s[0], (String)s[1], null, (String)s[2]);
        }
        return ChannelList.getChannel((String)s[0], (String)s[1], (String)s[2], (String)s[3]);
    }

    private static Object[] getDateAndProgIDforUniqueID(String uniqueID) {
        devplugin.Date progDate;
        String[] id = uniqueID.split("_");
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(id[4]);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(date.getTime());
            progDate = new devplugin.Date(cal);
        }
        catch (ParseException e) {
            mLog.severe("Couldn't parse date from unique ID");
            return null;
        }
        return new Object[]{progDate, id[0] + '_' + id[1] + '_' + id[2] + '_' + id[3] + '_' + id[5]};
    }

    public static void selectProgram(Program program) {
        if (program != null) {
            Method m;
            if (TVBrowser.VERSION.compareTo(new Version(3, 11, true)) >= 0) {
                try {
                    m = MainFrame.class.getDeclaredMethod("selectProgram", Program.class, Boolean.TYPE);
                    m.invoke((Object)MainFrame.getInstance(), program, true);
                }
                catch (Exception m2) {}
            } else {
                ProgramCompat.selectProgramInternal(program);
            }
            if (VersionCompat.isCenterPanelSupported()) {
                try {
                    m = MainFrame.class.getDeclaredMethod("showProgramTableTabIfAvailable", new Class[0]);
                    m.invoke((Object)MainFrame.getInstance(), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void selectProgramInternal(Program program) {
        ProgramTable table = MainFrame.getInstance().getProgramTableScrollPane().getProgramTable();
        table.deSelectItem();
        table.selectProgram(program);
    }

    public static JPopupMenu createRemovedProgramContextMenu(Program program) {
        JPopupMenu result = null;
        if (TVBrowser.VERSION.compareTo(new Version(3, 20, true)) >= 0) {
            try {
                Method m = ContextMenuManager.class.getDeclaredMethod("createRemovedProgramContextMenu", Program.class);
                result = (JPopupMenu)m.invoke((Object)ContextMenuManager.getInstance(), program);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = ProgramCompat.createRemovedProgramContextMenuLegacy(program);
        }
        return result;
    }

    private static JPopupMenu createRemovedProgramContextMenuLegacy(final Program program) {
        JPopupMenu menu = new JPopupMenu();
        ActionMenu repetitionSearch = SearchPluginProxy.getInstance().getContextMenuActions(program);
        if (repetitionSearch != null) {
            menu.add(MenuUtil.createMenuItem((ActionMenu)repetitionSearch));
        }
        JMenuItem item = new JMenuItem(LOCALIZER.msg("scrollToPlaceOfProgram", "Scroll to last place of program in program table"));
        item.setFont(MenuUtil.CONTEXT_MENU_PLAINFONT);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Method m;
                MainFrame.getInstance().goTo(program.getDate());
                MainFrame.getInstance().showChannel(program.getChannel());
                try {
                    m = MainFrame.class.getMethod("scrollToTime", Integer.TYPE, Boolean.TYPE);
                    m.invoke((Object)MainFrame.getInstance(), program.getStartTime(), false);
                }
                catch (Exception e2) {
                    MainFrame.getInstance().scrollToTime(program.getStartTime());
                }
                try {
                    m = MainFrame.class.getMethod("showProgramTableTabIfAvailable", new Class[0]);
                    m.invoke((Object)MainFrame.getInstance(), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(item);
        return menu;
    }
}

