// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

package securitycenter

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The change in state of the asset.
//
// When querying across two points in time this describes
// the change between the two points: ADDED, REMOVED, or ACTIVE.
// If there was no compare_duration supplied in the request the state change
// will be: UNUSED
type ListAssetsResponse_ListAssetsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListAssetsResponse_ListAssetsResult_UNUSED ListAssetsResponse_ListAssetsResult_StateChange = 0
	// Asset was added between the points in time.
	ListAssetsResponse_ListAssetsResult_ADDED ListAssetsResponse_ListAssetsResult_StateChange = 1
	// Asset was removed between the points in time.
	ListAssetsResponse_ListAssetsResult_REMOVED ListAssetsResponse_ListAssetsResult_StateChange = 2
	// Asset was present at both point(s) in time.
	ListAssetsResponse_ListAssetsResult_ACTIVE ListAssetsResponse_ListAssetsResult_StateChange = 3
)

// Enum value maps for ListAssetsResponse_ListAssetsResult_StateChange.
var (
	ListAssetsResponse_ListAssetsResult_StateChange_name = map[int32]string{
		0: "UNUSED",
		1: "ADDED",
		2: "REMOVED",
		3: "ACTIVE",
	}
	ListAssetsResponse_ListAssetsResult_StateChange_value = map[string]int32{
		"UNUSED":  0,
		"ADDED":   1,
		"REMOVED": 2,
		"ACTIVE":  3,
	}
)

func (x ListAssetsResponse_ListAssetsResult_StateChange) Enum() *ListAssetsResponse_ListAssetsResult_StateChange {
	p := new(ListAssetsResponse_ListAssetsResult_StateChange)
	*p = x
	return p
}

func (x ListAssetsResponse_ListAssetsResult_StateChange) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListAssetsResponse_ListAssetsResult_StateChange) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[0].Descriptor()
}

func (ListAssetsResponse_ListAssetsResult_StateChange) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[0]
}

func (x ListAssetsResponse_ListAssetsResult_StateChange) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListAssetsResponse_ListAssetsResult_StateChange.Descriptor instead.
func (ListAssetsResponse_ListAssetsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{24, 0, 0}
}

// The change in state of the finding.
//
// When querying across two points in time this describes
// the change in the finding between the two points: CHANGED, UNCHANGED,
// ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
// the finding at timestamp does not match the filter specified, but it did
// at timestamp - compare_duration. If there was no compare_duration
// supplied in the request the state change will be: UNUSED
type ListFindingsResponse_ListFindingsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListFindingsResponse_ListFindingsResult_UNUSED ListFindingsResponse_ListFindingsResult_StateChange = 0
	// The finding has changed state in some way between the points in time
	// and existed at both points.
	ListFindingsResponse_ListFindingsResult_CHANGED ListFindingsResponse_ListFindingsResult_StateChange = 1
	// The finding has not changed state between the points in time and
	// existed at both points.
	ListFindingsResponse_ListFindingsResult_UNCHANGED ListFindingsResponse_ListFindingsResult_StateChange = 2
	// The finding was created between the points in time.
	ListFindingsResponse_ListFindingsResult_ADDED ListFindingsResponse_ListFindingsResult_StateChange = 3
	// The finding at timestamp does not match the filter specified, but it
	// did at timestamp - compare_duration.
	ListFindingsResponse_ListFindingsResult_REMOVED ListFindingsResponse_ListFindingsResult_StateChange = 4
)

// Enum value maps for ListFindingsResponse_ListFindingsResult_StateChange.
var (
	ListFindingsResponse_ListFindingsResult_StateChange_name = map[int32]string{
		0: "UNUSED",
		1: "CHANGED",
		2: "UNCHANGED",
		3: "ADDED",
		4: "REMOVED",
	}
	ListFindingsResponse_ListFindingsResult_StateChange_value = map[string]int32{
		"UNUSED":    0,
		"CHANGED":   1,
		"UNCHANGED": 2,
		"ADDED":     3,
		"REMOVED":   4,
	}
)

func (x ListFindingsResponse_ListFindingsResult_StateChange) Enum() *ListFindingsResponse_ListFindingsResult_StateChange {
	p := new(ListFindingsResponse_ListFindingsResult_StateChange)
	*p = x
	return p
}

func (x ListFindingsResponse_ListFindingsResult_StateChange) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListFindingsResponse_ListFindingsResult_StateChange) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[1].Descriptor()
}

func (ListFindingsResponse_ListFindingsResult_StateChange) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[1]
}

func (x ListFindingsResponse_ListFindingsResult_StateChange) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult_StateChange.Descriptor instead.
func (ListFindingsResponse_ListFindingsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{26, 0, 0}
}

// Request message for bulk findings update.
//
// Note:
// 1. If multiple bulk update requests match the same resource, the order in
// which they get executed is not defined.
// 2. Once a bulk operation is started, there is no way to stop it.
type BulkMuteFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, at which bulk action needs to be applied. Its format is
	// "organizations/[organization_id]", "folders/[folder_id]",
	// "projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that identifies findings that should be updated.
	// The expression is a list of zero or more restrictions combined
	// via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
	// has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a
	// `-` character in front of them to indicate negation. The fields map to
	// those defined in the corresponding resource.
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// This can be a mute configuration name or any identifier for mute/unmute
	// of findings based on the filter.
	//
	// Deprecated: Do not use.
	MuteAnnotation string `protobuf:"bytes,3,opt,name=mute_annotation,json=muteAnnotation,proto3" json:"mute_annotation,omitempty"`
}

func (x *BulkMuteFindingsRequest) Reset() {
	*x = BulkMuteFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkMuteFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkMuteFindingsRequest) ProtoMessage() {}

func (x *BulkMuteFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkMuteFindingsRequest.ProtoReflect.Descriptor instead.
func (*BulkMuteFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{0}
}

func (x *BulkMuteFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkMuteFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Deprecated: Do not use.
func (x *BulkMuteFindingsRequest) GetMuteAnnotation() string {
	if x != nil {
		return x.MuteAnnotation
	}
	return ""
}

// The response to a BulkMute request. Contains the LRO information.
type BulkMuteFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkMuteFindingsResponse) Reset() {
	*x = BulkMuteFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkMuteFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkMuteFindingsResponse) ProtoMessage() {}

func (x *BulkMuteFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkMuteFindingsResponse.ProtoReflect.Descriptor instead.
func (*BulkMuteFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{1}
}

// Request message for creating a finding.
type CreateFindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new finding's parent. Its format should be
	// "organizations/[organization_id]/sources/[source_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must be alphanumeric and less than or equal to 32 characters and
	// greater than 0 characters in length.
	FindingId string `protobuf:"bytes,2,opt,name=finding_id,json=findingId,proto3" json:"finding_id,omitempty"`
	// Required. The Finding being created. The name and security_marks will be ignored as
	// they are both output only fields on this resource.
	Finding *Finding `protobuf:"bytes,3,opt,name=finding,proto3" json:"finding,omitempty"`
}

func (x *CreateFindingRequest) Reset() {
	*x = CreateFindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFindingRequest) ProtoMessage() {}

func (x *CreateFindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFindingRequest.ProtoReflect.Descriptor instead.
func (*CreateFindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateFindingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFindingRequest) GetFindingId() string {
	if x != nil {
		return x.FindingId
	}
	return ""
}

func (x *CreateFindingRequest) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

// Request message for creating a mute config.
type CreateMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new mute configs's parent. Its format is
	// "organizations/[organization_id]", "folders/[folder_id]", or
	// "projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The mute config being created.
	MuteConfig *MuteConfig `protobuf:"bytes,2,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must consist of lower case letters, numbers, and hyphen, with the first
	// character a letter, the last a letter or a number, and a 63 character
	// maximum.
	MuteConfigId string `protobuf:"bytes,3,opt,name=mute_config_id,json=muteConfigId,proto3" json:"mute_config_id,omitempty"`
}

func (x *CreateMuteConfigRequest) Reset() {
	*x = CreateMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMuteConfigRequest) ProtoMessage() {}

func (x *CreateMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateMuteConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMuteConfigRequest) GetMuteConfig() *MuteConfig {
	if x != nil {
		return x.MuteConfig
	}
	return nil
}

func (x *CreateMuteConfigRequest) GetMuteConfigId() string {
	if x != nil {
		return x.MuteConfigId
	}
	return ""
}

// Request message for creating a notification config.
type CreateNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new notification config's parent. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	// Unique identifier provided by the client within the parent scope.
	// It must be between 1 and 128 characters, and contains alphanumeric
	// characters, underscores or hyphens only.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// Required. The notification config being created. The name and the service account
	// will be ignored as they are both output only fields on this resource.
	NotificationConfig *NotificationConfig `protobuf:"bytes,3,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
}

func (x *CreateNotificationConfigRequest) Reset() {
	*x = CreateNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNotificationConfigRequest) ProtoMessage() {}

func (x *CreateNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateNotificationConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNotificationConfigRequest) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

func (x *CreateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

// Request message for creating a source.
type CreateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new source's parent. Its format should be
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Source being created, only the display_name and description will be
	// used. All other fields will be ignored.
	Source *Source `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *CreateSourceRequest) Reset() {
	*x = CreateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSourceRequest) ProtoMessage() {}

func (x *CreateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

// Request message for deleting a mute config.
type DeleteMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mute config to delete. Its format is
	// organizations/{organization}/muteConfigs/{config_id},
	// folders/{folder}/muteConfigs/{config_id}, or
	// projects/{project}/muteConfigs/{config_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMuteConfigRequest) Reset() {
	*x = DeleteMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMuteConfigRequest) ProtoMessage() {}

func (x *DeleteMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteMuteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting a notification config.
type DeleteNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the notification config to delete. Its format is
	// "organizations/[organization_id]/notificationConfigs/[config_id]".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNotificationConfigRequest) Reset() {
	*x = DeleteNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNotificationConfigRequest) ProtoMessage() {}

func (x *DeleteNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteNotificationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for retrieving a mute config.
type GetMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mute config to retrieve. Its format is
	// organizations/{organization}/muteConfigs/{config_id},
	// folders/{folder}/muteConfigs/{config_id}, or
	// projects/{project}/muteConfigs/{config_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMuteConfigRequest) Reset() {
	*x = GetMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMuteConfigRequest) ProtoMessage() {}

func (x *GetMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*GetMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetMuteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a notification config.
type GetNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the notification config to get. Its format is
	// "organizations/[organization_id]/notificationConfigs/[config_id]".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNotificationConfigRequest) Reset() {
	*x = GetNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotificationConfigRequest) ProtoMessage() {}

func (x *GetNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*GetNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetNotificationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting organization settings.
type GetOrganizationSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization to get organization settings for. Its format is
	// "organizations/[organization_id]/organizationSettings".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOrganizationSettingsRequest) Reset() {
	*x = GetOrganizationSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationSettingsRequest) ProtoMessage() {}

func (x *GetOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrganizationSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetOrganizationSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a source.
type GetSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Relative resource name of the source. Its format is
	// "organizations/[organization_id]/source/[source_id]".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSourceRequest) Reset() {
	*x = GetSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceRequest) ProtoMessage() {}

func (x *GetSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceRequest.ProtoReflect.Descriptor instead.
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{11}
}

func (x *GetSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for grouping by assets.
type GroupAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization to groupBy. Its format is
	// "organizations/[organization_id], folders/[folder_id], or
	// projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * update_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     `update_time = "2019-06-10T16:07:18-07:00"`
	//     `update_time = 1560208038000`
	//
	// * create_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     `create_time = "2019-06-10T16:07:18-07:00"`
	//     `create_time = 1560208038000`
	//
	// * iam_policy.policy_blob: `=`, `:`
	// * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	// * security_marks.marks: `=`, `:`
	// * security_center_properties.resource_name: `=`, `:`
	// * security_center_properties.resource_display_name: `=`, `:`
	// * security_center_properties.resource_type: `=`, `:`
	// * security_center_properties.resource_parent: `=`, `:`
	// * security_center_properties.resource_parent_display_name: `=`, `:`
	// * security_center_properties.resource_project: `=`, `:`
	// * security_center_properties.resource_project_display_name: `=`, `:`
	// * security_center_properties.resource_owners: `=`, `:`
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	//
	// Use a partial match on the empty string to filter based on a property
	// existing: `resource_properties.my_property : ""`
	//
	// Use a negated partial match on the empty string to filter based on a
	// property not existing: `-resource_properties.my_property : ""`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping. The string
	// value should follow SQL syntax: comma separated list of fields. For
	// example:
	// "security_center_properties.resource_project,security_center_properties.project".
	//
	// The following fields are supported when compare_duration is not set:
	//
	// * security_center_properties.resource_project
	// * security_center_properties.resource_project_display_name
	// * security_center_properties.resource_type
	// * security_center_properties.resource_parent
	// * security_center_properties.resource_parent_display_name
	//
	// The following fields are supported when compare_duration is set:
	//
	// * security_center_properties.resource_type
	// * security_center_properties.resource_project_display_name
	// * security_center_properties.resource_parent_display_name
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" property is
	// updated to indicate whether the asset was added, removed, or remained
	// present during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "ADDED":   indicates that the asset was not present at the start of
	//                compare_duration, but present at reference_time.
	// * "REMOVED": indicates that the asset was present at the start of
	//                compare_duration, but not present at reference_time.
	// * "ACTIVE":  indicates that the asset was present at both the
	//                start and the end of the time period defined by
	//                compare_duration and reference_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all assets present at
	// read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// The value returned by the last `GroupAssetsResponse`; indicates
	// that this is a continuation of a prior `GroupAssets` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *GroupAssetsRequest) Reset() {
	*x = GroupAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupAssetsRequest) ProtoMessage() {}

func (x *GroupAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupAssetsRequest.ProtoReflect.Descriptor instead.
func (*GroupAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{12}
}

func (x *GroupAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GroupAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *GroupAssetsRequest) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

func (x *GroupAssetsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *GroupAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *GroupAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for grouping by assets.
type GroupAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *GroupAssetsResponse) Reset() {
	*x = GroupAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupAssetsResponse) ProtoMessage() {}

func (x *GroupAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupAssetsResponse.ProtoReflect.Descriptor instead.
func (*GroupAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{13}
}

func (x *GroupAssetsResponse) GetGroupByResults() []*GroupResult {
	if x != nil {
		return x.GroupByResults
	}
	return nil
}

func (x *GroupAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *GroupAssetsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for grouping by findings.
type GroupFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source to groupBy. Its format is
	// "organizations/[organization_id]/sources/[source_id]",
	// folders/[folder_id]/sources/[source_id], or
	// projects/[project_id]/sources/[source_id]. To groupBy across all sources
	// provide a source_id of `-`. For example:
	// organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-,
	// or projects/{project_id}/sources/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//  * name
	//  * source_properties.a_property
	//  * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     `event_time = "2019-06-10T16:07:18-07:00"`
	//     `event_time = 1560208038000`
	//
	// * severity: `=`, `:`
	// * workflow_state: `=`, `:`
	// * security_marks.marks: `=`, `:`
	// * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	//
	//   For example, `source_properties.size = 100` is a valid filter string.
	//
	//   Use a partial match on the empty string to filter based on a property
	//   existing: `source_properties.my_property : ""`
	//
	//   Use a negated partial match on the empty string to filter based on a
	//   property not existing: `-source_properties.my_property : ""`
	//
	// * resource:
	//   * resource.name: `=`, `:`
	//   * resource.parent_name: `=`, `:`
	//   * resource.parent_display_name: `=`, `:`
	//   * resource.project_name: `=`, `:`
	//   * resource.project_display_name: `=`, `:`
	//   * resource.type: `=`, `:`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping (including
	// `state_change`). The string value should follow SQL syntax: comma separated
	// list of fields. For example: "parent,resource_name".
	//
	// The following fields are supported:
	//
	// * resource_name
	// * category
	// * state
	// * parent
	// * severity
	//
	// The following fields are supported when compare_duration is set:
	//
	// * state_change
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" attribute is
	// updated to indicate whether the finding had its state changed, the
	// finding's state remained unchanged, or if the finding was added during the
	// compare_duration period of time that precedes the read_time. This is the
	// time between (read_time - compare_duration) and read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "CHANGED":   indicates that the finding was present and matched the given
	//                  filter at the start of compare_duration, but changed its
	//                  state at read_time.
	// * "UNCHANGED": indicates that the finding was present and matched the given
	//                  filter at the start of compare_duration and did not change
	//                  state at read_time.
	// * "ADDED":     indicates that the finding did not match the given filter or
	//                  was not present at the start of compare_duration, but was
	//                  present at read_time.
	// * "REMOVED":   indicates that the finding was present and matched the
	//                  filter at the start of compare_duration, but did not match
	//                  the filter at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all findings present
	// at read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// The value returned by the last `GroupFindingsResponse`; indicates
	// that this is a continuation of a prior `GroupFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *GroupFindingsRequest) Reset() {
	*x = GroupFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupFindingsRequest) ProtoMessage() {}

func (x *GroupFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupFindingsRequest.ProtoReflect.Descriptor instead.
func (*GroupFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{14}
}

func (x *GroupFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GroupFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *GroupFindingsRequest) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

func (x *GroupFindingsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupFindingsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *GroupFindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *GroupFindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for group by findings.
type GroupFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *GroupFindingsResponse) Reset() {
	*x = GroupFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupFindingsResponse) ProtoMessage() {}

func (x *GroupFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupFindingsResponse.ProtoReflect.Descriptor instead.
func (*GroupFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{15}
}

func (x *GroupFindingsResponse) GetGroupByResults() []*GroupResult {
	if x != nil {
		return x.GroupByResults
	}
	return nil
}

func (x *GroupFindingsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupFindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *GroupFindingsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Result containing the properties and count of a groupBy request.
type GroupResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Properties matching the groupBy fields in the request.
	Properties map[string]*structpb.Value `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Total count of resources for the given properties.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *GroupResult) Reset() {
	*x = GroupResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupResult) ProtoMessage() {}

func (x *GroupResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupResult.ProtoReflect.Descriptor instead.
func (*GroupResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{16}
}

func (x *GroupResult) GetProperties() map[string]*structpb.Value {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *GroupResult) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Request message for listing  mute configs at a given scope e.g. organization,
// folder or project.
type ListMuteConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of mute configs. Its format is
	// "organizations/[organization_id]", "folders/[folder_id]",
	// "projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of configs to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMuteConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListMuteConfigs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMuteConfigsRequest) Reset() {
	*x = ListMuteConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMuteConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMuteConfigsRequest) ProtoMessage() {}

func (x *ListMuteConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMuteConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListMuteConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListMuteConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMuteConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMuteConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing mute configs.
type ListMuteConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mute configs from the specified parent.
	MuteConfigs []*MuteConfig `protobuf:"bytes,1,rep,name=mute_configs,json=muteConfigs,proto3" json:"mute_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMuteConfigsResponse) Reset() {
	*x = ListMuteConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMuteConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMuteConfigsResponse) ProtoMessage() {}

func (x *ListMuteConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMuteConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListMuteConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListMuteConfigsResponse) GetMuteConfigs() []*MuteConfig {
	if x != nil {
		return x.MuteConfigs
	}
	return nil
}

func (x *ListMuteConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing notification configs.
type ListNotificationConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization to list notification configs.
	// Its format is "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListNotificationConfigsResponse`; indicates
	// that this is a continuation of a prior `ListNotificationConfigs` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListNotificationConfigsRequest) Reset() {
	*x = ListNotificationConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationConfigsRequest) ProtoMessage() {}

func (x *ListNotificationConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListNotificationConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListNotificationConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNotificationConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNotificationConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing notification configs.
type ListNotificationConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Notification configs belonging to the requested parent.
	NotificationConfigs []*NotificationConfig `protobuf:"bytes,1,rep,name=notification_configs,json=notificationConfigs,proto3" json:"notification_configs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNotificationConfigsResponse) Reset() {
	*x = ListNotificationConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationConfigsResponse) ProtoMessage() {}

func (x *ListNotificationConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListNotificationConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListNotificationConfigsResponse) GetNotificationConfigs() []*NotificationConfig {
	if x != nil {
		return x.NotificationConfigs
	}
	return nil
}

func (x *ListNotificationConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing sources.
type ListSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent of sources to list. Its format should be
	// "organizations/[organization_id], folders/[folder_id], or
	// projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListSourcesResponse`; indicates
	// that this is a continuation of a prior `ListSources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListSourcesRequest) Reset() {
	*x = ListSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesRequest) ProtoMessage() {}

func (x *ListSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{21}
}

func (x *ListSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing sources.
type ListSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources belonging to the requested parent.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSourcesResponse) Reset() {
	*x = ListSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesResponse) ProtoMessage() {}

func (x *ListSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListSourcesResponse) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ListSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing assets.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization assets should belong to. Its format is
	// "organizations/[organization_id], folders/[folder_id], or
	// projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following are the allowed field and operator combinations:
	//
	// * name: `=`
	// * update_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     `update_time = "2019-06-10T16:07:18-07:00"`
	//     `update_time = 1560208038000`
	//
	// * create_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     `create_time = "2019-06-10T16:07:18-07:00"`
	//     `create_time = 1560208038000`
	//
	// * iam_policy.policy_blob: `=`, `:`
	// * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	// * security_marks.marks: `=`, `:`
	// * security_center_properties.resource_name: `=`, `:`
	// * security_center_properties.resource_display_name: `=`, `:`
	// * security_center_properties.resource_type: `=`, `:`
	// * security_center_properties.resource_parent: `=`, `:`
	// * security_center_properties.resource_parent_display_name: `=`, `:`
	// * security_center_properties.resource_project: `=`, `:`
	// * security_center_properties.resource_project_display_name: `=`, `:`
	// * security_center_properties.resource_owners: `=`, `:`
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	//
	// Use a partial match on the empty string to filter based on a property
	// existing: `resource_properties.my_property : ""`
	//
	// Use a negated partial match on the empty string to filter based on a
	// property not existing: `-resource_properties.my_property : ""`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,resource_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,resource_properties.a_property" and "
	// name     desc  ,   resource_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// update_time
	// resource_properties
	// security_marks.marks
	// security_center_properties.resource_name
	// security_center_properties.resource_display_name
	// security_center_properties.resource_parent
	// security_center_properties.resource_parent_display_name
	// security_center_properties.resource_project
	// security_center_properties.resource_project_display_name
	// security_center_properties.resource_type
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListAssetsResult's "state_change"
	// attribute is updated to indicate whether the asset was added, removed, or
	// remained present during the compare_duration period of time that precedes
	// the read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "ADDED":   indicates that the asset was not present at the start of
	//                compare_duration, but present at read_time.
	// * "REMOVED": indicates that the asset was present at the start of
	//                compare_duration, but not present at read_time.
	// * "ACTIVE":  indicates that the asset was present at both the
	//                start and the end of the time period defined by
	//                compare_duration and read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all assets present at
	// read_time.
	CompareDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// A field mask to specify the ListAssetsResult fields to be listed in the
	// response.
	// An empty field mask will list all fields.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListAssetsResponse`; indicates
	// that this is a continuation of a prior `ListAssets` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAssetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *ListAssetsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing assets.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Assets matching the list request.
	ListAssetsResults []*ListAssetsResponse_ListAssetsResult `protobuf:"bytes,1,rep,name=list_assets_results,json=listAssetsResults,proto3" json:"list_assets_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of assets matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{24}
}

func (x *ListAssetsResponse) GetListAssetsResults() []*ListAssetsResponse_ListAssetsResult {
	if x != nil {
		return x.ListAssetsResults
	}
	return nil
}

func (x *ListAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAssetsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for listing findings.
type ListFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source the findings belong to. Its format is
	// "organizations/[organization_id]/sources/[source_id],
	// folders/[folder_id]/sources/[source_id], or
	// projects/[project_id]/sources/[source_id]". To list across all sources
	// provide a source_id of `-`. For example:
	// organizations/{organization_id}/sources/-, folders/{folder_id}/sources/- or
	// projects/{projects_id}/sources/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//  * name
	//  * source_properties.a_property
	//  * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     `event_time = "2019-06-10T16:07:18-07:00"`
	//     `event_time = 1560208038000`
	//
	// * severity: `=`, `:`
	// * workflow_state: `=`, `:`
	// * security_marks.marks: `=`, `:`
	// * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	//
	//   For example, `source_properties.size = 100` is a valid filter string.
	//
	//   Use a partial match on the empty string to filter based on a property
	//   existing: `source_properties.my_property : ""`
	//
	//   Use a negated partial match on the empty string to filter based on a
	//   property not existing: `-source_properties.my_property : ""`
	//
	// * resource:
	//   * resource.name: `=`, `:`
	//   * resource.parent_name: `=`, `:`
	//   * resource.parent_display_name: `=`, `:`
	//   * resource.project_name: `=`, `:`
	//   * resource.project_display_name: `=`, `:`
	//   * resource.type: `=`, `:`
	//   * resource.folders.resource_folder: `=`, `:`
	//   * resource.display_name: `=`, `:`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,source_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,source_properties.a_property" and "
	// name     desc  ,   source_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// parent
	// state
	// category
	// resource_name
	// event_time
	// source_properties
	// security_marks.marks
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListFindingsResult's "state_change"
	// attribute is updated to indicate whether the finding had its state changed,
	// the finding's state remained unchanged, or if the finding was added in any
	// state during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "CHANGED":   indicates that the finding was present and matched the given
	//                  filter at the start of compare_duration, but changed its
	//                  state at read_time.
	// * "UNCHANGED": indicates that the finding was present and matched the given
	//                  filter at the start of compare_duration and did not change
	//                  state at read_time.
	// * "ADDED":     indicates that the finding did not match the given filter or
	//                  was not present at the start of compare_duration, but was
	//                  present at read_time.
	// * "REMOVED":   indicates that the finding was present and matched the
	//                  filter at the start of compare_duration, but did not match
	//                  the filter at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all findings present at
	// read_time.
	CompareDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// A field mask to specify the Finding fields to be listed in the response.
	// An empty field mask will list all fields.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListFindingsResponse`; indicates
	// that this is a continuation of a prior `ListFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListFindingsRequest) Reset() {
	*x = ListFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsRequest) ProtoMessage() {}

func (x *ListFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsRequest.ProtoReflect.Descriptor instead.
func (*ListFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{25}
}

func (x *ListFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFindingsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListFindingsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListFindingsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *ListFindingsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListFindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing findings.
type ListFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Findings matching the list request.
	ListFindingsResults []*ListFindingsResponse_ListFindingsResult `protobuf:"bytes,1,rep,name=list_findings_results,json=listFindingsResults,proto3" json:"list_findings_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of findings matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListFindingsResponse) Reset() {
	*x = ListFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse) ProtoMessage() {}

func (x *ListFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{26}
}

func (x *ListFindingsResponse) GetListFindingsResults() []*ListFindingsResponse_ListFindingsResult {
	if x != nil {
		return x.ListFindingsResults
	}
	return nil
}

func (x *ListFindingsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListFindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFindingsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for updating a finding's state.
type SetFindingStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/finding/{finding_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired State of the finding.
	State Finding_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securitycenter.v1.Finding_State" json:"state,omitempty"`
	// Required. The time at which the updated state takes effect.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *SetFindingStateRequest) Reset() {
	*x = SetFindingStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetFindingStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetFindingStateRequest) ProtoMessage() {}

func (x *SetFindingStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetFindingStateRequest.ProtoReflect.Descriptor instead.
func (*SetFindingStateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{27}
}

func (x *SetFindingStateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetFindingStateRequest) GetState() Finding_State {
	if x != nil {
		return x.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (x *SetFindingStateRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Request message for updating a finding's mute status.
type SetMuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/finding/{finding_id}",
	// "folders/{folder_id}/sources/{source_id}/finding/{finding_id}",
	// "projects/{project_id}/sources/{source_id}/finding/{finding_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired state of the Mute.
	Mute Finding_Mute `protobuf:"varint,2,opt,name=mute,proto3,enum=google.cloud.securitycenter.v1.Finding_Mute" json:"mute,omitempty"`
}

func (x *SetMuteRequest) Reset() {
	*x = SetMuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMuteRequest) ProtoMessage() {}

func (x *SetMuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMuteRequest.ProtoReflect.Descriptor instead.
func (*SetMuteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{28}
}

func (x *SetMuteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetMuteRequest) GetMute() Finding_Mute {
	if x != nil {
		return x.Mute
	}
	return Finding_MUTE_UNSPECIFIED
}

// Request message for running asset discovery for an organization.
type RunAssetDiscoveryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization to run asset discovery for. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *RunAssetDiscoveryRequest) Reset() {
	*x = RunAssetDiscoveryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunAssetDiscoveryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunAssetDiscoveryRequest) ProtoMessage() {}

func (x *RunAssetDiscoveryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunAssetDiscoveryRequest.ProtoReflect.Descriptor instead.
func (*RunAssetDiscoveryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{29}
}

func (x *RunAssetDiscoveryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for updating a ExternalSystem resource.
type UpdateExternalSystemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The external system resource to update.
	ExternalSystem *ExternalSystem `protobuf:"bytes,1,opt,name=external_system,json=externalSystem,proto3" json:"external_system,omitempty"`
	// The FieldMask to use when updating the external system resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExternalSystemRequest) Reset() {
	*x = UpdateExternalSystemRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateExternalSystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExternalSystemRequest) ProtoMessage() {}

func (x *UpdateExternalSystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExternalSystemRequest.ProtoReflect.Descriptor instead.
func (*UpdateExternalSystemRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateExternalSystemRequest) GetExternalSystem() *ExternalSystem {
	if x != nil {
		return x.ExternalSystem
	}
	return nil
}

func (x *UpdateExternalSystemRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating or creating a finding.
type UpdateFindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The finding resource to update or create if it does not already exist.
	// parent, security_marks, and update_time will be ignored.
	//
	// In the case of creation, the finding id portion of the name must be
	// alphanumeric and less than or equal to 32 characters and greater than 0
	// characters in length.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// The FieldMask to use when updating the finding resource. This field should
	// not be specified when creating a finding.
	//
	// When updating a finding, an empty mask is treated as updating all mutable
	// fields and replacing source_properties.  Individual source_properties can
	// be added/updated by using "source_properties.<property key>" in the field
	// mask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFindingRequest) Reset() {
	*x = UpdateFindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFindingRequest) ProtoMessage() {}

func (x *UpdateFindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFindingRequest.ProtoReflect.Descriptor instead.
func (*UpdateFindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateFindingRequest) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

func (x *UpdateFindingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a mute config.
type UpdateMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The mute config being updated.
	MuteConfig *MuteConfig `protobuf:"bytes,1,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMuteConfigRequest) Reset() {
	*x = UpdateMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMuteConfigRequest) ProtoMessage() {}

func (x *UpdateMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{32}
}

func (x *UpdateMuteConfigRequest) GetMuteConfig() *MuteConfig {
	if x != nil {
		return x.MuteConfig
	}
	return nil
}

func (x *UpdateMuteConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a notification config.
type UpdateNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The notification config to update.
	NotificationConfig *NotificationConfig `protobuf:"bytes,1,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// The FieldMask to use when updating the notification config.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNotificationConfigRequest) Reset() {
	*x = UpdateNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNotificationConfigRequest) ProtoMessage() {}

func (x *UpdateNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{33}
}

func (x *UpdateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *UpdateNotificationConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating an organization's settings.
type UpdateOrganizationSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization settings resource to update.
	OrganizationSettings *OrganizationSettings `protobuf:"bytes,1,opt,name=organization_settings,json=organizationSettings,proto3" json:"organization_settings,omitempty"`
	// The FieldMask to use when updating the settings resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateOrganizationSettingsRequest) Reset() {
	*x = UpdateOrganizationSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationSettingsRequest) ProtoMessage() {}

func (x *UpdateOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{34}
}

func (x *UpdateOrganizationSettingsRequest) GetOrganizationSettings() *OrganizationSettings {
	if x != nil {
		return x.OrganizationSettings
	}
	return nil
}

func (x *UpdateOrganizationSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a source.
type UpdateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source resource to update.
	Source *Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The FieldMask to use when updating the source resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSourceRequest) Reset() {
	*x = UpdateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSourceRequest) ProtoMessage() {}

func (x *UpdateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UpdateSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a SecurityMarks resource.
type UpdateSecurityMarksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The security marks resource to update.
	SecurityMarks *SecurityMarks `protobuf:"bytes,1,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The FieldMask to use when updating the security marks resource.
	//
	// The field mask must not contain duplicate fields.
	// If empty or set to "marks", all marks will be replaced.  Individual
	// marks can be updated using "marks.<mark_key>".
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The time at which the updated SecurityMarks take effect.
	// If not set uses current server time.  Updates will be applied to the
	// SecurityMarks that are active immediately preceding this time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *UpdateSecurityMarksRequest) Reset() {
	*x = UpdateSecurityMarksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSecurityMarksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSecurityMarksRequest) ProtoMessage() {}

func (x *UpdateSecurityMarksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSecurityMarksRequest.ProtoReflect.Descriptor instead.
func (*UpdateSecurityMarksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateSecurityMarksRequest) GetSecurityMarks() *SecurityMarks {
	if x != nil {
		return x.SecurityMarks
	}
	return nil
}

func (x *UpdateSecurityMarksRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSecurityMarksRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Result containing the Asset and its State.
type ListAssetsResponse_ListAssetsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset matching the search request.
	Asset *Asset `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// State change of the asset between the points in time.
	StateChange ListAssetsResponse_ListAssetsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1.ListAssetsResponse_ListAssetsResult_StateChange" json:"state_change,omitempty"`
}

func (x *ListAssetsResponse_ListAssetsResult) Reset() {
	*x = ListAssetsResponse_ListAssetsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse_ListAssetsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse_ListAssetsResult) ProtoMessage() {}

func (x *ListAssetsResponse_ListAssetsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse_ListAssetsResult.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse_ListAssetsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{24, 0}
}

func (x *ListAssetsResponse_ListAssetsResult) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *ListAssetsResponse_ListAssetsResult) GetStateChange() ListAssetsResponse_ListAssetsResult_StateChange {
	if x != nil {
		return x.StateChange
	}
	return ListAssetsResponse_ListAssetsResult_UNUSED
}

// Result containing the Finding and its StateChange.
type ListFindingsResponse_ListFindingsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Finding matching the search request.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// State change of the finding between the points in time.
	StateChange ListFindingsResponse_ListFindingsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1.ListFindingsResponse_ListFindingsResult_StateChange" json:"state_change,omitempty"`
	// Output only. Resource that is associated with this finding.
	Resource *ListFindingsResponse_ListFindingsResult_Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *ListFindingsResponse_ListFindingsResult) Reset() {
	*x = ListFindingsResponse_ListFindingsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse_ListFindingsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse_ListFindingsResult) ProtoMessage() {}

func (x *ListFindingsResponse_ListFindingsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse_ListFindingsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{26, 0}
}

func (x *ListFindingsResponse_ListFindingsResult) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult) GetStateChange() ListFindingsResponse_ListFindingsResult_StateChange {
	if x != nil {
		return x.StateChange
	}
	return ListFindingsResponse_ListFindingsResult_UNUSED
}

func (x *ListFindingsResponse_ListFindingsResult) GetResource() *ListFindingsResponse_ListFindingsResult_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Information related to the Google Cloud resource that is
// associated with this finding.
type ListFindingsResponse_ListFindingsResult_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The full resource name of project that the resource belongs to.
	ProjectName string `protobuf:"bytes,2,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// The human readable name of project that the resource belongs to.
	ProjectDisplayName string `protobuf:"bytes,3,opt,name=project_display_name,json=projectDisplayName,proto3" json:"project_display_name,omitempty"`
	// The full resource name of resource's parent.
	ParentName string `protobuf:"bytes,4,opt,name=parent_name,json=parentName,proto3" json:"parent_name,omitempty"`
	// The human readable name of resource's parent.
	ParentDisplayName string `protobuf:"bytes,5,opt,name=parent_display_name,json=parentDisplayName,proto3" json:"parent_display_name,omitempty"`
	// The full resource type of the resource.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// Contains a Folder message for each folder in the assets ancestry.
	// The first folder is the deepest nested folder, and the last folder is
	// the folder directly under the Organization.
	Folders []*Folder `protobuf:"bytes,7,rep,name=folders,proto3" json:"folders,omitempty"`
	// The human readable name of the resource.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) Reset() {
	*x = ListFindingsResponse_ListFindingsResult_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse_ListFindingsResult_Resource) ProtoMessage() {}

func (x *ListFindingsResponse_ListFindingsResult_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult_Resource.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse_ListFindingsResult_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{26, 0, 0}
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetProjectName() string {
	if x != nil {
		return x.ProjectName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetProjectDisplayName() string {
	if x != nil {
		return x.ProjectDisplayName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetParentName() string {
	if x != nil {
		return x.ParentName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetParentDisplayName() string {
	if x != nil {
		return x.ParentDisplayName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_securitycenter_v1_securitycenter_service_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x41, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75,
	0x6e, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x01, 0x0a, 0x17, 0x42, 0x75,
	0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6d,
	0x75, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1a, 0x0a,
	0x18, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc8, 0x01, 0x0a, 0x14, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x07,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x22, 0xe0, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x6d, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x0e,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xff, 0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12,
	0x68, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xac, 0x01, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5f, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6f, 0x0a, 0x1f, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x32, 0x0a, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x14, 0x47, 0x65,
	0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x54, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcc,
	0x02, 0x0a, 0x12, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x42, 0x79, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xec, 0x01,
	0x0a, 0x13, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62,
	0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0e, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x42, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xcf, 0x02, 0x0a,
	0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xee,
	0x01, 0x0a, 0x15, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x62, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08,
	0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0xd7, 0x01, 0x0a, 0x0b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x5b, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0x55, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9e, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xae, 0x01,
	0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb0,
	0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x12, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x7f, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x03, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x8e, 0x04, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x11, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x82, 0x02, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x3b, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x72, 0x0a,
	0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x22, 0x3d, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x0a, 0x0a, 0x06, 0x55, 0x4e, 0x55, 0x53, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03,
	0x22, 0x84, 0x03, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xe7, 0x07, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x7b, 0x0a, 0x15, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65,
	0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0xd1, 0x05,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x07,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x76, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x71, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xbd, 0x02, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a,
	0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x4d, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x4e, 0x55, 0x53, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x44,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10,
	0x04, 0x22, 0xe5, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x0e, 0x53, 0x65,
	0x74, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x45, 0x0a, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x22, 0x6c, 0x0a, 0x18, 0x52, 0x75, 0x6e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x22, 0xb8, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x9b, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa8, 0x01,
	0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x6d, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc8, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x13,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0xd0, 0x01, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x15, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x97, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xef, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x59, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x32, 0xd8, 0x42, 0x0a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0xe2, 0x02, 0x0a, 0x10, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75,
	0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b,
	0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xf5, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x92, 0x01, 0x22, 0x2e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a,
	0x2d, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x2e,
	0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x50, 0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x4d,
	0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0xb1, 0x01, 0x0a, 0x0c, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x22, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0xda, 0x41,
	0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xcc,
	0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22,
	0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x69, 0x64, 0x2c, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0xd8, 0x02,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xde, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e,
	0x01, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x0b, 0x6d, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x31, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x0b,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x32, 0x22, 0x23, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda,
	0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x12, 0xa3, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x47, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x24, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xea,
	0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x84, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x77, 0x2a, 0x28, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x24, 0x2a, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x25, 0x2a,
	0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x18,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x96, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xf8, 0x01, 0x0a, 0x0d,
	0x47, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x84, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x77, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xca, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xcf, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9a, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x33, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x83, 0x02, 0x0a, 0x0b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8a, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x83, 0x01, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x3a, 0x01, 0x2a, 0x5a, 0x28, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x01, 0x2a, 0x5a, 0x29, 0x22,
	0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x01, 0x2a, 0x12, 0xbf, 0x02, 0x0a, 0x0d, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7,
	0x01, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x01, 0x2a, 0x5a, 0x34, 0x22, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x01,
	0x2a, 0x5a, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x12, 0xe3, 0x01, 0x0a, 0x0a, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x5a, 0x1f, 0x12,
	0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x5a, 0x20,
	0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x12, 0x8f, 0x02, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x8c, 0x01, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x5a, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x8b, 0x02, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x86, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x77,
	0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x5a, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xdd, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xf2, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x6b, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5a, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5a, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x87, 0x02, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x3a, 0x72, 0x75, 0x6e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x51, 0x0a, 0x38,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0xc4, 0x02, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x22, 0xcf, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb0, 0x01, 0x22, 0x38,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x37, 0x22, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x38, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x15, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2c, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x12, 0xa5, 0x02, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x4d, 0x75,
	0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xc0, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xad, 0x01, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x3a, 0x01,
	0x2a, 0x5a, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x12, 0x9d,
	0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xc8,
	0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x40, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd0, 0x03, 0x0a, 0x14, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x22,
	0xca, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa5, 0x02, 0x32, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5a, 0x5e, 0x32,
	0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5a, 0x5f, 0x32,
	0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0xda, 0x41,
	0x1b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc1, 0x02, 0x0a,
	0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xd0, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbf, 0x01, 0x32, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5a, 0x3c, 0x32, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5a, 0x3d, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0xda, 0x41, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0xdd, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe3, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xc2, 0x01, 0x32, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x3d, 0x32, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x3e, 0x32, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x17, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0xab, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x99, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x32, 0x44, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x1f, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x93,
	0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x7c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x32, 0x45,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x15, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x15, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0xb1, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x32, 0x2b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0xda,
	0x41, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x9f, 0x05, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x4d, 0x61, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x22, 0x9c, 0x04, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x84, 0x04, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x5a, 0x4c, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d,
	0x61, 0x72, 0x6b, 0x73, 0x7d, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x61, 0x72, 0x6b, 0x73, 0x5a, 0x4d, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61,
	0x72, 0x6b, 0x73, 0x7d, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x61, 0x72, 0x6b, 0x73, 0x5a, 0x5e, 0x32, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61,
	0x72, 0x6b, 0x73, 0x7d, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x61, 0x72, 0x6b, 0x73, 0x5a, 0x58, 0x32, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x3a, 0x0e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x5a, 0x59,
	0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0xda, 0x41, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x1a, 0x51, 0xca, 0x41, 0x1d, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xda, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x4c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x50, 0x00, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData = file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc
)

func file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData
}

var file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_google_cloud_securitycenter_v1_securitycenter_service_proto_goTypes = []interface{}{
	(ListAssetsResponse_ListAssetsResult_StateChange)(0),     // 0: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.StateChange
	(ListFindingsResponse_ListFindingsResult_StateChange)(0), // 1: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
	(*BulkMuteFindingsRequest)(nil),                          // 2: google.cloud.securitycenter.v1.BulkMuteFindingsRequest
	(*BulkMuteFindingsResponse)(nil),                         // 3: google.cloud.securitycenter.v1.BulkMuteFindingsResponse
	(*CreateFindingRequest)(nil),                             // 4: google.cloud.securitycenter.v1.CreateFindingRequest
	(*CreateMuteConfigRequest)(nil),                          // 5: google.cloud.securitycenter.v1.CreateMuteConfigRequest
	(*CreateNotificationConfigRequest)(nil),                  // 6: google.cloud.securitycenter.v1.CreateNotificationConfigRequest
	(*CreateSourceRequest)(nil),                              // 7: google.cloud.securitycenter.v1.CreateSourceRequest
	(*DeleteMuteConfigRequest)(nil),                          // 8: google.cloud.securitycenter.v1.DeleteMuteConfigRequest
	(*DeleteNotificationConfigRequest)(nil),                  // 9: google.cloud.securitycenter.v1.DeleteNotificationConfigRequest
	(*GetMuteConfigRequest)(nil),                             // 10: google.cloud.securitycenter.v1.GetMuteConfigRequest
	(*GetNotificationConfigRequest)(nil),                     // 11: google.cloud.securitycenter.v1.GetNotificationConfigRequest
	(*GetOrganizationSettingsRequest)(nil),                   // 12: google.cloud.securitycenter.v1.GetOrganizationSettingsRequest
	(*GetSourceRequest)(nil),                                 // 13: google.cloud.securitycenter.v1.GetSourceRequest
	(*GroupAssetsRequest)(nil),                               // 14: google.cloud.securitycenter.v1.GroupAssetsRequest
	(*GroupAssetsResponse)(nil),                              // 15: google.cloud.securitycenter.v1.GroupAssetsResponse
	(*GroupFindingsRequest)(nil),                             // 16: google.cloud.securitycenter.v1.GroupFindingsRequest
	(*GroupFindingsResponse)(nil),                            // 17: google.cloud.securitycenter.v1.GroupFindingsResponse
	(*GroupResult)(nil),                                      // 18: google.cloud.securitycenter.v1.GroupResult
	(*ListMuteConfigsRequest)(nil),                           // 19: google.cloud.securitycenter.v1.ListMuteConfigsRequest
	(*ListMuteConfigsResponse)(nil),                          // 20: google.cloud.securitycenter.v1.ListMuteConfigsResponse
	(*ListNotificationConfigsRequest)(nil),                   // 21: google.cloud.securitycenter.v1.ListNotificationConfigsRequest
	(*ListNotificationConfigsResponse)(nil),                  // 22: google.cloud.securitycenter.v1.ListNotificationConfigsResponse
	(*ListSourcesRequest)(nil),                               // 23: google.cloud.securitycenter.v1.ListSourcesRequest
	(*ListSourcesResponse)(nil),                              // 24: google.cloud.securitycenter.v1.ListSourcesResponse
	(*ListAssetsRequest)(nil),                                // 25: google.cloud.securitycenter.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                               // 26: google.cloud.securitycenter.v1.ListAssetsResponse
	(*ListFindingsRequest)(nil),                              // 27: google.cloud.securitycenter.v1.ListFindingsRequest
	(*ListFindingsResponse)(nil),                             // 28: google.cloud.securitycenter.v1.ListFindingsResponse
	(*SetFindingStateRequest)(nil),                           // 29: google.cloud.securitycenter.v1.SetFindingStateRequest
	(*SetMuteRequest)(nil),                                   // 30: google.cloud.securitycenter.v1.SetMuteRequest
	(*RunAssetDiscoveryRequest)(nil),                         // 31: google.cloud.securitycenter.v1.RunAssetDiscoveryRequest
	(*UpdateExternalSystemRequest)(nil),                      // 32: google.cloud.securitycenter.v1.UpdateExternalSystemRequest
	(*UpdateFindingRequest)(nil),                             // 33: google.cloud.securitycenter.v1.UpdateFindingRequest
	(*UpdateMuteConfigRequest)(nil),                          // 34: google.cloud.securitycenter.v1.UpdateMuteConfigRequest
	(*UpdateNotificationConfigRequest)(nil),                  // 35: google.cloud.securitycenter.v1.UpdateNotificationConfigRequest
	(*UpdateOrganizationSettingsRequest)(nil),                // 36: google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest
	(*UpdateSourceRequest)(nil),                              // 37: google.cloud.securitycenter.v1.UpdateSourceRequest
	(*UpdateSecurityMarksRequest)(nil),                       // 38: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest
	nil,                                                      // 39: google.cloud.securitycenter.v1.GroupResult.PropertiesEntry
	(*ListAssetsResponse_ListAssetsResult)(nil),              // 40: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult
	(*ListFindingsResponse_ListFindingsResult)(nil),          // 41: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
	(*ListFindingsResponse_ListFindingsResult_Resource)(nil), // 42: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
	(*Finding)(nil),                                          // 43: google.cloud.securitycenter.v1.Finding
	(*MuteConfig)(nil),                                       // 44: google.cloud.securitycenter.v1.MuteConfig
	(*NotificationConfig)(nil),                               // 45: google.cloud.securitycenter.v1.NotificationConfig
	(*Source)(nil),                                           // 46: google.cloud.securitycenter.v1.Source
	(*durationpb.Duration)(nil),                              // 47: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                            // 48: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                            // 49: google.protobuf.FieldMask
	(Finding_State)(0),                                       // 50: google.cloud.securitycenter.v1.Finding.State
	(Finding_Mute)(0),                                        // 51: google.cloud.securitycenter.v1.Finding.Mute
	(*ExternalSystem)(nil),                                   // 52: google.cloud.securitycenter.v1.ExternalSystem
	(*OrganizationSettings)(nil),                             // 53: google.cloud.securitycenter.v1.OrganizationSettings
	(*SecurityMarks)(nil),                                    // 54: google.cloud.securitycenter.v1.SecurityMarks
	(*structpb.Value)(nil),                                   // 55: google.protobuf.Value
	(*Asset)(nil),                                            // 56: google.cloud.securitycenter.v1.Asset
	(*Folder)(nil),                                           // 57: google.cloud.securitycenter.v1.Folder
	(*v1.GetIamPolicyRequest)(nil),                           // 58: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),                           // 59: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),                     // 60: google.iam.v1.TestIamPermissionsRequest
	(*longrunning.Operation)(nil),                            // 61: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                    // 62: google.protobuf.Empty
	(*v1.Policy)(nil),                                        // 63: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil),                    // 64: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_securitycenter_v1_securitycenter_service_proto_depIdxs = []int32{
	43, // 0: google.cloud.securitycenter.v1.CreateFindingRequest.finding:type_name -> google.cloud.securitycenter.v1.Finding
	44, // 1: google.cloud.securitycenter.v1.CreateMuteConfigRequest.mute_config:type_name -> google.cloud.securitycenter.v1.MuteConfig
	45, // 2: google.cloud.securitycenter.v1.CreateNotificationConfigRequest.notification_config:type_name -> google.cloud.securitycenter.v1.NotificationConfig
	46, // 3: google.cloud.securitycenter.v1.CreateSourceRequest.source:type_name -> google.cloud.securitycenter.v1.Source
	47, // 4: google.cloud.securitycenter.v1.GroupAssetsRequest.compare_duration:type_name -> google.protobuf.Duration
	48, // 5: google.cloud.securitycenter.v1.GroupAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	18, // 6: google.cloud.securitycenter.v1.GroupAssetsResponse.group_by_results:type_name -> google.cloud.securitycenter.v1.GroupResult
	48, // 7: google.cloud.securitycenter.v1.GroupAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	48, // 8: google.cloud.securitycenter.v1.GroupFindingsRequest.read_time:type_name -> google.protobuf.Timestamp
	47, // 9: google.cloud.securitycenter.v1.GroupFindingsRequest.compare_duration:type_name -> google.protobuf.Duration
	18, // 10: google.cloud.securitycenter.v1.GroupFindingsResponse.group_by_results:type_name -> google.cloud.securitycenter.v1.GroupResult
	48, // 11: google.cloud.securitycenter.v1.GroupFindingsResponse.read_time:type_name -> google.protobuf.Timestamp
	39, // 12: google.cloud.securitycenter.v1.GroupResult.properties:type_name -> google.cloud.securitycenter.v1.GroupResult.PropertiesEntry
	44, // 13: google.cloud.securitycenter.v1.ListMuteConfigsResponse.mute_configs:type_name -> google.cloud.securitycenter.v1.MuteConfig
	45, // 14: google.cloud.securitycenter.v1.ListNotificationConfigsResponse.notification_configs:type_name -> google.cloud.securitycenter.v1.NotificationConfig
	46, // 15: google.cloud.securitycenter.v1.ListSourcesResponse.sources:type_name -> google.cloud.securitycenter.v1.Source
	48, // 16: google.cloud.securitycenter.v1.ListAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	47, // 17: google.cloud.securitycenter.v1.ListAssetsRequest.compare_duration:type_name -> google.protobuf.Duration
	49, // 18: google.cloud.securitycenter.v1.ListAssetsRequest.field_mask:type_name -> google.protobuf.FieldMask
	40, // 19: google.cloud.securitycenter.v1.ListAssetsResponse.list_assets_results:type_name -> google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult
	48, // 20: google.cloud.securitycenter.v1.ListAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	48, // 21: google.cloud.securitycenter.v1.ListFindingsRequest.read_time:type_name -> google.protobuf.Timestamp
	47, // 22: google.cloud.securitycenter.v1.ListFindingsRequest.compare_duration:type_name -> google.protobuf.Duration
	49, // 23: google.cloud.securitycenter.v1.ListFindingsRequest.field_mask:type_name -> google.protobuf.FieldMask
	41, // 24: google.cloud.securitycenter.v1.ListFindingsResponse.list_findings_results:type_name -> google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
	48, // 25: google.cloud.securitycenter.v1.ListFindingsResponse.read_time:type_name -> google.protobuf.Timestamp
	50, // 26: google.cloud.securitycenter.v1.SetFindingStateRequest.state:type_name -> google.cloud.securitycenter.v1.Finding.State
	48, // 27: google.cloud.securitycenter.v1.SetFindingStateRequest.start_time:type_name -> google.protobuf.Timestamp
	51, // 28: google.cloud.securitycenter.v1.SetMuteRequest.mute:type_name -> google.cloud.securitycenter.v1.Finding.Mute
	52, // 29: google.cloud.securitycenter.v1.UpdateExternalSystemRequest.external_system:type_name -> google.cloud.securitycenter.v1.ExternalSystem
	49, // 30: google.cloud.securitycenter.v1.UpdateExternalSystemRequest.update_mask:type_name -> google.protobuf.FieldMask
	43, // 31: google.cloud.securitycenter.v1.UpdateFindingRequest.finding:type_name -> google.cloud.securitycenter.v1.Finding
	49, // 32: google.cloud.securitycenter.v1.UpdateFindingRequest.update_mask:type_name -> google.protobuf.FieldMask
	44, // 33: google.cloud.securitycenter.v1.UpdateMuteConfigRequest.mute_config:type_name -> google.cloud.securitycenter.v1.MuteConfig
	49, // 34: google.cloud.securitycenter.v1.UpdateMuteConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	45, // 35: google.cloud.securitycenter.v1.UpdateNotificationConfigRequest.notification_config:type_name -> google.cloud.securitycenter.v1.NotificationConfig
	49, // 36: google.cloud.securitycenter.v1.UpdateNotificationConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 37: google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest.organization_settings:type_name -> google.cloud.securitycenter.v1.OrganizationSettings
	49, // 38: google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	46, // 39: google.cloud.securitycenter.v1.UpdateSourceRequest.source:type_name -> google.cloud.securitycenter.v1.Source
	49, // 40: google.cloud.securitycenter.v1.UpdateSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	54, // 41: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest.security_marks:type_name -> google.cloud.securitycenter.v1.SecurityMarks
	49, // 42: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest.update_mask:type_name -> google.protobuf.FieldMask
	48, // 43: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest.start_time:type_name -> google.protobuf.Timestamp
	55, // 44: google.cloud.securitycenter.v1.GroupResult.PropertiesEntry.value:type_name -> google.protobuf.Value
	56, // 45: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.asset:type_name -> google.cloud.securitycenter.v1.Asset
	0,  // 46: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.state_change:type_name -> google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.StateChange
	43, // 47: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.finding:type_name -> google.cloud.securitycenter.v1.Finding
	1,  // 48: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.state_change:type_name -> google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
	42, // 49: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.resource:type_name -> google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
	57, // 50: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.folders:type_name -> google.cloud.securitycenter.v1.Folder
	2,  // 51: google.cloud.securitycenter.v1.SecurityCenter.BulkMuteFindings:input_type -> google.cloud.securitycenter.v1.BulkMuteFindingsRequest
	7,  // 52: google.cloud.securitycenter.v1.SecurityCenter.CreateSource:input_type -> google.cloud.securitycenter.v1.CreateSourceRequest
	4,  // 53: google.cloud.securitycenter.v1.SecurityCenter.CreateFinding:input_type -> google.cloud.securitycenter.v1.CreateFindingRequest
	5,  // 54: google.cloud.securitycenter.v1.SecurityCenter.CreateMuteConfig:input_type -> google.cloud.securitycenter.v1.CreateMuteConfigRequest
	6,  // 55: google.cloud.securitycenter.v1.SecurityCenter.CreateNotificationConfig:input_type -> google.cloud.securitycenter.v1.CreateNotificationConfigRequest
	8,  // 56: google.cloud.securitycenter.v1.SecurityCenter.DeleteMuteConfig:input_type -> google.cloud.securitycenter.v1.DeleteMuteConfigRequest
	9,  // 57: google.cloud.securitycenter.v1.SecurityCenter.DeleteNotificationConfig:input_type -> google.cloud.securitycenter.v1.DeleteNotificationConfigRequest
	58, // 58: google.cloud.securitycenter.v1.SecurityCenter.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	10, // 59: google.cloud.securitycenter.v1.SecurityCenter.GetMuteConfig:input_type -> google.cloud.securitycenter.v1.GetMuteConfigRequest
	11, // 60: google.cloud.securitycenter.v1.SecurityCenter.GetNotificationConfig:input_type -> google.cloud.securitycenter.v1.GetNotificationConfigRequest
	12, // 61: google.cloud.securitycenter.v1.SecurityCenter.GetOrganizationSettings:input_type -> google.cloud.securitycenter.v1.GetOrganizationSettingsRequest
	13, // 62: google.cloud.securitycenter.v1.SecurityCenter.GetSource:input_type -> google.cloud.securitycenter.v1.GetSourceRequest
	14, // 63: google.cloud.securitycenter.v1.SecurityCenter.GroupAssets:input_type -> google.cloud.securitycenter.v1.GroupAssetsRequest
	16, // 64: google.cloud.securitycenter.v1.SecurityCenter.GroupFindings:input_type -> google.cloud.securitycenter.v1.GroupFindingsRequest
	25, // 65: google.cloud.securitycenter.v1.SecurityCenter.ListAssets:input_type -> google.cloud.securitycenter.v1.ListAssetsRequest
	27, // 66: google.cloud.securitycenter.v1.SecurityCenter.ListFindings:input_type -> google.cloud.securitycenter.v1.ListFindingsRequest
	19, // 67: google.cloud.securitycenter.v1.SecurityCenter.ListMuteConfigs:input_type -> google.cloud.securitycenter.v1.ListMuteConfigsRequest
	21, // 68: google.cloud.securitycenter.v1.SecurityCenter.ListNotificationConfigs:input_type -> google.cloud.securitycenter.v1.ListNotificationConfigsRequest
	23, // 69: google.cloud.securitycenter.v1.SecurityCenter.ListSources:input_type -> google.cloud.securitycenter.v1.ListSourcesRequest
	31, // 70: google.cloud.securitycenter.v1.SecurityCenter.RunAssetDiscovery:input_type -> google.cloud.securitycenter.v1.RunAssetDiscoveryRequest
	29, // 71: google.cloud.securitycenter.v1.SecurityCenter.SetFindingState:input_type -> google.cloud.securitycenter.v1.SetFindingStateRequest
	30, // 72: google.cloud.securitycenter.v1.SecurityCenter.SetMute:input_type -> google.cloud.securitycenter.v1.SetMuteRequest
	59, // 73: google.cloud.securitycenter.v1.SecurityCenter.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	60, // 74: google.cloud.securitycenter.v1.SecurityCenter.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	32, // 75: google.cloud.securitycenter.v1.SecurityCenter.UpdateExternalSystem:input_type -> google.cloud.securitycenter.v1.UpdateExternalSystemRequest
	33, // 76: google.cloud.securitycenter.v1.SecurityCenter.UpdateFinding:input_type -> google.cloud.securitycenter.v1.UpdateFindingRequest
	34, // 77: google.cloud.securitycenter.v1.SecurityCenter.UpdateMuteConfig:input_type -> google.cloud.securitycenter.v1.UpdateMuteConfigRequest
	35, // 78: google.cloud.securitycenter.v1.SecurityCenter.UpdateNotificationConfig:input_type -> google.cloud.securitycenter.v1.UpdateNotificationConfigRequest
	36, // 79: google.cloud.securitycenter.v1.SecurityCenter.UpdateOrganizationSettings:input_type -> google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest
	37, // 80: google.cloud.securitycenter.v1.SecurityCenter.UpdateSource:input_type -> google.cloud.securitycenter.v1.UpdateSourceRequest
	38, // 81: google.cloud.securitycenter.v1.SecurityCenter.UpdateSecurityMarks:input_type -> google.cloud.securitycenter.v1.UpdateSecurityMarksRequest
	61, // 82: google.cloud.securitycenter.v1.SecurityCenter.BulkMuteFindings:output_type -> google.longrunning.Operation
	46, // 83: google.cloud.securitycenter.v1.SecurityCenter.CreateSource:output_type -> google.cloud.securitycenter.v1.Source
	43, // 84: google.cloud.securitycenter.v1.SecurityCenter.CreateFinding:output_type -> google.cloud.securitycenter.v1.Finding
	44, // 85: google.cloud.securitycenter.v1.SecurityCenter.CreateMuteConfig:output_type -> google.cloud.securitycenter.v1.MuteConfig
	45, // 86: google.cloud.securitycenter.v1.SecurityCenter.CreateNotificationConfig:output_type -> google.cloud.securitycenter.v1.NotificationConfig
	62, // 87: google.cloud.securitycenter.v1.SecurityCenter.DeleteMuteConfig:output_type -> google.protobuf.Empty
	62, // 88: google.cloud.securitycenter.v1.SecurityCenter.DeleteNotificationConfig:output_type -> google.protobuf.Empty
	63, // 89: google.cloud.securitycenter.v1.SecurityCenter.GetIamPolicy:output_type -> google.iam.v1.Policy
	44, // 90: google.cloud.securitycenter.v1.SecurityCenter.GetMuteConfig:output_type -> google.cloud.securitycenter.v1.MuteConfig
	45, // 91: google.cloud.securitycenter.v1.SecurityCenter.GetNotificationConfig:output_type -> google.cloud.securitycenter.v1.NotificationConfig
	53, // 92: google.cloud.securitycenter.v1.SecurityCenter.GetOrganizationSettings:output_type -> google.cloud.securitycenter.v1.OrganizationSettings
	46, // 93: google.cloud.securitycenter.v1.SecurityCenter.GetSource:output_type -> google.cloud.securitycenter.v1.Source
	15, // 94: google.cloud.securitycenter.v1.SecurityCenter.GroupAssets:output_type -> google.cloud.securitycenter.v1.GroupAssetsResponse
	17, // 95: google.cloud.securitycenter.v1.SecurityCenter.GroupFindings:output_type -> google.cloud.securitycenter.v1.GroupFindingsResponse
	26, // 96: google.cloud.securitycenter.v1.SecurityCenter.ListAssets:output_type -> google.cloud.securitycenter.v1.ListAssetsResponse
	28, // 97: google.cloud.securitycenter.v1.SecurityCenter.ListFindings:output_type -> google.cloud.securitycenter.v1.ListFindingsResponse
	20, // 98: google.cloud.securitycenter.v1.SecurityCenter.ListMuteConfigs:output_type -> google.cloud.securitycenter.v1.ListMuteConfigsResponse
	22, // 99: google.cloud.securitycenter.v1.SecurityCenter.ListNotificationConfigs:output_type -> google.cloud.securitycenter.v1.ListNotificationConfigsResponse
	24, // 100: google.cloud.securitycenter.v1.SecurityCenter.ListSources:output_type -> google.cloud.securitycenter.v1.ListSourcesResponse
	61, // 101: google.cloud.securitycenter.v1.SecurityCenter.RunAssetDiscovery:output_type -> google.longrunning.Operation
	43, // 102: google.cloud.securitycenter.v1.SecurityCenter.SetFindingState:output_type -> google.cloud.securitycenter.v1.Finding
	43, // 103: google.cloud.securitycenter.v1.SecurityCenter.SetMute:output_type -> google.cloud.securitycenter.v1.Finding
	63, // 104: google.cloud.securitycenter.v1.SecurityCenter.SetIamPolicy:output_type -> google.iam.v1.Policy
	64, // 105: google.cloud.securitycenter.v1.SecurityCenter.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	52, // 106: google.cloud.securitycenter.v1.SecurityCenter.UpdateExternalSystem:output_type -> google.cloud.securitycenter.v1.ExternalSystem
	43, // 107: google.cloud.securitycenter.v1.SecurityCenter.UpdateFinding:output_type -> google.cloud.securitycenter.v1.Finding
	44, // 108: google.cloud.securitycenter.v1.SecurityCenter.UpdateMuteConfig:output_type -> google.cloud.securitycenter.v1.MuteConfig
	45, // 109: google.cloud.securitycenter.v1.SecurityCenter.UpdateNotificationConfig:output_type -> google.cloud.securitycenter.v1.NotificationConfig
	53, // 110: google.cloud.securitycenter.v1.SecurityCenter.UpdateOrganizationSettings:output_type -> google.cloud.securitycenter.v1.OrganizationSettings
	46, // 111: google.cloud.securitycenter.v1.SecurityCenter.UpdateSource:output_type -> google.cloud.securitycenter.v1.Source
	54, // 112: google.cloud.securitycenter.v1.SecurityCenter.UpdateSecurityMarks:output_type -> google.cloud.securitycenter.v1.SecurityMarks
	82, // [82:113] is the sub-list for method output_type
	51, // [51:82] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v1_securitycenter_service_proto_init() }
func file_google_cloud_securitycenter_v1_securitycenter_service_proto_init() {
	if File_google_cloud_securitycenter_v1_securitycenter_service_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v1_run_asset_discovery_response_proto_init()
	file_google_cloud_securitycenter_v1_asset_proto_init()
	file_google_cloud_securitycenter_v1_external_system_proto_init()
	file_google_cloud_securitycenter_v1_finding_proto_init()
	file_google_cloud_securitycenter_v1_folder_proto_init()
	file_google_cloud_securitycenter_v1_mute_config_proto_init()
	file_google_cloud_securitycenter_v1_notification_config_proto_init()
	file_google_cloud_securitycenter_v1_organization_settings_proto_init()
	file_google_cloud_securitycenter_v1_security_marks_proto_init()
	file_google_cloud_securitycenter_v1_source_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkMuteFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkMuteFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOrganizationSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMuteConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMuteConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetFindingStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunAssetDiscoveryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateExternalSystemRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateOrganizationSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSecurityMarksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse_ListAssetsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsResponse_ListFindingsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsResponse_ListFindingsResult_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_securitycenter_v1_securitycenter_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v1_securitycenter_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v1_securitycenter_service_proto = out.File
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc = nil
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_goTypes = nil
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
	// parent can be either an organization, folder or project. The findings
	// matched by the filter will be muted after the LRO is done.
	BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Deletes an existing mute config.
	DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets a mute config.
	GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings,
	// /v1/folders/{folder_id}/sources/-/findings,
	// /v1/projects/{project_id}/sources/-/findings
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists mute configs.
	ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the state of a finding.
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates the mute state of a finding.
	SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Updates external system. This is for a given finding.
	UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates a mute config.
	UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	//
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
}

type securityCenterClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterClient(cc grpc.ClientConnInterface) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/BulkMuteFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error) {
	out := new(GroupAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error) {
	out := new(ListMuteConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListMuteConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error) {
	out := new(ListNotificationConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListNotificationConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetMute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error) {
	out := new(ExternalSystem)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateExternalSystem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
type SecurityCenterServer interface {
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
	// parent can be either an organization, folder or project. The findings
	// matched by the filter will be muted after the LRO is done.
	BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunning.Operation, error)
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error)
	// Deletes an existing mute config.
	DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Gets a mute config.
	GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings,
	// /v1/folders/{folder_id}/sources/-/findings,
	// /v1/projects/{project_id}/sources/-/findings
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists mute configs.
	ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunning.Operation, error)
	// Updates the state of a finding.
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Updates the mute state of a finding.
	SetMute(context.Context, *SetMuteRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Updates external system. This is for a given finding.
	UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates a mute config.
	UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error)
	//
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
}

// UnimplementedSecurityCenterServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterServer struct {
}

func (*UnimplementedSecurityCenterServer) BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkMuteFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateSource(context.Context, *CreateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationSettings not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupAssets not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedSecurityCenterServer) ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMuteConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (*UnimplementedSecurityCenterServer) RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAssetDiscovery not implemented")
}
func (*UnimplementedSecurityCenterServer) SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFindingState not implemented")
}
func (*UnimplementedSecurityCenterServer) SetMute(context.Context, *SetMuteRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMute not implemented")
}
func (*UnimplementedSecurityCenterServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalSystem not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganizationSettings not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecurityMarks not implemented")
}

func RegisterSecurityCenterServer(s *grpc.Server, srv SecurityCenterServer) {
	s.RegisterService(&_SecurityCenter_serviceDesc, srv)
}

func _SecurityCenter_BulkMuteFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkMuteFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/BulkMuteFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, req.(*BulkMuteFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, req.(*CreateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, req.(*CreateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, req.(*DeleteMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, req.(*DeleteNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, req.(*GetMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, req.(*GetNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, req.(*GetOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupAssets(ctx, req.(*GroupAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListMuteConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMuteConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListMuteConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, req.(*ListMuteConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListNotificationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListNotificationConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, req.(*ListNotificationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_RunAssetDiscovery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAssetDiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, req.(*RunAssetDiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetMute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetMute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetMute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetMute(ctx, req.(*SetMuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateExternalSystem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalSystemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateExternalSystem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, req.(*UpdateExternalSystemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, req.(*UpdateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, req.(*UpdateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, req.(*UpdateOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenter_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v1.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BulkMuteFindings",
			Handler:    _SecurityCenter_BulkMuteFindings_Handler,
		},
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "CreateMuteConfig",
			Handler:    _SecurityCenter_CreateMuteConfig_Handler,
		},
		{
			MethodName: "CreateNotificationConfig",
			Handler:    _SecurityCenter_CreateNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteMuteConfig",
			Handler:    _SecurityCenter_DeleteMuteConfig_Handler,
		},
		{
			MethodName: "DeleteNotificationConfig",
			Handler:    _SecurityCenter_DeleteNotificationConfig_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetMuteConfig",
			Handler:    _SecurityCenter_GetMuteConfig_Handler,
		},
		{
			MethodName: "GetNotificationConfig",
			Handler:    _SecurityCenter_GetNotificationConfig_Handler,
		},
		{
			MethodName: "GetOrganizationSettings",
			Handler:    _SecurityCenter_GetOrganizationSettings_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupAssets",
			Handler:    _SecurityCenter_GroupAssets_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _SecurityCenter_ListAssets_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListMuteConfigs",
			Handler:    _SecurityCenter_ListMuteConfigs_Handler,
		},
		{
			MethodName: "ListNotificationConfigs",
			Handler:    _SecurityCenter_ListNotificationConfigs_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "RunAssetDiscovery",
			Handler:    _SecurityCenter_RunAssetDiscovery_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetMute",
			Handler:    _SecurityCenter_SetMute_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdateExternalSystem",
			Handler:    _SecurityCenter_UpdateExternalSystem_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateMuteConfig",
			Handler:    _SecurityCenter_UpdateMuteConfig_Handler,
		},
		{
			MethodName: "UpdateNotificationConfig",
			Handler:    _SecurityCenter_UpdateNotificationConfig_Handler,
		},
		{
			MethodName: "UpdateOrganizationSettings",
			Handler:    _SecurityCenter_UpdateOrganizationSettings_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v1/securitycenter_service.proto",
}
