import yoda

# from the paper
C_QED = {
 'd01' : [0.97, 0.96, 0.96, 0.96, 0.96, 0.97, 0.97, 1.07 ],
 'd02' : [0.96, 0.97, 0.96, 0.95, 0.97, 0.97, 1.02 ],
 'd03' : [0.96, 0.96, 0.97, 0.98, 0.94 ],
 'd04' : [0.95, 0.96, 0.96, 0.96 ],
 'd05' : [0.91, 0.98, 0.96, 0.97, 0.96, 0.96, 0.97 ],
 'd06' : [0.96, 0.96, 0.96, 0.97, 0.94, 0.93 ],
 'd07' : [0.97, 0.95, 0.96, 0.94, 0.92 ],
 'd08' : [0.98, 0.95, 0.96, 0.94, 0.92 ],
 'd09' : [1.01, 0.99, 1.00, 1.01, 1.01 ],
}

def patch(path, ao):
    did = ao.name()[:3]
    if did in C_QED:
        for b in ao.bins():
            b.scale( 1.0 / C_QED[did][b.index()-1] )
    return ao

