/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttfbin;

import com.kreative.unicode.ttflib.FindOpenType;
import com.kreative.unicode.ttflib.PuaaEntry;
import com.kreative.unicode.ttflib.PuaaTable;
import com.kreative.unicode.ttflib.TtfFile;
import java.awt.Font;
import java.awt.font.OpenType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuaaLookup {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray.length == 0) {
            PuaaLookup.printHelp();
            return;
        }
        PuaaTable puaaTable = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n++];
            if (bl && string.startsWith("-")) {
                PuaaTable puaaTable2;
                if (string.equals("--")) {
                    bl = false;
                    continue;
                }
                if (string.equals("-f") && n < stringArray.length) {
                    if ((puaaTable2 = PuaaLookup.readFromFont(stringArray[n++])) == null) continue;
                    puaaTable = puaaTable2;
                    continue;
                }
                if (string.equals("-i") && n < stringArray.length) {
                    if ((puaaTable2 = PuaaLookup.readFromFile(stringArray[n++])) == null) continue;
                    puaaTable = puaaTable2;
                    continue;
                }
                if (string.equals("-p") && n < stringArray.length) {
                    arrayList.add(stringArray[n++]);
                    continue;
                }
                if (string.equals("-c") && n < stringArray.length) {
                    arrayList2.add(PuaaLookup.parseCP(stringArray[n++]));
                    continue;
                }
                if (string.equals("--help")) {
                    PuaaLookup.printHelp();
                    continue;
                }
                System.out.println("Unknown option: " + string);
                continue;
            }
            arrayList2.add(PuaaLookup.parseCP(string));
        }
        if (puaaTable == null) {
            return;
        }
        PuaaLookup.printChars(puaaTable, arrayList, arrayList2);
    }

    private static PuaaTable readFromFont(String string) {
        try {
            Font font = new Font(string, 0, 1);
            OpenType openType = FindOpenType.forFont(font);
            if (openType != null) {
                byte[] byArray = openType.getFontTable("PUAA");
                if (byArray != null) {
                    return new PuaaTable(byArray);
                }
                System.out.println("Error: Table not found.");
                return null;
            }
            System.out.println("Error: Not an OpenType font.");
            return null;
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    private static PuaaTable readFromFile(String string) {
        try {
            File file = new File(string);
            TtfFile ttfFile = new TtfFile(file);
            PuaaTable puaaTable = ttfFile.getTableAs(PuaaTable.class, "PUAA");
            if (puaaTable != null) {
                return puaaTable;
            }
            System.out.println("Error: Table not found.");
            return null;
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    private static void printChars(PuaaTable puaaTable, List<String> list, List<Integer> list2) {
        if (list2 == null || list2.isEmpty()) {
            PuaaLookup.printProps(puaaTable, list);
            return;
        }
        int n = 0;
        for (String object2 : puaaTable.getProperties()) {
            if (object2.length() <= n) continue;
            n = object2.length();
        }
        n += 4;
        HashMap hashMap = new HashMap();
        for (String string : puaaTable.getProperties()) {
            hashMap.put(string, puaaTable.getPropertyMap(string));
        }
        for (int n2 : list2) {
            System.out.println("U+" + PuaaLookup.toHexString(n2) + ":");
            for (String string : puaaTable.getProperties()) {
                if (!list.isEmpty() && !list.contains(string) || !((Map)hashMap.get(string)).containsKey(n2)) continue;
                StringBuffer stringBuffer = new StringBuffer("  ");
                stringBuffer.append(string);
                stringBuffer.append(":");
                while (stringBuffer.length() < n) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append((String)((Map)hashMap.get(string)).get(n2));
                System.out.println(stringBuffer.toString());
            }
        }
    }

    private static void printProps(PuaaTable puaaTable, List<String> list) {
        if (list == null || list.isEmpty()) {
            PuaaLookup.printTOC(puaaTable);
            return;
        }
        for (String string : puaaTable.getProperties()) {
            if (!list.contains(string)) continue;
            System.out.println(string + ":");
            for (PuaaEntry puaaEntry : puaaTable.getPropertyRuns(string)) {
                StringBuffer stringBuffer = new StringBuffer("  ");
                stringBuffer.append(PuaaLookup.toHexString(puaaEntry.getFirstCodePoint()));
                if (puaaEntry.getFirstCodePoint() != puaaEntry.getLastCodePoint()) {
                    stringBuffer.append("..");
                    stringBuffer.append(PuaaLookup.toHexString(puaaEntry.getLastCodePoint()));
                }
                stringBuffer.append(":");
                while (stringBuffer.length() < 18) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(puaaEntry.getPropertyString(puaaEntry.getFirstCodePoint()));
                System.out.println(stringBuffer.toString());
            }
        }
    }

    private static void printTOC(PuaaTable puaaTable) {
        System.out.println("Properties:");
        for (String string : puaaTable.getProperties()) {
            System.out.println("  " + string);
        }
    }

    private static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 4) {
            string = ("0000" + string).substring(string.length());
        }
        return string;
    }

    private static int parseCP(String string) {
        string = string.replaceAll("[Uu][+]|[0][Xx]|\\s+", "");
        return Integer.parseInt(string, 16);
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("PuaaLookup - Look up Unicode Character Database properties in TrueType files.");
        System.out.println();
        System.out.println("  -f <name>     Specify source TrueType font name.");
        System.out.println("  -i <path>     Specify source TrueType file.");
        System.out.println("  -p <prop>     Specify properties to look up.");
        System.out.println("  -c <cp>       Specify code points to look up.");
        System.out.println("  --            Process remaining arguments as code points.");
        System.out.println();
    }
}

