/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.EblcGlyphIdOffsetPair;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable;
import com.kreative.bitsnpicas.truetype.SbitBigGlyphMetrics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EblcIndexSubtable2
extends EblcIndexSubtable {
    public int imageSize;
    public SbitBigGlyphMetrics bigMetrics;

    protected void read(DataInputStream dataInputStream) throws IOException {
        this.imageSize = dataInputStream.readInt();
        this.bigMetrics = new SbitBigGlyphMetrics();
        this.bigMetrics.read(dataInputStream);
    }

    protected void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.imageSize);
        (this.bigMetrics != null ? this.bigMetrics : new SbitBigGlyphMetrics()).write(dataOutputStream);
    }

    protected int length() {
        return 12;
    }

    public int[] getOffsets() {
        int n = this.header.lastGlyphIndex - this.header.firstGlyphIndex + 2;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i * this.imageSize + this.header.imageDataOffset;
        }
        return nArray;
    }

    public void setOffsets(int[] nArray) {
        this.imageSize = nArray[1] - nArray[0];
    }

    public EblcGlyphIdOffsetPair[] getGlyphIdOffsetPairs() {
        int n = this.header.lastGlyphIndex - this.header.firstGlyphIndex + 2;
        EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray = new EblcGlyphIdOffsetPair[n];
        for (int i = 0; i < n; ++i) {
            eblcGlyphIdOffsetPairArray[i] = new EblcGlyphIdOffsetPair();
            eblcGlyphIdOffsetPairArray[i].glyphID = this.header.firstGlyphIndex + i;
            eblcGlyphIdOffsetPairArray[i].offset = i * this.imageSize + this.header.imageDataOffset;
        }
        return eblcGlyphIdOffsetPairArray;
    }

    public void setGlyphIdOffsetPairs(EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray) {
        this.header.firstGlyphIndex = eblcGlyphIdOffsetPairArray[0].glyphID;
        this.header.lastGlyphIndex = eblcGlyphIdOffsetPairArray[0].glyphID + eblcGlyphIdOffsetPairArray.length - 2;
        this.imageSize = eblcGlyphIdOffsetPairArray[1].offset - eblcGlyphIdOffsetPairArray[0].offset;
    }
}

