/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.EbdtComponent;
import com.kreative.bitsnpicas.truetype.ListBasedEbdtEntry;
import com.kreative.bitsnpicas.truetype.SbitSmallGlyphMetrics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EbdtEntryFormat8
extends ListBasedEbdtEntry<EbdtComponent> {
    public SbitSmallGlyphMetrics smallMetrics;

    @Override
    public int format() {
        return 8;
    }

    @Override
    protected void read(DataInputStream dataInputStream, int n) throws IOException {
        this.smallMetrics = new SbitSmallGlyphMetrics();
        this.smallMetrics.read(dataInputStream);
        dataInputStream.readByte();
        int n2 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            EbdtComponent ebdtComponent = new EbdtComponent();
            ebdtComponent.read(dataInputStream);
            this.add(ebdtComponent);
        }
    }

    @Override
    protected void write(DataOutputStream dataOutputStream) throws IOException {
        (this.smallMetrics != null ? this.smallMetrics : new SbitSmallGlyphMetrics()).write(dataOutputStream);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(this.size());
        for (EbdtComponent ebdtComponent : this) {
            ebdtComponent.write(dataOutputStream);
        }
    }

    @Override
    protected int length() {
        return 8 + this.size() * 4;
    }
}

