/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import java.io.UnsupportedEncodingException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuaaUtility {
    public static String[] splitLine(String string) {
        int n = string.indexOf("#");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string.split(";");
    }

    public static int[] splitRange(String string) {
        String[] stringArray = string.split("[.]+");
        int n = Integer.parseInt(stringArray[0].trim(), 16);
        if (stringArray.length < 2) {
            return new int[]{n, n};
        }
        int n2 = Integer.parseInt(stringArray[1].trim(), 16);
        return new int[]{n, n2};
    }

    public static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        while (string.length() < 4) {
            string = "0" + string;
        }
        return string;
    }

    public static String joinRange(PuaaSubtableEntry puaaSubtableEntry) {
        if (puaaSubtableEntry.firstCodePoint == puaaSubtableEntry.lastCodePoint) {
            return PuaaUtility.toHexString(puaaSubtableEntry.firstCodePoint);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PuaaUtility.toHexString(puaaSubtableEntry.firstCodePoint));
        stringBuffer.append("..");
        stringBuffer.append(PuaaUtility.toHexString(puaaSubtableEntry.lastCodePoint));
        return stringBuffer.toString();
    }

    public static String joinLine(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            if (stringArray[i] == null) continue;
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return object == null;
        }
        return object.equals(object2);
    }

    public static boolean appendToEntry(PuaaSubtableEntry.Single single, int n, String string) {
        if (single == null) {
            return false;
        }
        if ((short)single.lastCodePoint == -1) {
            return false;
        }
        if (single.lastCodePoint + 1 != n) {
            return false;
        }
        if (!PuaaUtility.equals(single.value, string)) {
            return false;
        }
        ++single.lastCodePoint;
        return true;
    }

    public static boolean appendToEntry(PuaaSubtableEntry.Multiple multiple, int n, String string) {
        if (multiple == null) {
            return false;
        }
        if ((short)multiple.lastCodePoint == -1) {
            return false;
        }
        if (multiple.lastCodePoint + 1 != n) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(multiple.values));
        arrayList.add(string);
        multiple.values = arrayList.toArray(new String[arrayList.size()]);
        ++multiple.lastCodePoint;
        return true;
    }

    public static boolean appendToEntry(PuaaSubtableEntry.Boolean boolean_, int n, boolean bl) {
        if (boolean_ == null) {
            return false;
        }
        if ((short)boolean_.lastCodePoint == -1) {
            return false;
        }
        if (boolean_.lastCodePoint + 1 != n) {
            return false;
        }
        if (boolean_.value != bl) {
            return false;
        }
        ++boolean_.lastCodePoint;
        return true;
    }

    public static boolean appendToEntry(PuaaSubtableEntry.Decimal decimal, int n, int n2) {
        if (decimal == null) {
            return false;
        }
        if ((short)decimal.lastCodePoint == -1) {
            return false;
        }
        if (decimal.lastCodePoint + 1 != n) {
            return false;
        }
        if (decimal.value != n2) {
            return false;
        }
        ++decimal.lastCodePoint;
        return true;
    }

    public static boolean appendToEntry(PuaaSubtableEntry.Hexadecimal hexadecimal, int n, int n2) {
        if (hexadecimal == null) {
            return false;
        }
        if ((short)hexadecimal.lastCodePoint == -1) {
            return false;
        }
        if (hexadecimal.lastCodePoint + 1 != n) {
            return false;
        }
        if (hexadecimal.value != n2) {
            return false;
        }
        ++hexadecimal.lastCodePoint;
        return true;
    }

    public static boolean appendToEntry(PuaaSubtableEntry.HexMultiple hexMultiple, int n, int n2) {
        if (hexMultiple == null) {
            return false;
        }
        if ((short)hexMultiple.lastCodePoint == -1) {
            return false;
        }
        if (hexMultiple.lastCodePoint + 1 != n) {
            return false;
        }
        int n3 = hexMultiple.values.length;
        int[] nArray = new int[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = hexMultiple.values[i];
        }
        nArray[n3] = n2;
        hexMultiple.values = nArray;
        ++hexMultiple.lastCodePoint;
        return true;
    }

    public static boolean appendToEntry(PuaaSubtableEntry.HexSequence hexSequence, int n, int[] nArray) {
        if (hexSequence == null) {
            return false;
        }
        if ((short)hexSequence.lastCodePoint == -1) {
            return false;
        }
        if (hexSequence.lastCodePoint + 1 != n) {
            return false;
        }
        if (!Arrays.equals(hexSequence.values, nArray)) {
            return false;
        }
        ++hexSequence.lastCodePoint;
        return true;
    }

    private static <T> List<CEFMItem<T>> sorted(Map<Integer, T> map) {
        ArrayList<CEFMItem<T>> arrayList = new ArrayList<CEFMItem<T>>();
        for (Map.Entry<Integer, T> entry : map.entrySet()) {
            T t = entry.getValue();
            if (t == null || t instanceof String && t.toString().length() == 0) continue;
            arrayList.add(new CEFMItem<T>(entry.getKey(), t));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<PuaaSubtableEntry> createEntriesFromStringMap(Map<Integer, String> map) {
        List<CEFMItem<String>> list = PuaaUtility.sorted(map);
        ArrayList<PuaaSubtableEntry.Single> arrayList = new ArrayList<PuaaSubtableEntry.Single>();
        PuaaSubtableEntry.Single single = null;
        for (CEFMItem<String> object2 : list) {
            if (PuaaUtility.appendToEntry(single, object2.cp, (String)object2.value)) continue;
            single = new PuaaSubtableEntry.Single();
            single.firstCodePoint = object2.cp;
            single.lastCodePoint = object2.cp;
            single.value = (String)object2.value;
            arrayList.add(single);
        }
        ArrayList arrayList2 = new ArrayList();
        Object var5_6 = null;
        for (PuaaSubtableEntry.Single single2 : arrayList) {
            void var5_7;
            if (single2.firstCodePoint != single2.lastCodePoint) {
                Object var5_8 = null;
                arrayList2.add(single2);
                continue;
            }
            if (PuaaUtility.appendToEntry((PuaaSubtableEntry.Multiple)var5_7, single2.firstCodePoint, single2.value)) continue;
            PuaaSubtableEntry.Multiple multiple = new PuaaSubtableEntry.Multiple();
            multiple.firstCodePoint = single2.firstCodePoint;
            multiple.lastCodePoint = single2.lastCodePoint;
            multiple.values = new String[]{single2.value};
            arrayList2.add(multiple);
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            PuaaSubtableEntry puaaSubtableEntry = (PuaaSubtableEntry)arrayList2.get(i);
            if (puaaSubtableEntry.firstCodePoint != puaaSubtableEntry.lastCodePoint) continue;
            single = new PuaaSubtableEntry.Single();
            single.firstCodePoint = puaaSubtableEntry.firstCodePoint;
            single.lastCodePoint = puaaSubtableEntry.lastCodePoint;
            single.value = puaaSubtableEntry.getPropertyValue(puaaSubtableEntry.firstCodePoint);
            arrayList2.set(i, single);
        }
        return arrayList2;
    }

    public static List<PuaaSubtableEntry> createEntriesFromBooleanMap(Map<Integer, Boolean> map) {
        List<CEFMItem<Boolean>> list = PuaaUtility.sorted(map);
        ArrayList<PuaaSubtableEntry> arrayList = new ArrayList<PuaaSubtableEntry>();
        PuaaSubtableEntry.Boolean boolean_ = null;
        for (CEFMItem<Boolean> cEFMItem : list) {
            if (PuaaUtility.appendToEntry(boolean_, cEFMItem.cp, (Boolean)cEFMItem.value)) continue;
            boolean_ = new PuaaSubtableEntry.Boolean();
            boolean_.firstCodePoint = cEFMItem.cp;
            boolean_.lastCodePoint = cEFMItem.cp;
            boolean_.value = (Boolean)cEFMItem.value;
            arrayList.add(boolean_);
        }
        return arrayList;
    }

    public static List<PuaaSubtableEntry> createEntriesFromDecimalMap(Map<Integer, Integer> map) {
        List<CEFMItem<Integer>> list = PuaaUtility.sorted(map);
        ArrayList<PuaaSubtableEntry> arrayList = new ArrayList<PuaaSubtableEntry>();
        PuaaSubtableEntry.Decimal decimal = null;
        for (CEFMItem<Integer> cEFMItem : list) {
            if (PuaaUtility.appendToEntry(decimal, cEFMItem.cp, (int)((Integer)cEFMItem.value))) continue;
            decimal = new PuaaSubtableEntry.Decimal();
            decimal.firstCodePoint = cEFMItem.cp;
            decimal.lastCodePoint = cEFMItem.cp;
            decimal.value = (Integer)cEFMItem.value;
            arrayList.add(decimal);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<PuaaSubtableEntry> createEntriesFromHexadecimalMap(Map<Integer, Integer> map) {
        List<CEFMItem<Integer>> list = PuaaUtility.sorted(map);
        ArrayList<PuaaSubtableEntry.Hexadecimal> arrayList = new ArrayList<PuaaSubtableEntry.Hexadecimal>();
        PuaaSubtableEntry.Hexadecimal hexadecimal = null;
        for (CEFMItem<Integer> object2 : list) {
            if (PuaaUtility.appendToEntry(hexadecimal, object2.cp, (int)((Integer)object2.value))) continue;
            hexadecimal = new PuaaSubtableEntry.Hexadecimal();
            hexadecimal.firstCodePoint = object2.cp;
            hexadecimal.lastCodePoint = object2.cp;
            hexadecimal.value = (Integer)object2.value;
            arrayList.add(hexadecimal);
        }
        ArrayList arrayList2 = new ArrayList();
        Object var5_6 = null;
        for (PuaaSubtableEntry.Hexadecimal hexadecimal2 : arrayList) {
            void var5_7;
            if (hexadecimal2.firstCodePoint != hexadecimal2.lastCodePoint) {
                Object var5_8 = null;
                arrayList2.add(hexadecimal2);
                continue;
            }
            if (PuaaUtility.appendToEntry((PuaaSubtableEntry.HexMultiple)var5_7, hexadecimal2.firstCodePoint, hexadecimal2.value)) continue;
            PuaaSubtableEntry.HexMultiple hexMultiple = new PuaaSubtableEntry.HexMultiple();
            hexMultiple.firstCodePoint = hexadecimal2.firstCodePoint;
            hexMultiple.lastCodePoint = hexadecimal2.lastCodePoint;
            hexMultiple.values = new int[]{hexadecimal2.value};
            arrayList2.add(hexMultiple);
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            PuaaSubtableEntry puaaSubtableEntry = (PuaaSubtableEntry)arrayList2.get(i);
            if (puaaSubtableEntry.firstCodePoint != puaaSubtableEntry.lastCodePoint) continue;
            hexadecimal = new PuaaSubtableEntry.Hexadecimal();
            hexadecimal.firstCodePoint = puaaSubtableEntry.firstCodePoint;
            hexadecimal.lastCodePoint = puaaSubtableEntry.lastCodePoint;
            hexadecimal.value = Integer.parseInt(puaaSubtableEntry.getPropertyValue(puaaSubtableEntry.firstCodePoint), 16);
            arrayList2.set(i, hexadecimal);
        }
        return arrayList2;
    }

    public static List<PuaaSubtableEntry> createEntriesFromHexSequenceMap(Map<Integer, int[]> map) {
        List<CEFMItem<int[]>> list = PuaaUtility.sorted(map);
        ArrayList<PuaaSubtableEntry> arrayList = new ArrayList<PuaaSubtableEntry>();
        PuaaSubtableEntry.HexSequence hexSequence = null;
        for (CEFMItem<int[]> cEFMItem : list) {
            if (PuaaUtility.appendToEntry(hexSequence, cEFMItem.cp, (int[])cEFMItem.value)) continue;
            hexSequence = new PuaaSubtableEntry.HexSequence();
            hexSequence.firstCodePoint = cEFMItem.cp;
            hexSequence.lastCodePoint = cEFMItem.cp;
            hexSequence.values = (int[])cEFMItem.value;
            arrayList.add(hexSequence);
        }
        return arrayList;
    }

    private static boolean isChunky(char c) {
        return Character.isLetterOrDigit(c) || Character.isSurrogate(c) || c >= '\"' && c <= '*' || c == '<' || c == '>' || c == '@' || c == '[' || c == ']' || c == '_' || c == '{' || c == '}';
    }

    private static List<String> splitName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            while (n2 < cArray.length && PuaaUtility.isChunky(cArray[n2])) {
                ++n2;
            }
            while (n2 < cArray.length && !PuaaUtility.isChunky(cArray[n2]) && !Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            while (n2 < cArray.length && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            arrayList.add(string.substring(n, n2));
            n = n2;
        }
        return arrayList;
    }

    private static String joinName(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static int utf8Length(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
    }

    public static List<PuaaSubtableEntry> createEntriesFromNameMap(Map<Integer, String> map) {
        Cloneable cloneable;
        Object object;
        Object object2;
        int n;
        int n2;
        ArrayList<CEFNMItem> arrayList = new ArrayList<CEFNMItem>();
        for (Map.Entry<Integer, String> object32 : map.entrySet()) {
            if (object32.getValue() == null || object32.getValue().length() == 0) continue;
            arrayList.add(new CEFNMItem(object32.getKey(), object32.getValue()));
        }
        Collections.sort(arrayList);
        ArrayList arrayList2 = new ArrayList();
        while (true) {
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            int n3 = 0;
            n2 = 0;
            n = arrayList.size();
            while (n3 < n) {
                CEFNMItem cEFNMItem = (CEFNMItem)arrayList.get(n2);
                ++n2;
                if (!cEFNMItem.pieces.isEmpty()) {
                    object2 = new PuaaSubtableEntry.Single();
                    ((PuaaSubtableEntry.Single)object2).firstCodePoint = cEFNMItem.cp;
                    ((PuaaSubtableEntry.Single)object2).lastCodePoint = cEFNMItem.cp;
                    ((PuaaSubtableEntry.Single)object2).value = cEFNMItem.getPrefix();
                    while (n2 < n && PuaaUtility.appendToEntry((PuaaSubtableEntry.Single)object2, ((CEFNMItem)object).cp, ((CEFNMItem)(object = (CEFNMItem)arrayList.get(n2))).getPrefix())) {
                        ++n2;
                    }
                    if (((PuaaSubtableEntry.Single)object2).firstCodePoint != ((PuaaSubtableEntry.Single)object2).lastCodePoint) {
                        arrayList3.add(object2);
                        while (n3 < n2) {
                            ((CEFNMItem)arrayList.get(n3)).removePrefix();
                            ++n3;
                        }
                    }
                }
                n3 = n2;
            }
            if (arrayList3.isEmpty()) break;
            arrayList2.addAll(arrayList3);
        }
        ArrayList arrayList4 = new ArrayList();
        while (true) {
            cloneable = new ArrayList();
            n2 = 0;
            n = 0;
            int n4 = arrayList.size();
            while (n2 < n4) {
                object2 = (CEFNMItem)arrayList.get(n);
                ++n;
                if (!((CEFNMItem)object2).pieces.isEmpty()) {
                    CEFNMItem cEFNMItem;
                    object = new PuaaSubtableEntry.Single();
                    ((PuaaSubtableEntry.Single)object).firstCodePoint = ((CEFNMItem)object2).cp;
                    ((PuaaSubtableEntry.Single)object).lastCodePoint = ((CEFNMItem)object2).cp;
                    ((PuaaSubtableEntry.Single)object).value = ((CEFNMItem)object2).getSuffix();
                    while (n < n4 && PuaaUtility.appendToEntry((PuaaSubtableEntry.Single)object, cEFNMItem.cp, (cEFNMItem = (CEFNMItem)arrayList.get(n)).getSuffix())) {
                        ++n;
                    }
                    if (((PuaaSubtableEntry.Single)object).firstCodePoint != ((PuaaSubtableEntry.Single)object).lastCodePoint) {
                        cloneable.add(object);
                        while (n2 < n) {
                            ((CEFNMItem)arrayList.get(n2)).removeSuffix();
                            ++n2;
                        }
                    }
                }
                n2 = n;
            }
            if (cloneable.isEmpty()) break;
            arrayList4.addAll(0, cloneable);
        }
        cloneable = new HashMap();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (CEFNMItem cEFNMItem : arrayList) {
            if (cEFNMItem.pieces.isEmpty()) continue;
            object2 = cEFNMItem.getValue();
            if (PuaaUtility.utf8Length((String)object2) > 255) {
                int n5 = ((String)object2).length() / 2;
                if (Character.isLowSurrogate(((String)object2).charAt(n5))) {
                    ++n5;
                }
                cloneable.put(cEFNMItem.cp, ((String)object2).substring(0, n5));
                hashMap.put(cEFNMItem.cp, ((String)object2).substring(n5));
                continue;
            }
            cloneable.put(cEFNMItem.cp, object2);
        }
        ArrayList arrayList5 = new ArrayList();
        arrayList5.addAll(arrayList2);
        arrayList5.addAll(PuaaUtility.createEntriesFromStringMap(cloneable));
        arrayList5.addAll(PuaaUtility.createEntriesFromStringMap(hashMap));
        arrayList5.addAll(arrayList4);
        return arrayList5;
    }

    public static SortedMap<Integer, String> createMapFromEntries(List<? extends PuaaSubtableEntry> list) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        for (PuaaSubtableEntry puaaSubtableEntry : list) {
            for (int i = puaaSubtableEntry.firstCodePoint; i <= puaaSubtableEntry.lastCodePoint; ++i) {
                String string = puaaSubtableEntry.getPropertyValue(i);
                if (string == null) continue;
                if (treeMap.containsKey(i)) {
                    treeMap.put(i, (String)treeMap.get(i) + string);
                    continue;
                }
                treeMap.put(i, string);
            }
        }
        return treeMap;
    }

    public static List<PuaaSubtableEntry.Single> createRunsFromEntries(List<? extends PuaaSubtableEntry> list) {
        List<CEFMItem<String>> list2 = PuaaUtility.sorted(PuaaUtility.createMapFromEntries(list));
        ArrayList<PuaaSubtableEntry.Single> arrayList = new ArrayList<PuaaSubtableEntry.Single>();
        PuaaSubtableEntry.Single single = null;
        for (CEFMItem<String> cEFMItem : list2) {
            if (PuaaUtility.appendToEntry(single, cEFMItem.cp, (String)cEFMItem.value)) continue;
            single = new PuaaSubtableEntry.Single();
            single.firstCodePoint = cEFMItem.cp;
            single.lastCodePoint = cEFMItem.cp;
            single.value = (String)cEFMItem.value;
            arrayList.add(single);
        }
        return arrayList;
    }

    public static int naturalCompare(String string, String string2) {
        List<String> list = PuaaUtility.naturalTokenize(string.trim());
        List<String> list2 = PuaaUtility.naturalTokenize(string2.trim());
        for (int i = 0; i < list.size() && i < list2.size(); ++i) {
            try {
                double d = Double.parseDouble(list.get(i));
                double d2 = Double.parseDouble(list2.get(i));
                int n = Double.compare(d, d2);
                if (n == 0) continue;
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                int n = list.get(i).compareToIgnoreCase(list2.get(i));
                if (n == 0) continue;
                return n;
            }
        }
        return list.size() - list2.size();
    }

    private static List<String> naturalTokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            int n2;
            int n3 = Character.isDigit(c) ? 1 : (n2 = Character.isLetter(c) ? 2 : 3);
            if (n2 != n) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                n = n2;
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CEFNMItem
    implements Comparable<CEFNMItem> {
        public final int cp;
        public final List<String> pieces;

        public CEFNMItem(int n, String string) {
            this.cp = n;
            this.pieces = PuaaUtility.splitName(string);
        }

        @Override
        public int compareTo(CEFNMItem cEFNMItem) {
            return this.cp - cEFNMItem.cp;
        }

        public String getPrefix() {
            return this.pieces.isEmpty() ? null : this.pieces.get(0);
        }

        public String removePrefix() {
            return this.pieces.isEmpty() ? null : this.pieces.remove(0);
        }

        public String getSuffix() {
            return this.pieces.isEmpty() ? null : this.pieces.get(this.pieces.size() - 1);
        }

        public String removeSuffix() {
            return this.pieces.isEmpty() ? null : this.pieces.remove(this.pieces.size() - 1);
        }

        public String getValue() {
            return PuaaUtility.joinName(this.pieces);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CEFMItem<T>
    implements Comparable<CEFMItem<T>> {
        public final int cp;
        public final T value;

        public CEFMItem(int n, T t) {
            this.cp = n;
            this.value = t;
        }

        @Override
        public int compareTo(CEFMItem<T> cEFMItem) {
            return this.cp - cEFMItem.cp;
        }
    }
}

