/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaCodecRegistry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Scanner;

public class PuaaCodecTest {
    private static final PuaaCodecRegistry registry = PuaaCodecRegistry.instance;

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            File file = new File(string);
            PuaaCodecTest.testDir(file);
        }
    }

    private static void testDir(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.getName().startsWith(".")) continue;
                PuaaCodecTest.testDir(file2);
            }
        } else {
            PuaaCodec puaaCodec = registry.getCodec(file.getName());
            if (puaaCodec != null) {
                PuaaCodecTest.testFile(file, puaaCodec);
            }
        }
    }

    private static void testFile(File file, PuaaCodec puaaCodec) {
        System.out.print(file.getName());
        System.out.print("\t");
        System.out.print(file.length());
        System.out.print("\t");
        try {
            PuaaTable puaaTable = new PuaaTable();
            Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
            puaaCodec.compile(puaaTable, scanner);
            scanner.close();
            byte[] byArray = puaaTable.compile(null);
            System.out.print(byArray.length);
            System.out.print("\t");
            puaaTable = new PuaaTable();
            puaaTable.decompile(byArray, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
            puaaCodec.decompile(puaaTable, printWriter);
            printWriter.flush();
            printWriter.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            System.out.print(byArray2.length);
            System.out.print("\t");
            byte[] byArray3 = puaaTable.compile(null);
            if (Arrays.equals(byArray, byArray3)) {
                System.out.println("PASS");
            } else {
                System.out.println("FAIL");
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR: " + iOException);
        }
    }
}

