/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.rsrc.SoundResource;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SoundPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public SoundPanel(SoundResource soundResource) {
        JLabel jLabel = new JLabel(new ImageIcon(SoundPanel.class.getResource("Sound.png")));
        jLabel.setAlignmentX(0.5f);
        JButton jButton = new JButton("Play Sound");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(jButton);
        jPanel.setAlignmentX(0.5f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(Box.createGlue());
        jPanel2.add(jLabel);
        jPanel2.add(jPanel);
        jPanel2.add(Box.createGlue());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setLayout(new GridLayout());
        this.add(jPanel2);
        final byte[] byArray = soundResource.toAiff();
        final byte[] byArray2 = soundResource.toWav();
        if (byArray == null && byArray2 == null) {
            jButton.setEnabled(false);
        } else {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (byArray != null) {
                        try {
                            SoundPanel.playSound(byArray);
                            return;
                        }
                        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                            // empty catch block
                        }
                    }
                    if (byArray2 != null) {
                        try {
                            SoundPanel.playSound(byArray2);
                            return;
                        }
                        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                            // empty catch block
                        }
                    }
                    JOptionPane.showMessageDialog(null, "Could not produce audio in a supported format.", "Play Sound", 0);
                }
            });
        }
    }

    private static void playSound(byte[] byArray) throws UnsupportedAudioFileException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(byArray));
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat, (int)audioInputStream.getFrameLength() * audioFormat.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            clip.start();
            clip.drain();
            clip.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
    }
}

