/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.geos.GEOSFontFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SplitGEOS {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            SplitGEOS.printHelp();
        } else {
            boolean bl = true;
            File file = null;
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n++];
                if (bl && string.startsWith("-")) {
                    if (string.equals("--")) {
                        bl = false;
                        continue;
                    }
                    if (string.equals("-d") && n < stringArray.length) {
                        file = new File(stringArray[n++]);
                        continue;
                    }
                    if (string.equals("--help")) {
                        SplitGEOS.printHelp();
                        continue;
                    }
                    System.err.println("Unknown option: " + string);
                    continue;
                }
                try {
                    System.out.print(string + "...");
                    File file2 = new File(string);
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file2));
                    GEOSFontFile gEOSFontFile = new GEOSFontFile(dataInputStream);
                    dataInputStream.close();
                    if (gEOSFontFile.isValid()) {
                        for (int n2 : gEOSFontFile.getFontPointSizes()) {
                            GEOSFontFile gEOSFontFile2 = new GEOSFontFile();
                            gEOSFontFile2.setFontName(gEOSFontFile.getFontName());
                            gEOSFontFile2.setClassTextString(gEOSFontFile.getClassTextString());
                            gEOSFontFile2.setDescriptionString(gEOSFontFile.getDescriptionString());
                            gEOSFontFile2.setFontID(gEOSFontFile.getFontID());
                            gEOSFontFile2.setFontPointSize(n2, gEOSFontFile.getFontPointSize(n2));
                            gEOSFontFile2.recalculate();
                            File file3 = new File(file != null ? file : file2.getParentFile(), gEOSFontFile.getFontName() + "." + n2 + ".cvt");
                            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file3));
                            gEOSFontFile2.write(dataOutputStream);
                            dataOutputStream.flush();
                            dataOutputStream.close();
                        }
                        System.out.println(" DONE");
                        continue;
                    }
                    System.out.println(" ERROR: Not a GEOS font file.");
                }
                catch (IOException iOException) {
                    System.out.println(" ERROR: " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                }
            }
        }
    }

    private static void printHelp() {
        System.out.println("SplitGEOS - Split GEOS font files into individual point sizes.");
        System.out.println("  -d <path>     Specify directory for output files.");
    }
}

