/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class ImageToSvg {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = true;
        int[] nArray = new int[]{0, -700, 800, 800};
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2;
            String string3;
            String string4 = stringArray[n++];
            if (bl && string4.startsWith("-")) {
                if (string4.equals("--")) {
                    bl = false;
                    continue;
                }
                if (string4.equals("-x") && n < stringArray.length) {
                    nArray[0] = ImageToSvg.parseInt(stringArray[n++]);
                    continue;
                }
                if (string4.equals("-y") && n < stringArray.length) {
                    nArray[1] = ImageToSvg.parseInt(stringArray[n++]);
                    continue;
                }
                if (string4.equals("-w") && n < stringArray.length) {
                    nArray[2] = ImageToSvg.parseInt(stringArray[n++]);
                    continue;
                }
                if (string4.equals("-h") && n < stringArray.length) {
                    nArray[3] = ImageToSvg.parseInt(stringArray[n++]);
                    continue;
                }
                if (string4.equals("-r") && n + 4 <= stringArray.length) {
                    nArray[0] = ImageToSvg.parseInt(stringArray[n++]);
                    nArray[1] = ImageToSvg.parseInt(stringArray[n++]);
                    nArray[2] = ImageToSvg.parseInt(stringArray[n++]);
                    nArray[3] = ImageToSvg.parseInt(stringArray[n++]);
                    continue;
                }
                if (string4.equals("--help")) {
                    ImageToSvg.printHelp();
                    continue;
                }
                System.err.println("Unknown option: " + string4);
                continue;
            }
            File file = new File(string4);
            String string5 = file.getName();
            int n2 = string5.lastIndexOf(46);
            if (n2 <= 0 || (string3 = ImageToSvg.getMimeType(string2 = string5.substring(n2 + 1))) == null || (string = ImageToSvg.createDataURI(file, string3)) == null) continue;
            File file2 = file.getParentFile();
            String string6 = string5.substring(0, n2);
            String string7 = string6 + ".svg";
            File file3 = new File(file2, string7);
            ImageToSvg.writeSVG(file3, string, nArray);
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  java -jar BitsNPicas.jar imagetosvg <options> <files>");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -x <number>         Set X origin of image.");
        System.out.println("  -y <number>         Set Y origin of image.");
        System.out.println("  -w <number>         Set width of image.");
        System.out.println("  -h <number>         Set height of image.");
        System.out.println("  -r <x> <y> <w> <h>  Set image position and size.");
        System.out.println("  --                  Treat remaining args as file names.");
        System.out.println();
    }

    private static String createDataURI(File file, String string) {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer("data:");
            stringBuffer.append(string);
            stringBuffer.append(";base64,");
            Base64OutputStream base64OutputStream = new Base64OutputStream(stringBuffer);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[0x100000];
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                base64OutputStream.write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)base64OutputStream).flush();
            ((OutputStream)base64OutputStream).close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            System.err.println("Error reading " + file.getAbsolutePath());
            return null;
        }
    }

    private static void writeSVG(File file, String string, int[] nArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
            printWriter.print("<svg id=\"glyph{{{0}}}\"");
            printWriter.print(" xmlns=\"http://www.w3.org/2000/svg\"");
            printWriter.print(" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
            printWriter.print("<image x=\"" + nArray[0] + "\" y=\"" + nArray[1] + "\"");
            printWriter.print(" width=\"" + nArray[2] + "\" height=\"" + nArray[3] + "\"");
            printWriter.print(" xlink:href=\"" + string + "\"/>");
            printWriter.print("</svg>");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing " + file.getAbsolutePath());
        }
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static String getMimeType(String string) {
        if (string.equalsIgnoreCase("bmp")) {
            return "image/bmp";
        }
        if (string.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        if (string.equalsIgnoreCase("jpe")) {
            return "image/jpeg";
        }
        if (string.equalsIgnoreCase("jpeg")) {
            return "image/jpeg";
        }
        if (string.equalsIgnoreCase("jpg")) {
            return "image/jpeg";
        }
        if (string.equalsIgnoreCase("png")) {
            return "image/png";
        }
        if (string.equalsIgnoreCase("tif")) {
            return "image/tiff";
        }
        if (string.equalsIgnoreCase("tiff")) {
            return "image/tiff";
        }
        if (string.equalsIgnoreCase("wbm")) {
            return "image/vnd.wap.wbmp";
        }
        if (string.equalsIgnoreCase("wbmp")) {
            return "image/vnd.wap.wbmp";
        }
        if (string.equalsIgnoreCase("webp")) {
            return "image/webp";
        }
        return null;
    }

    private static class Base64OutputStream
    extends OutputStream {
        private final StringBuffer sb;
        private int word = 0;
        private int count = 0;
        private static final char[] b64e = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        public Base64OutputStream(StringBuffer stringBuffer) {
            this.sb = stringBuffer;
        }

        public void write(int n) throws IOException {
            this.word <<= 8;
            this.word |= n & 0xFF;
            ++this.count;
            if (this.count >= 3) {
                this.writeWord();
                this.word = 0;
                this.count = 0;
            }
        }

        public void flush() throws IOException {
            if (this.count > 0) {
                for (int i = this.count; i < 3; ++i) {
                    this.word <<= 8;
                }
                this.writeWord();
            }
            this.word = 0;
            this.count = 0;
        }

        public void close() throws IOException {
            this.flush();
        }

        private void writeWord() throws IOException {
            int n = 18;
            for (int i = 0; i <= this.count; ++i) {
                this.sb.append(b64e[this.word >> n & 0x3F]);
                n -= 6;
            }
            for (n = this.count; n < 3; ++n) {
                this.sb.append('=');
            }
        }
    }
}

