/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FZXBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList encoding;

    public FZXBitmapFontImporter() {
        this.encoding = null;
    }

    public FZXBitmapFontImporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        int n;
        int n2;
        if (byArray.length < 3) {
            return new BitmapFont[0];
        }
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        int n5 = byArray[2] & 0xFF;
        if (n5 < 32) {
            return new BitmapFont[0];
        }
        int n6 = (n5 - 30) * 3;
        if (byArray.length < n6 + 2) {
            return new BitmapFont[0];
        }
        int[] nArray = new int[n5 - 30];
        int[] nArray2 = new int[n5 - 31];
        int[] nArray3 = new int[n5 - 31];
        int[] nArray4 = new int[n5 - 31];
        int n7 = 3;
        int n8 = 0;
        int n9 = 32;
        while (n9 <= n5) {
            n2 = byArray[n7] & 0xFF | (byArray[n7 + 1] & 0xFF) << 8;
            n = byArray[n7 + 2] & 0xFF;
            nArray[n8] = (n2 & 0x3FFF) + n7;
            nArray2[n8] = n2 >> 14;
            nArray3[n8] = n >> 4;
            nArray4[n8] = (n & 0xF) + 1;
            ++n9;
            ++n8;
            n7 += 3;
        }
        nArray[n5 - 31] = (byArray[n6] & 0xFF | (byArray[n6 + 1] & 0xFF) << 8) + n6;
        byte[][][] byArrayArray = new byte[n5 - 31][][];
        n8 = 0;
        n9 = 32;
        while (n9 <= n5) {
            n2 = nArray4[n8] <= 8 ? 1 : 2;
            n = (nArray[n8 + 1] - nArray[n8]) / n2;
            if (n < 0) {
                n = 0;
            }
            byArrayArray[n8] = new byte[n][nArray4[n8]];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n) {
                int n12 = n10 < byArray.length ? (byArray[n10] & 0xFF) << 8 : 0;
                n12 |= n10 + 1 < byArray.length ? byArray[n10 + 1] & 0xFF : 0;
                int n13 = 32768;
                int n14 = 0;
                while (n14 < nArray4[n8]) {
                    if ((n12 & n13) != 0) {
                        byArrayArray[n8][n11][n14] = -1;
                    }
                    ++n14;
                    n13 >>= 1;
                }
                ++n11;
                n10 += n2;
            }
            ++n9;
            ++n8;
        }
        BitmapFont bitmapFont = new BitmapFont(n3, 0, n3, 0, n3, n3, 0);
        n9 = 0;
        n2 = 32;
        while (n2 <= n5) {
            n = this.zxcp(n2);
            if (n >= 0) {
                BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArrayArray[n9], -nArray2[n9], nArray4[n9] - nArray2[n9] + n4, n3 - nArray3[n9]);
                bitmapFont.putCharacter(n, bitmapFontGlyph);
            }
            ++n2;
            ++n9;
        }
        bitmapFont.setAscentDescent();
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return this.importFont(byteArrayOutputStream.toByteArray());
    }

    public BitmapFont[] importFont(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        fileInputStream.close();
        BitmapFont[] bitmapFontArray = this.importFont(byteArrayOutputStream.toByteArray());
        if (bitmapFontArray.length > 0) {
            String string = file.getName();
            if (string.toLowerCase().endsWith(".fzx")) {
                string = string.substring(0, string.length() - 4);
            }
            for (BitmapFont bitmapFont : bitmapFontArray) {
                bitmapFont.setName(1, string);
            }
        }
        return bitmapFontArray;
    }

    private int zxcp(int n) {
        if (this.encoding != null) {
            return this.encoding.get(n);
        }
        if (n == 96) {
            return 163;
        }
        if (n == 127) {
            return 169;
        }
        if (n < 128) {
            return n;
        }
        return 61440 + n;
    }
}

