/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos.mover;

import com.kreative.bitsnpicas.geos.GEOSFontFile;
import com.kreative.bitsnpicas.geos.mover.GEOSIconWell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GEOSFontInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GEOSFontFile gff;
    private GEOSIconWell iconWell;
    private JTextField nameField;
    private SpinnerNumberModel idSpinner;
    private JTextField classField;
    private JLabel classLengthLabel;
    private JTextField descriptionField;

    public GEOSFontInfoPanel(GEOSFontFile gEOSFontFile) {
        this.gff = gEOSFontFile;
        this.iconWell = new GEOSIconWell(gEOSFontFile.infoBlock.iconBitmap);
        this.nameField = new JTextField(gEOSFontFile.getFontName());
        this.idSpinner = new SpinnerNumberModel(gEOSFontFile.getFontID(), 0, 1023, 1);
        String string = gEOSFontFile.getClassTextString();
        String string2 = Integer.toString(string.length());
        this.classField = new JTextField(string);
        this.classLengthLabel = new JLabel(string2);
        this.descriptionField = new JTextField(gEOSFontFile.getDescriptionString());
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel.add(new JLabel("Font ID:"));
        jPanel.add(new JLabel("Length:"));
        jPanel.add(new JLabel(" "));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel2.add(new JSpinner(this.idSpinner));
        jPanel2.add(this.classLengthLabel);
        jPanel2.add(new JLabel(" "));
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)jPanel, "Before");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel4.add(new JLabel("Font Name:"));
        jPanel4.add(new JLabel("Class Text:"));
        jPanel4.add(new JLabel("Description:"));
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel5.add(this.nameField);
        jPanel5.add(this.classField);
        jPanel5.add(this.descriptionField);
        JPanel jPanel6 = new JPanel(new BorderLayout(8, 8));
        jPanel6.add((Component)jPanel4, "Before");
        jPanel6.add((Component)jPanel5, "Center");
        JPanel jPanel7 = new JPanel(new BorderLayout(12, 12));
        jPanel7.add((Component)this.iconWell, "Before");
        jPanel7.add((Component)jPanel6, "Center");
        jPanel7.add((Component)jPanel3, "After");
        this.setLayout(new GridLayout());
        this.add(jPanel7);
        this.init();
    }

    private void init() {
        this.iconWell.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((GEOSFontInfoPanel)GEOSFontInfoPanel.this).gff.infoBlock.iconBitmap = GEOSFontInfoPanel.this.iconWell.getIconData();
                GEOSFontInfoPanel.this.fireChangeEvent();
            }
        });
        this.nameField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void documentUpdate(DocumentEvent documentEvent) {
                GEOSFontInfoPanel.this.gff.setFontName(GEOSFontInfoPanel.this.nameField.getText());
                GEOSFontInfoPanel.this.fireChangeEvent();
            }
        });
        this.idSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GEOSFontInfoPanel.this.gff.setFontID(GEOSFontInfoPanel.this.idSpinner.getNumber().intValue());
                GEOSFontInfoPanel.this.fireChangeEvent();
            }
        });
        this.classField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void documentUpdate(DocumentEvent documentEvent) {
                String string = GEOSFontInfoPanel.this.classField.getText();
                String string2 = Integer.toString(string.length());
                GEOSFontInfoPanel.this.gff.setClassTextString(string);
                GEOSFontInfoPanel.this.classLengthLabel.setText(string2);
                GEOSFontInfoPanel.this.fireChangeEvent();
            }
        });
        this.descriptionField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void documentUpdate(DocumentEvent documentEvent) {
                GEOSFontInfoPanel.this.gff.setDescriptionString(GEOSFontInfoPanel.this.descriptionField.getText());
                GEOSFontInfoPanel.this.fireChangeEvent();
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.getChangeListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private static abstract class DocumentAdapter
    implements DocumentListener {
        private DocumentAdapter() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentUpdate(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentUpdate(documentEvent);
        }

        public abstract void documentUpdate(DocumentEvent var1);
    }
}

