/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.CBMConstants;
import com.kreative.bitsnpicas.geos.CBMDirectoryBlock;
import com.kreative.bitsnpicas.geos.GEOSInfoBlock;
import com.kreative.bitsnpicas.geos.VLIRRecordBlock;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConvertFile
implements CBMConstants {
    public CBMDirectoryBlock directoryBlock;
    public GEOSInfoBlock infoBlock;
    public VLIRRecordBlock recordBlock;
    public byte[] sequentialData;
    public List<byte[]> vlirData;

    public ConvertFile() {
        this.clear(128, 0, 0);
    }

    public ConvertFile(int n) {
        this.clear(n, 0, 0);
    }

    public ConvertFile(int n, int n2) {
        this.clear(n, n2, 0);
    }

    public ConvertFile(int n, int n2, int n3) {
        this.clear(n, n2, n3);
    }

    public void clear() {
        this.clear(128, 0, 0);
    }

    public void clear(int n) {
        this.clear(n, 0, 0);
    }

    public void clear(int n, int n2) {
        this.clear(n, n2, 0);
    }

    public void clear(int n, int n2, int n3) {
        this.directoryBlock = new CBMDirectoryBlock();
        this.directoryBlock.cbmFileType = n;
        this.directoryBlock.geosFileType = n2;
        this.directoryBlock.fileStructure = n3;
        if (n2 == 0) {
            this.infoBlock = null;
            this.recordBlock = null;
            this.sequentialData = new byte[0];
            this.vlirData = null;
        } else {
            ++this.directoryBlock.sectorSize;
            this.infoBlock = new GEOSInfoBlock();
            this.infoBlock.cbmFileType = n;
            this.infoBlock.geosFileType = n2;
            this.infoBlock.fileStructure = n3;
            if (n3 == 1) {
                ++this.directoryBlock.sectorSize;
                this.directoryBlock.setCommentString("PRG formatted GEOS file");
                this.recordBlock = new VLIRRecordBlock();
                this.sequentialData = null;
                this.vlirData = new ArrayList<byte[]>();
            } else {
                this.directoryBlock.setCommentString("SEQ formatted GEOS file");
                this.recordBlock = null;
                this.sequentialData = new byte[0];
                this.vlirData = null;
            }
        }
    }

    public void recalculate() {
        this.directoryBlock.sectorSize = 0;
        if (this.directoryBlock.geosFileType == 0) {
            this.directoryBlock.sectorSize += (this.sequentialData.length + 253) / 254;
        } else {
            ++this.directoryBlock.sectorSize;
            if (this.infoBlock.fileStructure == 1) {
                ++this.directoryBlock.sectorSize;
                this.recordBlock.clear();
                for (byte[] byArray : this.vlirData) {
                    VLIRRecordBlock.Entry entry = new VLIRRecordBlock.Entry(byArray.length);
                    this.directoryBlock.sectorSize += entry.sectorCount;
                    this.recordBlock.add(entry);
                }
            } else {
                this.directoryBlock.sectorSize += (this.sequentialData.length + 253) / 254;
            }
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.directoryBlock = new CBMDirectoryBlock();
        this.directoryBlock.read(dataInput);
        if (this.directoryBlock.geosFileType == 0) {
            this.infoBlock = null;
            this.recordBlock = null;
            this.sequentialData = ConvertFile.readRemainder(dataInput);
            this.vlirData = null;
        } else {
            this.infoBlock = new GEOSInfoBlock();
            this.infoBlock.read(dataInput);
            if (this.infoBlock.fileStructure == 1) {
                this.recordBlock = new VLIRRecordBlock();
                this.recordBlock.read(dataInput);
                this.sequentialData = null;
                this.vlirData = new ArrayList<byte[]>();
                int n = 0;
                for (VLIRRecordBlock.Entry entry : this.recordBlock) {
                    byte[] byArray = new byte[entry.length];
                    if (entry.length > 0) {
                        dataInput.readFully(new byte[n]);
                        dataInput.readFully(byArray);
                        n = entry.sectorCount * 254 - entry.length;
                    }
                    this.vlirData.add(byArray);
                }
            } else {
                this.recordBlock = null;
                this.sequentialData = ConvertFile.readRemainder(dataInput);
                this.vlirData = null;
            }
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.directoryBlock.write(dataOutput);
        if (this.directoryBlock.geosFileType == 0) {
            dataOutput.write(this.sequentialData);
        } else {
            this.infoBlock.write(dataOutput);
            if (this.infoBlock.fileStructure == 1) {
                this.recordBlock.write(dataOutput);
                int n = 0;
                for (byte[] byArray : this.vlirData) {
                    if (byArray.length <= 0) continue;
                    dataOutput.write(new byte[n]);
                    dataOutput.write(byArray);
                    int n2 = (byArray.length + 253) / 254;
                    n = n2 * 254 - byArray.length;
                }
            } else {
                dataOutput.write(this.sequentialData);
            }
        }
    }

    private static byte[] readRemainder(DataInput dataInput) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (true) {
                byteArrayOutputStream.write(dataInput.readByte());
            }
        }
        catch (EOFException eOFException) {
            return byteArrayOutputStream.toByteArray();
        }
    }
}

