/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.unicode.data.NameResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphLocator<G extends FontGlyph> {
    private final Font<G> font;
    private final GlyphListModel model;
    private final int index;
    private final Integer codePoint;
    private final String glyphName;

    public GlyphLocator(Font<G> font, GlyphListModel glyphListModel, int n) {
        this.font = font;
        this.model = glyphListModel;
        this.index = n;
        this.codePoint = glyphListModel.isCodePoint(n) ? glyphListModel.getCodePoint(n) : null;
        this.glyphName = glyphListModel.isGlyphName(n) ? glyphListModel.getGlyphName(n) : null;
    }

    public boolean isValid() {
        return this.codePoint != null || this.glyphName != null;
    }

    public G getGlyph() {
        if (this.codePoint != null) {
            return this.font.getCharacter(this.codePoint);
        }
        if (this.glyphName != null) {
            return this.font.getNamedGlyph(this.glyphName);
        }
        return null;
    }

    public G setGlyph(G g) {
        if (this.codePoint != null) {
            return this.font.putCharacter(this.codePoint, g);
        }
        if (this.glyphName != null) {
            return this.font.putNamedGlyph(this.glyphName, g);
        }
        return null;
    }

    public G removeGlyph() {
        if (this.codePoint != null) {
            return this.font.removeCharacter(this.codePoint);
        }
        if (this.glyphName != null) {
            return this.font.removeNamedGlyph(this.glyphName);
        }
        return null;
    }

    public Font<G> getGlyphFont() {
        return this.font;
    }

    public GlyphListModel getGlyphListModel() {
        return this.model;
    }

    public int getGlyphIndex() {
        if (this.model.tracksFont()) {
            if (this.codePoint != null) {
                return this.model.indexOfCodePoint(this.codePoint);
            }
            if (this.glyphName != null) {
                return this.model.indexOfGlyphName(this.glyphName);
            }
            return -1;
        }
        return this.index;
    }

    public boolean isCodePoint() {
        return this.codePoint != null;
    }

    public Integer getCodePoint() {
        return this.codePoint;
    }

    public boolean isGlyphName() {
        return this.glyphName != null;
    }

    public String getGlyphName() {
        return this.glyphName;
    }

    public String toString() {
        if (this.codePoint != null) {
            String string = Integer.toHexString(this.codePoint).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            String string2 = NameResolver.instance(this.codePoint).getName(this.codePoint);
            return "U+" + string + " " + string2 + " from " + this.font.toString();
        }
        if (this.glyphName != null) {
            return this.glyphName + " from " + this.font.toString();
        }
        return "Undefined from " + this.font.toString();
    }

    public GlyphLocator<G> getPrevious() {
        int n = this.getGlyphIndex();
        if (n >= 0) {
            int n2 = this.model.getCellCount();
            for (int i = 0; i < n2; ++i) {
                GlyphLocator<G> glyphLocator;
                if (n <= 0) {
                    n = n2;
                }
                if (!(glyphLocator = new GlyphLocator<G>(this.font, this.model, --n)).isValid()) continue;
                return glyphLocator;
            }
        }
        return null;
    }

    public GlyphLocator<G> getNext() {
        int n = this.getGlyphIndex();
        if (n >= 0) {
            int n2 = this.model.getCellCount();
            for (int i = 0; i < n2; ++i) {
                GlyphLocator<G> glyphLocator;
                if (++n >= n2) {
                    n = 0;
                }
                if (!(glyphLocator = new GlyphLocator<G>(this.font, this.model, n)).isValid()) continue;
                return glyphLocator;
            }
        }
        return null;
    }

    public GlyphLocator<G> getPreviousDefined() {
        int n = this.getGlyphIndex();
        if (n >= 0) {
            int n2 = this.model.getCellCount();
            for (int i = 0; i < n2; ++i) {
                GlyphLocator<G> glyphLocator;
                if (n <= 0) {
                    n = n2;
                }
                if ((glyphLocator = new GlyphLocator<G>(this.font, this.model, --n)).getGlyph() == null) continue;
                return glyphLocator;
            }
        }
        return null;
    }

    public GlyphLocator<G> getNextDefined() {
        int n = this.getGlyphIndex();
        if (n >= 0) {
            int n2 = this.model.getCellCount();
            for (int i = 0; i < n2; ++i) {
                GlyphLocator<G> glyphLocator;
                if (++n >= n2) {
                    n = 0;
                }
                if ((glyphLocator = new GlyphLocator<G>(this.font, this.model, n)).getGlyph() == null) continue;
                return glyphLocator;
            }
        }
        return null;
    }
}

