/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.unicode.data.Block;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListCodePointModel
implements GlyphListModel {
    private final List<Integer> codePoints;
    private final String name;
    private final String url;
    private final String iconGroup;

    public GlyphListCodePointModel(List<Integer> list, String string, String string2, String string3) {
        this.codePoints = list;
        this.name = string;
        this.url = string2;
        this.iconGroup = string3;
    }

    public GlyphListCodePointModel(Block block) {
        this.codePoints = block;
        this.name = block.name;
        if (GlyphListCodePointModel.isPUABlock(block)) {
            this.url = null;
            this.iconGroup = "pua";
        } else {
            String string = Integer.toHexString(block.firstCodePoint).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            this.url = "http://www.unicode.org/charts/PDF/U" + string + ".pdf";
            this.iconGroup = "unicode";
        }
    }

    private static boolean isPUABlock(Block block) {
        if (block.firstCodePoint >= 57344 && block.lastCodePoint <= 63743) {
            return block.firstCodePoint != 57344 || block.lastCodePoint != 63743;
        }
        if (block.firstCodePoint >= 983040 && block.lastCodePoint <= 1048575) {
            return block.firstCodePoint != 983040 || block.lastCodePoint != 1048575;
        }
        if (block.firstCodePoint >= 0x100000 && block.lastCodePoint <= 0x10FFFF) {
            return block.firstCodePoint != 0x100000 || block.lastCodePoint != 0x10FFFF;
        }
        return false;
    }

    @Override
    public boolean isCodePoint(int n) {
        Integer n2 = this.codePoints.get(n);
        return n2 != null && Character.isValidCodePoint(n2);
    }

    @Override
    public Integer getCodePoint(int n) {
        return this.codePoints.get(n);
    }

    @Override
    public int indexOfCodePoint(Integer n) {
        return this.codePoints.indexOf(n);
    }

    @Override
    public boolean tracksFont() {
        return false;
    }

    @Override
    public int getCellCount() {
        return this.codePoints.size();
    }

    @Override
    public boolean isGlyphName(int n) {
        return false;
    }

    @Override
    public String getGlyphName(int n) {
        return null;
    }

    @Override
    public int indexOfGlyphName(String string) {
        return -1;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getIconGroup() {
        return this.iconGroup;
    }

    public boolean equals(Object object) {
        if (object instanceof GlyphListCodePointModel) {
            GlyphListCodePointModel glyphListCodePointModel = (GlyphListCodePointModel)object;
            return this.codePoints.equals(glyphListCodePointModel.codePoints) && this.name.equals(glyphListCodePointModel.name);
        }
        return false;
    }

    public int hashCode() {
        return this.codePoints.hashCode() ^ this.name.hashCode();
    }
}

