/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.GlyphListCodePointModel;
import com.kreative.bitsnpicas.edit.GlyphListListener;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.bitsnpicas.edit.GlyphListSelection;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.Resources;
import com.kreative.unicode.data.Block;
import com.kreative.unicode.data.NameResolver;
import com.kreative.unicode.fontmap.FontMapController;
import com.kreative.unicode.fontmap.FontMapEntry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javax.swing.JComponent;
import javax.swing.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphList<G extends FontGlyph>
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private static final int LABEL_HEIGHT = 18;
    private static final Color SUBTABLE_BG = new Color(0xFFAA00);
    private static final Color SUBTABLE_SELBG = new Color(0xCC7700);
    private final FontMapController fontMap = FontMapController.getInstance();
    private final Font<G> font;
    private int cellSize;
    private int columnCount;
    private int rowCount;
    private boolean antiAlias;
    private boolean bufferedLabels;
    private boolean bufferedGlyphs;
    private Dimension preferredSize;
    private GlyphListModel model;
    private final GlyphListSelection selection;
    private final List<GlyphListListener<G>> listeners;

    public GlyphList(Font<G> font) {
        this.font = font;
        this.cellSize = 36;
        this.columnCount = 16;
        this.rowCount = 8;
        this.antiAlias = CommonMenuItems.IS_MAC_OS;
        this.bufferedLabels = false;
        this.bufferedGlyphs = false;
        this.preferredSize = null;
        this.model = new GlyphListCodePointModel(new Block(0, 127, "Basic Latin"));
        this.selection = new GlyphListSelection();
        this.listeners = new ArrayList<GlyphListListener<G>>();
        MyMouseListener myMouseListener = new MyMouseListener();
        this.addMouseListener(myMouseListener);
        this.addMouseMotionListener(myMouseListener);
        MyKeyListener myKeyListener = new MyKeyListener();
        this.addKeyListener(myKeyListener);
        this.setFocusable(true);
        MyComponentListener myComponentListener = new MyComponentListener();
        this.addComponentListener(myComponentListener);
    }

    public Font<G> getGlyphFont() {
        return this.font;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int n) {
        if (this.cellSize != n && n >= 8) {
            this.cellSize = n;
            this.revalidate();
            this.repaint();
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n) {
        if (this.columnCount != n && n > 0) {
            this.columnCount = n;
            this.revalidate();
            this.repaint();
        }
    }

    public void setBestColumnCount() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = n / this.cellSize;
        if (n2 > 8) {
            n2 &= 0xFFFFFFF8;
        }
        if (this.columnCount != n2 && n2 > 0) {
            this.columnCount = n2;
            this.revalidate();
            this.repaint();
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int n) {
        if (this.rowCount != n && n > 0) {
            this.rowCount = n;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
        this.repaint();
    }

    public boolean getBufferedLabels() {
        return this.bufferedLabels;
    }

    public void setBufferedLabels(boolean bl) {
        this.bufferedLabels = bl;
        this.repaint();
    }

    public boolean getBufferedGlyphs() {
        return this.bufferedGlyphs;
    }

    public void setBufferedGlyphs(boolean bl) {
        this.bufferedGlyphs = bl;
        this.repaint();
    }

    public GlyphListModel getModel() {
        return this.model;
    }

    public void setModel(GlyphListModel glyphListModel) {
        if (this.model != glyphListModel && glyphListModel != null) {
            this.model = glyphListModel;
            this.model.tracksFont();
            this.selection.clear();
            for (GlyphListListener<G> glyphListListener : this.listeners) {
                glyphListListener.selectionChanged(this, this.font);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void clearSelection() {
        this.selection.clear();
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.selectionChanged(this, this.font);
        }
        this.repaint();
    }

    public void selectAll() {
        this.selection.clear();
        this.selection.add(0, this.model.getCellCount() - 1);
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.selectionChanged(this, this.font);
        }
        this.repaint();
    }

    public SortedSet<Integer> getSelectedIndices() {
        return this.selection.toSet();
    }

    public void setSelectedIndices(Collection<Integer> collection, boolean bl) {
        this.selection.clear();
        int n = this.model.getCellCount();
        Iterator<GlyphListListener<G>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Integer object = iterator.next();
            if (object == null || object < 0 || object >= n) continue;
            this.selection.add(object);
        }
        if (bl && (iterator = this.getSelectionRect()) != null) {
            this.scrollRectToVisible((Rectangle)((Object)iterator));
        }
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.selectionChanged(this, this.font);
        }
        this.repaint();
    }

    public List<GlyphLocator<G>> getSelection() {
        ArrayList<GlyphLocator<G>> arrayList = new ArrayList<GlyphLocator<G>>();
        Iterator iterator = this.selection.toSet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            GlyphLocator<G> glyphLocator = new GlyphLocator<G>(this.font, this.model, n);
            if (!glyphLocator.isValid()) continue;
            arrayList.add(glyphLocator);
        }
        return arrayList;
    }

    public void openSelection() {
        if (this.selection.isEmpty()) {
            return;
        }
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.selectionOpened(this, this.font);
        }
    }

    public void deleteSelection() {
        if (this.selection.isEmpty()) {
            return;
        }
        for (GlyphLocator<G> glyphLocator : this.getSelection()) {
            glyphLocator.removeGlyph();
        }
        this.glyphRepertoireChanged();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        int n = (this.model.getCellCount() + this.columnCount - 1) / this.columnCount;
        int n2 = this.cellSize * this.columnCount + 1;
        int n3 = (this.cellSize + 18) * n + 1;
        Insets insets = this.getInsets();
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void addGlyphListListener(GlyphListListener<G> glyphListListener) {
        this.listeners.add(glyphListListener);
    }

    public void removeGlyphListListener(GlyphListListener<G> glyphListListener) {
        this.listeners.remove(glyphListListener);
    }

    public void metricsChanged() {
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.metricsChanged(this, this.font);
        }
        this.repaint();
    }

    public void glyphContentChanged() {
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.glyphsChanged(this, this.font);
        }
        this.repaint();
    }

    public void glyphRepertoireChanged() {
        if (this.model.tracksFont()) {
            this.selection.clear();
        }
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.glyphsChanged(this, this.font);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        SortedSet<Integer> sortedSet = this.selection.toSet();
        Rectangle rectangle = this.getVisibleRect();
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right - 1;
        int n2 = n / this.columnCount + 1;
        BufferedImage bufferedImage = this.bufferedLabels ? new BufferedImage(n2, 18, 2) : null;
        BufferedImage bufferedImage2 = this.bufferedGlyphs ? new BufferedImage(n2, this.cellSize, 2) : null;
        double d2 = this.font.getEmAscent2D();
        double d3 = d2 + this.font.getEmDescent2D();
        double d4 = d = d3 <= 0.0 ? (double)(this.cellSize - 3) / 10.0 : (double)(this.cellSize - 3) / d3;
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d >= 1.0) {
            d = Math.floor(d);
        }
        double d5 = Math.round(((double)(this.cellSize - 3) - d3 * d) / 2.0 + d2 * d + 1.0);
        java.awt.Font font = new java.awt.Font("Monospaced", 0, this.cellSize / 2);
        int n3 = this.model.getCellCount();
        block5: for (int i = 0; i < n3; ++i) {
            boolean bl;
            java.awt.Font font2;
            Object object;
            String string;
            G g;
            int n4 = insets.left + n * (i % this.columnCount) / this.columnCount;
            int n5 = insets.top + (this.cellSize + 18) * (i / this.columnCount);
            int n6 = insets.left + n * (i % this.columnCount + 1) / this.columnCount;
            if (!rectangle.intersects(n4, n5, n6 - n4 + 1, this.cellSize + 18 + 1)) continue;
            if (this.model.isCodePoint(i)) {
                int n7 = this.model.getCodePoint(i);
                g = this.font.getCharacter(n7);
                string = this.getCharacterLabel(n7);
                if (string.length() < 4) {
                    object = this.fontMap.entryForCodePoint(n7);
                    font2 = object != null ? ((FontMapEntry)object).getFont() : graphics.getFont();
                    bl = this.antiAlias;
                } else {
                    font2 = Resources.HEX_FONT != null ? Resources.HEX_FONT : graphics.getFont();
                    bl = Resources.HEX_FONT != null ? false : this.antiAlias;
                }
            } else if (this.model.isGlyphName(i)) {
                string = this.model.getGlyphName(i);
                g = this.font.getNamedGlyph(string);
                font2 = Resources.PSNAME_FONT != null ? Resources.PSNAME_FONT : graphics.getFont();
                bl = Resources.PSNAME_FONT != null ? false : this.antiAlias;
            } else {
                String string2;
                Color color;
                Color color2;
                Integer n8 = this.model.getCodePoint(i);
                if (n8 == null) continue;
                switch (n8) {
                    case -54506: {
                        object = Color.gray;
                        color2 = Color.lightGray;
                        color = Color.black;
                        string = "Sequence";
                        string2 = Integer.toHexString(0xFF00 | i).substring(2).toUpperCase();
                        break;
                    }
                    case -57683: {
                        object = SUBTABLE_SELBG;
                        color2 = SUBTABLE_BG;
                        color = Color.black;
                        string = "Subtable";
                        string2 = Integer.toHexString(0xFF00 | i).substring(2).toUpperCase();
                        break;
                    }
                    case -17711: {
                        object = Color.black;
                        color2 = Color.darkGray;
                        color = Color.white;
                        string = "Undefined";
                        string2 = Integer.toHexString(0xFF00 | i).substring(2).toUpperCase();
                        break;
                    }
                    default: {
                        int n9 = n8 >>> 16;
                        int n10 = n8 & 0xFFFF;
                        if (n9 < 32 || n9 > 65533 || n10 < 32 || n10 > 65533) continue block5;
                        String string3 = Integer.toHexString(0xFF0000 | n9).substring(2).toUpperCase();
                        String string4 = Integer.toHexString(0xFF0000 | n10).substring(2).toUpperCase();
                        object = Color.gray;
                        color2 = Color.lightGray;
                        color = Color.black;
                        string = string3 + "." + string4;
                        string2 = String.valueOf(new char[]{(char)n9, (char)n10});
                    }
                }
                font2 = Resources.PSNAME_FONT != null ? Resources.PSNAME_FONT : graphics.getFont();
                bl = Resources.PSNAME_FONT != null ? false : this.antiAlias;
                this.paintCellBackground(graphics, color2, n4, n6, n5);
                this.paintCellLabel(graphics, color2, color, string, font2, bl, n4, n6, n5, bufferedImage);
                this.paintCellMarker(graphics, (Color)(sortedSet.contains(i) ? object : color2), color, string2, font, this.antiAlias, n4, n6, n5, bufferedImage2);
                continue;
            }
            this.paintCellBackground(graphics, Color.gray, n4, n6, n5);
            this.paintCellLabel(graphics, SystemColor.text, SystemColor.textText, string, font2, bl, n4, n6, n5, bufferedImage);
            this.paintCellGlyph(graphics, (FontGlyph)g, sortedSet.contains(i), n4, n6, n5, bufferedImage2, d5, d);
        }
    }

    private void paintCellBackground(Graphics graphics, Color color, int n, int n2, int n3) {
        graphics.setColor(Color.black);
        graphics.fillRect(n, n3, n2 - n + 1, this.cellSize + 18 + 1);
        graphics.setColor(color);
        graphics.fillRect(n + 1, n3 + 1, n2 - n - 1, this.cellSize + 18 - 1);
    }

    private void paintCellLabel(Graphics graphics, Color color, Color color2, String string, java.awt.Font font, boolean bl, int n, int n2, int n3, BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setColor(color2);
            graphics2D.setFont(font);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string);
            if (font == Resources.PSNAME_FONT) {
                --n4;
            }
            int n5 = (n2 - n - 1 - n4) / 2;
            int n6 = (18 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(string, n5, n6);
            graphics2D.dispose();
            graphics.drawImage(bufferedImage, n + 1, n3 + 1, n2, n3 + 18, 0, 0, n2 - n - 1, 17, null);
        } else {
            java.awt.Font font2 = graphics.getFont();
            Shape shape = graphics.getClip();
            graphics.setColor(color);
            graphics.fillRect(n + 1, n3 + 1, n2 - n - 1, 17);
            graphics.clipRect(n + 1, n3 + 1, n2 - n - 1, 17);
            graphics.setColor(color2);
            graphics.setFont(font);
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = fontMetrics.stringWidth(string);
            if (font == Resources.PSNAME_FONT) {
                --n7;
            }
            int n8 = (n2 - n - 1 - n7) / 2;
            int n9 = (18 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics.drawString(string, n + 1 + n8, n3 + 1 + n9);
            graphics.setFont(font2);
            graphics.setClip(shape);
        }
    }

    private void paintCellGlyph(Graphics graphics, FontGlyph fontGlyph, boolean bl, int n, int n2, int n3, BufferedImage bufferedImage, double d, double d2) {
        if (fontGlyph == null) {
            graphics.setColor(bl ? SystemColor.textHighlight : SystemColor.text);
            graphics.fillRect(n + 1, n3 + 18 + 1, n2 - n - 1, this.cellSize - 1);
            graphics.setColor(Color.gray);
            graphics.drawLine(n + 1, n3 + 18 + 1, n2 - 1, n3 + this.cellSize + 18 - 1);
            graphics.drawLine(n2 - 1, n3 + 18 + 1, n + 1, n3 + this.cellSize + 18 - 1);
        } else if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(bl ? SystemColor.textHighlight : SystemColor.text);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setColor(bl ? SystemColor.textHighlightText : SystemColor.textText);
            double d3 = Math.round(((double)(n2 - n - 2) - fontGlyph.getCharacterWidth2D() * d2) / 2.0);
            fontGlyph.paint(graphics2D, d3, d, d2);
            graphics2D.dispose();
            graphics.drawImage(bufferedImage, n + 1, n3 + 18 + 1, n2, n3 + 18 + this.cellSize, 0, 0, n2 - n - 1, this.cellSize - 1, null);
        } else {
            Shape shape = graphics.getClip();
            graphics.setColor(bl ? SystemColor.textHighlight : SystemColor.text);
            graphics.fillRect(n + 1, n3 + 18 + 1, n2 - n - 1, this.cellSize - 1);
            graphics.clipRect(n + 1, n3 + 18 + 1, n2 - n - 1, this.cellSize - 1);
            graphics.setColor(bl ? SystemColor.textHighlightText : SystemColor.textText);
            double d4 = Math.round(((double)(n2 - n - 2) - fontGlyph.getCharacterWidth2D() * d2) / 2.0);
            fontGlyph.paint(graphics, (double)(n + 1) + d4, (double)(n3 + 18 + 1) + d, d2);
            graphics.setClip(shape);
        }
    }

    private void paintCellMarker(Graphics graphics, Color color, Color color2, String string, java.awt.Font font, boolean bl, int n, int n2, int n3, BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setColor(color2);
            graphics2D.setFont(font);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = (n2 - n - 1 - fontMetrics.stringWidth(string)) / 2;
            int n5 = (this.cellSize - 3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(string, n4, n5);
            graphics.drawImage(bufferedImage, n + 1, n3 + 18 + 1, n2, n3 + 18 + this.cellSize, 0, 0, n2 - n - 1, this.cellSize - 1, null);
        } else {
            java.awt.Font font2 = graphics.getFont();
            Shape shape = graphics.getClip();
            graphics.setColor(color);
            graphics.fillRect(n + 1, n3 + 18 + 1, n2 - n - 1, this.cellSize - 1);
            graphics.clipRect(n + 1, n3 + 18 + 1, n2 - n - 1, this.cellSize - 1);
            graphics.setColor(color2);
            graphics.setFont(font);
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = (n2 - n - 1 - fontMetrics.stringWidth(string)) / 2;
            int n7 = (this.cellSize - 3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics.drawString(string, n + 1 + n6, n3 + 18 + 1 + n7);
            graphics.setFont(font2);
            graphics.setClip(shape);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        int n = this.cellSize * this.columnCount + 1;
        int n2 = (this.cellSize + 18) * this.rowCount + 1;
        Insets insets = this.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.cellSize + 18;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return rectangle.height / (this.cellSize + 18) * (this.cellSize + 18);
    }

    private String getCharacterLabel(int n) {
        String string = NameResolver.instance(n).getCategory(n);
        if ("Zs Zl Zp Cc Cf Cs Cn".contains(string)) {
            String string2 = Integer.toHexString(n).toUpperCase();
            while (string2.length() < 4) {
                string2 = "0" + string2;
            }
            return string2;
        }
        return String.valueOf(Character.toChars(n));
    }

    private Rectangle getSelectionRect() {
        SortedSet<Integer> sortedSet = this.selection.toSet();
        if (sortedSet.isEmpty()) {
            return null;
        }
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right - 1;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            int n7 = insets.left + n * (n6 % this.columnCount) / this.columnCount;
            int n8 = insets.left + n * (n6 % this.columnCount + 1) / this.columnCount;
            int n9 = insets.top + (this.cellSize + 18) * (n6 / this.columnCount);
            int n10 = n9 + this.cellSize + 18;
            if (n7 < n2) {
                n2 = n7;
            }
            if (n9 < n3) {
                n3 = n9;
            }
            if (n8 > n4) {
                n4 = n8;
            }
            if (n10 <= n5) continue;
            n5 = n10;
        }
        return new Rectangle(n2, n3, n4 - n2 + 1, n5 - n3 + 1);
    }

    private Rectangle getLastSelectionRect() {
        int n = this.selection.getLast();
        if (n < 0) {
            return null;
        }
        Insets insets = this.getInsets();
        int n2 = this.getWidth() - insets.left - insets.right - 1;
        int n3 = insets.left + n2 * (n % this.columnCount) / this.columnCount;
        int n4 = insets.left + n2 * (n % this.columnCount + 1) / this.columnCount;
        int n5 = insets.top + (this.cellSize + 18) * (n / this.columnCount);
        int n6 = n5 + this.cellSize + 18;
        return new Rectangle(n3, n5, n4 - n3 + 1, n6 - n5 + 1);
    }

    private void startSelection(InputEvent inputEvent, int n) {
        if (inputEvent.isShiftDown()) {
            this.selection.extend(n);
        } else if (inputEvent.isControlDown() || inputEvent.isMetaDown()) {
            this.selection.add(n);
        } else {
            this.selection.clear();
            this.selection.add(n);
        }
        Rectangle rectangle = this.getLastSelectionRect();
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.selectionChanged(this, this.font);
        }
        this.repaint();
    }

    private void continueSelection(InputEvent inputEvent, int n) {
        this.selection.extend(n);
        Rectangle rectangle = this.getLastSelectionRect();
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
        for (GlyphListListener<G> glyphListListener : this.listeners) {
            glyphListListener.selectionChanged(this, this.font);
        }
        this.repaint();
    }

    private class MyComponentListener
    extends ComponentAdapter {
        private MyComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            GlyphList.this.setBestColumnCount();
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if ((keyEvent.isMetaDown() || keyEvent.isControlDown()) && keyEvent.isShiftDown()) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 12: 
                case 27: {
                    GlyphList.this.clearSelection();
                    break;
                }
                case 37: {
                    if (GlyphList.this.selection.isEmpty()) break;
                    int n = GlyphList.this.selection.getLast() - 1;
                    if (n < 0) {
                        n = 0;
                    }
                    if (n >= GlyphList.this.model.getCellCount()) {
                        n = GlyphList.this.model.getCellCount() - 1;
                    }
                    GlyphList.this.startSelection(keyEvent, n);
                    break;
                }
                case 39: {
                    if (GlyphList.this.selection.isEmpty()) break;
                    int n = GlyphList.this.selection.getLast() + 1;
                    if (n < 0) {
                        n = 0;
                    }
                    if (n >= GlyphList.this.model.getCellCount()) {
                        n = GlyphList.this.model.getCellCount() - 1;
                    }
                    GlyphList.this.startSelection(keyEvent, n);
                    break;
                }
                case 38: {
                    if (GlyphList.this.selection.isEmpty()) break;
                    int n = GlyphList.this.selection.getLast() - GlyphList.this.columnCount;
                    if (n < 0) {
                        n = 0;
                    }
                    if (n >= GlyphList.this.model.getCellCount()) {
                        n = GlyphList.this.model.getCellCount() - 1;
                    }
                    GlyphList.this.startSelection(keyEvent, n);
                    break;
                }
                case 40: {
                    if (GlyphList.this.selection.isEmpty()) break;
                    int n = GlyphList.this.selection.getLast() + GlyphList.this.columnCount;
                    if (n < 0) {
                        n = 0;
                    }
                    if (n >= GlyphList.this.model.getCellCount()) {
                        n = GlyphList.this.model.getCellCount() - 1;
                    }
                    GlyphList.this.startSelection(keyEvent, n);
                    break;
                }
                case 36: {
                    GlyphList.this.startSelection(keyEvent, 0);
                    break;
                }
                case 35: {
                    GlyphList.this.startSelection(keyEvent, GlyphList.this.model.getCellCount() - 1);
                    break;
                }
                case 10: {
                    GlyphList.this.openSelection();
                    break;
                }
                case 127: {
                    GlyphList.this.deleteSelection();
                    break;
                }
                case 155: {
                    GlyphList.this.setAntiAlias(!GlyphList.this.antiAlias);
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            if (keyEvent.isMetaDown() || keyEvent.isControlDown()) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if ((c >= ' ' && c < '\u007f' || c >= '\u00a0') && (n = GlyphList.this.model.indexOfCodePoint(Integer.valueOf(c))) >= 0) {
                GlyphList.this.selection.clear();
                GlyphList.this.selection.add(n);
                Rectangle rectangle = GlyphList.this.getLastSelectionRect();
                if (rectangle != null) {
                    GlyphList.this.scrollRectToVisible(rectangle);
                }
                for (GlyphListListener glyphListListener : GlyphList.this.listeners) {
                    glyphListListener.selectionChanged(GlyphList.this, GlyphList.this.font);
                }
                GlyphList.this.repaint();
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GlyphList.this.requestFocusInWindow();
            int n = this.getClickedIndex(mouseEvent);
            GlyphList.this.startSelection(mouseEvent, n);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.getClickedIndex(mouseEvent);
            GlyphList.this.continueSelection(mouseEvent, n);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = this.getClickedIndex(mouseEvent);
            GlyphList.this.continueSelection(mouseEvent, n);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                GlyphList.this.openSelection();
            }
        }

        private int getClickedIndex(MouseEvent mouseEvent) {
            int n;
            int n2;
            Insets insets = GlyphList.this.getInsets();
            int n3 = GlyphList.this.getWidth() - insets.left - insets.right;
            int n4 = (mouseEvent.getX() - insets.left) * GlyphList.this.columnCount / n3;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 >= GlyphList.this.columnCount) {
                n4 = GlyphList.this.columnCount - 1;
            }
            if ((n2 = (n = (mouseEvent.getY() - insets.top) / (GlyphList.this.cellSize + 18)) * GlyphList.this.columnCount + n4) < 0) {
                n2 = 0;
            }
            if (n2 >= GlyphList.this.model.getCellCount()) {
                n2 = GlyphList.this.model.getCellCount() - 1;
            }
            return n2;
        }
    }
}

