/*
 *                           TERMS AND CONDITIONS
 *                                   FOR
 *                         OPEN SOURCE CODE LICENSE
 *                               Version 1.1
 * 
 * Japan Registry Services Co., Ltd. ("JPRS"), a Japanese corporation
 * having its head office at Chiyoda First Bldg. East 13F 3-8-1 Nishi-Kanda,
 * Chiyoda-ku, Tokyo 101-0065, Japan, grants you the license for open source
 * code specified in EXHIBIT A the "Code" subject to the following Terms and
 * Conditions ("OSCL").
 * 
 * 1. License Grant.
 *   JPRS hereby grants you a worldwide, royalty-free, non-exclusive
 *   license, subject to third party intellectual property claims:
 *   (a) under intellectual property rights (other than patent or
 *       trademark) licensable by JPRS to use, reproduce, modify, display,
 *       perform, sublicense and distribute the Code (or portions thereof)
 *       with or without modifications, and/or as part of a derivative work;
 *       or
 *   (b) under claims of the infringement through the making, using,
 *       offering to sell and/or otherwise disposing the JPRS Revised Code
 *       (or portions thereof);
 *   (c) the licenses granted in this Section 1(a) and (b) are effective on
 *       the date JPRS first distributes the Code to you under the terms of
 *       this OSCL;
 *   (d) Notwithstanding the above stated terms, no patent license is
 *       granted:
 *       1)  for a code that you delete from the Code;
 *       2)  separate from the Code; or
 *       3)  for infringements caused by:
 *            i) modification of the Code; or
 *           ii) combination of the Code with other software or devices.
 * 
 * 2. Consents.
 *   You agree that:
 *   (a) you must include a copy of this OSCL and the notice set forth in
 *       EXHIBIT A with every copy of the Code you distribute;
 *   (b) you must include a copy of this OSCL and the notice set forth in
 *       EXHIBIT A with every copy of binary form of the Code in the
 *       documentation and/or other materials provided with the distribution;
 *   (c) you may not offer or impose any terms on any source code version
 *       that alters or restricts the applicable version of this OSCL or
 *       the recipients' rights hereunder.
 *   (d) If the terms and conditions are set forth in EXHIBIT A, you must
 *       comply with those terms and conditions.
 * 
 * 3. Proprietary Information.
 *   All trademarks, service marks, patents, copyrights, trade secrets, and
 *   other proprietary rights in or related to the Code are and will remain
 *   the exclusive property of JPRS or its licensors, whether or not
 *   specifically recognized or perfected under local law except specified
 *   in this OSCL; provided however you agree and understand that the JPRS
 *   name may not be used to endorse or promote this Code without prior
 *   written approval of JPRS.
 * 
 * 4. WARRANTY DISCLAIMER.
 *   JPRS MAKES NO REPRESENTATIONS AND WARRANTIES REGARDING THE USE OF THE
 *   CODE, NOR DOES JPRS MAKE ANY REPRESENTATIONS THAT THE CODE WILL BECOME
 *   COMMERCIALLY AVAILABLE. JPRS, ITS AFFILIATES, AND ITS SUPPLIERS DO NOT
 *   WARRANT OR REPRESENT THAT THE CODE IS FREE OF ERRORS OR THAT THE CODE
 *   IS SUITABLE FOR TRANSLATION AND/OR LOCALIZATION. THE CODE IS PROVIDED
 *   ON AN "AS IS" BASIS AND JPRS AND ITS SUPPLIERS HAVE NO OBLIGATION TO
 *   CORRECT ERRORS OR TO SUPPORT THE CODE UNDER THIS OSCL FOR ANY REASON.
 *   TO THE FULL EXTENT PERMITTED BY LAW, ALL OBLIGATIONS ARE HEREBY
 *   EXCLUDED WHETHER EXPRESS, STATUTORY OR IMPLIED UNDER LAW, COURSE OF
 *   DEALING, CUSTOM, TRADE USAGE, ORAL OR WRITTEN STATEMENT OR OTHERWISE,
 *   INCLUDING BUT NOT LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
 *   OR FITNESS FOR A PARTICULAR PURPOSE CONCERNING THE CODE.
 * 
 * 5. NO LIABILITY.
 *   UNDER NO CIRCUMSTANCES SHALL JPRS AND/OR ITS AFFILIATES, LICENSORS, OR
 *   REPRESENTATIVES BE LIABLE FOR ANY DAMAGES INCLUDING BUT NOT LIMITED TO
 *   CONSEQUENTIAL, INDIRECT, SPECIAL, PUNITIVE OR INCIDENTAL DAMAGES,
 *   WHETHER FORESEEABLE OR UNFORESEEABLE, BASED ON YOUR CLAIMS, INCLUDING,
 *   BUT NOT LIMITED TO, CLAIMS FOR LOSS OF DATA, GOODWILL, PROFITS, USE OF
 *   MONEY, INTERRUPTION IN USE OR AVAILABILITY OF DATA, STOPPAGE, IMPLIED
 *   WARRANTY, BREACH OF CONTRACT, MISREPRESENTATION, NEGLIGENCE, STRICT
 *   LIABILITY IN TORT, OR OTHERWISE.
 * 
 * 6. Indemnification.
 *   You hereby agree to indemnify, defend, and hold harmless JPRS for any
 *   liability incurred by JRPS due to your terms of warranty, support,
 *   indemnity, or liability offered by you to any third party.
 * 
 * 7. Termination.
 * 7.1 This OSCL shall be automatically terminated in the events that:
 *   (a) You fail to comply with the terms herein and fail to cure such
 *       breach within 30 days of becoming aware of the breach;
 *   (b) You initiate patent or copyright infringement litigation against
 *       any party (including a cross-claim or counterclaim in a lawsuit)
 *       alleging that the Code constitutes a direct or indirect patent or
 *       copyright infringement, in such case, this OSCL to you shall
 *       terminate as of the date such litigation is filed;
 * 7.2 In the event of termination under Sections 7.1(a) or 7.1(b) above,
 *     all end user license agreements (excluding distributors and
 *     resellers) which have been validly granted by You or any distributor
 *     hereunder prior to termination shall survive termination.
 *
 * 
 * 8. General.
 *   This OSCL shall be governed by, and construed and enforced in
 *   accordance with, the laws of Japan. Any litigation or arbitration
 *   between the parties shall be conducted exclusively in Tokyo, Japan
 *   except written consent of JPRS provides other venue.
 * 
 * 
 *                                EXHIBIT A
 * 
 * The original open source code of idnkit-2 is idnkit-1.0 developed and
 * conceived by Japan Network Information Center ("JPNIC"), a Japanese
 * association, Kokusai-Kougyou-Kanda Bldg 6F, 2-3-4 Uchi-Kanda,
 * Chiyoda-ku, Tokyo 101-0047, Japan, and JPRS modifies above original code
 * under following Terms and Conditions set forth by JPNIC.
 * 
 *                                  JPNIC
 * 
 * Copyright (c) 2000-2002 Japan Network Information Center.  All rights reserved.
 * 
 * By using this file, you agree to the terms and conditions set forth bellow.
 * 
 *                       LICENSE TERMS AND CONDITIONS
 * 
 * The following License Terms and Conditions apply, unless a different
 * license is obtained from Japan Network Information Center ("JPNIC"),
 * a Japanese association, Kokusai-Kougyou-Kanda Bldg 6F, 2-3-4 Uchi-Kanda,
 * Chiyoda-ku, Tokyo 101-0047, Japan.
 * 
 * 1. Use, Modification and Redistribution (including distribution of any
 *    modified or derived work) in source and/or binary forms is permitted
 *    under this License Terms and Conditions.
 * 
 * 2. Redistribution of source code must retain the copyright notices as they
 *    appear in each source code file, this License Terms and Conditions.
 * 
 * 3. Redistribution in binary form must reproduce the Copyright Notice,
 *    this License Terms and Conditions, in the documentation and/or other
 *    materials provided with the distribution. For the purposes of binary
 *    distribution the "Copyright Notice" refers to the following language:
 *    "Copyright (c) 2000-2002 Japan Network Information Center.  All rights reserved."
 * 
 * 4. The name of JPNIC may not be used to endorse or promote products
 *    derived from this Software without specific prior written approval of
 *    JPNIC.
 * 
 * 5. Disclaimer/Limitation of Liability: THIS SOFTWARE IS PROVIDED BY JPNIC
 *    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 *    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JPNIC BE LIABLE
 *    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *    OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * 
 *                        JPRS Public License Notice
 *                                   For
 *                                idnkit-2.
 * 
 * The contents of this file are subject to the Terms and Conditions for
 * the Open Source Code License (the "OSCL"). You may not use this file
 * except in compliance with above terms and conditions. A copy of the OSCL
 * is available at <http://jprs.co.jp/idn/>.
 * The JPRS Revised Code is idnkit-2.
 * The Initial Developer of the JPRS Revised Code is Japan Network
 * Information Center ("JPNIC"), a Japanese association,
 * Kokusai-Kougyou-Kanda Bldg 6F, 2-3-4 Uchi-Kanda, Chiyoda-ku, Tokyo
 * 101-0047, Japan.
 * "Copyright (c) 2000-2002 Japan Network Information Center.  All rights reserved."
 * "Copyright (c) 2010-2012 Japan Registry Services Co., Ltd.  All rights reserved."
 * Contributor(s): ______________________________________.
 * 
 * If you wish to allow use of your version of this file only under the
 * above License(s) and not to allow others to use your version of this
 * file, please indicate your decision by deleting the relevant provisions
 * above and replacing them with the notice and other provisions required
 * by the above License(s). If you do not delete the relevant provisions,
 * a recipient may use your version of this file under either the above
 * License(s).
 */

/*
 * Configuration context APIs of libidnkit.
 *
 * All the functions provided by this module requires a configuration
 * context of type 'idn_resconf_t' as an argument. The context holds
 * information described in the configuration file (idn.conf).
 * See 'resconf' module for details.
 */

#ifndef IDN_RESCONF_H
#define IDN_RESCONF_H 1

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include <idn/result.h>
#include <idn/export.h>

/*
 * Type for a resconf object.
 */
typedef struct idn_resconf *idn_resconf_t;

/*
 * Mapping names.
 */
#define IDN_RESCONF_NFCMAP_NAME			"nfc"
#define IDN_RESCONF_NFKCMAP_NAME		"nfkc"
#define IDN_RESCONF_NFDMAP_NAME			"nfd"
#define IDN_RESCONF_NFKDMAP_NAME		"nfkd"
#define IDN_RESCONF_LOWERCASEMAP_NAME		"lowercase"
#define IDN_RESCONF_DELIMITERMAP_NAME		"delimitermap"
#define IDN_RESCONF_WIDTHMAP_NAME		"width"
#define IDN_RESCONF_TR46MAP_NAME		"tr46-map"
#define IDN_RESCONF_TR46DEVIATIONMAP_NAME	"tr46-map-deviation"
#define IDN_RESCONF_TR46CHECK_NAME		"tr46-check"
#define IDN_RESCONF_TR46DEVIATIONCHECK_NAME	"tr46-check-deviation"
#define IDN_RESCONF_LANGLOCALMAP_NAME		"language-local"
#define IDN_RESCONF_TLDLOCALMAP_NAME		"tld-local"

#define IDN_RESCONF_RESMANIDNA2008MAP_NAME	  "resman-idna2008-mappings-01"
#define IDN_RESCONF_RFC5895_NAME	  	  "rfc5895"
#define IDN_RESCONF_TR46PROCESSING_NAME		  "tr46-processing"
#define IDN_RESCONF_TR46DEVIATIONPROCESSING_NAME  "tr46-processing-deviation"

/*
 * Initialize the module.
 *
 * It must be called before any other functions of this module.
 *
 * Returns:
 *	idn_success		-- ok.
 *	idn_nomemory		-- malloc failed.
 */
IDN_EXPORT idn_result_t
idn_resconf_initialize(void);

/*
 * Create a configuration context.
 * Create an empty context and store it in '*ctxp'.
 *
 * Returns:
 *	idn_success		-- ok.
 *	idn_nomemory		-- malloc failed.
 */
IDN_EXPORT idn_result_t
idn_resconf_create(idn_resconf_t *ctxp);

/*
 * Destroy the configuration context.
 *
 * Destroy the configuration context created by 'idn_resconf_create',
 * and release memory for it.
 */
IDN_EXPORT void
idn_resconf_destroy(idn_resconf_t ctx);

/*
 * Set the default configurations to the resconf context.
 *
 * "default configurations" means loading an empty configuration file.
 * Note that the function resets the context and then sets the default
 * configuration.
 * 
 * Returns:
 *	idn_success		-- ok.
 *	idn_invalid_syntax	-- syntax error found.
 *	idn_invalid_name	-- invalid encoding/nomalization name is
 *				   specified.
 *	idn_nomemory		-- malloc failed.
 */
IDN_EXPORT idn_result_t
idn_resconf_setdefaults(idn_resconf_t ctx);

/*
 * Get the pathname of the default configuration file.
 *
 * Returns:
 *	the pathname of the default configuration file.
 */
IDN_EXPORT char *
idn_resconf_defaultfile(void);

/*
 * Get the local encoding name.
 */
IDN_EXPORT const char *
idn_resconf_getlocalencoding(idn_resconf_t ctx);

/*
 * Set the local encoding name.
 */
IDN_EXPORT idn_result_t
idn_resconf_setlocalencoding(idn_resconf_t ctx, const char *name);

/*
 * Get the current language.
 */
IDN_EXPORT const char *
idn_resconf_getlanguage(idn_resconf_t ctx);

/*
 * Set the current language.
 */
IDN_EXPORT idn_result_t
idn_resconf_setlanguage(idn_resconf_t ctx, const char *name);

/*
 * Get flags to the local-converter. 
 */
IDN_EXPORT int
idn_resconf_getlocalconverterflags(idn_resconf_t ctx);

/*
 * Set flags to the local-converter. 
 */
IDN_EXPORT void
idn_resconf_setocalconverterflags(idn_resconf_t ctx, int flags);

/*
 * Set the localcheck file.
 */
IDN_EXPORT idn_result_t
idn_resconf_setlocalcheckfile(idn_resconf_t ctx, const char *file);

/*
 * Load a configuration file.
 *
 * Parse a configuration file whose name is specified by 'file'.
 * Its result is stored in 'ctx'. If 'file' is NULL, the default file
 * is loaded.
 *
 * Returns:
 *	idn_success		-- ok.
 *	idn_nofile		-- couldn't open specified file.
 *	idn_invalid_syntax	-- syntax error found.
 *	idn_invalid_name	-- invalid encoding/nomalization name is
 *				   specified.
 *	idn_nomemory		-- malloc failed.
 */
IDN_EXPORT idn_result_t
idn_resconf_loadfile(idn_resconf_t ctx, const char *file);

/*
 * Load a configuration from an array of strings.
 */
IDN_EXPORT idn_result_t
idn_resconf_loadstrings(idn_resconf_t ctx, char *strings[]);

#ifdef __cplusplus
}
#endif

#endif /* IDN_RESCONF_H */
