//////////////////////////////////////////////////////////////////////////////
//
// 		  Copyright (C) 1996,1997  Matthew Doar  doar@pobox.com
// 
// Permission to use, copy, and distribute this software and its documentation 
// for any purpose with or without fee is hereby granted, provided that the 
// above copyright notice appears with all copies and that both that copyright 
// notice and this permission notice appear in supporting documentation. 
// 
// Permission to modify the software is granted, but not the right to 
// distribute the modified code. Modifications are to be distributed as 
// patches to the released version. 
// 
// This software is provided "as is" without express or implied warranty. 
//
//////////////////////////////////////////////////////////////////////////////

// tiers_output.cc

#include <iostream.h>
#ifndef _TIERS_HH
#include "tiers.hh"
#endif


////////////////////////////////////////////////////////////////////////
// Model:OutputParams
//
// Output all the parameters and details needed to reconstruct the model
////////////////////////////////////////////////////////////////////////
bool
Model::OutputParams()
{
  bool ret = true;
  
  if (TIERS_VERBOSE)
	{
	  // output the parameters used to create this network
	  cout << "#" << endl 
		   << "# Parameters for Network Model\tModelId: " << ModelId << endl 
		   << "# ============================ " << endl 
		   << "#" << endl
		   << "# Value\tParameter" << endl
		   << "# -----\t---------" << endl 
		   << "#" << endl 
		   << "# " << NW << "\tNW: number of WANs" << endl
		   << "# " << NM << "\tNM: number of MANs per WAN" << endl
		   << "# " << NL << "\tNL: number of LANs per MAN" << endl
		   << "# " << SW << "\tSW: number of nodes per WAN" << endl
		   << "# " << SM << "\tSM: number of nodes per MAN" << endl
		   << "# " << SL << "\tSL: number of nodes per LAN" << endl
		   << "# " << RW << "\tRW: intranetwork redundancy for WAN" << endl
		   << "# " << RM << "\tRM: intranetwork redundancy for MANs" << endl
		   << "# " << RL << "\tRL: intranetwork redundancy for LANs" << endl
		   << "# " << RMW << "\tRMW: internetwork redundancy for MAN to WAN" << endl
		   << "# " << RLM << "\tRLM: internetwork redundancy for LAN to MAN" << endl
		   << "#" << endl
		   << "# " << GRID << "\t Grid size (square)" << endl
		   << "# " << WAN_SCALE << "\t Grid unit for WAN" << endl
		   << "# " << MAN_SCALE << "\t Grid unit for MAN" << endl
		   << "# " << LAN_SCALE << "\t Grid unit for LAN" << endl
		   << "#" << endl
		   << "# " << PROXIMITY_TEST_WAN << "\t Proximity test for WAN (0 is inactive)" << endl 
		   << "# " << PROXIMITY_TEST_MAN << "\t Proximity test for MAN (0 is inactive)" << endl 
		   << "# " << PROXIMITY_TEST_LAN << "\t Proximity test for LAN (0 is inactive)" << endl << "#" << endl
		   << "# " << REMOVE_DUP_EDGES << "\t Edge list is directed (0) or undirected (1)" << endl;

	  unsigned long int TotalNumNodes = SW + (NM*SM) + (NM*NL*SL);
	  cout << "# Total Number of Nodes (derived) : " << TotalNumNodes << endl;

	  // output the Cost Table used for this network
	  cout << "#" << endl << "# Edge Metrics" << endl 
		   << "# ------------" << endl
		   << "#" << endl << "# From\tTo\tBand-\tFixed\tDelay/Unit" << endl
		   << "# Type\tType\twidth\tDelay\tDistance" << endl
		   << "# ------------------------------------------" << endl;

	  for (unsigned int i = 0; i < 3; i++)
		{
		  for (unsigned int j = 0; j < 3; j++)
			{
			  unsigned int index = i*3+j;
			  cout 
				<< "# " << i << "\t" << j << "\t"
				<< theCostTable[index].bw << "\t"
				<< theCostTable[index].d1 << "\t"
				<< theCostTable[index].d2 << "\t"
				<< endl;
			}
		}

	} // ifdef

  return ret;
}




////////////////////////////////////////////////////////////////////////
// Model:OutputNodes
//
// Output all the nodes in the graph
////////////////////////////////////////////////////////////////////////
bool
Model::OutputNodes()
{
  bool ret = true;
  unsigned long int i = 0;
  unsigned long int j = 0;
  
  if (TIERS_VERBOSE)
	{
	  cout << "#" << endl
		   << "# NODES" << endl
		   << "# =====" << endl 
		   << "#" << endl
		   << "# Node\tX\tY\tType (0 = WAN, 1 = MAN, 2 = LAN)" << endl
		   << "# ------------------------------------" << endl;

	}

  // WAN
  for (i = 0; i < 1 /* NW should equal 1 */; i++)
	{
	  for (j = 0; j < WanList[i].NumNodes(); j++)
		{
		  cout << ((WanList[i]).nodes[j]).number << "\t" 
			<< (((WanList[i]).nodes[j]).x)*WAN_SCALE << "\t" 
			<< (((WanList[i]).nodes[j]).y)*WAN_SCALE << "\t" 
			<< ((WanList[i]).nodes[j]).type << endl;
		}
	}
  
  // MANs - already scaled when repositioning took place
  unsigned long int NumMans = WanList[0].NumNetworks();
  for (i = 0; i < NumMans; i++)
	{
	  for (j = 0; j < ManList[i].NumNodes(); j++)
		{
		  cout << ((ManList[i]).nodes[j]).number << "\t" 
			<< (((ManList[i]).nodes[j]).x) << "\t" 
			<< (((ManList[i]).nodes[j]).y) << "\t" 
			<< ((ManList[i]).nodes[j]).type << endl;
		}
	}

  // LANs - already scaled when repositioning took place
  // Count the total number of LANs
  unsigned long int NumLans = 0;
  for (unsigned long int man = 0; man < NumMans; man++)
	{
	  NumLans += ManList[man].NumNetworks();
	}

  for (i = 0; i < NumMans*NumLans; i++)
	{
	  for (j = 0; j < LanList[i].NumNodes(); j++)
		{
		  cout << ((LanList[i]).nodes[j]).number << "\t" 
			<< (((LanList[i]).nodes[j]).x) << "\t" 
			<< (((LanList[i]).nodes[j]).y) << "\t" 
			<< ((LanList[i]).nodes[j]).type << endl;
		}
	}
  

  return ret;
}



////////////////////////////////////////////////////////////////////////
// Model::OutputEdges
//
// Output all the active edges in the graph
////////////////////////////////////////////////////////////////////////
bool
Model::OutputEdges()
{
  bool ret = true;
  unsigned long int network = 0;
  unsigned long int from = 0;
  
  if (TIERS_VERBOSE)
	{
	  cout << "#" << endl
		   << "# EDGES" << endl
		   << "# =====" << endl 
		   << "#" << endl
		   << "# From\t To\tDelay\tBand-\tFrom\tTo\tState (1:active, 2:redundant" << endl
		   << "# Node\tNode\t     \twidth\tType\tType\t3:internetwork, 4:red.inter.)"
		   << endl
		   << "# ---------------------------------------------------" << endl;
	}


  // WANs
  for (network = 0; network < 1 /* NW should equal 1 */; network++)
	{
	  if (TIERS_DEBUG)
		{
		  cout << "#" << endl << "# WAN " << network << endl << "#" << endl;
		}

	  for (from = 0; from < WanList[network].NumNodes(); from++)
		{
		  unsigned long int MaxNumEdges = WanList[network].MaxNumEdges();
		  unsigned long int NumEdges = WanList[network].NumEdges(from);
		  Edge	*edges = WanList[network].newedges;
		  for (unsigned long int to = 0; to < NumEdges; to++)
			{
			  unsigned long int index = from*MaxNumEdges+to;
			  Node fromNode = WanList[network].nodes[from];
			  Node toNode = WanList[network].nodes[to];

			  if (!(edges[index].state == Model::INACTIVE) && 
				  WanList[network].test_dup_edges(edges[index].start, 
												  edges[index].end))
				{
				  cout << edges[index].start << "\t"
					   << edges[index].end << "\t"
					   << edges[index].delay << "\t"
					   << edges[index].bw << "\t"
					   << fromNode.type << "\t";

				  if (edges[index].state < Model::INTERNETWORK)
					{
					  cout << toNode.type;
					}
				  else
					{
					  cout << MAN;
					}

				  cout << "\t" << edges[index].state
					   << endl;
				}
			} // to
		} // from
	} // network

  // MANs
  for (network = 0; network < WanList[0].NumNetworks(); network++)
	{
	  if (TIERS_DEBUG)
		{
		  cout << "#" << endl << "# MAN " << network << endl << "#" << endl;
		}

	  for (from = 0; from < ManList[network].NumNodes(); from++)
		{
		  unsigned long int MaxNumEdges = ManList[network].MaxNumEdges();
		  unsigned long int NumEdges = ManList[network].NumEdges(from);
		  Edge	*edges = ManList[network].newedges;
		  for (unsigned long int to = 0; to < NumEdges; to++)
			{
			  unsigned long int index = from*MaxNumEdges+to;
			  Node fromNode = ManList[network].nodes[from];
			  // a useful alias, only valid if `to' is in the current network
			  Node toNode = ManList[network].nodes[to];

			  if (!(edges[index].state == Model::INACTIVE) &&
				  ManList[network].test_dup_edges(edges[index].start,
												  edges[index].end))
				{
				  cout << edges[index].start << "\t"
					   << edges[index].end << "\t"
					   << edges[index].delay << "\t"
					   << edges[index].bw << "\t"	
					   << fromNode.type << "\t";

				  // Problem: how to find the type of the destination node
				  // if the edge is not in the current network.
				  // Partial solution: if the edges[index].state is ACTIVE or 
				  // REDUNDANT, the node is in the current network.
				  // This resulted in bug noted 3/3/97 in CHANGES
				  // Better partial solution - test if the destination node 
				  // number is in the range for the WAN. DONE
				  // Best solution: create a global node list as is done in
				  // tiers_output_gnuplot.cc
				  if (edges[index].state < Model::INTERNETWORK)
					{
					  cout << toNode.type;
					}
				  else
					{
					  if (edges[index].end < SW)
						{
						  cout << WAN;	// relies on unique node numbers
						}
					  else
						{
						  cout << LAN;
						}
					}

				  cout << "\t" << edges[index].state
					   << endl;
				}
			} // to
		} // from
	} // network

  // LANs
  // LANs are modelled as a star, with the edges in edges
  // Edges for internetwork redundancy are at the end of edges
  network = 0; // the index of each LAN
  for (unsigned long int supernetwork = 0; 
	   supernetwork < WanList[0].NumNetworks(); 
	   supernetwork++)
	{
	  unsigned long int UpperLimit = network + 
		ManList[supernetwork].NumNetworks();
	  for (network = network; network < UpperLimit; network++)
		{
		  if (TIERS_DEBUG)
			{
			  cout << "#" << endl << "# LAN " << network << endl << "#" << endl;
			}

		  // edge (0,0) is undefined
		  for (unsigned long int to = 1; 
			   to < (LanList[network].NumEdges(0)+1); 
			   to++)
			{
			  Edge	*edges = LanList[network].edges;	// newedges is 0
			  Node fromNode = LanList[network].nodes[0];
			  if (edges[to].state != Model::INACTIVE)
				{
				  cout << edges[to].start << "\t"
					   << edges[to].end << "\t"
					   << edges[to].delay << "\t"
					   << edges[to].bw << "\t"
					   << fromNode.type << "\t";

				  if (edges[to].state < Model::INTERNETWORK)
					{
					  cout << LAN;
					}
				  else
					{
					  cout << MAN;
					}

				  cout << "\t" << edges[to].state
					   << endl;

				  // generate the symmetrical edge for the purposes of output
				  if (!REMOVE_DUP_EDGES)
					{
					  cout << edges[to].end << "\t"
						   << edges[to].start << "\t"
						   << edges[to].delay << "\t"
						   << edges[to].bw << "\t";

					  if (edges[to].state < Model::INTERNETWORK)
						{
						  cout << LAN;
						}
					  else
						{
						  cout << MAN;
						}

					  cout << "\t" << fromNode.type
						   << "\t" << edges[to].state
						   << endl;
					}
				} // to
			} // network
		} // supernetwork
	}

  
  return ret;
}

// end of file

