# [for (x)emacs] -*-  mode: RPM-SPEC; coding: utf-8 -*-
%define KDEDIR /usr
Summary: A CD-ROM mounting utility.
Name: autorun
Version: 3.17
Release: 1
License: GPL
Group: Applications/System
Source: %name-%{PACKAGE_VERSION}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
ExcludeArch: s390 s390x
BuildRequires: linuxdoc-tools xmlto
BuildRequires: desktop-file-utils >= 0.3

%description
The autorun utility recognizes all of the CD-ROM drives on your
system, mounts the drive when a CD-ROM is inserted and executes an
autorun executable (if one exists) on the CD. If you want to give
users (instead of just root) the autorun ability, you'll need to add
user,exec options to the CD-ROM line in /etc/fstab.

%prep
%setup -q

%build
export KDEDIR=%{KDEDIR}
export NOTIFY_PATH="$KDEDIR/bin/kfmclient configureDesktop"
%{configure} --sysconfdir=/etc \
        --datadir=%{KDEDIR}/share
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications

desktop-file-install --vendor redhat \
   --dir $RPM_BUILD_ROOT%{_datadir}/applications \
   --add-category "Application;Utilities;X-Red-Hat-Base" \
   --add-only-show-in KDE \
   $RPM_BUILD_ROOT%{_datadir}/autorun/Autorun.desktop

mkdir -p $RPM_BUILD_ROOT/etc/skel/.kde/Autostart
cp $RPM_BUILD_ROOT%{_datadir}/autorun/Autorun.desktop  $RPM_BUILD_ROOT/etc/skel/.kde/Autostart/Autorun.desktop

rm -fr $RPM_BUILD_ROOT%{_datadir}/autorun

%find_lang %name

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog NEWS README Autorun.desktop
%{_bindir}/autorun
/etc/skel/.kde/Autostart/Autorun.desktop
%{_mandir}/man?/*
%{_datadir}/applications/*.desktop

%changelog
* Wed Sep 14 2005 Harald Hoyer <harald@redhat.com> - 3.17
- minor bugfixes in cdrom.cc

* Tue Apr 19 2005 Harald Hoyer <harald@redhat.com> - 3.16
- new languages, translation updates
- close() before mount()

* Mon Jan 31 2005 Harald Hoyer <harald@redhat.com> - 3.15
- added daemon options
- added recognition of "pamconsole" attribute in /etc/fstab
- updated translation

* Wed Oct 11 2004 Harald Hoyer <harald@redhat.com> - 3.14
- translation update

* Wed Sep 29 2004 Harald Hoyer <harald@redhat.com> - 3.13-3
- removed INSTALL from documentation

* Wed Apr 21 2004 Harald Hoyer <harald@redhat.com> - 3.13-2
- translation update

* Wed Mar 10 2004 Harald Hoyer <harald@redhat.com> - 3.13-1
- include errno.h in cdrom.cc

* Wed Jan 28 2004 Harald Hoyer <harald@redhat.com> - 3.12-1
- added xmlto to BuildRequires

* Thu Oct 09 2003 Harald Hoyer <harald@redhat.de> 3.11-1
- include all languages in po

* Thu Feb 27 2003 Owen Taylor <otaylor@redhat.com> 3.9-1
- In checkMedia, check for mounted, before
  doing ioctls(), since we won't be able to open mounted
  devices with O_EXCL. (#85233)

* Wed Feb 26 2003 Harald Hoyer <harald@redhat.de> 3.8-1
- better test for EBUSY, than reopen without O_EXCL

* Tue Feb 25 2003 Harald Hoyer <harald@redhat.de> 3.6-1
- open cdrom with O_EXCL

* Thu Jan 30 2003 Harald Hoyer <harald@redhat.de> 3.5-1
- fixed manpage

* Thu Nov 21 2002 Harald Hoyer <harald@redhat.de>
- fixed help string for i18n #73646

* Thu Aug 29 2002 Trond Eivind Glomsrød <teg@redhat.com>
- Update translations
- s/Copyright/License/
- use %%{_tmppath}

* Wed Aug  7 2002 Harald Hoyer <harald@redhat.de>
- changed to docbook format for the manpage

* Tue Aug  6 2002 Harald Hoyer <harald@redhat.de>
- updated i18n

* Thu Jun 27 2002 Harald Hoyer <harald@redhat.de>
- removed desktop file from menu structure

* Mon Jun 10 2002 Harald Hoyer <harald@redhat.de>
- better gettext messages

* Tue May 21 2002 Harald Hoyer <harald@redhat.de> 3.0-1
- added i18n

* Wed Apr 10 2002 Harald Hoyer <harald@redhat.de> 2.73-1
- fixed #62965

* Mon Mar  4 2002 Harald Hoyer <harald@redhat.de> 2.72-1
- fixed #60629

* Tue Feb 26 2002 Elliot Lee <sopwith@redhat.com> 2.71-2
- Add BuildRequires: linuxdoc-tools

* Fri Jan 25 2002 Harald Hoyer <harald@redhat.de>
- using namespace std for g++-3

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Sep 12 2001 Tim Powers <timp@redhat.com>
- rebuild with new gcc and binutils

* Thu Jul 26 2001 Harald Hoyer <harald@redhat.com> 2.66-1
- autorun now creates a lockfile

* Wed Jul 25 2001 Harald Hoyer <harald@redhat.com> 2.65-5
- fixed autorun-condstart.sh
 
* Wed Jul 25 2001 Harald Hoyer <harald@redhat.com> 2.65-4
- added autorun-condstart.sh, which fixes KDE bad Exec behaviour in .desktop

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Fri Apr 27 2001 Bill Nottingham <notting@redhat.com>
- rebuild for C++ exception handling on ia64

* Fri Mar 30 2001 Harald Hoyer <harald@redhat.de> 2.65
- fixed .desktop (escaped the double-quotes)

* Fri Mar 30 2001 Harald Hoyer <harald@redhat.de> 2.65
- fixed .desktop (escaped the double-quotes)

* Wed Mar 28 2001 Preston Brown <pbrown@redhat.com> 2.63-5
- better check for console ownership (works in runlevel 3 also)

* Wed Mar 21 2001 Preston Brown <pbrown@redhat.com> 2.63-4
- one more message marked only for verbose output

* Wed Mar 21 2001 Harald Hoyer <harald@redhat.de> 2.63-3
- fixed Autorun.desktop

* Wed Mar 14 2001 Harald Hoyer <harald@redhat.de> 
- removed requirements for kdemultimedia and kdebase

* Tue Mar 06 2001 Harald Hoyer <harald@redhat.de>
- added additional check to ensure we have a CDROM
- additional check if CDROM is in defined status

* Thu Feb 15 2001 Preston Brown <pbrown@redhat.com>
- accept "auto" type of filesystem as valid
 
* Wed Feb  7 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- KDE 2.x keeps its autostart files in ~/.kde/Autostart,
  not ~/Desktop/Autostart

* Tue Feb 06 2001 Harald Hoyer <harald@redhat.com>
- fixed Autorun.kdelnk to lock the door
- renamed Autorun.kdelnk to .desktop
 
* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild
 
* Tue Jul  4 2000 Jakub Jelinek <jakub@redhat.com>
- Rebuild with new C++
 
* Thu Jun  1 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- rebuild with current gcc
- move man pages where they belong
- use makeinstall macro
 
* Wed May 03 2000 Harald Hoyer <harald@redhat.com>
- fixed Autostart .kdelnk

* Thu Feb 14 2000 Harald Hoyer <harald@redhat.com>
- updated man page

* Thu Feb 10 2000 Harald Hoyer <harald@redhat.com>
- released 2.6
- fixed insert-notify bug

* Thu Feb 10 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- fix up Autorun.kdelnk

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix descriptions and summary

* Tue Nov 16 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- version 2.5
- some .spec cleanups

* Fri Sep 24 1999 Cristian Gafton <gafton@redhat.com>
- correct patch for the "owner" option

* Wed Sep 22 1999 Preston Brown <pbrown@redhat.com>
- require kdemultimedia (kscd) and kdebase (kfmexec)

* Tue Sep 21 1999 Preston Brown <pbrown@redhat.com>
- fixed path to autorun script
- don't install .kdelnks; we now check for autorun in startkde
  and act accordingly

* Mon Sep 13 1999 Preston Brown <pbrown@redhat.com>
- patched to allow "owner" mount option

* Tue Sep 07 1999 Cristian Gafton <gafton@redhat.com>
- enabled back KDE-only mode

* Mon Sep 06 1999 Cristian Gafton <gafton@redhat.com>
- version 2.3

* Mon Aug 23 1999 Cristian Gafton <gafton@redhat.com>
- imported for Red Hat Linux 6.1
- patch it up to make it more desktop-independant (and require cdp because
  of that)
