/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "par-cmdline/fileops.h"
#include "par-cmdline/rwpar.h"
#include "par-cmdline/backend.h"
#include "par-cmdline/checkpar.h"
#include "par-cmdline/makepar.h"
#include "pure-sfv.h"
#include <math.h>

struct cmdline cmd;

/*\ Sanity check \*/
static int
check_sizes(void)
{
    int fail = 0;
    if (sizeof(u8) != 1) {
        fprintf(stderr, "u8 isn't 8 bits wide.\n");
        fail++;
    }
    if (sizeof(u16) != 2) {
        fprintf(stderr, "u16 isn't 16 bits wide.\n");
        fail++;
    }
    if (sizeof(u32) != 4) {
        fprintf(stderr, "u32 isn't 32 bits wide.\n");
        fail++;
    }
    if (sizeof(i64) != 8) {
        fprintf(stderr, "u64 isn't 64 bits wide.\n");
        fail++;
    }
    return fail;
}
int pparCreateN(pure_sfv_params* params, crc_info_type* sfv_info, char* par_name, int from, int to)
{
    par_t  *par = 0;
    int     i;
    int     fail = 0;
    double  v;

    DBUG_PRINT("pparCreateN", ("enter"));

    DBUG_PRINT("pparCreateN", ("par_name [%s][%i-%i]", par_name, from, to));

    if (!params->quiet) {
        printf("----( Creating: %s )--------\n", par_name);
    }

    unlink(par_name);

    if (check_sizes())  return -1;

    memset(&cmd, 0, sizeof(cmd));
    cmd.volumes = 10;
    cmd.pervol = 1;
    cmd.pxx = 1;
    cmd.ctrl = 1;
    cmd.add = 1;
    cmd.usecase = 1;
    cmd.move = 1;
    if (params->quiet) {
        cmd.loglevel = 0;
    }

    if (params->par_recovery_ratio == 0) {
        cmd.volumes = 0;
        cmd.pxx = 0;
    } else {
        v = ((double)params->par_recovery_ratio * (double)(to - from)) / 100.0;
        /* The ceil function returns a double value representing the smallest integer that is greater than or equal to x.  */
        cmd.volumes = (int)ceil(v);
        cmd.pervol = 0;
        if (cmd.volumes == 0) { cmd.volumes = 1;}
    }

    DBUG_PRINT("pparCreateN", ("cmd.volumes [%i]", cmd.volumes));

    cmd.action = ACTION_ADD;

    par = read_par_header(unist(par_name), 1, 0, 0);
    if (!par) return 2;

    cmd.action = ACTION_ADDING;

    for(i = from; ((i < to) && (i < sfv_info->len)); i++) {
        DBUG_PRINT("pparCreateN", ("add_file[%i] [%s]", i, sfv_info->items[i].file_name));
        par_add_file(par, find_file_name(unist(sfv_info->items[i].file_name), 1));
    }

    if (par) {
        if (cmd.pxx && !par_make_pxx(par))
            fail |= 1;
        if (!par->vol_number && !write_par_header(par))
            fail |= 1;
        free_par(par);
    }

    return fail;
}

int pparCreate(pure_sfv_params* params, crc_info_type* sfv_info)
{
    int     fail = 0;
    string  par_name;
    string  par_name_set;
    char    *end;
    int     n_set = 1;
    int     i, prev_to;
    int     per_set, from, to;
    const int max_in_par_set = 255;

    if (sfv_info->len > max_in_par_set) {
        n_set = sfv_info->len / max_in_par_set + 1;
    }

    strncpy(par_name, sfv_info->name, MAX_STRING_LEN);
    end = strrchr(par_name, '.');
    if (end != NULL) {
        *end = '\0';
    }


    if ( n_set == 1 ) {
        strcat(par_name, "." par_extension);
        DBUG_PRINT("pparCreate", ("par_name [%s] set[%i]", par_name , n_set));
        fail = pparCreateN(params, sfv_info, par_name, 0, sfv_info->len);
    } else {
        per_set = sfv_info->len / n_set;
        prev_to = 0;
        for (i = 0; i < n_set; i++) {
            
            DBUG_PRINT("pparCreate", ("par_name [%s] sets[%i-%i]", par_name, i, n_set));
            
            from = prev_to;
            to = (i + 1) * per_set;
            if (i == (n_set - 1)) {
                to = sfv_info->len;
            }
            prev_to =  to;

            sprintf(par_name_set, "%s_%03i-%03i." par_extension, par_name, from+1, to);
            fail = pparCreateN(params, sfv_info, par_name_set, from, to);
            if (fail) return fail;
        }
    }

    return fail;
}
