
/*

    memory.h - Header file for memory histogram
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/

*/


/* prevent multiple inclusion */
#ifndef _MP_MEMORY


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_MEMORY

  
/* header definitions starts here */


/* data for memory monitor */
struct memory_monitor {
  int handler;			/* graphic area handler */
  int enable;			/* enabled flag */
  int update_dly;		/* update delay in 2/10 sec */
  unsigned long total,		/* total memory */
		shared,		/* shared memory */
		mpfree,		/* free memory */
		used,		/* used memory */
		buffers,	/* kernel buffers */
		cache,		/* disk cache */
		swap,		/* total swap space */
		paged;		/* used swap */
  int xm, ym, wm, hm;		/* monitor gauge position and size */
  char shared_color[30];	/* color for shared meter */
  char used_color[30];		/* color for used memory */
  char buffers_color[30];	/* color for buffers */
  char cache_color[30];		/* color for cache */
  char paged_color[30];		/* color for used swap space */
};

  
  
/* reads memory and swap status from /proc/meminfo */
void mem_update(struct memory_monitor *mmon);

/* set size for memory/swap histogram */
int mem_size(struct memory_monitor *mmon);

/* draw memory histogram */
void mem_draw(struct memory_monitor *mmon);


#ifdef __cplusplus
}
#endif

#endif /* _MP_MEMORY */


