// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::count_tokens::_count_tokens_output::CountTokensOutputBuilder;

pub use crate::operation::count_tokens::_count_tokens_input::CountTokensInputBuilder;

impl crate::operation::count_tokens::builders::CountTokensInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::count_tokens::CountTokensOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::count_tokens::CountTokensError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.count_tokens();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `CountTokens`.
///
/// <p>Returns the token count for a given inference request. This operation helps you estimate token usage before sending requests to foundation models by returning the token count that would be used if the same input were sent to the model in an inference request.</p>
/// <p>Token counting is model-specific because different models use different tokenization strategies. The token count returned by this operation will match the token count that would be charged if the same input were sent to the model in an <code>InvokeModel</code> or <code>Converse</code> request.</p>
/// <p>You can use this operation to:</p>
/// <ul>
/// <li>
/// <p>Estimate costs before sending inference requests.</p></li>
/// <li>
/// <p>Optimize prompts to fit within token limits.</p></li>
/// <li>
/// <p>Plan for token usage in your applications.</p></li>
/// </ul>
/// <p>This operation accepts the same input formats as <code>InvokeModel</code> and <code>Converse</code>, allowing you to count tokens for both raw text inputs and structured conversation formats.</p>
/// <p>The following operations are related to <code>CountTokens</code>:</p>
/// <ul>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/bedrock/latest/API/API_runtime_InvokeModel.html">InvokeModel</a> - Sends inference requests to foundation models</p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/bedrock/latest/API/API_runtime_Converse.html">Converse</a> - Sends conversation-based inference requests to foundation models</p></li>
/// </ul>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct CountTokensFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::count_tokens::builders::CountTokensInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::count_tokens::CountTokensOutput,
        crate::operation::count_tokens::CountTokensError,
    > for CountTokensFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::count_tokens::CountTokensOutput,
            crate::operation::count_tokens::CountTokensError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl CountTokensFluentBuilder {
    /// Creates a new `CountTokensFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the CountTokens as a reference.
    pub fn as_input(&self) -> &crate::operation::count_tokens::builders::CountTokensInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::count_tokens::CountTokensOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::count_tokens::CountTokensError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::count_tokens::CountTokens::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::count_tokens::CountTokens::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::count_tokens::CountTokensOutput,
        crate::operation::count_tokens::CountTokensError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub fn model_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.model_id(input.into());
        self
    }
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub fn set_model_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_model_id(input);
        self
    }
    /// <p>The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens differently, so the token count is specific to the model you specify.</p>
    pub fn get_model_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_model_id()
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub fn input(mut self, input: crate::types::CountTokensInput) -> Self {
        self.inner = self.inner.input(input);
        self
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub fn set_input(mut self, input: ::std::option::Option<crate::types::CountTokensInput>) -> Self {
        self.inner = self.inner.set_input(input);
        self
    }
    /// <p>The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field</p></li>
    /// <li>
    /// <p>For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field</p></li>
    /// </ul>
    /// <p>The input format must be compatible with the model specified in the <code>modelId</code> parameter.</p>
    pub fn get_input(&self) -> &::std::option::Option<crate::types::CountTokensInput> {
        self.inner.get_input()
    }
}
