/*
 * ckpass.h
 *
 * Header for main program and support functions.
 *
 * This file is part of the ckpass project.
 *
 * Copyright (C) 2009  Heath N. Caldwell <hncaldwell@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CKPASS_H
#define CKPASS_H

#include <ncurses.h>
#include <kpass.h>
#include "bindings.h"

#define MAX(a, b) ((a) > (b) ? (a) : (b))
#define MIN(a, b) ((a) < (b) ? (a) : (b))

#define WIN_GROUPS 0
#define WIN_ENTRIES 1

#define MAX_PASSWORD_LENGTH 256
#define MAX_FILENAME_LENGTH 2048

WINDOW *_groups_super_win = 0;
WINDOW *_groups_win = 0;
WINDOW *_entries_super_win = 0;
WINDOW *_entries_win = 0;
WINDOW *_top_bar = 0;
WINDOW *_bottom_bar = 0;

int _entry_widths[] = {25, 17, 33, 128};

struct binding *_groups_bindings;
struct binding *_entries_bindings;

void show_header(WINDOW *win, kpass_db *db);
void fatal(const char *message);
void error_dialog(char *s);
int open_db(kpass_db *db, const char *filename);
int read_db(kpass_db *db, const char *filename);
int decrypt_db(kpass_db *db, const char *password);
void init_windows();
void draw_groups(const kpass_db *, int, int, bool);
void draw_entries(const kpass_db *, int, int, int, bool, bool);
void draw_top_bar(const char *);
void draw_bottom_bar(int mode);
int entries_in_group(const kpass_db *, int);
struct kpass_entry *nth_entry_in_group(const kpass_db *, int, int);
int find_groups_win_width(const kpass_db *);
int pipeout(const char *command, const char *s);
void init_bindings();

#endif //CKPASS_H

