Minutes from OpenVDB TSC meeting, May 02, 2023

Attendees: *Jeff* L., *Andre* P, *Ken* M., *Greg* H., *Dan* B.

Additional Attendees: 

Regrets: *Rich* J., *Nick* A.

Agenda:

1) Confirm quorum
2) Secretary
3) SIGGRAPH 2023
4) Website broken link
5) Root node offset
6) I/O revamp

------------


1) Confirm quorum

Quorum is present.


2) Secretary

Secretary is Greg Hurst.


3) SIGGRAPH 2023

Course accepted with good feedback from reviewers.
Must sign over copyrights for anything in the presentation. Need to do this now.
Course material must be submitted by June 5. Option to revise slides by August 11.

For ASWF: tentatively do Bird of a Feather and advertise SIGGRAPH course.


4) Website broken link

PR for broken Houdini link to be merged.
https://github.com/AcademySoftwareFoundation/openvdb-website/pull/71

Fixed link:
https://www.openvdb.org/download/files/houdini_examples.hip-1.0.1.zip


5) Root node offset

Root node dense, all other nodes are dense. Root essentially hash table.

Since root is sparse, root access is slower. Tend to avoid touching the root node. e.g. value accessors.

Root is centered at origin (0, 0, 0), and so a small sphere centered at the origin makes 8 children.

The offset mitigates this issue. 

Root node now has mOrigin member, just like all other nodes (added in v10)

Currently mOrigin is hard coded to origin still and even has checks to throw errors if not.

First pass tried to hard code half offset (-2048, -2048, -2048) but saw no measurable speedup.

Can we make mOrigin anything? If so looks like we will have massive overhead -- merging trees, etc will need to rebuild tree structure.

If you guarantee that the root node is aligned with grandchild of other root
e.g. If mOrigin is a multiple of 128, then only misaligned is child nodes of the root.
And so during these operations, only root node needs to be rebuilt.
It _can_ generalize to arbitrary fan factors but need different number from 128.
2 level tree is a special case, but n (>= 3) follows above logic.

What is the impact on the existing code? CSG, Combinations, etc.
Merging 2 grids with incommensurate origins is tricky if const operators... duplicate data etc.

How to maintain backward compatibility for I/O if we just hardcode (-2048, -2048, -2048)?
And (it seems) that's the only backward compatibility to suss out.
Export will need to recenter to (0, 0, 0)?
I/O needs to be refactored anyway...
Hardcoded global offset means we don't need to explicitly export it

Ken will investigate and do deep dive


6) I/O revamp

Would be good to investigate into I/O revamp. 
Come up with a list of modern requirements. 
Refer to this list in future development efforts.
