+++
dep = 8
title = "Draft Tasks"
authors = [ "Michelle Noorali <michelle.noorali@microsoft.com>" ]
created = 2018-04-10
+++

# Abstract

This document describes draft `tasks`, how to define them, and when to use them.

# Motivation

Draft users may find themselves wanting to hook into different parts of the draft application lifecycle. For example, a user may want to set up or install a dependency in their cluster before running `draft up`, run commands in their application container after deploying it to their Kubernetes cluster, or perform cleanup steps after deleting their application. Draft tasks make it possible for users to define and run these types of actions.

# Specification
Tasks live in `.draft-tasks.toml` in an application's root directory. If a tasks.toml file is specified in a draft pack, running the `draft create` command will copy `tasks.toml` from the draft pack to `.draft-tasks.toml` in the application's root directory.

The format of a tasks file is as follows:

In `APP_ROOT/.draft-tasks.toml`:
```toml
[pre-up]
hello = "echo hello world" # where hello is the task description and the task is on the right side of = inside ""
mysql = "helm install mysql --name mysql-service"

[post-deploy]
"friendly msg for no reason" = "echo setting up some stuff in my container"
"sync database" = "rake db:migrate"

[cleanup]
"delete mysql" = "helm delete mysql-service --purge"
```

# Types of tasks
- `pre-up`: These tasks run before `draft up` which builds and deploys the application.
- `post-deploy`: These tasks run after `draft up`. Draft will wait until pods are ready and then execute setup tasks inside of each application pod.
- `cleanup`: These tasks are run after the application is deleted from the Kubernetes cluster but before the `draft delete` command completes execution.

_Notes:
- The task description is currently not used when running draft. This will probably change as we continue to build out the experience around tasks
- If you define multiple tasks under a task type (say you have two tasks: "hello" and "goodbye" under [pre-up]), there is no guarantee on their execution (that "hello" will run before/after "goodbye")_
