+++
dep = 4
title = "Draft Pack Repository Format"
authors = [ "Matt Fisher <matt.fisher@microsoft.com>" ]
created = 2017-10-18
+++

# Introduction

Pack repositories are external sources of Draft packs. They can be created by anyone to provide their own packs to any Draft user, and users can extend Draft's list of available language packs by adding the pack repository using the `draft pack-repo` tool.

# Creating a pack repository

A pack repository is usually a Git repository available online, but you can use anything as long as it’s a protocol that a version control system like git, mercurial or svn understands, or even just a directory with files in it. The name of the repository doesn't matter, though it is recommended as a best practive to start the repository name with `draft-` as a common convention.

Packs follow the same format as the core’s ones, and can be added under `packs/`. By placing packs inside their own directory, it makes the repository organisation easier to grasp, and top-level files are not mixed with packs.

See [Azure/draft](https://github.com/Azure/draft) for an example of a pack repository with a `packs/` subdirectory.

# Maintaining a pack repository

A pack repository is just a Git repository so there's nothing specific when making modifications, apart from committing and pushing changes to the repository.

# Adding a pack repository to Draft

If it’s on GitHub, users can add repositories to their list with `draft pack-repo add https://github.com/user/draft-repo`. If it’s hosted outside of GitHub, they have to use `draft pack-repo add <URL>`, where `<URL>` is your version control system's clone URL.

# Updating a pack repository installed to Draft

Once a pack repository is installed, Draft will update it each time a user runs `draft pack-repo update`. Outdated packs will be upgraded in `$(draft home)/packs`, but changes will not apply to applications already bootstrapped by `draft create`.
