// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package entityresolution

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMatchingWorkflow = "CreateMatchingWorkflow"

// CreateMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMatchingWorkflow for more information on using the CreateMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMatchingWorkflowRequest method.
//	req, resp := client.CreateMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow
func (c *EntityResolution) CreateMatchingWorkflowRequest(input *CreateMatchingWorkflowInput) (req *request.Request, output *CreateMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateMatchingWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/matchingworkflows",
	}

	if input == nil {
		input = &CreateMatchingWorkflowInput{}
	}

	output = &CreateMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMatchingWorkflow API operation for AWS EntityResolution.
//
// Creates a MatchingWorkflow object which stores the configuration of the data
// processing job to be run. It is important to note that there should not be
// a pre-existing MatchingWorkflow with the same name. To modify an existing
// workflow, utilize the UpdateMatchingWorkflow API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation CreateMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current AWS Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow
func (c *EntityResolution) CreateMatchingWorkflow(input *CreateMatchingWorkflowInput) (*CreateMatchingWorkflowOutput, error) {
	req, out := c.CreateMatchingWorkflowRequest(input)
	return out, req.Send()
}

// CreateMatchingWorkflowWithContext is the same as CreateMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) CreateMatchingWorkflowWithContext(ctx aws.Context, input *CreateMatchingWorkflowInput, opts ...request.Option) (*CreateMatchingWorkflowOutput, error) {
	req, out := c.CreateMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchemaMapping = "CreateSchemaMapping"

// CreateSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchemaMapping for more information on using the CreateSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSchemaMappingRequest method.
//	req, resp := client.CreateSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping
func (c *EntityResolution) CreateSchemaMappingRequest(input *CreateSchemaMappingInput) (req *request.Request, output *CreateSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opCreateSchemaMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/schemas",
	}

	if input == nil {
		input = &CreateSchemaMappingInput{}
	}

	output = &CreateSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchemaMapping API operation for AWS EntityResolution.
//
// Creates a schema mapping, which defines the schema of the input customer
// records table. The SchemaMapping also provides Entity Resolution with some
// metadata about the table, such as the attribute types of the columns and
// which columns to match on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation CreateSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current AWS Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping
func (c *EntityResolution) CreateSchemaMapping(input *CreateSchemaMappingInput) (*CreateSchemaMappingOutput, error) {
	req, out := c.CreateSchemaMappingRequest(input)
	return out, req.Send()
}

// CreateSchemaMappingWithContext is the same as CreateSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) CreateSchemaMappingWithContext(ctx aws.Context, input *CreateSchemaMappingInput, opts ...request.Option) (*CreateSchemaMappingOutput, error) {
	req, out := c.CreateSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMatchingWorkflow = "DeleteMatchingWorkflow"

// DeleteMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMatchingWorkflow for more information on using the DeleteMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMatchingWorkflowRequest method.
//	req, resp := client.DeleteMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow
func (c *EntityResolution) DeleteMatchingWorkflowRequest(input *DeleteMatchingWorkflowInput) (req *request.Request, output *DeleteMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteMatchingWorkflow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/matchingworkflows/{workflowName}",
	}

	if input == nil {
		input = &DeleteMatchingWorkflowInput{}
	}

	output = &DeleteMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMatchingWorkflow API operation for AWS EntityResolution.
//
// Deletes the MatchingWorkflow with a given name. This operation will succeed
// even if a workflow with the given name does not exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeleteMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow
func (c *EntityResolution) DeleteMatchingWorkflow(input *DeleteMatchingWorkflowInput) (*DeleteMatchingWorkflowOutput, error) {
	req, out := c.DeleteMatchingWorkflowRequest(input)
	return out, req.Send()
}

// DeleteMatchingWorkflowWithContext is the same as DeleteMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeleteMatchingWorkflowWithContext(ctx aws.Context, input *DeleteMatchingWorkflowInput, opts ...request.Option) (*DeleteMatchingWorkflowOutput, error) {
	req, out := c.DeleteMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchemaMapping = "DeleteSchemaMapping"

// DeleteSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchemaMapping for more information on using the DeleteSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSchemaMappingRequest method.
//	req, resp := client.DeleteSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping
func (c *EntityResolution) DeleteSchemaMappingRequest(input *DeleteSchemaMappingInput) (req *request.Request, output *DeleteSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteSchemaMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/schemas/{schemaName}",
	}

	if input == nil {
		input = &DeleteSchemaMappingInput{}
	}

	output = &DeleteSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSchemaMapping API operation for AWS EntityResolution.
//
// Deletes the SchemaMapping with a given name. This operation will succeed
// even if a schema with the given name does not exist. This operation will
// fail if there is a DataIntegrationWorkflow object that references the SchemaMapping
// in the workflow's InputSourceConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeleteSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping
func (c *EntityResolution) DeleteSchemaMapping(input *DeleteSchemaMappingInput) (*DeleteSchemaMappingOutput, error) {
	req, out := c.DeleteSchemaMappingRequest(input)
	return out, req.Send()
}

// DeleteSchemaMappingWithContext is the same as DeleteSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeleteSchemaMappingWithContext(ctx aws.Context, input *DeleteSchemaMappingInput, opts ...request.Option) (*DeleteSchemaMappingOutput, error) {
	req, out := c.DeleteSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatchId = "GetMatchId"

// GetMatchIdRequest generates a "aws/request.Request" representing the
// client's request for the GetMatchId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatchId for more information on using the GetMatchId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchIdRequest method.
//	req, resp := client.GetMatchIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId
func (c *EntityResolution) GetMatchIdRequest(input *GetMatchIdInput) (req *request.Request, output *GetMatchIdOutput) {
	op := &request.Operation{
		Name:       opGetMatchId,
		HTTPMethod: "POST",
		HTTPPath:   "/matchingworkflows/{workflowName}/matches",
	}

	if input == nil {
		input = &GetMatchIdInput{}
	}

	output = &GetMatchIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatchId API operation for AWS EntityResolution.
//
// Returns the corresponding Match ID of a customer record if the record has
// been processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetMatchId for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId
func (c *EntityResolution) GetMatchId(input *GetMatchIdInput) (*GetMatchIdOutput, error) {
	req, out := c.GetMatchIdRequest(input)
	return out, req.Send()
}

// GetMatchIdWithContext is the same as GetMatchId with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatchId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetMatchIdWithContext(ctx aws.Context, input *GetMatchIdInput, opts ...request.Option) (*GetMatchIdOutput, error) {
	req, out := c.GetMatchIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatchingJob = "GetMatchingJob"

// GetMatchingJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMatchingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatchingJob for more information on using the GetMatchingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchingJobRequest method.
//	req, resp := client.GetMatchingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob
func (c *EntityResolution) GetMatchingJobRequest(input *GetMatchingJobInput) (req *request.Request, output *GetMatchingJobOutput) {
	op := &request.Operation{
		Name:       opGetMatchingJob,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows/{workflowName}/jobs/{jobId}",
	}

	if input == nil {
		input = &GetMatchingJobInput{}
	}

	output = &GetMatchingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatchingJob API operation for AWS EntityResolution.
//
// Gets the status, metrics, and errors (if there are any) that are associated
// with a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetMatchingJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob
func (c *EntityResolution) GetMatchingJob(input *GetMatchingJobInput) (*GetMatchingJobOutput, error) {
	req, out := c.GetMatchingJobRequest(input)
	return out, req.Send()
}

// GetMatchingJobWithContext is the same as GetMatchingJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatchingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetMatchingJobWithContext(ctx aws.Context, input *GetMatchingJobInput, opts ...request.Option) (*GetMatchingJobOutput, error) {
	req, out := c.GetMatchingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatchingWorkflow = "GetMatchingWorkflow"

// GetMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatchingWorkflow for more information on using the GetMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchingWorkflowRequest method.
//	req, resp := client.GetMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow
func (c *EntityResolution) GetMatchingWorkflowRequest(input *GetMatchingWorkflowInput) (req *request.Request, output *GetMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetMatchingWorkflow,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows/{workflowName}",
	}

	if input == nil {
		input = &GetMatchingWorkflowInput{}
	}

	output = &GetMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatchingWorkflow API operation for AWS EntityResolution.
//
// Returns the MatchingWorkflow with a given name, if it exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow
func (c *EntityResolution) GetMatchingWorkflow(input *GetMatchingWorkflowInput) (*GetMatchingWorkflowOutput, error) {
	req, out := c.GetMatchingWorkflowRequest(input)
	return out, req.Send()
}

// GetMatchingWorkflowWithContext is the same as GetMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetMatchingWorkflowWithContext(ctx aws.Context, input *GetMatchingWorkflowInput, opts ...request.Option) (*GetMatchingWorkflowOutput, error) {
	req, out := c.GetMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaMapping = "GetSchemaMapping"

// GetSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaMapping for more information on using the GetSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSchemaMappingRequest method.
//	req, resp := client.GetSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping
func (c *EntityResolution) GetSchemaMappingRequest(input *GetSchemaMappingInput) (req *request.Request, output *GetSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opGetSchemaMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/schemas/{schemaName}",
	}

	if input == nil {
		input = &GetSchemaMappingInput{}
	}

	output = &GetSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaMapping API operation for AWS EntityResolution.
//
// Returns the SchemaMapping of a given name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping
func (c *EntityResolution) GetSchemaMapping(input *GetSchemaMappingInput) (*GetSchemaMappingOutput, error) {
	req, out := c.GetSchemaMappingRequest(input)
	return out, req.Send()
}

// GetSchemaMappingWithContext is the same as GetSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetSchemaMappingWithContext(ctx aws.Context, input *GetSchemaMappingInput, opts ...request.Option) (*GetSchemaMappingOutput, error) {
	req, out := c.GetSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMatchingJobs = "ListMatchingJobs"

// ListMatchingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMatchingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMatchingJobs for more information on using the ListMatchingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMatchingJobsRequest method.
//	req, resp := client.ListMatchingJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs
func (c *EntityResolution) ListMatchingJobsRequest(input *ListMatchingJobsInput) (req *request.Request, output *ListMatchingJobsOutput) {
	op := &request.Operation{
		Name:       opListMatchingJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows/{workflowName}/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMatchingJobsInput{}
	}

	output = &ListMatchingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMatchingJobs API operation for AWS EntityResolution.
//
// Lists all jobs for a given workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListMatchingJobs for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs
func (c *EntityResolution) ListMatchingJobs(input *ListMatchingJobsInput) (*ListMatchingJobsOutput, error) {
	req, out := c.ListMatchingJobsRequest(input)
	return out, req.Send()
}

// ListMatchingJobsWithContext is the same as ListMatchingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMatchingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingJobsWithContext(ctx aws.Context, input *ListMatchingJobsInput, opts ...request.Option) (*ListMatchingJobsOutput, error) {
	req, out := c.ListMatchingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMatchingJobsPages iterates over the pages of a ListMatchingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMatchingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMatchingJobs operation.
//	pageNum := 0
//	err := client.ListMatchingJobsPages(params,
//	    func(page *entityresolution.ListMatchingJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListMatchingJobsPages(input *ListMatchingJobsInput, fn func(*ListMatchingJobsOutput, bool) bool) error {
	return c.ListMatchingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMatchingJobsPagesWithContext same as ListMatchingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingJobsPagesWithContext(ctx aws.Context, input *ListMatchingJobsInput, fn func(*ListMatchingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMatchingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMatchingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMatchingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMatchingWorkflows = "ListMatchingWorkflows"

// ListMatchingWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListMatchingWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMatchingWorkflows for more information on using the ListMatchingWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMatchingWorkflowsRequest method.
//	req, resp := client.ListMatchingWorkflowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows
func (c *EntityResolution) ListMatchingWorkflowsRequest(input *ListMatchingWorkflowsInput) (req *request.Request, output *ListMatchingWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListMatchingWorkflows,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMatchingWorkflowsInput{}
	}

	output = &ListMatchingWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMatchingWorkflows API operation for AWS EntityResolution.
//
// Returns a list of all the MatchingWorkflows that have been created for an
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListMatchingWorkflows for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows
func (c *EntityResolution) ListMatchingWorkflows(input *ListMatchingWorkflowsInput) (*ListMatchingWorkflowsOutput, error) {
	req, out := c.ListMatchingWorkflowsRequest(input)
	return out, req.Send()
}

// ListMatchingWorkflowsWithContext is the same as ListMatchingWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListMatchingWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingWorkflowsWithContext(ctx aws.Context, input *ListMatchingWorkflowsInput, opts ...request.Option) (*ListMatchingWorkflowsOutput, error) {
	req, out := c.ListMatchingWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMatchingWorkflowsPages iterates over the pages of a ListMatchingWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMatchingWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMatchingWorkflows operation.
//	pageNum := 0
//	err := client.ListMatchingWorkflowsPages(params,
//	    func(page *entityresolution.ListMatchingWorkflowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListMatchingWorkflowsPages(input *ListMatchingWorkflowsInput, fn func(*ListMatchingWorkflowsOutput, bool) bool) error {
	return c.ListMatchingWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMatchingWorkflowsPagesWithContext same as ListMatchingWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingWorkflowsPagesWithContext(ctx aws.Context, input *ListMatchingWorkflowsInput, fn func(*ListMatchingWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMatchingWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMatchingWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMatchingWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemaMappings = "ListSchemaMappings"

// ListSchemaMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemaMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemaMappings for more information on using the ListSchemaMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchemaMappingsRequest method.
//	req, resp := client.ListSchemaMappingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings
func (c *EntityResolution) ListSchemaMappingsRequest(input *ListSchemaMappingsInput) (req *request.Request, output *ListSchemaMappingsOutput) {
	op := &request.Operation{
		Name:       opListSchemaMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/schemas",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemaMappingsInput{}
	}

	output = &ListSchemaMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemaMappings API operation for AWS EntityResolution.
//
// Returns a list of all the SchemaMappings that have been created for an AWS
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListSchemaMappings for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings
func (c *EntityResolution) ListSchemaMappings(input *ListSchemaMappingsInput) (*ListSchemaMappingsOutput, error) {
	req, out := c.ListSchemaMappingsRequest(input)
	return out, req.Send()
}

// ListSchemaMappingsWithContext is the same as ListSchemaMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemaMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListSchemaMappingsWithContext(ctx aws.Context, input *ListSchemaMappingsInput, opts ...request.Option) (*ListSchemaMappingsOutput, error) {
	req, out := c.ListSchemaMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemaMappingsPages iterates over the pages of a ListSchemaMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemaMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchemaMappings operation.
//	pageNum := 0
//	err := client.ListSchemaMappingsPages(params,
//	    func(page *entityresolution.ListSchemaMappingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListSchemaMappingsPages(input *ListSchemaMappingsInput, fn func(*ListSchemaMappingsOutput, bool) bool) error {
	return c.ListSchemaMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemaMappingsPagesWithContext same as ListSchemaMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListSchemaMappingsPagesWithContext(ctx aws.Context, input *ListSchemaMappingsInput, fn func(*ListSchemaMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemaMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemaMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemaMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource
func (c *EntityResolution) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS EntityResolution.
//
// Displays the tags associated with an AWS Entity Resolution resource. In Entity
// Resolution, SchemaMapping, and MatchingWorkflow can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource
func (c *EntityResolution) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMatchingJob = "StartMatchingJob"

// StartMatchingJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMatchingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMatchingJob for more information on using the StartMatchingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMatchingJobRequest method.
//	req, resp := client.StartMatchingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob
func (c *EntityResolution) StartMatchingJobRequest(input *StartMatchingJobInput) (req *request.Request, output *StartMatchingJobOutput) {
	op := &request.Operation{
		Name:       opStartMatchingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/matchingworkflows/{workflowName}/jobs",
	}

	if input == nil {
		input = &StartMatchingJobInput{}
	}

	output = &StartMatchingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMatchingJob API operation for AWS EntityResolution.
//
// Starts the MatchingJob of a workflow. The workflow must have previously been
// created using the CreateMatchingWorkflow endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation StartMatchingJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current AWS Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob
func (c *EntityResolution) StartMatchingJob(input *StartMatchingJobInput) (*StartMatchingJobOutput, error) {
	req, out := c.StartMatchingJobRequest(input)
	return out, req.Send()
}

// StartMatchingJobWithContext is the same as StartMatchingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMatchingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) StartMatchingJobWithContext(ctx aws.Context, input *StartMatchingJobInput, opts ...request.Option) (*StartMatchingJobOutput, error) {
	req, out := c.StartMatchingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource
func (c *EntityResolution) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS EntityResolution.
//
// Assigns one or more tags (key-value pairs) to the specified AWS Entity Resolution
// resource. Tags can help you organize and categorize your resources. You can
// also use them to scope user permissions by granting a user permission to
// access or change only resources with certain tag values. In Entity Resolution,
// SchemaMapping, and MatchingWorkflow can be tagged. Tags don't have any semantic
// meaning to AWS and are interpreted strictly as strings of characters. You
// can use the TagResource action with a resource that already has tags. If
// you specify a new tag key, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource
func (c *EntityResolution) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource
func (c *EntityResolution) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS EntityResolution.
//
// Removes one or more tags from the specified AWS Entity Resolution resource.
// In Entity Resolution, SchemaMapping, and MatchingWorkflow can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource
func (c *EntityResolution) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMatchingWorkflow = "UpdateMatchingWorkflow"

// UpdateMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMatchingWorkflow for more information on using the UpdateMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMatchingWorkflowRequest method.
//	req, resp := client.UpdateMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow
func (c *EntityResolution) UpdateMatchingWorkflowRequest(input *UpdateMatchingWorkflowInput) (req *request.Request, output *UpdateMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateMatchingWorkflow,
		HTTPMethod: "PUT",
		HTTPPath:   "/matchingworkflows/{workflowName}",
	}

	if input == nil {
		input = &UpdateMatchingWorkflowInput{}
	}

	output = &UpdateMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMatchingWorkflow API operation for AWS EntityResolution.
//
// Updates an existing MatchingWorkflow. This method is identical to CreateMatchingWorkflow,
// except it uses an HTTP PUT request instead of a POST request, and the MatchingWorkflow
// must already exist for the method to succeed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UpdateMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the AWS Entity
//     Resolution service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by AWS Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow
func (c *EntityResolution) UpdateMatchingWorkflow(input *UpdateMatchingWorkflowInput) (*UpdateMatchingWorkflowOutput, error) {
	req, out := c.UpdateMatchingWorkflowRequest(input)
	return out, req.Send()
}

// UpdateMatchingWorkflowWithContext is the same as UpdateMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UpdateMatchingWorkflowWithContext(ctx aws.Context, input *UpdateMatchingWorkflowInput, opts ...request.Option) (*UpdateMatchingWorkflowOutput, error) {
	req, out := c.UpdateMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action. HTTP Status Code:
// 403
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request could not be processed because of conflict in the current state
// of the resource. Example: Workflow already exists, Schema already exists,
// Workflow is currently running, etc. HTTP Status Code: 400
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateMatchingWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the workflow. There cannot be multiple DataIntegrationWorkflows
	// with the same name.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMatchingWorkflowInput"}
	if s.InputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceConfig"))
	}
	if s.InputSourceConfig != nil && len(s.InputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSourceConfig", 1))
	}
	if s.OutputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSourceConfig"))
	}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.ResolutionTechniques == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolutionTechniques"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResolutionTechniques != nil {
		if err := s.ResolutionTechniques.Validate(); err != nil {
			invalidParams.AddNested("ResolutionTechniques", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateMatchingWorkflowInput) SetDescription(v string) *CreateMatchingWorkflowInput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *CreateMatchingWorkflowInput) SetIncrementalRunConfig(v *IncrementalRunConfig) *CreateMatchingWorkflowInput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateMatchingWorkflowInput) SetInputSourceConfig(v []*InputSource) *CreateMatchingWorkflowInput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *CreateMatchingWorkflowInput) SetOutputSourceConfig(v []*OutputSource) *CreateMatchingWorkflowInput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *CreateMatchingWorkflowInput) SetResolutionTechniques(v *ResolutionTechniques) *CreateMatchingWorkflowInput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateMatchingWorkflowInput) SetRoleArn(v string) *CreateMatchingWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMatchingWorkflowInput) SetTags(v map[string]*string) *CreateMatchingWorkflowInput {
	s.Tags = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateMatchingWorkflowInput) SetWorkflowName(v string) *CreateMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type CreateMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the MatchingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateMatchingWorkflowOutput) SetDescription(v string) *CreateMatchingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *CreateMatchingWorkflowOutput) SetIncrementalRunConfig(v *IncrementalRunConfig) *CreateMatchingWorkflowOutput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateMatchingWorkflowOutput) SetInputSourceConfig(v []*InputSource) *CreateMatchingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *CreateMatchingWorkflowOutput) SetOutputSourceConfig(v []*OutputSource) *CreateMatchingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *CreateMatchingWorkflowOutput) SetResolutionTechniques(v *ResolutionTechniques) *CreateMatchingWorkflowOutput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateMatchingWorkflowOutput) SetRoleArn(v string) *CreateMatchingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *CreateMatchingWorkflowOutput) SetWorkflowArn(v string) *CreateMatchingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateMatchingWorkflowOutput) SetWorkflowName(v string) *CreateMatchingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type CreateSchemaMappingInput struct {
	_ struct{} `type:"structure"`

	// A description of the schema.
	Description *string `locationName:"description" type:"string"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// that Entity Resolution uses for matching.
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list"`

	// The name of the schema. There cannot be multiple SchemaMappings with the
	// same name.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaMappingInput"}
	if s.MappedInputFields != nil && len(s.MappedInputFields) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MappedInputFields", 2))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.MappedInputFields != nil {
		for i, v := range s.MappedInputFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MappedInputFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaMappingInput) SetDescription(v string) *CreateSchemaMappingInput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *CreateSchemaMappingInput) SetMappedInputFields(v []*SchemaInputAttribute) *CreateSchemaMappingInput {
	s.MappedInputFields = v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaMappingInput) SetSchemaName(v string) *CreateSchemaMappingInput {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchemaMappingInput) SetTags(v map[string]*string) *CreateSchemaMappingInput {
	s.Tags = v
	return s
}

type CreateSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// A description of the schema.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// that Entity Resolution uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaMappingOutput) SetDescription(v string) *CreateSchemaMappingOutput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *CreateSchemaMappingOutput) SetMappedInputFields(v []*SchemaInputAttribute) *CreateSchemaMappingOutput {
	s.MappedInputFields = v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaMappingOutput) SetSchemaArn(v string) *CreateSchemaMappingOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaMappingOutput) SetSchemaName(v string) *CreateSchemaMappingOutput {
	s.SchemaName = &v
	return s
}

type DeleteMatchingWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMatchingWorkflowInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *DeleteMatchingWorkflowInput) SetWorkflowName(v string) *DeleteMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type DeleteMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A successful operation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteMatchingWorkflowOutput) SetMessage(v string) *DeleteMatchingWorkflowOutput {
	s.Message = &v
	return s
}

type DeleteSchemaMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schema to delete.
	//
	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaMappingInput"}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaName sets the SchemaName field's value.
func (s *DeleteSchemaMappingInput) SetSchemaName(v string) *DeleteSchemaMappingInput {
	s.SchemaName = &v
	return s
}

type DeleteSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// A successful operation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteSchemaMappingOutput) SetMessage(v string) *DeleteSchemaMappingOutput {
	s.Message = &v
	return s
}

// An object containing an error message, if there was an error.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error message from the job, if there is one.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetails) SetErrorMessage(v string) *ErrorDetails {
	s.ErrorMessage = &v
	return s
}

// The request was rejected because it attempted to create resources beyond
// the current AWS Entity Resolution account limits. The error message describes
// the limit exceeded. HTTP Status Code: 402
type ExceedsLimitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExceedsLimitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExceedsLimitException) GoString() string {
	return s.String()
}

func newErrorExceedsLimitException(v protocol.ResponseMetadata) error {
	return &ExceedsLimitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExceedsLimitException) Code() string {
	return "ExceedsLimitException"
}

// Message returns the exception's message.
func (s *ExceedsLimitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExceedsLimitException) OrigErr() error {
	return nil
}

func (s *ExceedsLimitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExceedsLimitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExceedsLimitException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetMatchIdInput struct {
	_ struct{} `type:"structure"`

	// The record to fetch the Match ID for.
	//
	// Record is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetMatchIdInput's
	// String and GoString methods.
	//
	// Record is a required field
	Record map[string]*string `locationName:"record" type:"map" required:"true" sensitive:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchIdInput"}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecord sets the Record field's value.
func (s *GetMatchIdInput) SetRecord(v map[string]*string) *GetMatchIdInput {
	s.Record = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchIdInput) SetWorkflowName(v string) *GetMatchIdInput {
	s.WorkflowName = &v
	return s
}

type GetMatchIdOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifiers for this group of match records.
	MatchId *string `locationName:"matchId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdOutput) GoString() string {
	return s.String()
}

// SetMatchId sets the MatchId field's value.
func (s *GetMatchIdOutput) SetMatchId(v string) *GetMatchIdOutput {
	s.MatchId = &v
	return s
}

type GetMatchingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchingJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetMatchingJobInput) SetJobId(v string) *GetMatchingJobInput {
	s.JobId = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchingJobInput) SetWorkflowName(v string) *GetMatchingJobInput {
	s.WorkflowName = &v
	return s
}

type GetMatchingJobOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the job has finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// An object containing an error message, if there was an error.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// Metrics associated with the execution, specifically total records processed,
	// unique IDs generated, and records the execution skipped.
	Metrics *JobMetrics `locationName:"metrics" type:"structure"`

	// The time at which the job was started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The current status of the job. Either running, succeeded, queued, or failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetMatchingJobOutput) SetEndTime(v time.Time) *GetMatchingJobOutput {
	s.EndTime = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetMatchingJobOutput) SetErrorDetails(v *ErrorDetails) *GetMatchingJobOutput {
	s.ErrorDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetMatchingJobOutput) SetJobId(v string) *GetMatchingJobOutput {
	s.JobId = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetMatchingJobOutput) SetMetrics(v *JobMetrics) *GetMatchingJobOutput {
	s.Metrics = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMatchingJobOutput) SetStartTime(v time.Time) *GetMatchingJobOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMatchingJobOutput) SetStatus(v string) *GetMatchingJobOutput {
	s.Status = &v
	return s
}

type GetMatchingWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchingWorkflowInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchingWorkflowInput) SetWorkflowName(v string) *GetMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type GetMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the workflow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes
	// this role to access resources on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The timestamp of when the workflow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the MatchingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMatchingWorkflowOutput) SetCreatedAt(v time.Time) *GetMatchingWorkflowOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetMatchingWorkflowOutput) SetDescription(v string) *GetMatchingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *GetMatchingWorkflowOutput) SetIncrementalRunConfig(v *IncrementalRunConfig) *GetMatchingWorkflowOutput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *GetMatchingWorkflowOutput) SetInputSourceConfig(v []*InputSource) *GetMatchingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *GetMatchingWorkflowOutput) SetOutputSourceConfig(v []*OutputSource) *GetMatchingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *GetMatchingWorkflowOutput) SetResolutionTechniques(v *ResolutionTechniques) *GetMatchingWorkflowOutput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetMatchingWorkflowOutput) SetRoleArn(v string) *GetMatchingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetMatchingWorkflowOutput) SetTags(v map[string]*string) *GetMatchingWorkflowOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetMatchingWorkflowOutput) SetUpdatedAt(v time.Time) *GetMatchingWorkflowOutput {
	s.UpdatedAt = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *GetMatchingWorkflowOutput) SetWorkflowArn(v string) *GetMatchingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchingWorkflowOutput) SetWorkflowName(v string) *GetMatchingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type GetSchemaMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schema to be retrieved.
	//
	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaMappingInput"}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaName sets the SchemaName field's value.
func (s *GetSchemaMappingInput) SetSchemaName(v string) *GetSchemaMappingInput {
	s.SchemaName = &v
	return s
}

type GetSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the SchemaMapping was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the schema.
	Description *string `locationName:"description" type:"string"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// Venice uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The timestamp of when the SchemaMapping was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSchemaMappingOutput) SetCreatedAt(v time.Time) *GetSchemaMappingOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSchemaMappingOutput) SetDescription(v string) *GetSchemaMappingOutput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *GetSchemaMappingOutput) SetMappedInputFields(v []*SchemaInputAttribute) *GetSchemaMappingOutput {
	s.MappedInputFields = v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *GetSchemaMappingOutput) SetSchemaArn(v string) *GetSchemaMappingOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *GetSchemaMappingOutput) SetSchemaName(v string) *GetSchemaMappingOutput {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSchemaMappingOutput) SetTags(v map[string]*string) *GetSchemaMappingOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetSchemaMappingOutput) SetUpdatedAt(v time.Time) *GetSchemaMappingOutput {
	s.UpdatedAt = &v
	return s
}

// An object which defines an incremental run type and has only incrementalRunType
// as a field.
type IncrementalRunConfig struct {
	_ struct{} `type:"structure"`

	// The type of incremental run. It takes only one value: IMMEDIATE.
	IncrementalRunType *string `locationName:"incrementalRunType" type:"string" enum:"IncrementalRunType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncrementalRunConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncrementalRunConfig) GoString() string {
	return s.String()
}

// SetIncrementalRunType sets the IncrementalRunType field's value.
func (s *IncrementalRunConfig) SetIncrementalRunType(v string) *IncrementalRunConfig {
	s.IncrementalRunType = &v
	return s
}

// An object containing InputSourceARN, SchemaName, and ApplyNormalization.
type InputSource struct {
	_ struct{} `type:"structure"`

	// Normalizes the attributes defined in the schema in the input data. For example,
	// if an attribute has an AttributeType of PHONE_NUMBER, and the data in the
	// input table is in a format of 1234567890, Entity Resolution will normalize
	// this field in the output to (123)-456-7890.
	ApplyNormalization *bool `locationName:"applyNormalization" type:"boolean"`

	// An Glue table ARN for the input source table.
	//
	// InputSourceARN is a required field
	InputSourceARN *string `locationName:"inputSourceARN" type:"string" required:"true"`

	// The name of the schema to be retrieved.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSource"}
	if s.InputSourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceARN"))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyNormalization sets the ApplyNormalization field's value.
func (s *InputSource) SetApplyNormalization(v bool) *InputSource {
	s.ApplyNormalization = &v
	return s
}

// SetInputSourceARN sets the InputSourceARN field's value.
func (s *InputSource) SetInputSourceARN(v string) *InputSource {
	s.InputSourceARN = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *InputSource) SetSchemaName(v string) *InputSource {
	s.SchemaName = &v
	return s
}

// This exception occurs when there is an internal failure in the AWS Entity
// Resolution service. HTTP Status Code: 500
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object containing InputRecords, TotalRecordsProcessed, MatchIDs, and RecordsNotProcessed.
type JobMetrics struct {
	_ struct{} `type:"structure"`

	// The total number of input records.
	InputRecords *int64 `locationName:"inputRecords" type:"integer"`

	// The total number of matchIDs generated.
	MatchIDs *int64 `locationName:"matchIDs" type:"integer"`

	// The total number of records that did not get processed,
	RecordsNotProcessed *int64 `locationName:"recordsNotProcessed" type:"integer"`

	// The total number of records processed.
	TotalRecordsProcessed *int64 `locationName:"totalRecordsProcessed" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMetrics) GoString() string {
	return s.String()
}

// SetInputRecords sets the InputRecords field's value.
func (s *JobMetrics) SetInputRecords(v int64) *JobMetrics {
	s.InputRecords = &v
	return s
}

// SetMatchIDs sets the MatchIDs field's value.
func (s *JobMetrics) SetMatchIDs(v int64) *JobMetrics {
	s.MatchIDs = &v
	return s
}

// SetRecordsNotProcessed sets the RecordsNotProcessed field's value.
func (s *JobMetrics) SetRecordsNotProcessed(v int64) *JobMetrics {
	s.RecordsNotProcessed = &v
	return s
}

// SetTotalRecordsProcessed sets the TotalRecordsProcessed field's value.
func (s *JobMetrics) SetTotalRecordsProcessed(v int64) *JobMetrics {
	s.TotalRecordsProcessed = &v
	return s
}

// An object containing the JobId, Status, StartTime, and EndTime of a job.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the job has finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The time at which the job was started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The current status of the job. Either running, succeeded, queued, or failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *JobSummary) SetEndTime(v time.Time) *JobSummary {
	s.EndTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *JobSummary) SetStartTime(v time.Time) *JobSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobSummary) SetStatus(v string) *JobSummary {
	s.Status = &v
	return s
}

type ListMatchingJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from the previous ListSchemaMappings API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMatchingJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMatchingJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMatchingJobsInput) SetMaxResults(v int64) *ListMatchingJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingJobsInput) SetNextToken(v string) *ListMatchingJobsInput {
	s.NextToken = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *ListMatchingJobsInput) SetWorkflowName(v string) *ListMatchingJobsInput {
	s.WorkflowName = &v
	return s
}

type ListMatchingJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of JobSummary objects, each of which contain the ID, status, start
	// time, and end time of a job.
	Jobs []*JobSummary `locationName:"jobs" type:"list"`

	// The pagination token from the previous ListSchemaMappings API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListMatchingJobsOutput) SetJobs(v []*JobSummary) *ListMatchingJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingJobsOutput) SetNextToken(v string) *ListMatchingJobsOutput {
	s.NextToken = &v
	return s
}

type ListMatchingWorkflowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token from the previous ListSchemaMappings API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMatchingWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMatchingWorkflowsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMatchingWorkflowsInput) SetMaxResults(v int64) *ListMatchingWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingWorkflowsInput) SetNextToken(v string) *ListMatchingWorkflowsInput {
	s.NextToken = &v
	return s
}

type ListMatchingWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from the previous ListSchemaMappings API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of MatchingWorkflowSummary objects, each of which contain the fields
	// WorkflowName, WorkflowArn, CreatedAt, and UpdatedAt.
	WorkflowSummaries []*MatchingWorkflowSummary `locationName:"workflowSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingWorkflowsOutput) SetNextToken(v string) *ListMatchingWorkflowsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowSummaries sets the WorkflowSummaries field's value.
func (s *ListMatchingWorkflowsOutput) SetWorkflowSummaries(v []*MatchingWorkflowSummary) *ListMatchingWorkflowsOutput {
	s.WorkflowSummaries = v
	return s
}

type ListSchemaMappingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token from the previous ListSchemaMappings API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemaMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemaMappingsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchemaMappingsInput) SetMaxResults(v int64) *ListSchemaMappingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaMappingsInput) SetNextToken(v string) *ListSchemaMappingsInput {
	s.NextToken = &v
	return s
}

type ListSchemaMappingsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from the previous ListDomains API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of SchemaMappingSummary objects, each of which contain the fields
	// SchemaName, SchemaArn, CreatedAt, UpdatedAt.
	SchemaList []*SchemaMappingSummary `locationName:"schemaList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaMappingsOutput) SetNextToken(v string) *ListSchemaMappingsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaList sets the SchemaList field's value.
func (s *ListSchemaMappingsOutput) SetSchemaList(v []*SchemaMappingSummary) *ListSchemaMappingsOutput {
	s.SchemaList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A list of MatchingWorkflowSummary objects, each of which contain the fields
// WorkflowName, WorkflowArn, CreatedAt, UpdatedAt.
type MatchingWorkflowSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the workflow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The timestamp of when the workflow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the MatchingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingWorkflowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingWorkflowSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *MatchingWorkflowSummary) SetCreatedAt(v time.Time) *MatchingWorkflowSummary {
	s.CreatedAt = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *MatchingWorkflowSummary) SetUpdatedAt(v time.Time) *MatchingWorkflowSummary {
	s.UpdatedAt = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *MatchingWorkflowSummary) SetWorkflowArn(v string) *MatchingWorkflowSummary {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *MatchingWorkflowSummary) SetWorkflowName(v string) *MatchingWorkflowSummary {
	s.WorkflowName = &v
	return s
}

// A list of OutputAttribute objects, each of which have the fields Name and
// Hashed. Each of these objects selects a column to be included in the output
// table, and whether the values of the column should be hashed.
type OutputAttribute struct {
	_ struct{} `type:"structure"`

	// Enables the ability to hash the column values in the output.
	Hashed *bool `locationName:"hashed" type:"boolean"`

	// A name of a column to be written to the output. This must be an InputField
	// name in the schema mapping.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHashed sets the Hashed field's value.
func (s *OutputAttribute) SetHashed(v bool) *OutputAttribute {
	s.Hashed = &v
	return s
}

// SetName sets the Name field's value.
func (s *OutputAttribute) SetName(v string) *OutputAttribute {
	s.Name = &v
	return s
}

// A list of OutputAttribute objects, each of which have the fields Name and
// Hashed. Each of these objects selects a column to be included in the output
// table, and whether the values of the column should be hashed.
type OutputSource struct {
	_ struct{} `type:"structure"`

	// Normalizes the attributes defined in the schema in the input data. For example,
	// if an attribute has an AttributeType of PHONE_NUMBER, and the data in the
	// input table is in a format of 1234567890, Entity Resolution will normalize
	// this field in the output to (123)-456-7890.
	ApplyNormalization *bool `locationName:"applyNormalization" type:"boolean"`

	// Customer KMS ARN for encryption at rest. If not provided, system will use
	// an Entity Resolution managed KMS key.
	KMSArn *string `type:"string"`

	// A list of OutputAttribute objects, each of which have the fields Name and
	// Hashed. Each of these objects selects a column to be included in the output
	// table, and whether the values of the column should be hashed.
	//
	// Output is a required field
	Output []*OutputAttribute `locationName:"output" type:"list" required:"true"`

	// The S3 path to which Entity Resolution will write the output table.
	//
	// OutputS3Path is a required field
	OutputS3Path *string `locationName:"outputS3Path" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputSource"}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.OutputS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Path"))
	}
	if s.Output != nil {
		for i, v := range s.Output {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Output", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyNormalization sets the ApplyNormalization field's value.
func (s *OutputSource) SetApplyNormalization(v bool) *OutputSource {
	s.ApplyNormalization = &v
	return s
}

// SetKMSArn sets the KMSArn field's value.
func (s *OutputSource) SetKMSArn(v string) *OutputSource {
	s.KMSArn = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *OutputSource) SetOutput(v []*OutputAttribute) *OutputSource {
	s.Output = v
	return s
}

// SetOutputS3Path sets the OutputS3Path field's value.
func (s *OutputSource) SetOutputS3Path(v string) *OutputSource {
	s.OutputS3Path = &v
	return s
}

// An object which defines the resolutionType and the ruleBasedProperties
type ResolutionTechniques struct {
	_ struct{} `type:"structure"`

	// There are two types of matching, RULE_MATCHING and ML_MATCHING
	ResolutionType *string `locationName:"resolutionType" type:"string" enum:"ResolutionType"`

	// An object which defines the list of matching rules to run and has a field
	// Rules, which is a list of rule objects.
	RuleBasedProperties *RuleBasedProperties `locationName:"ruleBasedProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolutionTechniques) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolutionTechniques) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolutionTechniques) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolutionTechniques"}
	if s.RuleBasedProperties != nil {
		if err := s.RuleBasedProperties.Validate(); err != nil {
			invalidParams.AddNested("RuleBasedProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolutionType sets the ResolutionType field's value.
func (s *ResolutionTechniques) SetResolutionType(v string) *ResolutionTechniques {
	s.ResolutionType = &v
	return s
}

// SetRuleBasedProperties sets the RuleBasedProperties field's value.
func (s *ResolutionTechniques) SetRuleBasedProperties(v *RuleBasedProperties) *ResolutionTechniques {
	s.RuleBasedProperties = v
	return s
}

// The resource could not be found. HTTP Status Code: 404
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object containing RuleName, and MatchingKeys.
type Rule struct {
	_ struct{} `type:"structure"`

	// A list of MatchingKeys. The MatchingKeys must have been defined in the SchemaMapping.
	// Two records are considered to match according to this rule if all of the
	// MatchingKeys match.
	//
	// MatchingKeys is a required field
	MatchingKeys []*string `locationName:"matchingKeys" min:"1" type:"list" required:"true"`

	// A name for the matching rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.MatchingKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchingKeys"))
	}
	if s.MatchingKeys != nil && len(s.MatchingKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MatchingKeys", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMatchingKeys sets the MatchingKeys field's value.
func (s *Rule) SetMatchingKeys(v []*string) *Rule {
	s.MatchingKeys = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *Rule) SetRuleName(v string) *Rule {
	s.RuleName = &v
	return s
}

// An object which defines the list of matching rules to run and has a field
// Rules, which is a list of rule objects.
type RuleBasedProperties struct {
	_ struct{} `type:"structure"`

	// You can either choose ONE_TO_ONE or MANY_TO_MANY as the AttributeMatchingModel.
	// When choosing MANY_TO_MANY, the system can match attribute across the sub-types
	// of an attribute type. For example, if the value of the Email field of Profile
	// A and the value of BusinessEmail field of Profile B matches, the two profiles
	// are matched on the Email type. When choosing ONE_TO_ONE the system can only
	// match if the sub-types are exact matches. For example, only when the value
	// of the Email field of Profile A and the value of the Email field of Profile
	// B matches, the two profiles are matched on the Email type.
	//
	// AttributeMatchingModel is a required field
	AttributeMatchingModel *string `locationName:"attributeMatchingModel" type:"string" required:"true" enum:"AttributeMatchingModel"`

	// A list of Rule objects, each of which have fields RuleName and MatchingKeys.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBasedProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBasedProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleBasedProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleBasedProperties"}
	if s.AttributeMatchingModel == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeMatchingModel"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeMatchingModel sets the AttributeMatchingModel field's value.
func (s *RuleBasedProperties) SetAttributeMatchingModel(v string) *RuleBasedProperties {
	s.AttributeMatchingModel = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *RuleBasedProperties) SetRules(v []*Rule) *RuleBasedProperties {
	s.Rules = v
	return s
}

// An object containing FieldField, Type, GroupName, and MatchKey.
type SchemaInputAttribute struct {
	_ struct{} `type:"structure"`

	// A string containing the field name.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" type:"string" required:"true"`

	// Instruct Entity Resolution to combine several columns into a unified column
	// with the identical attribute type. For example, when working with columns
	// such as first_name, middle_name, and last_name, assigning them a common GroupName
	// will prompt Entity Resolution to concatenate them into a single value.
	GroupName *string `locationName:"groupName" type:"string"`

	// A key that allows grouping of multiple input attributes into a unified matching
	// group. For example, let's consider a scenario where the source table contains
	// various addresses, such as business_address and shipping_address. By assigning
	// the MatchKey Address' to both attributes, Entity Resolution will match records
	// across these fields to create a consolidated matching group. If no MatchKey
	// is specified for a column, it won't be utilized for matching purposes but
	// will still be included in the output table.
	MatchKey *string `locationName:"matchKey" type:"string"`

	// The type of the attribute, selected from a list of values.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SchemaAttributeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaInputAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaInputAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaInputAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaInputAttribute"}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldName sets the FieldName field's value.
func (s *SchemaInputAttribute) SetFieldName(v string) *SchemaInputAttribute {
	s.FieldName = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *SchemaInputAttribute) SetGroupName(v string) *SchemaInputAttribute {
	s.GroupName = &v
	return s
}

// SetMatchKey sets the MatchKey field's value.
func (s *SchemaInputAttribute) SetMatchKey(v string) *SchemaInputAttribute {
	s.MatchKey = &v
	return s
}

// SetType sets the Type field's value.
func (s *SchemaInputAttribute) SetType(v string) *SchemaInputAttribute {
	s.Type = &v
	return s
}

// An object containing SchemaName, SchemaArn, CreatedAt, andUpdatedAt.
type SchemaMappingSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the SchemaMapping was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" type:"string" required:"true"`

	// The timestamp of when the SchemaMapping was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaMappingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaMappingSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SchemaMappingSummary) SetCreatedAt(v time.Time) *SchemaMappingSummary {
	s.CreatedAt = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *SchemaMappingSummary) SetSchemaArn(v string) *SchemaMappingSummary {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *SchemaMappingSummary) SetSchemaName(v string) *SchemaMappingSummary {
	s.SchemaName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SchemaMappingSummary) SetUpdatedAt(v time.Time) *SchemaMappingSummary {
	s.UpdatedAt = &v
	return s
}

type StartMatchingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the matching job to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMatchingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMatchingJobInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *StartMatchingJobInput) SetWorkflowName(v string) *StartMatchingJobInput {
	s.WorkflowName = &v
	return s
}

type StartMatchingJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartMatchingJobOutput) SetJobId(v string) *StartMatchingJobOutput {
	s.JobId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling. HTTP Status Code: 429
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateMatchingWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMatchingWorkflowInput"}
	if s.InputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceConfig"))
	}
	if s.InputSourceConfig != nil && len(s.InputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSourceConfig", 1))
	}
	if s.OutputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSourceConfig"))
	}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.ResolutionTechniques == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolutionTechniques"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResolutionTechniques != nil {
		if err := s.ResolutionTechniques.Validate(); err != nil {
			invalidParams.AddNested("ResolutionTechniques", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateMatchingWorkflowInput) SetDescription(v string) *UpdateMatchingWorkflowInput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *UpdateMatchingWorkflowInput) SetIncrementalRunConfig(v *IncrementalRunConfig) *UpdateMatchingWorkflowInput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateMatchingWorkflowInput) SetInputSourceConfig(v []*InputSource) *UpdateMatchingWorkflowInput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *UpdateMatchingWorkflowInput) SetOutputSourceConfig(v []*OutputSource) *UpdateMatchingWorkflowInput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *UpdateMatchingWorkflowInput) SetResolutionTechniques(v *ResolutionTechniques) *UpdateMatchingWorkflowInput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateMatchingWorkflowInput) SetRoleArn(v string) *UpdateMatchingWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *UpdateMatchingWorkflowInput) SetWorkflowName(v string) *UpdateMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type UpdateMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateMatchingWorkflowOutput) SetDescription(v string) *UpdateMatchingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *UpdateMatchingWorkflowOutput) SetIncrementalRunConfig(v *IncrementalRunConfig) *UpdateMatchingWorkflowOutput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateMatchingWorkflowOutput) SetInputSourceConfig(v []*InputSource) *UpdateMatchingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *UpdateMatchingWorkflowOutput) SetOutputSourceConfig(v []*OutputSource) *UpdateMatchingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *UpdateMatchingWorkflowOutput) SetResolutionTechniques(v *ResolutionTechniques) *UpdateMatchingWorkflowOutput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateMatchingWorkflowOutput) SetRoleArn(v string) *UpdateMatchingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *UpdateMatchingWorkflowOutput) SetWorkflowName(v string) *UpdateMatchingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

// The input fails to satisfy the constraints specified by AWS Entity Resolution.
// HTTP Status Code: 400
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AttributeMatchingModelOneToOne is a AttributeMatchingModel enum value
	AttributeMatchingModelOneToOne = "ONE_TO_ONE"

	// AttributeMatchingModelManyToMany is a AttributeMatchingModel enum value
	AttributeMatchingModelManyToMany = "MANY_TO_MANY"
)

// AttributeMatchingModel_Values returns all elements of the AttributeMatchingModel enum
func AttributeMatchingModel_Values() []string {
	return []string{
		AttributeMatchingModelOneToOne,
		AttributeMatchingModelManyToMany,
	}
}

const (
	// IncrementalRunTypeImmediate is a IncrementalRunType enum value
	IncrementalRunTypeImmediate = "IMMEDIATE"
)

// IncrementalRunType_Values returns all elements of the IncrementalRunType enum
func IncrementalRunType_Values() []string {
	return []string{
		IncrementalRunTypeImmediate,
	}
}

const (
	// JobStatusRunning is a JobStatus enum value
	JobStatusRunning = "RUNNING"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusQueued is a JobStatus enum value
	JobStatusQueued = "QUEUED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusRunning,
		JobStatusSucceeded,
		JobStatusFailed,
		JobStatusQueued,
	}
}

const (
	// ResolutionTypeRuleMatching is a ResolutionType enum value
	ResolutionTypeRuleMatching = "RULE_MATCHING"

	// ResolutionTypeMlMatching is a ResolutionType enum value
	ResolutionTypeMlMatching = "ML_MATCHING"
)

// ResolutionType_Values returns all elements of the ResolutionType enum
func ResolutionType_Values() []string {
	return []string{
		ResolutionTypeRuleMatching,
		ResolutionTypeMlMatching,
	}
}

const (
	// SchemaAttributeTypeName is a SchemaAttributeType enum value
	SchemaAttributeTypeName = "NAME"

	// SchemaAttributeTypeNameFirst is a SchemaAttributeType enum value
	SchemaAttributeTypeNameFirst = "NAME_FIRST"

	// SchemaAttributeTypeNameMiddle is a SchemaAttributeType enum value
	SchemaAttributeTypeNameMiddle = "NAME_MIDDLE"

	// SchemaAttributeTypeNameLast is a SchemaAttributeType enum value
	SchemaAttributeTypeNameLast = "NAME_LAST"

	// SchemaAttributeTypeAddress is a SchemaAttributeType enum value
	SchemaAttributeTypeAddress = "ADDRESS"

	// SchemaAttributeTypeAddressStreet1 is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressStreet1 = "ADDRESS_STREET1"

	// SchemaAttributeTypeAddressStreet2 is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressStreet2 = "ADDRESS_STREET2"

	// SchemaAttributeTypeAddressStreet3 is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressStreet3 = "ADDRESS_STREET3"

	// SchemaAttributeTypeAddressCity is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressCity = "ADDRESS_CITY"

	// SchemaAttributeTypeAddressState is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressState = "ADDRESS_STATE"

	// SchemaAttributeTypeAddressCountry is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressCountry = "ADDRESS_COUNTRY"

	// SchemaAttributeTypeAddressPostalcode is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressPostalcode = "ADDRESS_POSTALCODE"

	// SchemaAttributeTypePhone is a SchemaAttributeType enum value
	SchemaAttributeTypePhone = "PHONE"

	// SchemaAttributeTypePhoneNumber is a SchemaAttributeType enum value
	SchemaAttributeTypePhoneNumber = "PHONE_NUMBER"

	// SchemaAttributeTypePhoneCountrycode is a SchemaAttributeType enum value
	SchemaAttributeTypePhoneCountrycode = "PHONE_COUNTRYCODE"

	// SchemaAttributeTypeEmailAddress is a SchemaAttributeType enum value
	SchemaAttributeTypeEmailAddress = "EMAIL_ADDRESS"

	// SchemaAttributeTypeUniqueId is a SchemaAttributeType enum value
	SchemaAttributeTypeUniqueId = "UNIQUE_ID"

	// SchemaAttributeTypeDate is a SchemaAttributeType enum value
	SchemaAttributeTypeDate = "DATE"

	// SchemaAttributeTypeString is a SchemaAttributeType enum value
	SchemaAttributeTypeString = "STRING"
)

// SchemaAttributeType_Values returns all elements of the SchemaAttributeType enum
func SchemaAttributeType_Values() []string {
	return []string{
		SchemaAttributeTypeName,
		SchemaAttributeTypeNameFirst,
		SchemaAttributeTypeNameMiddle,
		SchemaAttributeTypeNameLast,
		SchemaAttributeTypeAddress,
		SchemaAttributeTypeAddressStreet1,
		SchemaAttributeTypeAddressStreet2,
		SchemaAttributeTypeAddressStreet3,
		SchemaAttributeTypeAddressCity,
		SchemaAttributeTypeAddressState,
		SchemaAttributeTypeAddressCountry,
		SchemaAttributeTypeAddressPostalcode,
		SchemaAttributeTypePhone,
		SchemaAttributeTypePhoneNumber,
		SchemaAttributeTypePhoneCountrycode,
		SchemaAttributeTypeEmailAddress,
		SchemaAttributeTypeUniqueId,
		SchemaAttributeTypeDate,
		SchemaAttributeTypeString,
	}
}
