/**
 * product.h
 *
 * Copyright (c) 2011 Daniel Berenguer <dberenguer@usapiens.com>
 * 
 * This file is part of the panStamp project.
 * 
 * panStamp  is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 * 
 * panStamp is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with panStamp; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 
 * USA
 * 
 * Author: Daniel Berenguer
 * Creation date: 03/31/2011
 */

#ifndef _PRODUCT_H
#define _PRODUCT_H

#include "config.h"

/**
 * Hardware version
 */
#define HARDWARE_BASE              0x00100000

#ifdef ENABLE_BRIGHTNESS
#  define HARDWARE_BRIGHTNESS            0x01
#else
#  define HARDWARE_BRIGHTNESS            0x00
#endif

#ifdef ENABLE_IR_RECV
#  define HARDWARE_IR_RECV               0x02
#else
#  define HARDWARE_IR_RECV               0x00
#endif

#ifdef ENABLE_DMX
#  define HARDWARE_DMX                   0x04
#else
#  define HARDWARE_DMX                   0x00
#endif

#ifdef ENABLE_REPEATER
#  define HARDWARE_REPEATER              0x08
#else
#  define HARDWARE_REPEATER              0x00
#endif

#ifdef ENABLE_LED_POWER
#  define HARDWARE_LED_POWER             0x10
#else
#  define HARDWARE_LED_POWER             0x00
#endif

#ifdef ENABLE_IR_SEND
#  define HARDWARE_IR_SEND               0x20
#else
#  define HARDWARE_IR_SEND               0x00
#endif

#ifdef ENABLE_IR_SEND
#  ifdef USE_SOFT_PWM
#    define HARDWARE_LED_4               0x40
#  else
#    define HARDWARE_LED_4               0x00
#  endif
#else
#  define HARDWARE_LED_4                 0x40
#endif

#ifdef ENABLE_IR_SEND
#  define HARDWARE_LED_5                 0x00
#else
#  ifdef USE_SOFT_PWM
#    define HARDWARE_LED_5               0x80
#  else
#    define HARDWARE_LED_5               0x00
#  endif
#endif
#define HARDWARE_LED_5                   0x00

#ifdef MAX_CHANNELS < 5
#  define HARDWARE_LED_5                 0x00
#endif
#ifdef MAX_CHANNELS < 4
#  define HARDWARE_LED_4                 0x00
#endif


#define HARDWARE_VERSION         ( HARDWARE_BASE | HARDWARE_LED_5 | HARDWARE_LED_4 | HARDWARE_IR_SEND | HARDWARE_LED_POWER | HARDWARE_REPEATER | HARDWARE_DMX | HARDWARE_IR_RECV | HARDWARE_BRIGHTNESS )

/**
 * Firmware version
 *
 *  version     description
 * 0x00000100  original panstamp rgbdriver example
 * 0x00000101  first fhem version
 * 0x00020001  added dmx base register
 * 0x00020002  added soft on power state
 * 0x00020003  added autosave timeout
 */
#define FIRMWARE_VERSION         0x00020003

/**
 * Manufacturer SWAP ID
 */
#define SWAP_MANUFACT_ID        0x00000022

/**
 * Product SWAP ID
 */
#define SWAP_PRODUCT_ID         0x00000003

#endif

